<?php

/**
 * core\lib\block\BlockLevelHeat.php
 */

/**
 * Сȶȵȼ
 *
 * @author Administrator
 */
class BlockLevelHeat {
    //put your code here
    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    private $dbback;
    /**
     *
     * @var Memcache  
     */
    private $mc;
    /**
     *
     * @var string 
     */
    private $table;
    /**
     *
     * @var array аֶ
     */
    public static $fields = array('id', 'block_id', 'level', 'utime');

    /**
     * 캯 ʼdbmemcache
     * @param string $table 
     */
    public function __construct($table = 'block_level_heat') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->mc = $container->get('mc');
        $this->table = $table;
    }
    
    /**
     * һСȼ
     * @param array $fieldData block_id,level
     * @return int زݵid
     */
    public function insert($fieldData) {
        $sql = SqlCombinHelper::insert_sql($this->table, $fieldData);
        $this->db->Execute($sql);
        return $this->db->Insert_ID();
    }
    
    /**
     * һӶСȼ
     * @param array $fieldsData block_id,levelĶά
     * @return int 
     */
    public function insertMutl($fieldsData) {
        $sql = SqlCombinHelper::insertMutil_sql($this->table, $fieldsData);
        //exit;
        $this->db->Execute($sql);
        return $this->db->Affected_Rows();
    }

    /**
     * СidСȶȵȼ
     * @param int $blockId Сid
     * @return array Сȼ
     */
    public function findByBlockId($blockId) {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields, "block_id='$blockId'");
        return $this->dbback->GetRow($sql);
    }
    
    
    public function findAll() {
        $sql = SqlCombinHelper::select_sql($this->table, self::$fields);
        return $this->dbback->getAll($sql);
    }

        /**
     * ҵȼΪ$levelС
     * @param  mixed $level A,B,C,D
     * @return array ذСidĶά
     */
    public function findByLevel($level) {
        if(is_numeric($level)) {
            $where = "level=$level";
        } else {
            $where = "level='$level'";
        }
        $sql = SqlCombinHelper::select_sql($this->table, $where);
        return $this->db->Execute($sql);
    }
    
    /**
     * Сȶȵȼ
     */
    public function emptyTable() {
        $sql = "TRUNCATE TABLE $this->table";
        $this->db->Execute($sql);
    }
    
    public function findBy($select,$conf,$arrayType=1) {
        $sql = SqlCombinHelper::select_sql($this->table, $select, $conf);
        if($arrayType) {
            return $this->dbback->GetAll($sql);
        } else {
            return $this->dbback->GetAssoc($sql);
        }
        
    }

    /**
     * ˢСȼ
     * @param array $data Сȼ,array(0=>array('block_id'=>10,'level'=>'A'))
     * @return int ˢµ
     */
    public function refreshData($data) {
        $this->emptyTable();
        return $this->insertMutl($data);
    }
    
    public static function friendlyShow($blockLevel) {
        
        $levelDef = array('A'=>4,'B'=>3,'C'=>2,'D'=>1);
        $re = array();
        if($blockLevel&&is_array($blockLevel)) {
            foreach($blockLevel as $v) {
                $width = $levelDef[$v['level']]*20;
                $re[$v['block_id']] = '<div l="'.$v['level'].'" style="width:'.$width.'px;" class="hot_bg_inner"></div>';
            }
            return $re;
        } else {
            $width = $levelDef[$blockLevel]*20;
            return '<div l="'.$blockLevel.'" style="width:'.$width.'px;" class="hot_bg_inner"></div>';
        }
    }
}

?>
