<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

/**
 * Сר
 */
class Market_block_expert extends MY_Controller {

    /**
     * Сר
     * @var Block_expert 
     */
    public $blockExpert;

    /**
     * 
     *
     * @access public
     * @return void
     */
    public function __construct() {
        parent::__construct();
        $this->load->model('Block_expert', 'blockExpert');
    }

    /**
     * Index Page for this controller.
     */
    public function index() {
        //brokerģ
        $this->load->model('broker_model');
        $css = load_css('zsb/css/v1.0/style1.css');
        $viewData = array();
        $viewData['page_title'] = '۱-Ӫ-Сר';
        $viewData['css'] = $css;
        //$info = $this->broker_model->get_user_session();print_r($info);
        //СרҲδ
        if($this->blockExpert->isNothing()||$this->blockExpert->isExpired()
                ||$this->blockExpert->isFire()||$this->blockExpert->isReject()) {
            $viewData['block'] = $this->blockExpert->get_block();//е
            //$viewData['notblock'] = $this->blockExpert->get_block_full();//
            $this->view('market', 'market/block_expert_apply_not', $viewData);
        }
        //
        if($this->blockExpert->isApply()) {
            $viewData['block'] = $this->blockExpert->get_block();//е
            $this->view('market', 'market/block_expert_apply_not', $viewData);
        }
        //Сר
        if($this->blockExpert->isExpert()){
            //СϢ
            $blockid = $this->blockExpert->getMyBlockId();
            $expert['block'] = $this->blockExpert->get_blockinfo($blockid);
            $expert['record'] = $this->blockExpert->getRecord();
            //ʱ
            $expert['time'] = $this->Sec2Time($expert['record']['endtime'] - time());
            $isApplyExpert = $this->blockExpert->is_apping();
            //С
            //$blocks = $this->blockExpert->get_block();
            //ģ
            $viewData['expert'] = $expert;
            $viewData['isApping'] = $isApplyExpert;
            $this->view('market', 'market/block_expert', $viewData);
        }
        
        
    }

    /**
     * Сרҿ
     */
    public function apply() {
        $blockid = $this->input->post("blockid");
        $reason = iconv('UTF-8', 'GBK', $this->input->post('reason'));
        $response = array();
        if (empty($blockid) || empty($reason)) {
            $response['status'] = -1; //
            $response['msg'] = '벻ȷ';
            return $this->ajaxResponse($response);
        }
        
        $blockinfo = $this->blockExpert->get_blockinfo($blockid);
        //var_dump($blockid);
        $result = $this->blockExpert->insert_block_apply($blockid, $blockinfo['blockname'], $reason);
        $response['status'] = $result;
        switch ($result) {
            case 1: $response['msg'] = "ɹѿ۳500ԱᾡˣĵȺ";
                break;
            case 2: $response['msg'] = "㣬費500лл";
                break;
            case 3: $response['msg'] = "СרңĵȴԱˡ";
                break;
            case 4: 
                $response['msg'] = 'Сר';
                break;
            case 5: 
                $response['msg'] = 'Ѿĵȴˣ';
                break;
            default:$response['msg'] = "ʧܣԺԡ";
                break;
        }
        // ʹͳ
        $info = $this->broker_model->get_user_session();
        $brokerId = $info['uid'];
        $gbuserbroker = new GrowthBidUserBroker();
        $gbuserbroker->addJoinBidRecord(1, $brokerId);
        return $this->ajaxResponse($response);
    }

    /**
     * ȡ
     */
    public function cancel() {
        $blockid = intval($this->input->post("blockid"));
        $response = array();
        if (!$blockid) {
            $response['status'] = -1; //
            $response['msg'] = '벻ȷ';
            return $this->ajaxResponse($response);
        }
        $this->blockExpert->del_apply($blockid);
        $response['status'] = 1;
        $response['msg'] = 'ύɹ500Ѿ';
        return $this->ajaxResponse($response);
    }

    private function ajaxResponse($data, $encode = 'gbk') {
        if ($encode == 'gbk') {
            $data = $this->gbk2utf($data);
        }
        $this->output->set_content_type('application/json')
                ->set_output(json_encode($data));
    }

    private function gbk2utf($data) {
        if (is_array($data)) {
            foreach ($data as &$value) {
                $value = $this->gbk2utf($value);
            }
        } else {
            $data = iconv('gbk', 'utf-8', $data);
        }
        return $data;
    }

    private function Sec2Time($time) {
        if (is_numeric($time)) {
            $value = array(
                "years" => 0, "days" => 0, "hours" => 0,
                "minutes" => 0, "seconds" => 0,
            );
            if ($time >= 31556926) {
                $value["years"] = floor($time / 31556926);
                $time = ($time % 31556926);
            }
            if ($time >= 86400) {
                $value["days"] = floor($time / 86400);
                $time = ($time % 86400);
            }
            if ($time >= 3600) {
                $value["hours"] = floor($time / 3600);
                $time = ($time % 3600);
            }
            if ($time >= 60) {
                $value["minutes"] = floor($time / 60);
                $time = ($time % 60);
            }
            $value["seconds"] = floor($time);
            return (array) $value;
        } else {
            return (bool) FALSE;
        }
    }

}

/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */
