<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * 
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * Rent_match_base_model CLASS
 *
 * ۼƱǩ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz
 */
//ظ
load_m("sell_attr_model");

class Sell_tag_base_wang_model extends Sell_attr_model {
   
    /**
     * ƱʶӦֵ
     * @var const
     */
    const  ISTAG_VALUE = 1;
    
    /**
     * Դǩ¼
     * @var const
     */
    const TAG_TBL = 'house_tag';
    
    /**
     * key
     * @var const
    */
    private $_mem_key;
    
    /**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct();
        
        //÷Դ
        $this->set_house_tbl('sell');
        
        //mem_key
        $this->_mem_key = GB_CITY.'sell_tag_base_wang_model';
    }
    
    /**
     * ȡֵ
     * @var const
     */
    public function get_istag_value()
    {
        return self::ISTAG_VALUE;
    }
    
    /**
     * ݷԴŻȡƱǩ¼Ϣ
     *
     * @access  public
     * @return  array   ƱǩϢ
     */
    public function get_tag_record($clear_cache = 0)
    {
        $data_info = array();
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);
        
        if( $rowid > 0 )
        {   
            $mem_key = $this->_mem_key.'_get_tag_record_'.$rowid;
			if( $clear_cache == 1)
			{
				$this->mc->delete($mem_key);
			}
            $cache = $this->mc->get($mem_key);

            if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
            {
                $data_info = $cache['data'];
            }
            else
            {
                $house_kind = $this->get_house_tbl();
                $cond_where = "rowid = '".$rowid."' AND tbl = '".$house_kind."' AND esta = 1";
                $this->dbback->where($cond_where);
                $data_info = $this->dbback->get( self::TAG_TBL )->row_array();
                
                $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$data_info),  600);
            }
        }
        return $data_info;
    }
    
    
    /**
     * жϷԴǷΪ۷Դ
     *
     * @access	public
     * @return	boolean  ǷΪ(ǩ)Դ
     */
    public function is_tag()
    {
        $is_tag = FALSE;
        
        $house_info = $this->init_houseinfo();
        
        if( is_array( $house_info ) && !empty( $house_info ) )
        {
            $is_tag = self::ISTAG_VALUE == $house_info['istag'] 
                    ? TRUE : FALSE;
        }
        
        return $is_tag;
    }
    
    
    /**
     * ñǩԴ
     *
     * @access  public
     * @return  boolean  Ƿóɹ
     */
    public function set_tag()
    {   
        $result = FALSE;
        $result_add = 0;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);

		if($house_info['is360'] == '2')
		{
			$expiretime = strtotime( date("Y-m-d 23:59:59") ) + 86400 * 13;
			
		}
		else
		{
			$expiretime = strtotime( date("Y-m-d 23:59:59") ) + 86400 * 6;
		}
        
        //ǩԴ¼
        $tag_info = array();
        $tag_info['rowid']  = $rowid;
        $tag_info['tbl']    = $this->get_house_tbl();
        $tag_info['uid']    = intval($house_info['uid']);
        $tag_info['addtime']    = time();
        $tag_info['expiretime'] = $expiretime;
        
        //ӱǩԴ¼
        $result_add = $this->_add_tag_record($tag_info);
        
       	//޸ıǩhouse_tag_package״̬ xue 2015-05-19        
        $this->load->model("tag_package_base_model");
		$result_update = $this->tag_package_base_model->update_tag_record($tag_info['uid']);
        //ķԴֵ
        if( $result_add > 0 && $result_update)
        {   
            $update_info = array();
            
            //ҪõķԴֵ
            $update_info['istag'] = self::ISTAG_VALUE;
            
            //öͼԴ
            $result = $this->update_house_atrr_val( $update_info , $rowid );

			//2016-11-3 ӱǩ־ --- start ------>

			$tag_info = array();
			$tag_info['uid']    = intval($house_info['uid']);
			if($this->get_house_tbl()=='sell')
			{
				$tag_info['tbl']    = '1';
			}else
			{
				$tag_info['tbl']    = '2';
			}
			
			$tag_info['rowid']  = $rowid;
			$tag_info['type']   = 1;
			
			$tag_info['time']    = time();
			$tag_info['ip']		 = get_ip();

			if( is_array($tag_info) && !empty($tag_info) )
			{
				$this->db->insert( 'log_broker_tag' , $tag_info );
				//$result = ($this->db->affected_rows() == 1) ? $this->db->insert_id() : 0;
			}

			//2016-11-3 ӱǩ־ --- end ------>
        }

        return $result;
    }

	/**
     * ȡԴǩ
	 *
	 */
	public function get_house_tag($data = array())
	{
		$result = array();

		if(empty($data))
		{
			return $result;
		}
		
		$time = time();

		$this->db->select('id,rowid,tbl,uid,addtime,expiretime,esta');
        $this->db->where('rowid', $data['houseId']);
        $this->db->where('tbl', $data['tbl']);
		$this->db->where('esta', $data['esta']);
		$this->db->where('expiretime >=', $time);
		
        return $this->db->get(self::TAG_TBL)->row_array();
	}
	
	/**
     * ·Դǩʱ
	 *
	 */
	public function edit_tag_expiretime($data = array())
	{
		$result = false;

		if(empty($data))
		{
			return $result;
		}
		
		$this->db->where("id",$data['id']);
		$this->db->update( self::TAG_TBL, array('expiretime' => $data['expiretime']));
		
		return $this->db->affected_rows() > 0 ? TRUE : FALSE;
	}

    
    
    /**
     * ñǩԴ
     *
     * @access  private
     * @return  int  0ӳɹ0ʧܣ-1 Ϊ
     */
    private function _add_tag_record( $data_info  )
    {   
        $result = -1;
        
        if( is_array($data_info) && !empty($data_info) )
        {
            $this->db->insert( self::TAG_TBL , $data_info );
            $result = ($this->db->affected_rows() == 1) ? $this->db->insert_id() : 0;
        }
        
        return $result;
    }
    
    
    /**
     * ƳǩԴ
     *
     * @access  public
     * @return  boolean  ǷƳɹ
     */
    public function remove_tag()
    {   
		
        $result = FALSE;
        
        $house_info = $this->init_houseinfo();
        $rowid = intval($house_info['id']);
        
        if( $rowid > 0)
        {
            //ʧЧԴ
            $result_invalid = $this->_invalid_tag_by_rowid($rowid);

            if( $result_invalid === TRUE )
            {   
                $update_info = array();

                //ҪõķԴֵ
                $update_info['istag'] = 0;

                //öͼԴ
                $result = $this->update_house_atrr_val( $update_info , $rowid );

				//2016-11-3 ȡǩ־ --- start ------>

				$tag_info = array();
				$tag_info['uid']    = intval($house_info['uid']);
				if($this->get_house_tbl()=='sell')
				{
					$tag_info['tbl']    = '1';
				}else
				{
					$tag_info['tbl']    = '2';
				}
				
				$tag_info['rowid']  = $rowid;
				$tag_info['type']   = 2;
				
				$tag_info['time']    = time();
				$tag_info['ip']		 = get_ip();

				//ӱǩԴ¼
				 if( is_array($tag_info) && !empty($tag_info) )
				{
					$this->db->insert( 'log_broker_tag' , $tag_info );
					//$result = ($this->db->affected_rows() == 1) ? $this->db->insert_id() : 0;
				}

				//2016-11-3 ȡǩ־ --- end ------>

            }
        }
        
        return $result;
    }
    
    
    /**
     * ʧЧԴǩ¼
     *
     * @access  private
     * @return  boolean  Ƿóɹ
     */
    private function _invalid_tag_by_rowid( $rowid )
    {   
        $result = FALSE;
        
        if( $rowid > 0 )
        {   
            $update_data = array();
            $update_data['esta'] = 2;
            $tbl = $this->get_house_tbl();
            if( $tbl != '')
            {
                $cond_where = "rowid = '".$rowid."' AND tbl = '".$tbl."' AND esta = 1";
                $this->db->where($cond_where);
                $this->db->update( self::TAG_TBL, $update_data);
                $result = $this->db->affected_rows() > 0 ? TRUE : FALSE;
            }
        }
        return $result;
    }
    
    /**
     * ǷԴǷϼƷԴı׼
     *
     * @access  public
     * @return  boolean  ǷϼƷԴ׼
     */
    public function check_tag_standard()
    {   
        $result = array();
        
        $houseinfo = $this->init_houseinfo();
        $this->load->model('broker_model');
        
        /** 鷿ԴǷΪ·ֱ **/
        if($houseinfo['nofee'] == 1)
        {
            //·Դ
            $result['is_ok'] = 0;
            $result['msg'] = '·ֱ';
            return  $result; 
        }
        
        $this->broker_model->set_uid($houseinfo['uid']);
        $broker_info = $this->broker_model->get_broker_info();
        
        /*** ˲ٺ ***/
        if( is_array( $broker_info ) && !empty( $broker_info ) )
        {
            if($broker_info['festa'] == 1 )
            {
                //״̬
                $result['is_ok'] = 0;
                $result['msg'] = 'ںУ޷ñǩԴ';
                
                return  $result;
            }
        }
        else
        {
            //ϢΪ
            $result['is_ok'] = 0;
            $result['msg'] = 'ϢΪ';
            return  $result;
        }

        /*** ͼԴ״ֻ̬ΪЧ״̬ ***/
        if( $houseinfo['esta'] != 1 )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴǼ״̬޷ñǩԴ';
            return  $result;
        }
        
        /*** ͼԴж ***/
        $this->load->model('sell_star_base_model');
        $isstar_value = $this->sell_star_base_model->get_isstar_value();
        if( $houseinfo['isstar'] != $isstar_value && (empty($houseinfo['is360']) || (!empty($houseinfo['is360']) && $houseinfo['is360'] != '2')))
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴΪǶͼȫԴ޷ñǩԴ';
            return  $result;
        }
        /***  Ƿ񳬹ǩײ ǩ۷ϳ xue modify 2015-05-16***/
        /*$this->load->model('broker_package_model'); //ײͱǩ
        $package_info = array();
        $package_info = $this->broker_package_model->find_by_id($broker_info['package_id']);
        if( empty($package_info) || $package_info['package_tag_num'] == 0)
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ǩײޣ޷ñǩԴ';
            return  $result;
        }*/
        
        /** 鿴ǷѾǼƷԴ **/
        if( self::ISTAG_VALUE == $houseinfo['istag'])
        {
            $result['is_ok'] = 0;
            $result['msg'] = '˷ԴǱǩԴ޷ظñǩԴ';
            return  $result;
        }
        
          /***  ˵ñǩǩ۷ϳ xue modify 2015-05-16***/ 
       /* $match_num_month = $this->get_month_tagnum_by_uid($broker_info['uid'] , 1 , 1);
        if( empty($package_info) || $match_num_month >= $package_info['package_tag_num'] )
		{
            $result['is_ok'] = 0;
            $result['msg'] = 'ñǩԴ޷ñǩԴ';
            return  $result;
        }
		*/

		/**** Ƿбǩxue add 2015-05-16****/ 
	    $this->load->model("tag_package_base_model");
		$tag_valid_num = $this->tag_package_base_model->get_tag_valid_num($broker_info['uid'],1,1);		
		//var_dump($tag_valid_num);
        if($tag_valid_num<1)
		{
            $result['is_ok'] = 0;
            $result['msg'] = 'ñǩԴ޷ñǩԴ';
            return  $result;
        }
        
        $result['is_ok'] = 1;
        $result['msg'] = 'ü';
        
        return $result;
    }





	 /**
     * ǷԴǷϼƷԴı׼
     *
     * @access  public
     * @return  boolean  ǷϼƷԴ׼
     */
    public function check_tag_standard_list($tag_valid_num)
    {   
        $result = array();
        
        $houseinfo = $this->init_houseinfo();
        $this->load->model('broker_model');
        
        /** 鷿ԴǷΪ·ֱ **/
        if($houseinfo['nofee'] == 1)
        {
            //·Դ
            $result['is_ok'] = 0;
            $result['msg'] = '·ֱ';
            return  $result; 
        }
        
        $this->broker_model->set_uid($houseinfo['uid']);
        $broker_info = $this->broker_model->get_broker_info();
       
        /*** ˲ٺ ***/
        if( is_array( $broker_info ) && !empty( $broker_info ) )
        {
            if($broker_info['festa'] == 1 )
            {
                //״̬
                $result['is_ok'] = 0;
                $result['msg'] = 'ںУ޷ñǩԴ';
                
                return  $result;
            }
        }
        else
        {
            //ϢΪ
            $result['is_ok'] = 0;
            $result['msg'] = 'ϢΪ';
            return  $result;
        }

        /*** ͼԴ״ֻ̬ΪЧ״̬ ***/
        if( $houseinfo['esta'] != 1 )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴǼ״̬޷ñǩԴ';
            return  $result;
        }
        
        /*** ͼԴж ***/
        $this->load->model('sell_star_base_model');
        $isstar_value = $this->sell_star_base_model->get_isstar_value();
        if( $houseinfo['isstar'] != $isstar_value )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴΪǶͼԴ޷ñǩԴ';
            return  $result;
        }
        /***  Ƿ񳬹ǩײ ǩ۷ϳ xue modify 2015-05-16***/
        /*$this->load->model('broker_package_model'); //ײͱǩ
        $package_info = array();
        $package_info = $this->broker_package_model->find_by_id($broker_info['package_id']);
        if( empty($package_info) || $package_info['package_tag_num'] == 0)
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ǩײޣ޷ñǩԴ';
            return  $result;
        }*/
        
        /** 鿴ǷѾǼƷԴ **/
        if($houseinfo['is360'] != '2' && self::ISTAG_VALUE == $houseinfo['istag'])
        {
            $result['is_ok'] = 0;
            $result['msg'] = '˷ԴǱǩԴ޷ظñǩԴ';
            return  $result;
        }
        
          /***  ˵ñǩǩ۷ϳ xue modify 2015-05-16***/ 
       /* $match_num_month = $this->get_month_tagnum_by_uid($broker_info['uid'] , 1 , 1);
        if( empty($package_info) || $match_num_month >= $package_info['package_tag_num'] )
		{
            $result['is_ok'] = 0;
            $result['msg'] = 'ñǩԴ޷ñǩԴ';
            return  $result;
        }
		*/

		/**** Ƿбǩxue add 2015-05-16****/ 
	    //$this->load->model("tag_package_base_model");
		//$tag_valid_num = $this->tag_package_base_model->get_tag_valid_num($broker_info['uid'],1,1);		
		//var_dump($tag_valid_num);
        if($tag_valid_num<1)
		{
            $result['is_ok'] = 0;
            $result['msg'] = 'ñǩԴ޷ñǩԴ';
            return  $result;
        }
        
        $result['is_ok'] = 1;
        $result['msg'] = 'ü';
        
        return $result;
    }
    


     /**
     * ǷԴǷϼƷԴı׼(бר)
     *
     * @access  public
     * @return  boolean  ǷϼƷԴ׼
     */
   /* public function check_tag_standard_list($month_tag_num)
    {   
        $result = array();
        
        $houseinfo = $this->init_houseinfo();
        $this->load->model('broker_model');
        
        /** 鷿ԴǷΪ·ֱ **/
      /*  if($houseinfo['nofee'] == 1)
        {
            //·Դ
            $result['is_ok'] = 0;
            $result['msg'] = '·ֱ';
            return  $result; 
        }
        
        $this->broker_model->set_uid($houseinfo['uid']);
        $broker_info = $this->broker_model->get_broker_info();
        
        /*** ˲ٺ ***/
      /*  if( is_array( $broker_info ) && !empty( $broker_info ) )
        {
            if($broker_info['festa'] == 1 )
            {
                //״̬
                $result['is_ok'] = 0;
                $result['msg'] = 'ںУ޷ñǩԴ';
                
                return  $result;
            }
        }
        else
        {
            //ϢΪ
            $result['is_ok'] = 0;
            $result['msg'] = 'ϢΪ';
            return  $result;
        }

        /*** ͼԴ״ֻ̬ΪЧ״̬ ***/
       /* if( $houseinfo['esta'] != 1 )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴǼ״̬޷ñǩԴ';
            return  $result;
        }
        
        /*** ͼԴж ***/
       /* $this->load->model('sell_star_base_model');
        $isstar_value = $this->sell_star_base_model->get_isstar_value();
        if( $houseinfo['isstar'] != $isstar_value )
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ԴΪǶͼԴ޷ñǩԴ';
            return  $result;
        }
        
        /***  Ƿ񳬹ǩײ ***/
       /* $this->load->model('broker_package_model'); //ײͱǩ
        $package_info = array();
        $package_info = $this->broker_package_model->find_by_id($broker_info['package_id']);
        if( empty($package_info) || $package_info['package_tag_num'] == 0)
        {
            $result['is_ok'] = 0;
            $result['msg'] = 'ǩײޣ޷ñǩԴ';
            return  $result;
        }
        
        /** 鿴ǷѾǼƷԴ **/
       /* if( self::ISTAG_VALUE == $houseinfo['istag'])
        {
            $result['is_ok'] = 0;
            $result['msg'] = '˷ԴǱǩԴ޷ظñǩԴ';
            return  $result;
        }
        
        /***  ˵ñǩ ***/
       /* $match_num_month = $month_tag_num;
        if( empty($package_info) || $match_num_month >= $package_info['package_tag_num'] )
		{
            $result['is_ok'] = 0;
            $result['msg'] = 'ñǩԴ޷ñǩԴ';
            return  $result;
        }
        
        $result['is_ok'] = 1;
        $result['msg'] = 'ü';
        
        return $result;
    }*/

    
    /**
     * ͨ˱ŻȡõıǩԴ
     *
     * @access  public
     * @param   int $uid ˺ű
	 * @param   int $update_cache Ƿ֮ǰĻ» 1֮ǰ
	 * @param   int $force_db Ƿǿ⣬1
     * @return  boolean  Ƿ϶ͼԴ׼
     */
    public function get_month_tagnum_by_uid( $uid , $update_cache = 0 , $force_db = 0)
    {   
        $tag_num = 0;
        $this->load->model('statistics_model');
        $tag_num = $this->statistics_model->jtLabelCount($uid , $update_cache , $force_db);
        
        return $tag_num ;
    }
    
    
    /**
     * жĳԴǷѾ˷Դǩ
     *
     * @access  public
     * @param   int $rowid Դ
     * @param   string $tbl Դ
     * @param   int $esta ¼״̬
     * @return  boolean  Ƿڼ¼򷵻TRUEڷFALSE 
     */
    public function is_tag_exists_by_rowid( $rowid , $tbl = 'sell' , $esta = 1 )
    {   
        $tag_num = 0;
         
        $cond_where = "rowid = '".$rowid."' AND tbl = '".$tbl."' AND esta = $esta ";
        
        $this->dbback->where($cond_where);
        
        $tag_num = $this->dbback->count_all_results(self::TAG_TBL);
        
        return $tag_num > 0 ? TRUE : FALSE ;
    }
    
    
    /**
     * ȡԴǩʣ
     *
     * @access  public
     * @param   int $expiretime ʱ
     * @return  strting  ʣ
     */
    public function tag_exipire_days( $expiretime )
    {   
	$strRemainder = '';

        if($expiretime > 0) 
        {
            $nowtime = strtotime( date('Y-m-d 00:00:00') );
            $dif    = $expiretime - $nowtime;
            
            $strRemainder = ceil( $dif / 86400 );
        }
        
        return isset($strRemainder) ? $strRemainder.'' : '';
    }
}
/* End of file sell_tag_base_model.php */
/* Location: ./applications/models/sell_tag_base_model.php */