<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ƥ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * Buy_match_base_model CLASS
 *
 * ƥ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz
 */

//ظ
load_m("house_match_base_model");

class Buy_match_base_model extends House_match_base_model{
       
    public function __construct() 
    {
        parent::__construct(0,1,0);
        
        $this->set_tbl_match('buy_match');
    }
    
    
    /**
    * ƥû˺űŻȡƥϢ
    *
    * @access   public
    * @param	string  $demand_tbl Ϣ
    * @param	int  $infofrom ƥϢԴ 1 ˡ5н
    * @param	int     $offset ƫ,ĬֵΪ0
    * @param	int     $limit ÿȡĬֵΪ10
    * @param	string  $order_key ֶΣĬֵ
    * @param	string  $order_by  򡢽ĬϽ
    * @param	int  $starttime  ʼͳʱʱ
    * @return   array  ƥϢ
    */
    public function get_rowid_by_matchuid( $infofrom = 5 )
    {
        $data_info = array();
        
        //
        $want_id = $this->get_want_id();
        
        //ƥ˺ű
        $match_uid = $this->get_match_uid();
        
        //ƥ
        $tbl_match = $this->get_tbl_match();
        
        if( $want_id > 0 && $match_uid > 0 && $tbl_match != '' 
                && in_array($tbl_match, $this->_tbl_arr)  )
        {
            $cond_where = "want_id = '".$want_id."' AND infofrom = '".$infofrom."' "
            . "AND match_uid = '".$match_uid."' ";

            $this->dbback->where($cond_where);

            $data_info = $this->dbback->get($tbl_match)->row_array();
        }

        return $data_info;
    }
    
    
    /**
    * ƥû˺űŻȡƥϢ
    *
    * @access   public
    * @param    string  $demand_tbl Ϣ
    * @param    int     $infofrom ƥϢԴ 1 ˡ5н
    * @param    int     $offset ƫ,ĬֵΪ0
    * @param    int     $limit ÿȡĬֵΪ10
    * @param    string  $order_key ֶΣĬֵ
    * @param    string  $order_by  򡢽ĬϽ
    * @param    int     $starttime  ʼͳʱʱ
    * @return   array   ƥϢ
    */
    public function get_demandlist_by_matchuid( $demand_tbl , $infofrom = 5 , $offset = 0 , $limit = 10 
                    , $order_key = 'creattime' , $order_by = 'DESC' , $starttime = 0 )
    {   
        $data_info = array();
        
        $tbl_match = $this->get_tbl_match();
        
        $match_uid = $this->get_match_uid();
        
        if( $match_uid > 0 && $demand_tbl != '' && $tbl_match != '' 
                && in_array($tbl_match, $this->_tbl_arr))
        {
            //ҪѯķԴϢֶ
            $select_fields = $this->get_search_fields();
            $select_fields_str = '';
            if( isset( $select_fields ) && !empty( $select_fields ) )
            {   
                //ѯֶ
                foreach ($select_fields as $key => $value)
                {
                    $select_fields_str .= $select_fields_str != '' 
                            ?  ','.$demand_tbl. '.'.$value : $demand_tbl. '.'.$value;
                }
                $this->dbback->select( $select_fields_str );
            }

            $this->dbback->from( $demand_tbl );
            $this->dbback->join( $tbl_match , $demand_tbl.".id = ".$tbl_match . '.want_id' , 'left');
            
            $cond_where = $tbl_match.".infofrom = '".$infofrom."'";

            $cond_where .= " AND ".$tbl_match.".match_uid = '".$match_uid."' ";
            
            if( $starttime == 0)
            {
                $start_time = time() - 86400 * 30;
            }
            
            $cond_where .= " AND ".$tbl_match.".creattime >= '".$start_time."' ";
            
            $this->dbback->where( $cond_where );

            //
            $this->dbback->order_by( $tbl_match.'.'.$order_key , $order_by );
            $this->dbback->limit( $limit , $offset );
            
            $data_info = $this->dbback->get()->result_array();
        }
        return $data_info;
    }
}
/* End of file buy_match_base_model.php */
/* Location: ./application/models/buy_match_base_model.php */
