<?php 
function getUConfig($env='prod') {
	if($env == 'prod') {
	$fname = 'config.ini';
	} else {
	$fname = 'config_test.ini';
	}
	$ucConfig = parse_ini_file($_SERVER['DOCUMENT_ROOT'].'/model/univercityChannel/'.$fname);
	return $ucConfig;
}

/*
$tbl = $ucConfig["schoolTable"];
$tblSchoolImg = $ucConfig["schoolImgTable"];
$tblSchoolBlock = $ucConfig["schoolBlockTable"];
*/
class UnivercityChannel {
	private $schoolTable;
	private $schoolImgTable;
	private $schoolBlockTable;
	private $suffix;
	private $debug;
	public function __construct($env='test') {
			$uconfig = getUConfig($env);
			$this->schoolTable = $uconfig["schoolTable"];
			$this->schoolImgTable = $uconfig["schoolImgTable"];
			$this->schoolBlockTable = $uconfig["schoolBlockTable"];
			$this->suffix = $uconfig['suffix'];
			$this->debug = $uconfig['debug'];
    }
	public function getSchoolTable() {
		return $this->schoolTable;
		
	}

	public function getSchoolImgTable() {
		return $this->schoolImgTable;
	}

	public function getSchoolBlockTable() {
		return $this->schoolBlockTable;
	
	}

	public function getSuffix() {
		return $this->suffix;
	}

	public function getDebug() {
		return $this->debug;
	}

	static public function getSchUrl($params) {
		$url = self::getUrl($params['id'],$params['c'],$params['blockid']);
		return $url;
	}

	static public function getHomepageUrl() {
		return self::getUrl();
	}
	
	static public function getSchSearchUrl($district) {
		global $uri_district,$conf_city,$Rewrite_selllist_xuequ;
		return $Rewrite_selllist_xuequ->get_url('district',$uri_district[$district]);
	}

	static private function getUrl($id=0,$module='',$blockid=0) {
		return get_xuequ_url($id,$module,$blockid);
	}
}


class School {
	private $db;
	private $db_back;
	private $entitys = array();
	private $uc;
	private $tbl;

	//Դ
	private $sell;
	//Դ
	private $sellNumber;

	public function __construct($db,$db_back,$uc) {
		$this->db = $db;
		$this->db_back = $db_back;
		$this->uc = $uc;
		$this->tbl = $this->uc->getSchoolTable();
	}

	public function getById($id) {
		$q = "select * from $this->tbl where id='$id'";
		$rel = $this->db_back->GetRow($q);
		return $rel;
	}

	public function insert($data) {
		$q = insert_sql($this->tbl, $data);
		$this->db->Execute($q);
	}

	public function update($id,$data) {
		$q = update_sql($this->tbl, $data, " where id=" . intval($id) . "");
		$this->db->Execute($q);
	}

	
	public function getSchoolByKeyword($select,$conf,$term = null,$order=null,$limit=null) {
		$where = '';
		$whereTemp = array();
		if($conf->__toString()) {
			$whereTemp[] = $conf->__toString();
		}
		if($term) {
			$whereTemp[] ="schoolname like '%$term%'";
		}
		if($whereTemp) {
			$where = "where ".implode(" and ",$whereTemp);
		}
		$sql = "select $select from $this->tbl $where";
		if($order) {
			$sql .= ' '.$order;
		}

		
		if($limit) {
			$sql .= ' '.$limit;
		}
		//echo $sql;
                 
		$rel = $this->db_back->GetAssoc($sql);
		if(is_array($rel)) {
			return $rel;
		} else {
			return array();
		}
		
	}

	public function getSchoolNumber($conf) {
		$countSelect = new Select();
		$countSelect->add('count(id)','number');
		$number = $this->getSchoolByKeyword($countSelect,$conf);
		if(is_array($number)&&!empty($number)) {
			$x = array_pop($number);
			return $x['number'];
		}
		return false;
	
	}
	
	/**
	 *
	 */
	public function getAllValidSchoolNumber() {
		$conf = new Conf();
		$conf->add('isshow',1);
		return $this->getSchoolNumber($conf);
	}

	/*
	 *ȡصѧУĿ
	 */
	public function getKeySchoolNumber() {
		$conf['rank'] = array('operator'=>'>','value'=>'1');
		$conf['isshow'] = 1;
		$conf = new Conf();
		$conf->add('rank','1','>')->add('isshow',1);
		return $this->getSchoolNumber($conf);
	}
	
	/*
	 *ȡѧУСûвѯ ѧУС
	 */
	public function getKeySchoolBlock($schoolId = null) {
		$tbl2 = $this->uc->getSchoolBlockTable();
		if($schoolId) {
			$sql = "select distinct b.block_id from $this->tbl as a left join $tbl2 as b on a.id = b.school_id where a.id='$schoolId' and isshow=1";
		} else {
			$sql = "select distinct b.block_id from $this->tbl as a left join $tbl2 as b on a.id = b.school_id where a.rank>1 and isshow=1";
		}
		$rel = $this->db_back->getAll($sql);
		$bId = array();
		if(is_array($rel)&&!empty($rel)) {
			foreach($rel as $v) {
				$bId[]=$v['block_id'];
			}
			return $bId;
		} else {
		return false; 
		}
	}
	
	/**
	 * СId
	 *@param $schoolId ѧУID
	 *@param $district 
	 *@param $schooltype ѧУ
	 *@param $rank 
	 *@param $features ɫ
	 */
	public function getSchoolBlock($schoolId=null,$district = null,$schooltype =null,$rank = null,$features = null,$isshow=null) {
		$tbl2 = $this->uc->getSchoolBlockTable();
		$schoolConf = new Conf('a');
		if($schoolId) {
			$schoolConf->add('id',$schoolId);
		}
		if($district) {
			$schoolConf->add('district',$district);
		}
		if($schooltype) {
			$schoolConf->add('schooltype',$schooltype);
		}
		if($rank) {
			$schoolConf->add('rank',$rank);
		}
		if($features) {
			$schoolConf->add('features',$features,'in');	
		}
		if($isshow!==null) {
			$schoolConf->add('isshow',$isshow);
		}
		return $this->getSchoolBlockId($schoolConf);
		
	}

	public function getSchoolBlockId($schoolConf) {
		$tbl2 = $this->uc->getSchoolBlockTable();
		$sql ="select distinct b.block_id from $this->tbl as a left join $tbl2 as b on a.id = b.school_id where ".$schoolConf." and b.block_id>0";
		$rel = $this->db_back->getAll($sql);
		$bId = array();
		if(is_array($rel)&&!empty($rel)) {
			foreach($rel as $v) {
				$bId[]=$v['block_id'];
			}
			return $bId;
		} else {
		return false; 
		}
	}

	public function getSellNumber($server,$blockIds) {
		//if(!$this->sellNumber) {
			$this->absSell($server,$blockIds);
		//}
		return $this->sellNumber;
	}

	public function getSell($server,$blockIds) {
		//if(!$this->sell) {
			$this->absSell($server,$blockIds);
		//}
		return  $this->sell;
	
	}

	private function absSell($server,$blockIds) {
		$sqlSell = "select id,address,blockid,blockshowname,price,buildarea,pic1 from sell where esta = 1 and blockid in ($blockIds) order by updatetime limit 0, 4 luc";
		$ary = $server->query($sqlSell);
		$this->sellNumber = $ary["TOTAL"] ? intval($ary["TOTAL"]):0;
		$this->sell  = $ary['Record'];
	}

}



class SchoolBlock {
	private $db;
	private $db_back;
	private $uc;
	private $tbl;
	private $blockTableName = 'block';

	private $blocks;

	public function __construct($db,$db_back,$uc) {
		$this->db = $db;
		$this->db_back = $db_back;
		$this->uc = $uc;
		$this->tbl = $this->uc->getSchoolBlockTable();
	}
	
	public function getAll($schoolId) {
		$sql = "select a.*,b.blockname,b.averprice from $this->tbl as a left join $this->blockTableName as b on a.block_id = b.id where school_id ='$schoolId' order by b.averprice asc";
		$this->blocks = $this->db_back->getAll($sql);
		return $this->blocks;
	}
	
	public function getAllBy($conf,$order=null,$limit=null) {
                $sql = 'select max(updatedate) from block_count ';
                $d = $this->db_back->getOne($sql);
                $d = !empty($d) ?  $d : date("Y-m-d");
		$sql = "select a.*,b.blockname,b.averprice,b.b_map_x,b.b_map_y,c.sellcount from $this->tbl as a left join $this->blockTableName as b on a.block_id = b.id left join block_count as c on a.block_id=c.blockid where $conf and c.updatedate='$d' $order  $limit";
                $this->blocks = $this->db_back->getAll($sql);
		return $this->blocks;
	}
	
	public function getAllAssocBy($conf) {
		$sql = "select a.*,b.blockname,b.averprice from $this->tbl as a left join $this->blockTableName as b on a.block_id = b.id where $conf order by b.averprice asc";
		$this->blocks = $this->db_back->getAssoc($sql);
		return $this->blocks;
	
	}

	public function getMaxPrice() {
		return $this->getPrice('max');
	}

	public function getMinPrice() {
		return $this->getPrice('min');
	}

	private function getPrice($type) {
		$re = 0;
		if($this->blocks) {
			foreach($this->blocks as $k=>$b) {
				if($type=='max') {
					$x = $b['averprice']>$re;	
				}
				if($type=='min') {
					$x =$b['averprice']<$re;
				}
				if($k==0) {
					$re = $b['averprice'];
				}
				if($x&&intval($b['averprice'])) {
					$re = $b['averprice'];
				}
			}
			return $re;
		} else {
			return false;
		}
	}
	
	public function count() {
		if($this->blocks&&is_array($this->blocks)) {
			return count($this->blocks);
		} else {
			return 0;
		}
	
	}

	/**
	 *ȡСԴ
	 */

	/**
	 *ĳСѧУ
	 */
	public function getSchoolByBlockId($blockId) {
		$tblSchool = $this->uc->getSchoolTable();
		$sql = "select a.*,b.block_id from $tblSchool a left join $this->tbl  b on a.id=b.school_id where b.block_id='$blockId' and a.isshow=1 limit 0,3";
		$rel = $this->db_back->getAll($sql);
		return $rel;
	}
}

abstract class UCModel {
	protected $db;
	protected $db_back;
	protected $uc;
	protected $tbl;
	
	public function __construct($db,$db_back,$uc) {
		$this->db = $db;
		$this->db_back = $db_back;
		$this->uc = $uc;
	}
}

class SchoolPic extends UCModel {

	public function __construct($db,$db_back,$uc) {
		parent::__construct($db,$db_back,$uc);
		$this->tbl = $this->uc->getSchoolImgTable();
	}

	public function getAll($schoolId) {
		$s = new select();
		$s->add("*");
		$c = new Conf();
		$c->add('school_id',$schoolId);
		$sS = new SqlSelect();
		$sS->setTable($this->tbl);
		$sS->setSelect($s);
		$sS->setWhere($c);
		$sql = $sS->getSql();
		$schoolPics = $this->db->GetAssoc($sql);
		return $schoolPics;
	}

}

class SqlSelect {
	private $table ;
	private $select;
	private $where;
	private $left;
	private $order;
	private $limit;
	public function setSelect($select) {
		$this->select = $select;
	}

	public function setWhere ($where) {
		$this->where = $where;
	}

	public function setTable($table) {
		$this->table = $table;
	}

	public function getSql() {
		return "select $this->select from $this->table where $this->where";
	}
}

class order {
	private $alis;
	private $d;
	private $data;
	public function __construct($alis=null) {
		$this->alis = $alis;
	}
	public function setOrder($key,$sort) {
		$temp = array();
		$temp['key'] = $key;
		$temp['sort'] = $sort;
		$this->data[$key] = $temp;
		if($this->alis) {
			$this->d = $this->alis.'.'."$key $sort";
		} else {
			$this->d = "$key $sort";
		}
	} 
	
	public function getData(){
		return $this->data;
	}
	public function  __toString() {
		if($this->d) {
			return "order by ".$this->d;
		} else {
			return '';
		}
		
	}
}

class Select {
	private $s=array();

	public function add($name,$alis=null) {
		$this->s[]=$alis?$name." as ".$alis:$name;
		return $this;
	}

	public function __toString() {
        return $this->s?implode(",",$this->s):"*";
    }
}

class Conf {
	private $c = array();
	private $c_o2 = array();
	private $tableName;

	public function __construct($tableName = null) {
		$this->setTableName($tableName);
	}

	public function add($key,$value,$operator1='=',$operator2 = 'and') {
		if($this->tableName) {
			$temp = $this->tableName.'.';
		}
		if($operator1 == 'in') {
			$temp .= $key." ".$operator1." "."('".implode("','",$value)."')";
		} else if($operator1 == 'like') {
			$temp .= $key." ".$operator1." "."'%".$value."%'";
		} else {
			$temp .= $key." ".$operator1." "."'$value'";
		}
		
		$this->c[] = $temp;
		$this->c_o2[] = $operator2;
		return $this;
	}

	public function __toString() {
        return $this->c?implode(" and ",$this->c):"";
    }

	public function setTableName($tableName) {
		$this->tableName = $tableName;
	}
}



function cut_str($string, $sublen, $start = 0, $code = 'UTF-8')
{	$tail = '';//"...";
    if($code == 'UTF-8')
    {
        $pa = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|\xe0[\xa0-\xbf][\x80-\xbf]|[\xe1-\xef][\x80-\xbf][\x80-\xbf]|\xf0[\x90-\xbf][\x80-\xbf][\x80-\xbf]|[\xf1-\xf7][\x80-\xbf][\x80-\xbf][\x80-\xbf]/";
        preg_match_all($pa, $string, $t_string);

        if(count($t_string[0]) - $start > $sublen) return join('', array_slice($t_string[0], $start, $sublen)).$tail;
        return join('', array_slice($t_string[0], $start, $sublen));
    }
    else
    {
        $start = $start*2;
        $sublen = $sublen*2;
        $strlen = strlen($string);
        $tmpstr = '';

        for($i=0; $i< $strlen; $i++)
        {
            if($i>=$start && $i< ($start+$sublen))
            {
                if(ord(substr($string, $i, 1))>129)
                {
                    $tmpstr.= substr($string, $i, 2);
                }
                else
                {
                    $tmpstr.= substr($string, $i, 1);
                }
            }
            if(ord(substr($string, $i, 1))>129) $i++;
        }
        if(strlen($tmpstr)< $strlen ) $tmpstr.= $tail;
        return $tmpstr;
    }
}

class OrderButtons {

	private $data = array();
	private $curKey;
	private $curSort;
	private $url;
	private $orderkey;
	public function __construct($id,$city,$c,$orderkey='order') {
            $this->url = get_xuequ_url($id,$c);  
            $this->orderkey = $orderkey;
	}
	
	public function setState($key,$sort) {
		$this->curKey = $key;
		$this->curSort = $sort;
	}
	
	public function add($button) {
		$this->data[] = $button;
	}

	public function html() {
		$str = '';
		foreach($this->data as $v) {
			$v->setUrl($this->url);
			if($v->getKey() == $this->curKey) {
				$v->setSort($this->curSort);
			}
			$str .= $v->html($this->orderkey);
		}
		$str .= '<input type="hidden" name="'.$this->orderkey.'" value="'.$this->curKey.'-'.$this->curSort.'"/>';
		return $str;
	}

	public function getState($lang='en') {
		$array = array('asc'=>'','desc'=>'');
		if($lang =='cn') {
			$ordername = 'Ĭ';
			foreach($this->data as $v) {
			if($v->getKey() == $this->curKey) {
				//$v->setSort($this->curSort);
				$ordername =$v->getName();
				break;
			}
			}

			return array($ordername,$array[$this->curSort]);
		} else {

			return array(substr($this->curKey,0,-6),$this->curSort);
		}
	}
}

class OrderButton {
	protected $key;
	protected $supportSort = array('asc');
	protected $name;
	protected $checked;
	protected $sort;
	protected $url;
	public function __construct($key,$name) {
		$this->key = $key;
		$this->name = $name;
		return $this;
	}

	public function getName() {
		return $this->name;
	}

	public function getSort() {
		return $this->sort;
	}
	public function setSupportSort($supportSort) {
		$this->supportSort = $supportSort;
		return $this;
	}
	public function setChecked($checked) {
		$this->checked = $checked;
		return $this;
	}
	public function setSort($sort) {
		$this->sort = $sort;
		return $this;
	}
	
	public function getKey() {
		return $this->key;
	}
	public function setUrl($url) {
		$this->url = $url;
	}
	
	protected function getNext() {
		$nexts  = array('asc'=>'desc','desc'=>'asc');
		return $next = $this->sort?$nexts[$this->sort]:'asc';
	}

	public function html($orderkey='order') {
		global $nofollow,$Rewrite_xuequ_detail,$uri_order_array_asc;
		$x = array('asc'=>'Up','desc'=>'Down');
		if($this->sort) {
			$class = 'sortBtn'.$x[$this->sort];
		} else {
			$class = '';
		}
		$url = $Rewrite_xuequ_detail->get_url($orderkey,$uri_order_array_asc[$this->key.'-'.$this->getNext()]);
		$format ='<a '.$nofollow.' href="%s" class="btn sortBtn %s" '.$orderkey.'="'.$this->key.'-'.$this->getNext().'" >%s</a>';
		return sprintf($format,$url,$class,$this->name);
	}
}

class SearchComponent {
	protected $name;
	protected $menu = array();
	protected $realName;
	protected $checkValue;
	protected $current;
	protected $customer;
	public function __construct($name,$realName,$checkValue) {
		$this->name = $name;
		$this->realName=$realName;
		$this->checkValue= $checkValue;
	}

	public function addMenu($name,$value,$key='') {
            global $Rewrite_xuequ_detail;
		if($this->name!='С') {
                    global $nofollow;
		}
		$checked = $value==$this->checkValue?"current":'';
                if($key!=''){
                    $this->menu[] = '<dd class="item"><a '.$nofollow.' href="'.$Rewrite_xuequ_detail->get_url($key,$value).'" class="'.$checked.'"  >'.$name.'</a></dd>';
                }else{
                    $this->menu[] = '<dd class="item"><a '.$nofollow.' href="#" class="'.$checked.'" value="'.$value.'" >'.$name.'</a></dd>';
                }
		return $this;
	}

	public function addMenu1($name,$value,$key='') {
                global $Rewrite_xuequ_detail;
		if(!$this->name=='С') {
                    global $nofollow;
		}
		
		$checked = $value===$this->checkValue?"current":'';
		$checked1 = $value===$this->checkValue&&$value?'itemCurrent':'';
                 if($key!=''){
                    $this->menu[] = '<dd class="item '.$checked1.'"><a '.$nofollow.' href="'.$Rewrite_xuequ_detail->get_url($key,$value).'" class="'.$checked.'"  >'.$name.'</a></dd>';
                }else{
                    $this->menu[] = '<dd class="item '.$checked1.'"><a '.$nofollow.' href="#" class="'.$checked.'" value="'.$value.'" >'.$name.'</a></dd>';
                }
               
		return $this;
	}
	

	public function setCustomer($html) {
		$this->customer = $html;
	}

	public function __toString() {
		return "<p class='title'>".$this->name."</p><dl class='itemBox'>".implode("",$this->menu).$this->customer.$this->createRealName()."</dl>";
	}

	protected function createRealName() {
		return '<input class="hiddeninput" type="hidden" name="'.$this->realName.'" value="'.$this->checkValue.'" />';
	}
}

class SubSearchComponent extends SearchComponent {

	public function addMenu1($name,$value,$key) {
		global $nofollow;
		$checked = $value==$this->checkValue?"current":'';
		$this->menu[] = '<dd class="item '.$checked1.'"><a '.$nofollow.'  href="'.$Rewrite_xuequ_detail->get_url($key,$value).'" class="'.$checked.'" value="'.$value.'" >'.$name.'</a></dd>';
		return $this;
	}

	public function __toString() {
		return '<div class="areaTypeBox"><dl class="areaTypeInner">'.implode("",$this->menu).$this->customer.$this->createRealName()."</dl></div>";
	}

}

class SelectSearchComponent extends SearchComponent {
	public function addMenu($name,$value,$key) {
		global $nofollow,$Rewrite_xuequ_detail;
		$checked = $value==$this->checkValue?"current":'';
		if($checked&&$value!=-1) {
			$this->x = '<label class="label" for="'.$this->realName.'">'.$name.'</label>
					<div class="value">
						<input type="text" readonly="" class="inputReadonly" id="'.$this->realName.'"><input type="hidden" value="'.$value.'" name="'.$this->realName.'" />
					</div>';
		}
		$this->menu[] ='<dd class="selecItem"><a '.$nofollow.' href="'.$Rewrite_xuequ_detail->get_url($key,$value).'" value="'.$value.'" class="link">'.$name.'</a></dd>';
		return $this;
	}
        
        
	public function __toString() {
		if(!$this->x) {
			$this->x = '<label class="label" for="'.$this->realName.'">'.$this->name.'</label>
					<div class="value">
						<input type="text" readonly="" value="" class="inputReadonly" id="'.$this->realName.'"><input type="hidden" value="" name="'.$this->realName.'" />
					</div>';
		}
		return $this->x.'
					<dl class="selectList" style="display: none;">'.implode("",$this->menu).'</dl>';;
	}

}

class DefOrderButton extends OrderButton {

	protected function getNext() {
		//$nexts=array('asc'=>'desc','desc'=>'asc');
		return '';//$next = $this->sort?$nexts[$this->sort]:'asc';
	}

	public function html($orderkey='order') {
		global $nofollow,$Rewrite_xuequ_detail,$uri_order_array_asc;
		if($this->sort) {
				$class = 'acquiesce';
		} else {
				$class = 'acquiesce  acquiesceNot';
		}
		//$url = $this->url;
                $url = $Rewrite_xuequ_detail->get_url($orderkey,$uri_order_array_asc[$this->key.'-asc']);
		$format ='<a '.$nofollow.' href="%s" class="btn %s" '.$orderkey.'="'.$this->key.'-asc">%s</a>';
		return sprintf($format,$url,$class,$this->name);
	}
	
}

function get_school_list_url($pName,$pre,$x=null) 
{
        global $Rewrite_xuequ_detail;
        $url=  $Rewrite_xuequ_detail->get_url($pName,$pre);

       return $url;
}

	/**
	 * 򵥷ҳ
	 *@param $start ʼ
	 *@param $total 
	 *@param $perpage ÿҳ
	 *@parma $name ʾ
	 */
	function simpleNav($start,$total,$perpage,$page,$name = 'Դ'){
		$str1 = '<p class="info">ҵ<span class="color">'.$total.'</span>'.$name.'</p>';
					;
		$prevDisabled = '<span class="trigger prev"></span>';
		$prevAbled ='<a  href="%s" class="trigger prev"></a>';
		$str2 = '<p class="number">'.($start+1).'/'.$total.'</p>';				
		$nextAbled = '<a class="trigger next" href="%s"></a>';				
		$nextDisabled = '<span class="trigger next" ></span>';
		$prev = $start?sprintf($prevAbled,get_school_list_url('page',$page-1)):$prevDisabled;
		$next = $start+$perpage>=$total?$nextDisabled:sprintf($nextAbled,get_school_list_url('page',$page+1));
		return $str1.'<div class="triggerBox"> '.$prev.$str2.$next.'</div>';
		
	}

/**
	 * 򵥷ҳ
	 *@param $start ʼ
	 *@param $total 
	 *@param $perpage ÿҳ
	 *@parma $name ʾ
	 */
	function simpleNav1($start,$total,$number,$name = 'Դ'){
		$str1 = '<p class="info">ҵ<span class="color">'.$number.'</span>'.$name.'</p>';
					;
		$prevDisabled = '<span class="trigger prev"></span>';
		$prevAbled ='<a  href="%s" class="trigger prev"></a>';
		$str2 = '<p class="number">'.($start).'/'.$total.'</p>';				
		$nextAbled = '<a class="trigger next" href="%s"></a>';				
		$nextDisabled = '<span class="trigger next" ></span>';
		$prev = $start-1>0?sprintf($prevAbled,get_school_list_url('page',$start-1)):$prevDisabled;
		$next = $start+1>=$total?$nextDisabled:sprintf($nextAbled,get_school_list_url('page',$start+1));
		return $str1.'<div class="triggerBox"> '.$prev.$str2.$next.'</div>';
		
	}
	

//ҳ
function school_pagenavi($page,$numofpage,$max =null)
{           

		$form='document.search_form';

		$showPages = 5;

		$total = $numofpage;

		if(!empty($max)){
			$max = (int)$max;
			$numofpage > $max && $numofpage = $max;
		}
		if($page>$numofpage) {return '';}
		if($numofpage <= 1 || !is_numeric($page)){
			return '';
		} else{

			$pre	= $page == 1 ? $page : $page - 1;
			$next	= $page == $total ? $total : $page + 1;

			if( $page == 1 ){
				$pages = "<li class='pageItem'><span class='btn_num'>ҳ</span></li><li class='pageItem'>
							<span class='btn_num prev-page'>һҳ</span></li>";
			}else {
				$first_page	= get_school_list_url("page",1,false);
			    $pre_page	= get_school_list_url("page",$pre,true);
				$pages		= "<li class='pageItem'><a class='btn_num' href='$first_page'>ҳ</a></li><li class='pageItem'><a class='btn_num prev-page' href='$pre_page'>һҳ</a></li>";
			}

			if($page > $numofpage){
				$showright = $numofpage;
				$showleft  = $numofpage-($showPages-1);
			}else if($page<=$numofpage && $page>1){

				if($page - 2 >0){
					$showleft = $page-2;
					if($page+2>$numofpage){
						$showright = $numofpage;
					}else{
						$showright = $page+2;
					}
					if($page+2<=$numofpage){
						$showright = $page+2;
					}else{
						$showright = $numofpage;
						if($numofpage < $showPages)
						$showleft = 1;
						else
						$showleft = $numofpage-($showPages-1);
					}
				}else{
					if($numofpage <= $showPages ){
						$showleft	= 1;
						$showright	= $numofpage;
					}
					else{
						$showleft	= $page - 1;
						$showright	= $page + 3;
					}
				}

			}else if($page==1){
				if($numofpage < $showPages)
				$showright = $numofpage;
				else
				$showright = $showPages;
				$showleft = $page;
			}

			for($i=$showleft;$i<=$showright;$i++){
				if($i==$page){
					$now_page= get_school_list_url("page",$page,false);
					$pages .= " <li class='pageItem'><a class='btn_num pageon' href='$now_page'>$page</a></li>";
				}else{
				    $now_i= get_school_list_url("page",$i,false);
				    $pages .= "<li class='pageItem'><a class='btn_num' href='$now_i'>$i</a></li> ";
				}
			}

			if( ($page == $total) || ($total == 0) ){
				$pages .= " <li class='pageItem'><span class='btn_num next-page'>һҳ</span></li>";
			} else {
                $next_page= get_school_list_url("page",$next,false);
				$pages .= "<li class='pageItem'><a class='btn_num next-page' href='$next_page'>һҳ</a></li>";
			}
			return $pages;
		}
	}

if(!function_exists(toThumb)) {
	function toThumb($imgUrl) {
	if(!stripos($imgUrl,'/thumb/')) {
		$bn = basename($imgUrl);
		return str_replace($bn,"thumb/".$bn,$imgUrl);
	} else {
		
		return false;
	}
	}
}



//ѧУǷУ̽
function checkTanFang($schoolname,$simpleTanFang) {
	foreach($simpleTanFang as $v) {
		$vowels = array("", "");
		$schoolname = str_replace($vowels, "", $schoolname);
		if(strripos($v['title'],$schoolname)===false) {
		 
		} else {
			return $v;
		}
	}
	return false;
}

//Ѷhtml
function newsHtml($newData,$number=null,$titleNum=null,$suffix='...') {
	if(!$newData){$newData = array();}
	$html = '<dl class="list">';
	if(!$number) {
		$number = count($newData);
		
	} 
	foreach($newData as $key=>$v) {
			if($titleNum&&mb_strlen($v['title'],'GB2312')>$titleNum) {
				$title = mb_substr($v['title'],0,$titleNum,'GB2312');
				$title .= $suffix;
			} else {
				$title = $v['title'];
			}
			$html .= '<dd class="item"><a title="'.$v['title'].'" class="link" href="'.$v['url'].'" target="_blank">'.$title.'</a></dd>';
			$number--;
			if($number<=0) { break; }
		}
	$html .= ' </dl>';
	return $html;
}
	  //Ѷ
function newsToSimple($news,$newsData){
	$simple = array();
	if(!$newData){$newData = array();}
        if( is_array($newsData['Record']) &&  !empty($newsData['Record']) ){
            foreach($newsData['Record'] as $key=>$v) {
                    $temp = array();
                    $temp ['url'] = $news->getNewsUrl($key);
                    $temp['title'] = $v['NEWS_TITLE'];//$news->getNewsTitle($key);//$v['TITLE'];
                    $temp['img'] = $news->getNewsImage($v['NEWS_ID']);//$v['ATTRIBUTE_VALUE'];
                    $temp['newid'] = $v['NEWS_ID'];
                    $temp['new_title'] = $v['NEWS_TITLE'];
                    $simple[] = $temp;
            }
        }
	return $simple;
}



function newsToSimple1($news,$newsData){
	$simple = array();
	if(!$newData){$newData = array();}
        if( is_array($newsData['Record']) &&  !empty($newsData['Record']) ){
            foreach($newsData['Record'] as $key=>$v) {
                    $temp = array();
                    $temp ['url'] = $news->getNewsUrl($key);
                    $temp['title'] = $v['TITLE'];//$news->getNewsTitle($key);//$v['TITLE'];
                    $temp['img'] = $news->getNewsImage($v['NEWS_ID']);//$v['ATTRIBUTE_VALUE'];
                    $temp['newid'] = $v['NEWS_ID'];
                    $temp['new_title'] = $v['TITLE'];
                    $simple[] = $temp;
            }
        }
	return $simple;
}

// תɫʽ
function arrayToFeature($array) {
	if(is_array($array)&&!empty($array)) {
		return "#".implode('#,#',$array)."#";
	} else {
		return '';
	}
	
}

//л תɫʽ
function arraySerToFeature($arraySer) {
	$array = unserialize($arraySer);
	return arrayToFeature($array);
}

function featureToArray($string){
	if($string) {
		$array= explode('#,#',substr($string,1,-1));
	} else {
		$array = array();
	}
	return $array;
}

function featureRegxp($features) {
	array_multisort($features, SORT_ASC);
	return '(.*)#'.implode('#,(.*)#',$features).'#';
	//'(.*)#2#,(.*)#3#,(.*)#5#';
}

function thumbToBig($imgUrl) {
	return str_replace("thumb/",'',$imgUrl);
}

function getNewsListUrl($conf_city,$channel = null) {
	return 'http://news.'.$conf_city.'.house365.com/newslist'.$channel;

}

function getSchoolBlockHouseUrl($id,$blockId) {
	global $GB_CITY_SELL_URL;
	$format =$GB_CITY_SELL_URL.'./school_district_detail.php?id=%s&c=sell&blockid=%s';
	return sprintf($format,$id,$blockId);
}


function getSellHouseUrl ($houseId) {
	return get_sellinfo_url($houseId);
}

function getSchoolUrl ($id,$c= null) {
    global $conf_city;
    $schoolDetailUrl = "http://".$conf_city.".sell.house365.com/school_district_detail.php?id=%s&c=%s";
    return sprintf($schoolDetailUrl,$id,$c);
}

function getSchoolBlockUrl($blockId) {
    $schoolBlockUrl = get_block_url($blockId);
    return $schoolBlockUrl;
}

class Crumbs {
	private $data;
	public function add($name,$url=null) {
		$this->data[] = array('name'=>$name,'url'=>$url);
		return $this;
	}
	public function getHtml() {
		$content = '';
		$number = count($this->data);
		foreach($this->data as $key=>$v) {
			if($key<$number-1) {
				$content .= '<a target="_blank" href="'.$v['url'].'" class="link">'.$v['name'].'</a>';
			} else {
				$content .= $v['name'];
			}
			
			if($key<$number-1) { $content .= '<span class="sprite">&gt;</span>'; }
		}
		$html = '<div class="crumbs">'.$content.'</div>';
		return $html;
	}
}

function count365js($conf_city,$channel,$ga_page) {
	$count365 = '<script type="text/javascript">
	var website = 2;
    var ga_city = "'.$conf_city.'";
    var ga_channel = "'.$channel.'";
    var ga_page= "'.$ga_page.'";
</script>
<script language="javascript" src="http://stat.house365.com/'.$conf_city.'365count.js"></script>';
return $count365;
}

class Route {
	
	private $path;
	private $name;
	private $params;
	public function __construct($name,$path) {
		$this->path = $path;
		$this->name = $name;
		$pattern  = '/\.+/g';
		$input = '/articles/{culture}/{year}/{title}.{_format}';
		$array = preg_grep ($pattern,$input);
		print_r($array);
	}

	public function geneUrl() {
	
	}

	private function u () {
	
	}
}
?>