<?php

/**
 * sitemapXMLļڵ<url></url>
 *
 * @param string $loc URLӵַ
 * @param string $lastmod ָӵʱ
 * @param string $changefreq Ƶ
 * @param string $priority Ȩ
 * @return string 
 */
function create_sitemap_url_ts($loc, $lastmod, $changefreq = '', $priority = '')
{
	$sitemap  =  "<url>\r\n";
	$sitemap .=  "<loc>".$loc."</loc>\r\n";
	$sitemap .=  "<lastmod>".$lastmod."</lastmod>\r\n";
	$sitemap .=  "<changefreq>".$changefreq."</changefreq>\r\n";
	$sitemap .=  "<priority>".$priority."</priority>\r\n";
	$sitemap .=  "</url>\r\n";
	return $sitemap;
}

/**
 * sitemapXMLļ
 *
 * @param array $data 
 * @param string $filename Ŀ¼ 磺sitemap/sitemap.xml
 * @return string 
 */
function create_sitemap_child_ts($data, $limit = 10000, $lastmod = '', $path = '')
{
	if($lastmod == '') $lastmod = date('Y-m-d',time());
	$sitemap_head  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\r\n";
	$sitemap_footer = "</urlset>";
	$f_array = array();
	foreach($data as $key => $val)
	{
		$modCount = intval(floor($key/$limit));
		if($f_array[$modCount] == ""){
			$f_array[$modCount] = "";
		}
		if(empty($val['changefreq'])){
			$val['changefreq'] = '';
		}
		if(empty($val['priority'])){
			$val['priority'] = '';
		}
		$sitemap_url = create_sitemap_url_ts($val['loc'], $lastmod, $val['changefreq'], $val['priority']);
		$f_array[$modCount] .= $sitemap_url;
	}
	$sitemap_files = array();
	foreach($f_array as $k => $v){
		$file_name = "sitemap_child_".$k.".xml";
		$sitemap_files[] = $file_name;
		$filexml = fopen($path.$file_name, "w"); 
		fwrite($filexml, $sitemap_head.$v.$sitemap_footer); 
		fclose($filexml);
	}
	return $sitemap_files;
}

/**
 * ɸsitemapXMLļ
 *
 * @param array $data ļַ
 * @param string $filename Ŀ¼ 磺sitemap/sitemap.xml
 * @return string 
 */
function create_sitemap_index_ts($data, $lastmod = '', $filename = 'sitemap.xml')
{
	if($lastmod == '') $lastmod = date('Y-m-d',time());
	$sitemap  = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\r\n";
    foreach($data as $val)
	{
		$sitemap .= "<sitemap>\r\n<loc>".$val."</loc>\r\n<lastmod>".$lastmod."</lastmod>\r\n</sitemap>\r\n";
	}
	$sitemap .= "</sitemapindex>";
	$filexml = fopen($filename, "w"); 
	fwrite($filexml, $sitemap); 
	fclose($filexml); 
}

/**
 * UriRewriteдURL
 *
 * @param string $types 
 * @param array $array 
 * @return string 
 */
if(!function_exists('getShopAnalyUrlCommSunsB')) {
	function getShopAnalyUrlCommSunsB($types,$array)
	{
		$Rewritess = new UriRewrite($types,false);
		$url = $Rewritess->get_url($array);
		return $url;
	}
}

/**
 * ð
 *
 * @return array 
 */
function get_street_list_ts()
{
	global $dbback,$conf_cityflag,$mc;
	$mem_key = 'sell_district_list_'.$conf_cityflag."_tsun";
	$cache = $mc->get($mem_key);
	if($cache) {
	   $streetlist = $cache;
	}else {
	   $streetlist = $dbback->GetAll("select id,district from street");
	   $mc->add($mem_key,$streetlist ,false,3600);
	}
	return $streetlist;
}

/**
 * õ
 *
 * @return array 
 */
function get_subway_list_ts()
{
	global $dbback,$conf_cityflag,$mc;
	$mem_key = 'sell_subway_list_'.$conf_cityflag."_tsun";
	$cache = $mc->get($mem_key);
	if($cache) {
	   $arr_railway_new = $cache;
	}else {
		$railwaylist = $dbback->GetAll("select line from traffic where type=2  group by  line order by bid asc ");
		$i = 1;
		$arr_line_railway = array();
		foreach($railwaylist as $key => $value){
			$arr_line_railway[$i] = $value['line'];
			$i++;
		}
		if($conf_cityflag == 'sz'){
		   array_pop($arr_line_railway);
	    }
		$arr_line_railway_asc = array_flip($arr_line_railway);
		$arr_railway = $dbback->GetAll("select bid,line from traffic where type=2");
		$arr_railway_new = array();
		foreach($arr_railway as $v){
			if($arr_line_railway_asc[$v['line']] != ''){
				$arr_railway_new[$arr_line_railway_asc[$v['line']]][]=$v['bid'];
			}
		}	   
		$mc->add($mem_key,$arr_railway_new ,false,3600);
	}
	return $arr_railway_new;
}

/**
 * BRT
 *
 * @return array 
 */
function get_brt_list_ts()
{
	global $dbback,$conf_cityflag,$mc;
	$mem_key = 'sell_brt_list_'.$conf_cityflag."_tsun";
	$cache = $mc->get($mem_key);
	if($cache) {
	   $arr_railway_new = $cache;
	}else {
		$railwaylist = $dbback->GetAll("select line from traffic where type=3  group by  line order by bid asc ");
		$i = 1;
		$arr_line_railway = array();
		foreach($railwaylist as $key => $value){
			$arr_line_railway[$i] = $value['line'];
			$i++;
		}
		$arr_line_railway_asc = array_flip($arr_line_railway);
		$arr_railway = $dbback->GetAll("select bid,line from traffic where type=3");
		$arr_railway_new = array();
		foreach($arr_railway as $v){
			if($arr_line_railway_asc[$v['line']] != ''){
				$arr_railway_new[$arr_line_railway_asc[$v['line']]][]=$v['bid'];
			}
		}	   
		$mc->add($mem_key,$arr_railway_new ,false,3600);
	}
	return $arr_railway_new;
}

/**
 * school
 *
 * @return array 
 */
function get_school_list_ts()
{
	global $dbback,$conf_cityflag,$mc;
	$mem_key = 'sell_school_list_'.$conf_cityflag."_tsun";
	$cache = $mc->get($mem_key);
	if($cache) {
	   $list = $cache;
	}else {
		$list = $dbback->GetAll("SELECT id FROM `school` where isshow = 1");
		$mc->add($mem_key,$list ,false,3600);
	}
	return $list;
}

/**
 * С
 *
 * @return array 
 */
function get_community_list_ts()
{
	global $dbback,$conf_cityflag,$mc;
	$mem_key = 'sell_community_list_'.$conf_cityflag."_tsun";
	$cache = $mc->get($mem_key);
	if($cache) {
	   $list = $cache;
	}else {
		$list = $dbback->GetAll("SELECT id FROM block WHERE esta = 2 AND blockname != ''");
		$mc->add($mem_key,$list ,false,3600);
	}
	return $list;
}

/**
 * þ
 *
 * @return array 
 */
function get_broker_list_ts()
{
	global $dbback,$conf_cityflag,$mc;
	$mem_key = 'sell_broker_list_'.$conf_cityflag."_tsun";
	$cache = $mc->get($mem_key);
	if($cache) {
	   $list = $cache;
	}else {
		$list = $dbback->GetAll("SELECT uid FROM `broker` WHERE valid_flag = 1");
		$mc->add($mem_key,$list ,false,3600);
	}
	return $list;
}

/**
 * ʴ
 *
 * @return array 
 */
function get_question_list_ts()
{
	global $dbback,$conf_cityflag,$mc;
	$mem_key = 'sell_question_list_'.$conf_cityflag."_tsun";
	$cache = $mc->get($mem_key);
	if($cache) {
	   $list = $cache;
	}else {
		$list = $dbback->GetAll("SELECT q_id FROM qa_question WHERE q_esta = 1");
		$mc->add($mem_key,$list ,false,3600);
	}
	return $list;
}
?>