<?php
/*
ԤԼˢ· by fisher
ļreserve.class.php
ڣ2013-6-14
ڣ2013-6-14
*/

class Reserve
{
	private $dao;

	private $project_table = 'reserve_refresh_project';
	private $project_house_table = 'reserve_refresh_project_house';
	private $project_time_table = 'reserve_refresh_project_time';

	private $uid;
	private $city;

	public $project_max_num;//˵ԤԼ
	public $project_times_max_num;//һʱ
	public $project_times_max_days;//һԴԤԼ

	public function __construct($uid)
	{
		global $dao, $conf_city;

		$this->uid = $uid;
		
		$this->dao = $dao;
		$this->city = $conf_city;

		$this->project_max_num = 10;//øþ˵ԤԼ
		$this->project_times_max_num = 10;//þһʱ
		$this->project_times_max_days = 7;//þһԴԤԼ

	}
	
	//ȡҵԤԼˢ·
	public function getMyProjects($delcache = false)
	{
		$sswhere = " uid = '".$this->uid."' ";
		$params = "id,name";
		$memkey = $this->city."_myprojects_".$this->uid;
		$memsec = '300';

		$project_arr = $this->dao->getAll($this->project_table, $sswhere, $params, $memkey, $memsec, $delcache);

		return $project_arr;
	}
	
	//ݷIDȡ÷
	public function getProjectNameByPid($pid, $delcache = false)
	{
		$project_name = "";

		$pid = intval($pid);
		if($pid > 0)
		{
			$sswhere = " id = '".$pid."' AND uid = '".$this->uid."' ";
			$params = "name";
			$memkey = $this->city."_projectname_".$pid."_".$this->uid;
			$memsec = '300';
			$project_name = $this->dao->getOne($this->project_table, $sswhere, $params, $memkey, $memsec, $delcache);
		}

		return $project_name;
	}

	//ݷIDȡ÷ʱ
	public function getProjectTimesByPid($pid, $delcache = false)
	{
		$pid = intval($pid);
		$name = $this->getProjectNameByPid($pid);

		if($name != "")
		{
			$sswhere = " pid = '".$pid."' ORDER BY time ASC";
			$params = "time";
			$memkey = $this->city."_projecttimes_".$pid;
			$memsec = '300';
			$project_name = $this->dao->getAll($this->project_time_table, $sswhere, $params, $memkey, $memsec, $delcache);
		}

		return $project_name;
	}

	//ʱַΪȾҳ
	public function getProjectTimeArr($project_times_arr)
	{
		$ptime_arr = array();
		if(is_array($project_times_arr) && !empty($project_times_arr))
		{
			foreach($project_times_arr as $val)
			{
				$time_str = $val['time'];
				$time_arr = explode(":", $time_str);
				if($time_arr[0] != "00")
				{
					$ptime_arr[$time_arr[0]][$time_arr[1]] = $time_arr[1];
				}
			}
		}
		
		return $ptime_arr;
	}

	//ݷIDȡ÷뷿Դ
	public function getProjectHousesByPid($pid, $delcache = false)
	{
		$pid = intval($pid);
		$project_name = array();
		$name = $this->getProjectNameByPid($pid);

		if($name != "")
		{
			$sswhere = " pid = '".$pid."' ORDER BY tbl ASC, endtime ASC";
			$params = "id,tbl,rowid,starttime,endtime";
			$memkey = $this->city."_projecthouses_".$pid;
			$memsec = '300';
			$project_name = $this->dao->getAll($this->project_house_table, $sswhere, $params, $memkey, $memsec, $delcache);
		}

		return $project_name;
	}

	//ݷIDȡ÷ϸϢ
	public function getProjectByPid($pid)
	{
		$project = array();

		$pid = intval($pid);
		$name = $this->getProjectNameByPid($pid);

		if($name != "")
		{
			$project['id'] = $pid;
			$project['name'] = $name;
			$project['time'] = $this->getProjectTimesByPid($pid);
			$project['house'] = $this->getProjectHousesByPid($pid);
		}

		return $project;
	}

	//ݷԴϢȡ÷ϸϢ
	public function getProjectByTblRowid($tbl, $rowid)
	{
		$project = array();
		
		$tbl = $tbl == "sell" ? "sell" : "rent";
		$rowid = intval($rowid);

		//ȡҵԤԼˢ·
		$project_arr = $this->getMyProjects();
		
		if(is_array($project_arr) && !empty($project_arr))
		{
			$parr = $this->dao->getRow("reserve_refresh_project_house", " tbl = '".$tbl."' AND rowid = '".$rowid."' ", "pid,endtime");
		}

		if($parr['pid'] > 0)
		{
			$project['name'] = $project_arr[$parr['pid']];
			$project['id'] = $parr['pid'];
			$project['endtime'] = $parr['endtime'];
		}

		return $project;
	}

	//ɾԴԤԼĹ
	public function deleteProjectHouse($tbl, $rowid)
	{
		$project = array();
		
		$tbl = $tbl == "sell" ? "sell" : "rent";
		$rowid = intval($rowid);

		if($rowid > 0)
		{
			$sswhere = " tbl = '".$tbl."' AND rowid = '".$rowid."' ";
			$this->dao->delete($this->project_house_table, $sswhere);
		}
	}

	//ɾʱԤԼ$pidĹ
	public function deleteProjectTimes($pid)
	{
		$pid = intval($pid);

		$sswhere = " pid = '".$pid."'";
		$this->dao->delete($this->project_time_table, $sswhere);

		//
		$this->dao->mc->delete($this->city."_projecttimes_".$pid);
	}

	//ɾԴԤԼ$pidĹ
	public function deleteProjectHouses($pid)
	{
		$pid = intval($pid);

		$sswhere = " pid = '".$pid."'";
		$this->dao->delete($this->project_house_table, $sswhere);

		//
		$this->dao->mc->delete($this->city."_projecthouses_".$pid);
	}


	//
	public function addProjectName($pname)
	{
		$project = $this->getMyProjects();
		$now_nums = count($project);

		$pid = 0;
		
		//жϵǰԤԼˢ·Ƿ
		if($now_nums < $this->project_max_num)
		{
			$pname = strip_tags(trim($pname));

			$dateline = time();
			$field = array('uid'=>$this->uid,'name'=>$pname, 'dateline'=>$dateline);
			$pid = $this->dao->insert($this->project_table, $field);
			
			//
			$this->dao->mc->delete($this->city."_myprojects_".$this->uid);
		}

		return $pid;
	}

	//·
	public function updateProjectName($pid, $pname)
	{
		$pid = intval($pid);
		$name = $this->getProjectNameByPid($pid);
		
		if($name != "")
		{
			$pname = strip_tags(trim($pname));

			$field = array('name'=>$pname);
			$sswhere = " id = '".$pid."' ";
			
			$this->dao->update($this->project_table, $field, $sswhere);
			
			//
			$this->dao->mc->delete($this->city."_myprojects_".$this->uid);
			$this->dao->mc->delete($this->city."_projectname_".$pid."_".$this->uid);
		}
	}

	//ʱ
	public function addProjectTimes($pid, $times)
	{
		$pid = intval($pid);
		$name = $this->getProjectNameByPid($pid);

		$times = strip_tags(trim($times));
		
		if($name != "" && $pid > 0 && $times != "")
		{
			$time_arr = explode(",", $times);
			//ύĻͻһ
			unset($time_arr[$this->project_times_max_num]);

			if(is_array($time_arr) && !empty($time_arr) && count($time_arr) <= $this->project_times_max_num)
			{
				//Ҫɾʷ
				$this->deleteProjectTimes($pid);
				
				//²
				foreach($time_arr as $val)
				{
					$time = strtotime($val);
					if($time > 0)
					{
						$val = date('H:i:s', $time);
						$field = array('pid'=>$pid, 'time'=>$val);
						$this->dao->insert($this->project_time_table, $field);	
					}
				}

				//
				$this->dao->mc->delete($this->city."_projecttimes_".$pid);
			}
		}
	}

	//뷿Դ
	public function addProjectHouses($pid, $tbl, $house_arr, $days)
	{
		$pid = intval($pid);
		$name = $this->getProjectNameByPid($pid);

		$tbl = $tbl == 'sell' ? 'sell' : 'rent';
		$days = intval($days);
		$days = $days > $this->project_times_max_days ? $this->project_times_max_days : ($days < 1 ? 1 : $days);

		$starttime = time();
		$endtime = strtotime(date("Y-m-d")) + $days * 86400 - 1;

		if($name != "" && $pid > 0 && is_array($house_arr) && !empty($house_arr))
		{
			foreach($house_arr as $val)
			{
				$rowid = intval($val);
				$field = array('pid'=>$pid, 'tbl'=>$tbl, 'rowid'=>$rowid, 'starttime'=>$starttime, 'endtime'=>$endtime);
				$this->dao->replace($this->project_house_table, $field);
			}
			
			//
			$this->dao->mc->delete($this->city."_projecthouses_".$pid);
		}
	}

	//·뷿Դ
	public function updateProjectHouses($pid, $house_arr)
	{
		$pid = intval($pid);
		$name = $this->getProjectNameByPid($pid);

		if($name != "" && $pid > 0 && is_array($house_arr) && !empty($house_arr))
		{
			$this->deleteProjectHouses($pid);

			foreach($house_arr as $val)
			{
				$rowid = intval($val['rowid']);
				$tbl = $val['tbl'] == 'sell' ? 'sell' : 'rent';
				$starttime = $val['starttime'];
				$endtime = $val['endtime'];
				$field = array('pid'=>$pid, 'tbl'=>$tbl, 'rowid'=>$rowid, 'starttime'=>$starttime, 'endtime'=>$endtime);
				$this->dao->replace($this->project_house_table, $field);
			}

			//
			$this->dao->mc->delete($this->city."_projecthouses_".$pid);
		}
	}
}
?>