<?php
/**
 * ķ
 * @author sun
 */
class PayHousebeanWay {

    /**
     *
     * @var TINY_ADODB ݿ 
     */    
    private $db;
    
    /**
     *
     * @var type ݿ
     */
    private $dbback;
    
    /**
     *
     * @var type 
     */
    private $mc;

    /**
     *
     * @var String ı 
     */
    private $table;
    
    /**
     * 캯ʼdb memcache ȡ
     * @param string $table ʹĬֵ
     */
    public function __construct() {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = 'pay_housebean_way';
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * ʼȡʽ
     * @param array $fields ֶ
     * @return boolean
     */
    public function initData($fields) {
        $sql = SqlCombinHelper::insert_sql($this->table, $fields);
        return $this->db->execute($sql);
    }
    
    /**
     * ݱûȡʽ
     * @param string $wayAlias 
     * @return Mixed 
     */
    public function getByWayAlias($wayAlias) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,
                "alias ='$wayAlias'");
        return $this->dbback->getRow($sql);
    }
    
    /**
     * ݱȡķ
     * @param string $wayAlias 
     * @return int
     */
    public function getNumByWayAlias($wayAlias) {
        $wayOne = $this->getByWayAlias($wayAlias);
        return $wayOne['num'];
    }
    
    /**
     * ȡϢ
     * @param string $wayAlias 
     * @return string
     */
    public function getDescriptionByWayAlias($wayAlias) {
        $wayOne = $this->getByWayAlias($wayAlias);
        return $wayOne['description'];
    }
    
    /**
     * ȡϢ
     * @param string $wayAlias 
     * @return string
     */
    public function getTypeByWayAlias($wayAlias) {
        $wayOne = $this->getByWayAlias($wayAlias);
        return $wayOne['type'];
    }
    
    /**
     * շȡʽ
     */
    public function emptyTable() {
        $sql = "TRUNCATE TABLE $this->table";
        $this->db->Execute($sql);
    }
}
