<?php

class ComplainRecord{
     /**
     *
     * @var TINY_ADODB ݿ
     */
    protected $db;
    /**
     *
     * @var TINY_ADODB ݿ
     */
    protected $dbback;
    /**
     *
     * @var Memcache 
     */
    protected $mc;
    /**
     *
     * @var string 
     */
    protected $table;
    /**
     *
     * @var ֶ 
     */
    protected $fields;
    
    /**
     * ʼ
     * @param string $table ĬΪcomplain_record
     */
    public function __construct($table='complain_record') {
        $container = Container::getInstance();
        $this->db = $container->get('db');
        $this->dbback = $container->get('dbback');
        $this->table = $table;
        $this->mc = $container->get('mc');
        $sqlfield = "DESC $this->table";
        $fieldsMKey = $sqlfield;
        $this->fields = $this->mc->get($fieldsMKey);
        if($this->fields === false) {
            $fields = $this->dbback->getAll($sqlfield);
            foreach ($fields as $field) {
                $this->fields[] = $field['Field'];
            }
            $this->mc->set($fieldsMKey, $this->fields, 3600);
        }
    }
    
    /**
     * findByHouseId
     * ݷԴidҼ¼
     * @param int $houseId ԴID
     * @return array
     */    
    public function findByHouseId($houseId){
          $sql = SqlCombinHelper::select_sql($this->table, $this->fields,
                "house_id = $houseId");
        return $this->dbback->getAll($sql);
    }



	/**
     * findByHouseId
     * ݷԴidҼ¼
     * @param int $houseId ԴID
     * @return array
     */    
    public function findByHouseIdFromDb($houseId){
          $sql = SqlCombinHelper::select_sql($this->table, $this->fields,
                "house_id = $houseId");
        return $this->db->getAll($sql);
    }
    
    
    /**
     * findCountByHouseId
     * ݷԴidͳ
     * @param int $houseId
     * @return int 
     */
    public function findCountByHouseId($houseId){
        $sql = SqlCombinHelper::count_sql($this->table, "house_id=$houseId");
        return $this->dbback->getOne($sql);
    }
    
    
    
     /*
     * Ҽ¼findByConf
     * findByConf
     */
     public function findByConf($conf,$order='',$offset='',$limit='',$groupby='') {      
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $conf);
        if($groupby){
            $sql .= "GROUP BY $groupby";
        }
        if($order) {
            $sql .= " ORDER BY $order";
        }
        if($limit && $offset){
          $sql .= " LIMIT ".$offset.",".$limit;
         }elseif($limit) {
            $sql .= " LIMIT $limit";
        }

        return $this->db->GetAll($sql);
    }
    
    
    /*
     * Ҽ¼findByConfGroupHaving
     * findByConf
     */
     public function findByConfGroupHaving($conf,$order='',$offset='',$limit='',$groupby='',$having) {      
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $conf);
        if($groupby){
            $sql .= " GROUP BY $groupby";
        }
        if($order) {
            $sql .= " ORDER BY $order";
        }
        if($having){
            $sql .= "HAVING $having";            
        }
        if($limit && $offset){
          $sql .= " LIMIT ".$offset.",".$limit;
         }elseif($limit) {
            $sql .= " LIMIT $limit";
        }

        return $this->db->GetAll($sql);
    }
        /*
     * Ҽ¼findByConfGroupHaving
     * findByConf
     */
     public function countByConfGroupHaving($conf,$groupby='',$having) {      
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $conf);
        if($groupby){
            $sql .= "GROUP BY $groupby";
        }
        if($having){
            $sql .= "HAVING $having";            
        }
        $sql = SqlCombinHelper::count_sql($this->table, $conf);
        return $this->dbback->getOne($sql);
    }
    
    /*
     * ͳ
     * findCountByConf
     */
	public function findCountByConf($conf,$groupby='') {   
        if($groupby){
            $conf .= " GROUP BY $groupby";
        }
        
		$sql = SqlCombinHelper::count_sql($this->table, $conf);
        return $this->dbback->getOne($sql);
	}  
    

    /*
     * ݾidҼ¼
     * findByBrokerAndStatus
     */
     public function findByBrokerAndStatus($broker_id,$status='',$order='',$offset='',$limit='') {
        $conf =  $status!= '' ?  "broker_id='$broker_id' AND status= $status" : "broker_id='$broker_id'";
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields, $conf);
        if($order) {
            $sql .= " ORDER BY $order";
        }
        if($limit && $offset){
          $sql .= " LIMIT ".$offset.",".$limit;
         }elseif($limit) {
            $sql .= " LIMIT $limit";
        }

        return $this->db->GetAll($sql);
    }
    
    
    /*
     * ݾid״̬ͳ
     * findCountByBrokerAndStatus
     */
	public function findCountByBrokerAndStatus($uid,$status='') {
        $conf =  $status!= '' ?  "broker_id='$uid' AND status= $status" : "broker_id='$uid'";
		$sql = SqlCombinHelper::count_sql($this->table, $conf); 
        return $this->dbback->getOne($sql);
	}  
    
    
    
    
    
    /**
     * ȡĳԴǷĳ˾ٱ
     * @param type $bid
     * @param type $houseId
     * @return type
     */
    public function findByBrokerAndHouseId($uid, $houseId) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,
                "broker_id = $uid  AND house_id = $houseId ");
        return $this->dbback->getRow($sql);
    }
   
    
    /*
     * id
     */
    public function findById($id) {
        $sql = SqlCombinHelper::select_sql($this->table, $this->fields,"id='$id'");
        return $this->dbback->GetRow($sql);
    }
    
    

    public function insert($fieldData) {
        if($this->checkField($fieldData)){
            $sql = SqlCombinHelper::insert_sql($this->table, $fieldData);           
            $this->db->execute($sql);
            return $this->db->Insert_ID();
        } else {
            return false;
        }
    }
    
   

    /**
     * 
     * @param array $fieldData
     * @param string $conf
     * @return boolean
     */
    public function update($fieldData,$conf) {
        if($this->checkField($fieldData)){
            $sql = SqlCombinHelper::update_sql($this->table, $fieldData, $conf);
            $this->db->Execute($sql);
            return $this->db->Affected_Rows();
        } else {
            return false;
        }
    }

   
    /**
     * Ƿȷ
     * @param array $fields Ҫ
     * @return boolean ȷtrueʧܷfalse
     */
    public function checkField($fieldData) {
        $fields = array_keys($fieldData);
        if(array_intersect($fields, $this->fields)==$fields){
            return true;
        } else {
            return false;
        }
    }
    
 
    
    public function getTable() {
        return $this->table;
    } 

  
    
    
    public function getFields() {
        return $this->fields;
    }
    /**
     * ձ
     */
    public function emptyAll() {
        $sql = "DELETE FROM $this->table";
        return $this->db->Execute($sql);
    }
    
    public function insertMutl(array $filedData) {
        $sql = SqlCombinHelper::insertMutil_sql($this->table, $filedData);
        $this->db->execute($sql);
        return $this->db->Affected_Rows();
    }
    
    
    
    
}
