<?php
/**
 * UserBehavior Class
 *
 * ¼ûΪ
 *
 * @package         core
 * @subpackage      lib
 * @author          liuhu
 */

class UserBehavior
{
    /**
    * ûID
    *
    * @access private
    * @var integer
    */
    private  $_uid = 0;
    
    /**
    * ¼ID
    *
    * @access private
    * @var integer
    */
    private  $_id = 0;
    
   /**
    * ֻ
    *
    * @access private
    * @var integer
    */
    private  $_telno = '';
    
    /**
    * 豸
    *
    * @access private
    * @var integer
    */
    private  $_device = 0;
    
    /**
    * 
    *
    * @access private
    * @var integer
    */
    private  $_district = 0;
    
    /**
    * 
    *
    * @access private
    * @var integer
    */
    private  $_street = 0;
    
    /**
    * Դ
    *
    * @access private
    * @var integer
    */
    private  $_infofrom = 0;
    
    /**
    * Դ
    *
    * @access private
    * @var integer
    */
    private  $_infotype = 0;
    
    /**
    * Դ޷ʽ
    *
    * @access private
    * @var integer
    */
    private  $_renttype = 0;
    
    /**
    * װ޳̶
    *
    * @access private
    * @var integer
    */
    private  $_fitment = 0;
    
    /**
    * Դ۸
    *
    * @access private
    * @var integer
    */
    private  $_price1 = 0;
    
    /**
    * Դ۸
    *
    * @access private
    * @var integer
    */
    private  $_price2 = 0;
    
    /**
    * Դ
    *
    * @access private
    * @var integer
    */
    private  $_averprice1 = 0;
    
    /**
    * Դ
    *
    * @access private
    * @var integer
    */
    private  $_averprice2 = 0;
    
    /**
    * Դ
    *
    * @access private
    * @var integer
    */
    private  $_buildarea1 = 0;
    
    /**
    * Դ
    *
    * @access private
    * @var integer
    */
    private  $_buildarea2 = 0;
    
    /**
    * Դ
    *
    * @access private
    * @var integer
    */
    private  $_room1 = 0;
    
    /**
    * Դ
    *
    * @access private
    * @var integer
    */
    private  $_room2 = 0;
    
    /**
    * Դ¥
    *
    * @access private
    * @var integer
    */
    private  $_floor1 = 0;
    
    /**
    * Դ¥
    *
    * @access private
    * @var integer
    */
    private  $_floor2 = 0;
    
    /**
    * 
    *
    * @access private
    * @var integer
    */
    private $_qa_type = 0;
    
    /**
    * 
    *
    * @access private
    * @var integer
    */
    private $_qa_class = 0;
    
    /**
    * ǷѴ
    *
    * @access private
    * @var integer
    */
    private $_is_best = 0;

	/**
    * ѧУ
    *
    * @access private
    * @var integer
    */
	private $_category_sh = 0;
	
	/**
    * ѧУȼ
    *
    * @access private
    * @var integer
    */
	private $_rank = 0;
    
    /**
    * ؼ/С
    *
    * @access private
    * @var string
    */
    private  $_keyword = '';
    
    /**
    * ûڵĳ
    *
    * @access private
    * @var int
    */
    private $_city = '';

    /**
    * վֵ(չ)
    *
    * @access private
    * @var array
    */
    private $_city_arr = array( 1 => 'nj' , 2 => 'wx' , 3 => 'sz', 4 => 'hf', 5 => 'hz', 6 => 'xa', 7 => 'cz', 8 => 'ks', 9 => 'wh', 10 => 'cq');


    /**
    * ûͻIP
    *
    * @access private
    * @var string
    */
    private $_ip = '';

    /**
    * ûΪ¼
    *
    * @access private
    * @var string
    */
    private  $_log_behavior_tbl = "log_user_behavior";
    
    /**
    * ûΪ¼(sell)
    *
    * @access private
    * @var string
    */
    private  $_log_behavior_sell_tbl = "behavior_sell";
    
    /**
    *  ûΪ¼(rent)
    *
    * @access private
    * @var string
    */
    private  $_log_behavior_rent_tbl = "behavior_rent";
    
    /**
    *  ûΪ¼(block)
    *
    * @access private
    * @var string
    */
    private  $_log_behavior_block_tbl = "behavior_block";

	/**
    *  ûΪ¼(block)
    *
    * @access private
    * @var string
    */
    private  $_log_behavior_school_tbl = "behavior_school";
	
    /**
    *  ûΪ¼(ask)
    *
    * @access private
    * @var string
    */
    private  $_log_behavior_ask_tbl = "behavior_ask";

    /**
    *  ûΪ¼ڵ
    *
    * @access private
    * @var string
    */
    private  $_behavior_nodes_tbl   = "behavior_nodes";

    /**
    *  Ƶ
    *
    * @access private
    * @var string
    */
    private  $_website    = 0;

    /**
    *  Ƶ(չм)
    *
    * @access private
    * @var array
    */
    private  $_website_arr   = array( 1 => 'ַ' ,2 => 'ⷿ' ,3 => 'С' ,
				4 => 'ʴ' , 5 => 'Ա', 6 => '', 7 =>'ѧ');

    /**
    *  ûλ
    *
    * @access private
    * @var string
    */
    private  $_position = 0;

    /**
    *  ûλ
    *
    * @access private
    * @var array
    */
    private  $_position_arr   = array( 1 => 'ҳ' , 2 => 'бҳ' , 3 => 'ҳ', 4 => 'ҳ' );

    /**
    *  û
    *
    * @access private
    * @var string
    */
    private  $_opreatetype    = 0;

    /**
    *  û
    *
    * @access private
    * @var array
    */
    private  $_opreatetype_arr   = array(1 => '' , 2 => '鿴' , 3 => 'ղؼ' ,
                                        4=>'' , 5 => 'עҷ' ,
					6 => 'ԤԼ' , 7 => '͵ֻ' , 8 => 'עԴ' ,
                                        9 => 'ⷢ'  , 11 => 'עС' );
    
    /**
    * 豸
    *
    * @access private
    * @var array
    */
    private  $_device_arr   = array( 1 => 'pc', 2 => 'andriod' , 3 => 'iphone');

    /**
    *  ݿ
    *
    * @access private
    * @var object
    */
    private $_db_user = NULL;

    /**
    *  ݿӿ
    *
    * @access private
    * @var object
    */
    private $_dbback_user = NULL;

    /*Constructor*/
    public function __construct( $db_user , $dbback_user = NULL , $city = 'nj' )
    {
        $this->_db_user	= $db_user;
        $this->_dbback_user = $dbback_user;
        $this->set_city(strip_tags($city));
    }


    /**
    * set_uid
    *
    * ʼuid
    *
    * @access	public
    * @param	int     $uid û
    * @return	void
    */
    public function set_uid( $uid )
    {
        $this->_uid = $uid;
    }
    
    
    /**
    * set_id
    *
    * ʼ
    *
    * @access	public
    * @param	int $id ¼
    * @return	void
    */
    public function set_id( $id )
    {
        $this->_id = $id;
    }
    
    
    /**
    * set_telno
    *
    * ʼ
    *
    * @access	public
    * @param	int $telno ֻ
    * @return	void
    */
    public function set_telno( $telno )
    {
        $this->_telno = strip_tags($telno);
    }
    
    
    /**
    * get_uid
    *
    * ʼuid
    *
    * @access	public
    * @return	int     $uid û
    */
    public function get_uid( )
    {
        return $this->_uid ;
    }

    /**
    * set_city
    *
    * ʼв
    *
    * @access	public
    * @param	string  $city в
    * @return	void
    */
    public function set_city($city)
    {
        $city_arr_flip	=  array_flip($this->_city_arr);
        $city_id	= $city_arr_flip[$city];
        
        $this->_city    = $city_id;
    }


    /**
    * get_city
    *
    * ó
    *
    * @access	public
    * @return	void
    */
    public function get_city()
    {
        return $this->_city ;
    }
    
    
    /**
    * set_district
    *
    * 
    *
    * @access	public
    * @param	int  $district 
    * @return	void
    */
    public function set_district($district)
    {
        $this->_district = intval($district);
    }
    
    
    /**
    * set_street
    *
    * 
    *
    * @access	public
    * @param	int  $street 
    * @return	void
    */
    public function set_street($street)
    {
        $this->_street = intval($street);
    }
    
    
    /**
    * set_street
    *
    * 
    *
    * @access	public
    * @param	int  $averprice1 1
    * @param	int  $averprice2 2
    * @return	void
    */
    public function set_averprice( $averprice1 , $averprice2 )
    {
        $this->_averprice1 = intval($averprice1);
        $this->_averprice2 = intval($averprice2);
    }

	
	/**
    * set_category
    *
    * ѧУ
    *
    * @access	public
    * @param	int  $category ѧУ
    * @return	void
    */
	public function set_category($category)
	{
		$this->_category_sh = intval($category);
	}


	/**
    * set_rank
    *
    * ѧУ
    *
    * @access	public
    * @param	int  $category ѧУ
    * @return	void
    */
	public function set_rank($rank)
	{
		$this->_rank = intval($rank);
	}


    /**
    * set_ip
    *
    * ʼIP
    *
    * @access	public
	* @param	string  $ip IP
    * @return	void
    */
    public function set_ip($ip)
    {
       $this->_ip = strip_tags($ip);
    }


    /**
    * set_website
    *
    * ʼwebsite
    *
    * @access	public
    * @param	int  $website
    * @return	void
    */
    public function set_website( $website )
    {
        $this->_website	= intval($website);
    }


    /**
    * get_website_arr
    *
    * ȡget_website_arr
    *
    * @access	public
    * @param	none
    * @return	array $website
    */
    public function get_website_arr()
    {
        return $this->_website_arr;
    }


    /**
    * set_position
    *
    * ʼposition
    *
    * @access	public
    * @param	int  $postion
    * @return	void
    */
    public function set_position( $position )
    {
        $this->_position = intval($position);
    }


    /**
    * get_position_arr
    *
    * ȡposition_arr
    *
    * @access	public
    * @param	none
    * @return	array $_position_arr
    */
    public function get_position_arr()
    {
        return $this->_position_arr;
    }


    /**
    * set_opreatetype
    *
    * ʼopreatetype
    *
    * @access	public
    * @param	int  opreatetype
    * @return	void
    */
    public function set_opreatetype( $opreatetype )
    {
       $this->_operate_type    = intval($opreatetype);
    }


    /**
    * get_opreatetype_arr
    *
    * ȡ$_opreatetype_arr
    *
    * @access	public
    * @param	none
    * @return	array $_opreatetype_arr
    */
    public function get_opreatetype_arr()
    {
        return $this->_opreatetype_arr;
    }
    
    
    /**
    * set_device
    *
    * ʼdevice
    *
    * @access	public
    * @param	int  $device
    * @return	void
    */
    public function set_device( $device )
    {
       $this->_device   = intval($device);
    }
    
    /**
    * get_device_arr
    *
    * ȡ_device_arr
    *
    * @access	public
    * @param	none
    * @return	array $_device_arr
    */
    public function get_device_arr()
    {
        return $this->_device_arr;
    }
    
    
    /**
    * set_infofrom
    *
    * ʼinfofrom
    *
    * @access	public
    * @param	int  $infofrom
    * @return	void
    */
    public function set_infofrom( $infofrom )
    {
       $this->_infofrom   = intval($infofrom);
    }
    
    
    /**
    * set_infotype
    *
    * ʼinfotype
    *
    * @access	public
    * @param	int  $infotype
    * @return	void
    */
    public function set_infotype( $infotype )
    {
       $this->_infotype   = intval($infotype);
    }
    
    
    /**
    * set_renttype
    *
    * ʼrenttype
    *
    * @access	public
    * @param	int  $renttype
    * @return	void
    */
    public function set_renttype( $renttype )
    {
       $this->_renttype  = intval($renttype);
    }
    

    /**
    * set_fitment
    *
    * ʼfitment
    *
    * @access	public
    * @param	int  $fitment
    * @return	void
    */
    public function set_fitment( $fitment )
    {
       $this->_fitment   = intval($fitment);
    }
    
    
    /**
    * set_price
    *
    * ʼ۸
    *
    * @access	public
    * @param	int  $price1
    * @param	int  $price2
    * @return	void
    */
    public function set_price( $price1  , $price2 )
    {
       $this->_price1   = intval($price1);
       $this->_price2   = intval($price2);
    }
    
    /**
    * set_buildarea
    *
    * ʼ
    *
    * @access	public
    * @param	int  $buildarea1
    * @param	int  $buildarea2
    * @return	void
    */
    public function set_buildarea( $buildarea1  , $buildarea2 )
    {
       $this->_buildarea1   = intval($buildarea1);
       $this->_buildarea2   = intval($buildarea2);
    }
    
    /**
    * set_floor
    *
    * ʼ¥
    *
    * @access	public
    * @param	int  $floor1
    * @param	int  $floor2
    * @return	void
    */
    public function set_floor( $floor1  , $floor2 )
    {
       $this->_floor1   = intval($floor1);
       $this->_floor2   = intval($floor2);
    }
    
    
    /**
    * set_room
    *
    * ʼͲ
    *
    * @access	public
    * @param	int  $floor1
    * @param	int  $floor2
    * @return	void
    */
    public function set_room( $room1  , $room2 )
    {
       $this->_room1   = intval($room1);
       $this->_room2   = intval($room2);
    }
    
    
    /**
    * set_keyword
    *
    * ʼؼ/СƲ
    *
    * @access	public
    * @param	string  keyword
    * @return	void
    */
    public function set_keyword( $keyword )
    {
       $this->_keyword  = strip_tags($keyword);
    }
    
    /**
    * set_qa_type
    *
    * ʼʴͲ
    *
    * @access	public
    * @param	intval  $qa_type
    * @return	void
    */
    public function set_qa_type( $qa_type )
    {
       $this->_qa_type  = intval($qa_type);
    }
    
    
    /**
    * set_qa_class
    *
    * ʼʴͲ
    *
    * @access	public
    * @param	string  keyword
    * @return	void
    */
    public function set_qa_class( $qa_class )
    {
       $this->_qa_class  = intval($qa_class);
    }
    
    /**
    * set_is_best
    *
    * ʼѴ𰸲
    *
    * @access	public
    * @param	int  $is_best
    * @return	void
    */
    public function set_is_best( $is_best )
    {
       $this->_is_best  = intval($is_best);
    }
    
    /**
    * get_device_by_id
    *
    * ȡ$_opreatetype_arr
    *
    * @access	public
    * @param	none
    * @return	array $_opreatetype_arr
    */
    public function get_device_by_id( $device_id )
    {
        $device_name = $this->_device_arr[$device_id];
        return $device_name;
    }


    /**
    * _tbl_exists
    *
    * жݿǷ
    *
    * @access	private
    * @param	int $tbl_name   
    * @return	boolean  true/false
    */
    private function _tbl_exists($tbl_name)
    {
        $sql = "SHOW TABLES LIKE '".$tbl_name."'";
        $tbl_info = $this->_db_user->GetAll($sql);
   
        if( is_array($tbl_info) && !empty($tbl_info) )
        {
            return true;
        }
        else
        {
            return false;
        }
    }


    /**
    * _get_tblname_by_date
    *
    * ɱֶ
    *
    * @access	private
    * @param	string	$date   (eg:20140313)
    * @param	string	$tbl_name  
    * @return	string	$tblname 
    */
    private function _get_tblname_by_date($date , $base_tblname = '')
    {
        $base_tblname = $base_tblname == '' ?
            $this->_log_behavior_tbl : strip_tags($base_tblname);

        $tblname = $base_tblname . $date;

        return $tblname;
    }


    /**
    * _creat_tbl_by_copy
    *
    * $tblname ± $tblname_new
    *
    * @access	private
    * @param	string	$tblname_new  ±
    * @param	string	$tblname	  Ƶı
    * @return	boolean true/false
    */
    private function _creat_tbl_by_copy ( $tblname_new , $tblname )
    {
        if( trim($tblname_new) == trim($tblname) )
        {
            return false;
        }

        //5.0֮ǰ(CREATE TABLE ± SELECT * FROM ɱ WHERE 1=2)
        // MYSQL5.0ϲ֧
        $sql = " CREATE TABLE $tblname_new LIKE $tblname ";
        $result = $this->_db_user->Execute($sql);

        if($result)
        {
            return true;
        }
        else
        {
            return false;
        }
    }
    
    
    /**
    * get_cityname_by_id
    *
    * ݳIDسнַ
    *
    * @access	public
    * @param	int $city_id б
    * @return	string	$city_name мдַ
    */
    public function get_cityname_by_id( $city_id )
    {
        $city_name = $this->_city_arr[$city_id];

        if( $city_name != '')
        {
            return $city_name;
        }
        else
        {
            return $city_name;
        }
    }


    /**
    * get_websitename_by_id
    *
    * ƵŷƵַ
    *
    * @access	public
    * @param	int $website_id Ƶ
    * @return	string	$website_name Ƶַ
    */
    public function get_websitename_by_id( $website_id )
    {
        $website_name = $this->_website_arr[$website_id];

        return $website_name;
    }


    /**
    * get_positionname_by_id
    *
    * λIDλַ
    *
    * @access	public
    * @param	int $postion_id λñ
    * @return	string	$postion_name λַ
    */
    public function get_positionname_by_id( $position_id )
    {
        $position_name = $this->_position_arr[$position_id];
        return $position_name;
    }


    /**
    * get_operate_by_id
    *
    * ݲͱŻȡ
    *
    * @access	public
    * @param	int $operate_id ͱ
    * @return	string	$operate_name 
    */
    public function get_operate_by_id( $operate_id )
    {
        $operate_name = $this->_opreatetype_arr[$operate_id];
        return $operate_name;
    }


    /**
    * get_node_by_id
    *
    * ݲݽڵIDȡַ
    *
    * @access	public
    * @param	int $node_id ݱ
    * @return	string	$node_str 
    */
    public function get_node_by_id( $node_id )
    {
        /*where*/
        $cond_where = " WHERE  id = '".$node_id."' ";

        /*sql*/
        $sql = " SELECT node FROM $this->_behavior_nodes_tbl ";
        $sql .= $cond_where;

        $node_str = $this->_dbback_user->GetOne($sql);

        return $node_str;
    }


    /**
    * get_node_by_ids
    *
    * ݶݽڵIDȡַ
    *
    * @access	public
    * @param	array	$node_id_arr ݱ
    * @return	array	$node_str 
    */
    public function get_node_by_ids( $node_id_arr )
    {
        $node_arr = array();

        if( is_array($node_id_arr) && !empty($node_id_arr) )
        {
            $ids = implode(',',$node_id_arr);

            /*where*/
            $cond_where = " WHERE id IN (".$ids.") ";

            /*sql*/
            $sql = " SELECT id,node FROM $this->_behavior_nodes_tbl ";
            $sql .= $cond_where;

            $result = $this->_dbback_user->GetAll($sql);

            for( $i = 0 ; $i < count( $result ) ; $i++)
            {
                $node_arr[$result[$i]['id']] = $result[$i]['node'];
            }
        }

        return $node_arr;
    }


    /**
    * array_pluck
    *
    * ȡάмֵɵ
    *
    * @access	public
    * @param	string	$key   Ҫkey
    * @param	string	$array Ŀ
    * @return	array   ֵ
    */
    public function array_pluck($key, $array)
    {
        if ( is_array( $key ) || !is_array( $array ) )
        {
            return array();
        }

        $funct	= create_function('$e', 'return is_array($e)
                                && array_key_exists("'.$key.'",$e) ? $e["'. $key .'"] : null;');

        return array_unique(array_map($funct, $array));
    }
    
    
    /**
    * _get_where_condtion
    *
    * ȡûĲѯ
    *
    * @access	public
    * @param	void
    * @return	string   ûĲѯ
    */
    private function _get_where_condtion()
    {   
        $cond_where = '';
        
        /*city_condtion*/
        if( $this->_city > 0 )
        {
            $cond_where	.= "WHERE city = '".$this->_city."' " ;
        }
        
        /*uid_condtion*/
        if( $this->_uid > 0 )
        {
            $cond_where	.= " AND uid = '".$this->_uid."' ";
        }

        /*website_condtion*/
        if( $this->_website > 0 )
        {
            $cond_where	.= " AND website = '".$this->_website."' " ;
        }

        /*position_condtion*/
        if( $this->_position > 0 )
        {
            $cond_where	.= " AND position = '".$this->_position."' " ;
        }

        /*operate_type_condtion*/
        if( $this->_operate_type > 0 )
        {
            $cond_where	.= " AND operate_type = '".$this->_operate_type."' ";
        }
        
        /*telno_condtion*/
        if( $this->_telno != '' )
        {
            $cond_where	.= " AND telno = '".$this->_telno."' ";
        }
        
        /*id_condtion*/
        if( $this->_id > 0 )
        {
            $cond_where	.= " AND id = '".$this->_id."' ";
        }
        
        /*device_condtion*/
        if( $this->_device > 0 )
        {
            $cond_where	.= " AND device = '".$this->_device."' ";
        }
        
        return $cond_where;
    }
    
    
    /**
    * _get_house_where_condtion
    *
    * ȡûѯhouse
    *
    * @access	public
    * @param	void
    * @return	string   ûĲѯ
    */
    private function _get_house_where_condtion()
    {   
        $cond_where = '';
        
        /*infofrom_condtion*/
        if( $this->_infofrom > 0 )
        {
            $cond_where	.= " AND infofrom = '".$this->_infofrom."' ";
        }
        
        /*infotpe_condtion*/
        if( $this->_infotype > 0 )
        {
            $cond_where	.= " AND infotype = '".$this->_infotype."' ";
        }
        
        /*district_condtion*/
        if( $this->_district > 0 )
        {
            $cond_where	.= " AND district = '".$this->_district."' ";
        }
        
        /*street_condtion*/
        if( $this->_street > 0 )
        {
            $cond_where	.= " AND streetid = '".$this->_street."' ";
        }
        
        /*renttype_condtion*/
        if( $this->_renttype > 0 )
        {
            $cond_where	.= " AND renttype = '".$this->_renttype."' ";
        }
         
        
        /*fitment_condtion*/
        if( $this->_fitment > 0 )
        {
            $cond_where	.= " AND fitment = '".$this->_fitment."' ";
        }

        /*price_condtion*/
        if( $this->_price1 > 0 ||  $this->_price2 > 0 )
        {   
            if($this->_price1 > 0  && $this->_price2 > 0)
            {
                $cond_where .= " AND price1 >= '".$this->_price1."' AND price2 <= '".$this->_price2."' AND price2 >= price1";
            }
            else if( $this->_price1 > 0)
            {
                $cond_where .= " AND price1 >= '".$this->_price1."'";
            }
            else
            {
                $cond_where .= " AND price2 <= '".$this->_price2."' AND price2 > 0";
            }
        }
        
        /*averprice_condtion*/
        if( $this->_averprice1 > 0 ||  $this->_averprice2 > 0 )
        {   
            if($this->_averprice1 > 0  && $this->_averprice2 > 0)
            {
                $cond_where .= " AND averprice1 >= '".$this->_averprice1."' AND averprice2 <= '".$this->_averprice2."' AND averprice2 >= averprice1";
            }
            else if( $this->_averprice1 > 0)
            {
                $cond_where .= " AND averprice1 >= '".$this->_averprice1."'";
            }
            else
            {
                $cond_where .= " AND averprice2 <= '".$this->_averprice2."' AND averprice2 > 0";
            }
        }
        
        /*buildarea_condtion*/
        if( $this->_buildarea1 > 0 ||  $this->_buildarea2 > 0 )
        {   
            if($this->_buildarea1 > 0  && $this->_buildarea2 > 0)
            {
                $cond_where .= " AND buildarea1 >= '".$this->_buildarea1."' AND buildarea2 <= '".$this->_buildarea2."' AND buildarea2 >= buildarea1";
            }
            else if( $this->_buildarea1 > 0)
            {
                $cond_where .= " AND buildarea1 >= '".$this->_buildarea1."'";
            }
            else
            {
                $cond_where .= " AND buildarea2 <= '".$this->_buildarea2."' AND buildarea2 > 0";
            }
        }
        
        /*floor_condtion*/
        if( $this->_floor1 > 0 ||  $this->_floor2 > 0 )
        {   
            if($this->_floor1 > 0  && $this->_floor2 > 0)
            {
                $cond_where .= " AND floor1 >= '".$this->_floor1."' AND floor2 <= '".$this->_floor2."' AND floor2 >= floor1";
            }
            else if( $this->_floor1 > 0)
            {
                $cond_where .= " AND floor1 >= '".$this->_floor1."'";
            }
            else
            {
                $cond_where .= " AND floor2 <= '".$this->_floor2."' AND floor2 > 0";
            }
        }
        
        /*room_condtion*/
        if( $this->_room1 > 0 ||  $this->_room2 > 0 )
        {   
            $cond_where .= " AND room >= '".$this->_room1."' AND room <= '".$this->_room2."'";
        }
        
        /*keyword_condtion*/
        if( $this->_keyword != '' )
        {
            $cond_where	.= " AND keyword LIKE '".$this->_keyword."%' ";
        }
        
        return $cond_where;
    }
    
    
    /**
    * _get_ask_where_condtion
    *
    * ȡûѯask
    *
    * @access	public
    * @param	void
    * @return	string   ûĲѯ
    */
    private function _get_ask_where_condtion()
    {   
        $cond_where = '';
        
        /*type_condtion*/
        if( $this->_qa_type > 0 )
        {
            $cond_where	.= " AND type = '".$this->_qa_type."' ";
        }
        
        /*class_condtion*/
        if( $this->_qa_class > 0 )
        {
            $cond_where	.= " AND class = '".$this->_qa_class."' ";
        }
        
        /*is_best_condtion*/
        if( $this->_is_best > 0 )
        {
            $cond_where	.= " AND is_best = '".$this->_is_best."' ";
        }
        

        /*keyword_condtion*/
        if( $this->_keyword != '' )
        {
            $cond_where	.= " AND keyword LIKE '".$this->_keyword."%' ";
        }
        
        return $cond_where;
    }



	/**
    * _get_school_where_condtion
    *
    * ȡûѯask
    *
    * @access	public
    * @param	void
    * @return	string   ûĲѯ
    */
    private function _get_school_where_condtion()
    {   
        $cond_where = '';
        
        /*district_condtion*/
        if( $this->_district > 0 )
        {
            $cond_where	.= " AND district = '".$this->_district."' ";
        }
        
        /*street_condtion*/
        if( $this->_street > 0 )
        {
            $cond_where	.= " AND streetid = '".$this->_street."' ";
        }
        
        /*rank_condtion*/
        if( $this->_rank > 0 )
        {
            $cond_where	.= " AND rank = '".$this->_rank."' ";
        }

		/*rank_condtion*/
        if( $this->_category_sh > 0 )
        {
            $cond_where	.= " AND category_sh = '".$this->_category_sh."' ";
        }
		
        /*keyword_condtion*/
        if( $this->_keyword != '' )
        {
            $cond_where	.= " AND keyword LIKE '".$this->_keyword."%' ";
        }
        
        return $cond_where;
    }
    
    
    /**
    * get_behavior_logs_count
    *
    * ȡûΪ¼
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @return	int   ¼־¼
    */
    public function get_behavior_logs_count( $day )
    {
        //òѯ
        $cond_where = $this->_get_where_condtion();

        $day = $day != '' ? $day : date('Ymd');
        $tbl_name = $this->_get_tblname_by_date($day);
        
        /*sql_select*/
        $sql = " SELECT COUNT(*) FROM $tbl_name ";
        $sql .=  $cond_where ;
        
        //ѯ
        $result = $this->_dbback_user->GetOne($sql);

        return $result;
    }
    
    
    /**
    * get_behavior_logs
    *
    * ȡûΪ¼Ϊ
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	int $offset վ
    * @param	int $limit վλñʶ
    * @param	int $order_key 
    * @param	string	$sort 
    * @return	array   ¼־¼
    */
    public function get_behavior_logs( $day , $offset = 0 , $limit = 10 , $order_key = 'datetime' , $sort = 'ASC')
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        /*order_query*/
        $cond_order = " ORDER BY $order_key  $sort ";

        /*limit_query*/
        $cond_limit = " LIMIT $offset , $limit ";

        $day = $day != '' ? $day : date('Ymd');
        $tbl_name = $this->_get_tblname_by_date($day);
        
        /*sql_select*/
        $sql = " SELECT * FROM $tbl_name ";
        $sql .=  $cond_where . $cond_order . $cond_limit;

        //жϱǲǴ
        $is_exist = $this->_tbl_exists($tbl_name);

        if( $is_exist )
        {
            $result = $this->_dbback_user->GetAll($sql); //ѯ
        }
        else
        {
            $result = array();
        }

        return $result;
    }


    /**
    * get_behavior_sell_logs_count
    *
    * ȡûΪ¼
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @return	int   ¼־¼
    */
    public function get_behavior_sell_logs_count( $day , $day2 )
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //SELLƵѯ
        $cond_where .= $this->_get_house_where_condtion();
        
        /*time_query*/
        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
                
        /*sql_select*/
        $sql = " SELECT COUNT(*) FROM $this->_log_behavior_sell_tbl ";
        $sql .=  $cond_where ;
        
        //ѯ
        $result = $this->_dbback_user->GetOne($sql);
        
        return $result;
    }
    
    
    /**
    * get_behavior_sell_logs
    *
    * ȡַûΪ¼Ϊ
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @param	int $offset վ
    * @param	int $limit վλñʶ
    * @param	int $order_key 
    * @param	string	$sort 
    * @return	array   ¼־¼
    */
    public function get_behavior_sell_logs( $day , $day2 ,$offset = 0 , $limit = 10 , $order_key = 'datetime' , $sort = 'ASC')
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //SELLƵѯ
        $cond_where .= $this->_get_house_where_condtion();
        
        /*order_query*/
        $cond_order = " ORDER BY $order_key  $sort ";

        /*limit_query*/
        $cond_limit = " LIMIT $offset , $limit ";

        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time   = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
        
        /*sql_select*/
        $sql = " SELECT * FROM $this->_log_behavior_sell_tbl ";
        $sql .=  $cond_where . $cond_order . $cond_limit;
        $result = $this->_dbback_user->GetAll($sql); //ѯ

        return $result;
    }
    
    
    /**
    * get_behavior_block_logs_count
    *
    * ȡûΪ¼
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @return	int   ¼־¼
    */
    public function get_behavior_block_logs_count( $day , $day2 )
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //SELLƵѯ
        $cond_where .= $this->_get_house_where_condtion();
        
        /*time_query*/
        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
                
        /*sql_select*/
        $sql = " SELECT COUNT(*) FROM $this->_log_behavior_block_tbl ";
        $sql .=  $cond_where ;
        
        //ѯ
        $result = $this->_dbback_user->GetOne($sql);
        
        return $result;
    }
    
    
    /**
    * get_behavior_block_logs
    *
    * ύûݽڵ
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @param	int $offset վ
    * @param	int $limit վλñʶ
    * @param	int $order_key 
    * @param	string	$sort 
    * @return	array   ¼־¼
    */
    public function get_behavior_block_logs( $day , $day2 ,$offset = 0 , $limit = 10 , $order_key = 'datetime' , $sort = 'ASC')
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //SELLƵѯ
        $cond_where .= $this->_get_house_where_condtion();
        
        /*order_query*/
        $cond_order = " ORDER BY $order_key  $sort ";

        /*limit_query*/
        $cond_limit = " LIMIT $offset , $limit ";

        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time   = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
        
        /*sql_select*/
        $sql = " SELECT * FROM $this->_log_behavior_block_tbl ";
        $sql .=  $cond_where . $cond_order . $cond_limit;
        $result = $this->_dbback_user->GetAll($sql); //ѯ
        
        return $result;
    }
    
    
    /**
    * get_behavior_rent_logs_count
    *
    * ȡûΪ¼
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @return	int   ¼־¼
    */
    public function get_behavior_rent_logs_count( $day , $day2 )
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //SELLƵѯ
        $cond_where .= $this->_get_house_where_condtion();
        
        /*time_query*/
        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
                
        /*sql_select*/
        $sql = " SELECT COUNT(*) FROM $this->_log_behavior_rent_tbl ";
        $sql .=  $cond_where ;
        
        //ѯ
        $result = $this->_dbback_user->GetOne($sql);
        
        return $result;
    }
    
    
    /**
    * get_behavior_rent_logs
    *
    * ȡⷿƵû¼
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @param	int $offset վ
    * @param	int $limit վλñʶ
    * @param	int $order_key 
    * @param	string	$sort 
    * @return	array   ־¼
    */
    public function get_behavior_rent_logs( $day , $day2 ,$offset = 0 , $limit = 10 , $order_key = 'datetime' , $sort = 'ASC')
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //SELLƵѯ
        $cond_where .= $this->_get_house_where_condtion();
        
        /*order_query*/
        $cond_order = " ORDER BY $order_key  $sort ";

        /*limit_query*/
        $cond_limit = " LIMIT $offset , $limit ";

        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time   = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
        
        /*sql_select*/
        $sql = " SELECT * FROM $this->_log_behavior_rent_tbl ";
        $sql .=  $cond_where . $cond_order . $cond_limit;
        $result = $this->_dbback_user->GetAll($sql); //ѯ
        
        return $result;
    }
    
    
    /**
    * get_behavior_ask_logs_count
    *
    * ȡûΪ¼
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @return	int   ¼־¼
    */
    public function get_behavior_ask_logs_count( $day , $day2 )
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //SELLƵѯ
        $cond_where .= $this->_get_ask_where_condtion();
        
        /*time_query*/
        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
                
        /*sql_select*/
        $sql = " SELECT COUNT(*) FROM $this->_log_behavior_ask_tbl ";
        $sql .=  $cond_where ;
        
        //ѯ
        $result = $this->_dbback_user->GetOne($sql);
        
        return $result;
    }
    
    
    /**
    * get_behavior_ask_logs
    *
    * ȡʴƵû¼
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @param	int $offset վ
    * @param	int $limit վλñʶ
    * @param	int $order_key 
    * @param	string	$sort 
    * @return	array   ־¼
    */
    public function get_behavior_ask_logs( $day , $day2 ,$offset = 0 , $limit = 10 , $order_key = 'datetime' , $sort = 'ASC')
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //SELLƵѯ
        $cond_where .= $this->_get_ask_where_condtion();
        
        /*order_query*/
        $cond_order = " ORDER BY $order_key  $sort ";

        /*limit_query*/
        $cond_limit = " LIMIT $offset , $limit ";

        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time   = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
        
        /*sql_select*/
        $sql = " SELECT * FROM $this->_log_behavior_ask_tbl ";
        $sql .=  $cond_where . $cond_order . $cond_limit;
        $result = $this->_dbback_user->GetAll($sql); //ѯ
        
        return $result;
    }


	/**
    * get_behavior_school_logs_count
    *
    * ȡûΪ¼
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @return	int  ־
    */
    public function get_behavior_school_logs_count( $day , $day2 )
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //SELLƵѯ
        $cond_where .= $this->_get_house_where_condtion();
        
        /*time_query*/
        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
                
        /*sql_select*/
        $sql = " SELECT COUNT(*) FROM $this->_log_behavior_school_tbl ";
        $sql .=  $cond_where ;
        
        //ѯ
        $result = $this->_dbback_user->GetOne($sql);
        
        return $result;
    }


	/**
    * get_behavior_school_logs
    *
    * ȡѧƵû¼
    *
    * @access	public
    * @param	string	$day ڣeg:20140313
    * @param	string	$day2 ڣeg:20140313
    * @param	int $offset վ
    * @param	int $limit վλñʶ
    * @param	int $order_key 
    * @param	string	$sort 
    * @return	array   ־¼
    */
    public function get_behavior_school_logs( $day , $day2 ,$offset = 0 , $limit = 10 , $order_key = 'datetime' , $sort = 'ASC')
    {   
        //òѯ
        $cond_where = $this->_get_where_condtion();
        
        //ѧƵѯ
        $cond_where .= $this->_get_school_where_condtion();
        
        /*order_query*/
        $cond_order = " ORDER BY $order_key  $sort ";

        /*limit_query*/
        $cond_limit = " LIMIT $offset , $limit ";

        $day = $day != '' ? $day : date('Ymd');
        $day2 = $day2 != '' ? $day2 : date('Ymd');
        $start_time = strtotime($day);
        $end_time   = strtotime($day2) + 86399;

        $cond_where .= " AND datetime >= '".$start_time."' AND datetime < '".$end_time."'";
        
        /*sql_select*/
        $sql = " SELECT * FROM $this->_log_behavior_school_tbl ";
        $sql .=  $cond_where . $cond_order . $cond_limit;
        $result = $this->_dbback_user->GetAll($sql); //ѯ

        return $result;
    }
}
/* End of file UserBehavior.class.php */
/* Location: ../core/lib/UserBehavior.class.php*/