<?php 

class Curl {

	private $ch;
	private $url;

	public function __construct(){
		$this -> ch = curl_init();
	}

	/**
	 * һ
	 * @param  String $url ĵַ
	 */
	public function setUrl($url){
		$this -> url = $url;
	}

	/**
	 * 
	 * @param  boolean $isHttps     Ƿhttpsʽ
	 * @param  string  $requestType ʽ
	 */
	private function setopt($isHttps, $requestType, $data, $useCert = false){
		curl_setopt($this -> ch, CURLOPT_URL, $this -> url);
		curl_setopt($this -> ch, CURLOPT_HEADER, 0);
		curl_setopt($this -> ch, CURLOPT_RETURNTRANSFER, 1);
		if ($isHttps) {
			curl_setopt($this -> ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($this -> ch, CURLOPT_SSL_VERIFYHOST, 2);
		}

        if($useCert == true){
            //֤
            //ʹ֤飺cert  key ֱ.pemļ
            curl_setopt($this->ch,CURLOPT_SSLCERTTYPE,'PEM');
            curl_setopt($this->ch,CURLOPT_SSLCERT, SSLCERT_PATH);
            curl_setopt($this->ch,CURLOPT_SSLKEYTYPE,'PEM');
            curl_setopt($this->ch,CURLOPT_SSLKEY, SSLKEY_PATH);
        }

		if (!empty($data)) {
			curl_setopt($this->ch, CURLOPT_POSTFIELDS, $data);
		}

		if ($requestType == 'POST') {
			curl_setopt($this->ch, CURLOPT_POST, true);
		}
	}

	/**
	 * ִһ
	 * @return resource ִн
	 */
	public function execute($isHttps = false, $requestType = 'GET', $data = null, $useCert = false){
		$this->setopt($isHttps, $requestType, $data, $useCert);
		$content = curl_exec($this->ch);
		var_dump($content);die;
		$this->close();
		if (!empty($content)) {
            return $content;
        } else {
            return curl_error($this->ch);
        }
	}

	/**
	 * رһԴ
	 */
	private function close(){
		curl_close($this -> ch);
	}
}