<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ҵ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright       Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------

/**
 * Сҵ߼
 *
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          fisher
 */

load_m("block_base_xiao_model");
class Block_xiao_model extends Block_base_xiao_model 
{
    /**
     * Сͼü¼
     * @var type 
     */
    private $_tbl_block_img_used = 'block_img_used_count';
	
	/**
     * KEY
     * @var private 
     */
	private $_mem_key = 'block_model';
    
    /**
     * ʼ
     */
    public function __construct() 
    {
        parent::__construct();
    }
    
    /**
     * СŻȡ¼
     * @param int $id С
     * @return array С¼ɵһά
     */
    public function base_info_by_id($id)
    {
        $this->load->model('street_model');
        $base_info_fields = array(
            'id', 'blockname', 'streetid', 'esta',
            'district', 'address', 'averprice'
        );
        $this->set_select_fields($base_info_fields);
        $base_info = $this->find_by_id($id);
        if ($base_info)
        {
            $base_info['averprice'] = floor($base_info['averprice']);
            $base_info['blockid'] = $id;
            $street = $this->street_model->find_by_id($base_info['streetid']);
            $base_info['streetname'] = $street['streetname'];
            $base_info['esta_block'] = $this->find_blocktype_by_esta($base_info['esta']);
            $base_info['url_block'] = $this->find_blockurl_by_id($base_info['id']);
        }
        return $base_info;
    }
    
    /**
     * ģƥĳСƵб
     * @param string $blockname С
     * @param int $num ʾ
     * @return array ƥ䵽С¼ɵĶά
     */
    public function auto_blockname($blockname, $num = 10)
    {
        $this->load->model('street_model');
        $base_info_fields = array(
            'id','blockname','district', 'streetid',
            'averprice','address', 'esta'
        );
        $this->set_select_fields($base_info_fields);
        $block_list = $this->find_like_by_blockname($blockname,20);
        if (is_array($block_list) && !empty($block_list))
        {
            $street_ids = array();
            foreach($block_list as $v)
            {
                if (isset($v['streetid']) && $v['streetid'] > 0)
                {
                    $street_ids[] = $v['streetid'];
                }
            }
            $where = "id in ('".  implode("','", $street_ids)."')";
            $this->street_model->set_select_fields(array('id', 'streetname'));
            $streetnames = $this->street_model->find_by($where);
            $streetnames = changeToKeyArray($streetnames, 'id');
            foreach($block_list as &$v)
            {
                if (isset($v['streetid']) && $v['streetid'] > 0)
                {
                    $v['streetname'] = $streetnames[$v['streetid']]['streetname'];
                }
                else 
                {
                    $v['streetname'] = '';
                }
                $v['averprice'] = floor($v['averprice']);
                $v['label'] = $v['blockname'];
                $v['esta_block'] = $this->find_blocktype_by_esta($v['esta']);
                $v['url_block'] = $this->find_blockurl_by_id($v['id']);
            }
        }
        else
        {
            $block_list[] = array(
                'label' => 'С',
                'id'    => 0,
            );
        }
        return $block_list;
    }
    
    /**
     * ʱС
     * @param string $blockname С
     * @param string $blockaddress Сַ
     * @param string $district 
     * @param int $streetid 
     * @return array һά array(code => 200, id => 222) 
     * code idΪɹС
     */
    public function add_temp_block($blockname, $blockaddress, $district, $streetid)
    {
        $result = array('code' => '', 'id' => '');
        //֤ύĸֶ()
        $len_blockname = strlen(trim($blockname));
        if( $len_blockname < 4 || $len_blockname > 16 ){
            $result['code'] = 100;
            return $result; //С2-8֮
        }
        //ǷͬС
        $blockname_num = $this->find_count_by_blockname($blockname);
        if ($blockname_num > 0)
        {
            $result['code'] = 300;
            return $result; //ѴͬС
        }
        $len_district = strlen(trim($district));
        if($len_district <= 0 )
        {
            $result['code'] = 400;
            return $result; //ѡ
        }
        if(trim($streetid) <= 0 )
        {
            $result['code'] = 500;
            return $result; //ѡ
        }
        $blockaddress = trim($blockaddress) ;
        $len_blockaddress = strlen($blockaddress);
        if($len_blockaddress <= 4 || $len_blockaddress >=100 )
        {
            $result['code'] = 600;
            return $result; //Сַ2-50֮䣡
        }
        else
        {
            $blockaddress_num = $this->find_count_by_address($blockaddress);
            if($blockaddress_num > 0)
            {
                $result['code'] = 700;
                return $result; //Сַ2-50֮䣡
            }
        }
        $this->load->helper('common_string_helper');
        $this->load->library('Spell', '', 'spell');
        $insert_data = array();
        $insert_data['blockname'] =  trim($blockname) ;
        $insert_data['address']	 =  trim($blockaddress)  ;
        $insert_data['district']  =  $district;
        $insert_data['streetid']	 =  $streetid;
        $insert_data['bi_s']		 =	strtoupper(csubstr($this->spell->s_spell(trim($blockname)),1));
        /*app-СרʱǷԱ༭ύС¼,
            0-ʾɱ༭С¼Сר,
            1-ʾСרңǲɱ༭С¼
            2-ʾСרңԱ༭С¼
        */
        $insert_data['app']			=  1;
        $insert_data['esta']			=  0;
        $insert_id = $this->insert($insert_data);
        if ($insert_id > 0)
        {
            $result['code'] = 200;
            $result['id'] = $insert_id;
            return $result;
        }
        else 
        {
            $result['code'] = 800;
            return $result;
        }
    }
    
    /**
     * ͼͼƬʹü¼
     * @param array $insert_data ͼ
     * @return int زɹid
     */
    public function insert_block_img_used($insert_data)
    {
        if ($this->db->insert($this->_tbl_block_img_used, $insert_data))
        {
            return $this->db->insert_id();
        }
    }
    
    /**
     * ѯв·ֱ۵СϢ
     * @param string $city в
     * @return array СϢ
     */
    public function get_nofee_block( $city = 'nj')
    {
        //ѯȫ·ӶС
        $nofee_block_arr = array();
        $cond_where = 'nofee = 1';
        $mem_key = $this->_mem_key.'_get_nofee_block_'.$city.'_'.$cond_where;
        //$this->mc->delete($mem_key);
        $cache = $this->mc->get($mem_key);

        if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $nofee_block_arr = $cache['data'];
        }
        else
        {   
            $nofee_block_arr = $this->find_by_cond($cond_where);
            $this->mc->add($mem_key, array('is_ok'=>1,'data'=>$nofee_block_arr),  3600);
        }
        
        return $nofee_block_arr;
    }


	
	/*
     * blockidǷų֮
     * @access public 
     * @return int 
     */
	public function get_block_remove_info_by_blockid($blockid)
	{

		$mem_key = $this->_mem_key.'_get_block_remove_info_by_blockid'.$blockid;
        $cache = $this->mc->get($mem_key);
		
		if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $status = $cache['data'];
        }
        else
        {
			$this->db->select('id,status,num');
			$cond_where = "block_id = '$blockid' and status =1 ";
			$this->db->where( $cond_where );
			
			$arr_data = $this->db->get('block_remove_list')->result_array(); 
			
			
			if(is_array($arr_data) && !empty($arr_data))
			{
				$status =$arr_data[0]['num'];
				$this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$status) ,  86400);
			}
			else
			{
				$status =0;
			}
			
			
		}
		
		return $status;
	}

    /**
     * ȡСĬͼƬ
     * ʱֻõ⾰ͼԤͱںչ
     * @param int $id СId
     * @param int $sort 0ͼ1⾰ͼ2ͼ
     * @return string СĬͼƬ
     */
    public function getBlockImg($id, $sort=1)
    {
        $mem_key = $this->_mem_key.'_getBlockImg_'.$id.'_'.$sort;
        //$cache = $this->mc->delete($mem_key);
        $cache = $this->mc->get($mem_key);
        if(isset($cache['is_ok']) && $cache['is_ok'] == 1 )
        {
            $result = $cache['data'];
        }
        else
        {
			 //ȡСĬ⾰ͼ
            if($sort == 1)
            {
                //ȡ
                $this->dbback->select('bi_img');
                $this->dbback->where( 'bi_blockid = '.$id.' and bi_type = 52' );
                $this->dbback->order_by('id','desc');
                $this->dbback->limit(1);
                $arr_data = $this->dbback->get('block_img')->result_array();
                //print_r($arr_data);die;
                if(is_array($arr_data) && !empty($arr_data))
                {
                    $result = $arr_data[0]['bi_img'];
                }
                else
                {   
                    //ȡС⾰ͼ
                    $this->dbback->select('bi_img');
                    $this->dbback->where( 'bi_blockid = '.$id.' and bi_type in (51,53)' );
                    $this->dbback->order_by('id','desc');
                    $this->dbback->limit(1);
                    $arr_data = $this->dbback->get('block_img')->result_array();
                    if(is_array($arr_data) && !empty($arr_data))
                    {
                        $result = $arr_data[0]['bi_img'];
                    }
                }
            }
			if(!empty($result))
			{
				$this->mc->add($mem_key , array('is_ok'=>1 , 'data'=>$result) ,  86400);
			}
			else
			{
				$result = '';
			}
		}
        return $result;
    }
}