<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Personal_house_wang extends MY_Controller {

    private $library;
        
    /**
    * 
    *
    * @access public
    * @return void
    */
    public function __construct()
    {
        parent::__construct();
    }
    
    
    /**
     * Index Page for this controller.
     */
    public function index()
    {
        $this->sell();
    }
    
    /**
     * Get the sell house
     */
    public function sell()
    {	
		$pg = $this->input->post('page', TRUE);
        $page = intval($pg) > 0 ? intval($pg) : 1;

        $this->load->library('server',array('appName'=>NS_SELL,'strCheckMethod'=>"",'returnMethod'=>"ary",'returnCharSet'=>"gbk"));
        
        $this->load->model('broker_wang_model');
        $dist = $this->broker_wang_model->get_broker_district();

        $arr = '' != $dist ? $this->_get_house($this->server, 'sell', $dist) : array('data'=>array(), 'pages'=>'');
        $data_arr['house_arr'] = $arr['data'];
		// var_dump($this->server);exit;
        $data_arr['pages'] = $arr['pages'];
        $data_arr['tab'] = 'sell';
        $data_arr['dist'] = $dist;//echo $dist;die;
        $data_arr['page_title'] = '˷Դ-۷Դ';
        $data_arr['css'] = load_css('zsb/css/v1.0/style1.css');
        $data_arr['google_analytics'] = get_ga_js_code('/Ӫ/˷Դ/۷Դ/'.$page.'/');
        $this->view('market', 'personal_house', $data_arr);
    }
    
     /**
     * Get the rent house
     */
    public function rent()
    {	
		$pg = $this->input->post('page', TRUE);
        $page = intval($pg) > 0 ? intval($pg) : 1;
        $this->load->library('server',array('appName'=>NS_RENT,'strCheckMethod'=>"",'returnMethod'=>"ary",'returnCharSet'=>"gbk"));
        
        $this->load->model('broker_model');
        $dist = $this->broker_model->get_broker_district();
        
        $arr = '' != $dist ? $this->_get_house($this->server, 'rent', $dist) : array('data'=>array(), 'pages'=>'');
        $data_arr['house_arr'] = $arr['data'];
        $data_arr['pages'] = $arr['pages'];
        $data_arr['tab'] = 'rent';
        $data_arr['dist'] = $dist;
        $data_arr['page_title'] = '˷Դ-ⷿԴ';
        $data_arr['css'] = load_css('zsb/css/v1.0/style1.css');
        $data_arr['google_analytics'] = get_ga_js_code('/Ӫ/˷Դ/ⷿԴ/'.$page.'/');
        $this->view('market', 'personal_house', $data_arr);
    }
    
    /**
     * ȡԴ
     */
    private function _get_house($server, $tbl, $dist)
    {
        if('' == $server->appName OR !in_array($tbl, array('sell', 'rent')))
        {
            return array();
        }
        
        $pg = $this->input->post('page', TRUE);
        $page = intval($pg) > 0 ? intval($pg) : 1;
        unset($pg);
        $pagesize = 20;
        $offset=$pagesize*($page-1);
        
        //ʼʱ
        $starttime = strtotime('-1 day');
        $endtime = time()-600;
        if ($tbl == 'sell') {
			$strCondition = 'id,uid,infotype, blockshowname, room, hall, buildarea, price, creattime, contactor, telno,tel400';
		} else {
			$strCondition = 'id,uid,infotype, blockshowname, room, hall, buildarea, price, creattime, priceunit, renttype, contactor, telno';
		}
        /*
        $sql = "SELECT ".$strCondition." FROM ".$tbl." WHERE infofrom = 1 and esta = 1 and creattime >= '".$starttime."' and district = '".$dist."'
            ORDER BY updatetime DESC LIMIT ".$offset.",".$pagesize." LUC";
		*/

		$sql = "SELECT ".$strCondition." FROM ".$tbl." WHERE infofrom = 1 and esta = 1 and creattime <='$endtime' and creattime >= '".$starttime."' and district = '".$dist."'
		
            ORDER BY updatetime DESC LIMIT ".$offset.",".$pagesize." LUC";
		//$sql ="SELECT id FROM rent WHERE infofrom = 1 and esta = 1 luc";

        $ary = $server->query($sql);

        $numrows = intval($ary["TOTAL"]);
        $pages = $numrows ? ceil($numrows/$pagesize) : 0;  //ҳ
        $page = $page > $pages ? $pages : $page;  //жתҳ

        $return = array();
        if(count($ary["Record"]) > 0)
        {
            $j = 0;
            foreach($ary["Record"] as $value){

                $arr_key=array_keys($value);
                for($i=0;$i<count($arr_key);$i++){
                    $value[strtolower($arr_key[$i])] = $value[$arr_key[$i]];
                    unset($value[$arr_key[$i]]);
                }
                $arr[$j]=$value;

                $j++;
            }
            
            $this->load->helper('common_url');
            $house_conf = $this->config->item('house');
            foreach($arr as &$val)
            {
                $val['url'] = $tbl =='sell' ? get_sellinfo_url($val['id']) : get_rentinfo_url($val['id']);
                $val['unit'] = $tbl =='sell' ? '' : $house_conf['personunit'][$val['priceunit']];
                $val['type'] = $tbl =='sell' ? '' : $val['renttype'];
                $val['infotype_str'] = $house_conf['infotype'][$val['infotype']];

				//˽Դʾ400
				if(isset($val['uid']) && $val['uid'] > 0 && isset($val['tel400']) && $val['tel400'] == 1  )
				{	
					$this->load->helper('common_api');
					$api_url = USER_CENTER.'api_400/get_telno400_by_uid/';
					$api_url_param = $val['uid'].'/'.GB_CITY;
					$telno_400_json = get_api($api_url.$api_url_param);
					if(!empty($telno_400_json))
					{
						$telno_info = json_decode($telno_400_json , TRUE);
						if(isset($telno_info[0]['num_400']) && isset($telno_info[0]['num_group']))
						{
							$telno_400 = $telno_info[0]['num_400'].'ת'.$telno_info[0]['num_group'];
							$val['telno'] = $telno_400;
						}
					}
				}
            }
            
            $return['pages'] = helper_pagination($page, $pages, 0);
            
            $return['data'] = $arr;
        }
        
        return $return;
    }
}
/* End of file welcome.php */
/* Location: ./application/controllers/welcome.php */