<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ۱ϵͳ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright      Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 */

// ------------------------------------------------------------------------

/**
 * House_demand_base_model CLASS
 *
 * 󹺡࣬ṩ󹺡Ϣķ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          xz     
 */
class House_demand_base_model extends MY_Model{
   
    /**
     * 󹺡û
     *
     * @access private
     * @var integer
     */
    private $_uid    = 0;
    
    /**
     * 󹺡Ϣ
     *
     * @access private
     * @var integer
     */
    private $_id    = 0;

    /**
     * ûڵĳ
     *
     * @access private
     * @var string
     */
    private $_city = NULL;
    
    
    /**
     * 󹺡Ϣ
     *
     * @access private
     * @var string
     */
    private  $_tbl = NULL;
    
    
    /**
     * 󹺡Ϣ
     *
     * @access private
     * @var string
     */
    protected $_tbl_arr = array( 'buy' , 'rentwanted');
    
    /**
     * ѯֶ
     *
     * @access private
     * @var array
     */
    private $_search_fields = array();
    
    
    /**
     * Constructor
     */
    public function __construct(1,1,1) 
    {
        parent::__construct();
    }
    
    
    /**
     * ʼϢ
     *
     * @access	public
     * @param	int $id ˺ű
     * @return	void
     */
    public function set_id( $id )
    {
        $this->_id = intval( $id );
    }
    
    
    /**
     * ȡϢ
     *
     * @access	public
     * @param	void
     * @return	int Ϣ
     */
    public function get_id( )
    {
        return $this->_id;
    }
    
    
    /**
     * ʼ󹺡û
     *
     * @access	public
     * @param	int $uid 󹺡û
     * @return	void
     */
    public function set_uid( $uid )
    {
        $this->_uid = intval( $uid );
    }
    
    
    /**
     * ȡ󹺡û
     *
     * @access	public
     * @param	void
     * @return	int 󹺡û
     */
    public function get_uid( )
    {
        return $this->_uid;
    }
    
    
    /**
     * 󹺡Ϣ
     *
     * @access	public
     * @param	string $tbl_name 
     * @return	void
     */
    public function set_tbl( $tbl_name )
    {
        $this->_tbl = strip_tags( $tbl_name );
    }
    
    
    /**
     * ȡϢ
     *
     * @access	public
     * @param	void
     * @return	string Ϣ
     */
    public function get_tbl( )
    {
        return $this->_tbl;
    }
    
    
    /**
     * õķԴϢҪѯֶ
     *
     * @access	public
     * @param	array  $arr_fields ԴϢֶ
     * @return	void
     */
    public function set_search_fields( $arr_fields )
    {
        $this->_search_fields = $arr_fields;
    }
    
    
    /**
     * ȡõķԴϢҪѯֶ
     *
     * @access	public
     * @param	void
     * @return	array  ԴϢҪѯֶ
     */
    public function get_search_fields()
    {
        return $this->_search_fields;
    }
    
    
    /**
     * ӷԴϢ
     *
     * @access	protected
     * @return	boolean ǷӳɹTRUE-ɹFAlSEʧܡ
     */
    protected function add_info($data_info)
    {
        $this->db->insert( $this->get_tbl() , $data_info );

        return ( $this->db->affected_rows() == 1 ) ? $this->db->insert_id() : FALSE;
    }
    
    
    /**
     * ݱɾϢ
     *
     * @access	protected
     * @return	boolean ǷɾɹTRUE-ɹFAlSEʧܡ
     */
    protected function delete_info_by_id()
    {   
        $id = $this->get_id();
        
        $tbl_name = $this->get_tbl();
        
        $this->db->delete($tbl_name , array( 'id' => $id ) ); 

        return ( $this->db->affected_rows() == 1 ) ? TRUE : FALSE;
    }
    
    
    /**
     * ݶɾϢ
     *
     * @access	protected
     * @param	array  $arr_ids Ϣ
     * @return	boolean ǷɾɹTRUE-ɹFAlSEʧܡ
     */
    protected function delete_info_by_ids($arr_ids)
    {   
        $tbl_name = $this->get_tbl();
        
        if( isset( $arr_ids ) && !empty( $arr_ids ) )
        {   
            //ѯֶ
            $arr_ids_str = implode( ',' , $arr_ids ) ;
            $cond_where = "id IN(".$arr_ids_str.")";
            
            $this->db->where($cond_where);
            $this->db->delete($tbl_name);
        }

        return ( $this->db->affected_rows() >= 1 ) ? TRUE : FALSE;
    }
    
    
    /**
     * ĳԴϢ
     *
     * @access	protected
     * @param	array  $update_arr  Ҫֶεļֵ
     * @param	string  $cond_where 
     * @param	boolean  $escape Ƿתֶεֵ
     * @return	boolean Ǹ³ɹTRUE-ɹFAlSEʧܡ
     */
    protected function update_info_by_cond( $update_arr , $cond_where , $escape = TRUE )
    {
        $tbl_name = $this->get_tbl();
        
        if( $tbl_name == '' || empty($update_arr) || $cond_where == '')
        {
            return FALSE;
        }
        
        foreach($update_arr as $key => $value)
        {
            $this->db->set( $key , $value , $escape);
        }

        //
        $this->db->where( $cond_where );
        
        //
        $this->db->update( $tbl_name ); 

        return ( $this->db->affected_rows() == 1 ) ? TRUE : FALSE;
    }
    
    
    /**
     * ĳԴϢ
     *
     * @access	protected
     * @param	array  $update_arr Ҫֶεļֵ
     * @param	boolean  $escape Ƿתֶεֵ
     * @return	boolean Ǹ³ɹTRUE-ɹFAlSEʧܡ
     */
    public function update_info_by_id( $update_arr , $escape = TRUE )
    {
        $id = $this->get_id();
        
        if( $id > 0)
        {
            $cond_where = "id = '".$id."' ";
            return $this->update_info_by_cond( $update_arr , $cond_where , $escape);
        }
        else
        {
            return FALSE;
        }
    }
    
    
    /**
     * ȡķԴϢ
     *
     * @access	protected
     * @param	string  $cond_where ѯ
     * @return	int   Ϣ
     */
    protected function get_count_by_cond( $cond_where = '' )
    {
        $count_num = 0;
        
        //ԴϢ
        $tbl_demand = $this->get_tbl();
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
            $count_num = $this->dbback->count_all_results( $tbl_demand );
        }
        
        return  intval( $count_num );
    }
    
    
    /**
     * ȡķԴϢб
     *
     * @access	protected
     * @param	string  $cond_where ѯ
     * @param	int     $offset ƫ,ĬֵΪ0
     * @param	int     $limit ÿȡĬֵΪ10
     * @param	string  $order_key ֶΣĬֵ
     * @param	string  $order_by  򡢽ĬϽ
     * @return	array   Ϣб
     */
    protected function get_list_by_cond( $cond_where , $offset = 0 , $limit = 10 , $order_key = 'creattime' , $order_by = 'DESC' )
    {   
        //ԴϢ
        $tbl_demand = $this->get_tbl();
        
        //ҪѯķԴϢֶ
        $select_fields = $this->get_search_fields();
        
        if( isset( $select_fields ) && !empty( $select_fields ) )
        {   
            //ѯֶ
            $select_fields_str = implode( ',' , $select_fields ) ;
            $this->dbback->select( $select_fields );
        }
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
        }

        //
        $this->dbback->order_by( $order_key , $order_by );

        //ѯ
        $arr_data = $this->dbback->get( $tbl_demand , $limit , $offset )->result_array();

        return  $arr_data;
    }
    
    
    /**
     * ȡ󹺡Ϣ
     *
     * @access	protected
     * @param	string  $cond_where ѯ
     * @return	array 󹺡Ϣ
     */
    protected function get_info_by_cond( $cond_where )
    {
        $arr_data = array();
        
        //ȡ
        $tbl_demand = $this->get_tbl();

        //Ҫѯ󹺡Ϣֶ
        $select_fields = $this->get_search_fields();
        if( isset( $select_fields ) && !empty( $select_fields ) )
        {   
            $select_fields_str = implode( ',' , $select_fields ) ;
            $this->dbback->select( $select_fields_str );
        }
        
        //ѯ
        if( $cond_where != '')
        {
            $this->dbback->where( $cond_where );
        }

        //ѯ
        $arr_data = $this->dbback->get( $tbl_demand )->row_array();
        
        return $arr_data;
    }
    
    
    /**
     * 󹺡Żȡ󹺡Ϣ
     *
     * @access	protected
     * @return	array Ϣ
     */
    public function get_info_by_id()
    {   
        $demandinfo = array();
        
        //ȡ󹺡Ϣ
        $id = $this->get_id();
        
        if( $id <= 0)
        {
            return $demandinfo;
        }
        
        $cond_where = "id = ".$id;
        $demandinfo = $this->get_info_by_cond( $cond_where );
        
        return $demandinfo;
    }
}
/* End of file house_demand_base_model.php */
/* Location: ./application/models/house_demand_base_model.php */