<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
 * zsb
 *
 * ҵ
 *
 * @package         zsb
 * @author          EllisLab Dev Team
 * @copyright       Copyright (c) 2006 - 2014, HOUSE365, Inc.
 * @link            http://nj.sell.house.com
 * @since           Version 1.0
 * @filesource
 */

// ------------------------------------------------------------------------
/**
 * С
 *
 * Сļ
 *
 * @package         zsb
 * @subpackage      Models
 * @category        Models
 * @author          fisher
 */
class Block_base_xiao_model extends MY_Model 
{ 
    /**
     * С
     * @var string 
     */
    private $_block_tbl = 'block';
    
    /**
     * Сͼ
     * @var string 
     */
    private $_block_img_tbl = 'block_img';
    
    
    /**
     * ѯֶ
     * @var string 
     */
    public $select_fields = '';
    
    /**
     * Ҫѯֶ
     * @param array $select_fields
     */
    public function set_select_fields($select_fields)
    {
        $select_fields_str = '';
        if(isset( $select_fields ) && !empty($select_fields))
        {   
            $select_fields_str = implode( ',', $select_fields) ;
        }
        $this->select_fields = $select_fields;
    }
    
    /**
     * ȡҪѯֶ
     * @return string
     */
    public function get_select_fields()
    {
        return $this->select_fields;
    }
    
   /**
    * ʼ
    */
    public function __construct()
    {
        parent::__construct(1,1,2);
    }
    
    /**
     * СŻȡСҳurlַ
     * @param int $id С
     * @return string Сweb˵ĵַ
     */
    public function find_blockurl_by_id($id)
    {
        return GB_XIAOQU_URL . $id . '/';
    }
    
    /**
     * ȡС״̬
     * @param iny $esta ״̬λ
     * @return string 
     */
    public function find_blocktype_by_esta($esta)
    {
        $esta_block = '';
        if($esta == 2)
        {
            $esta_block = "ʽС";
        }
        elseif($esta == 1)
        {
            $esta_block = "ʱС";
        }
        elseif($esta == 0)
        {
            $esta_block = "С";
        }
        return $esta_block;
    }
    
    /**
     * СidŻȡϢ
     * @param int $id С
     * @return array СϢɵһά
     */
    public function find_by_id($id)
    {
        //ѯֶ
        if ($this->get_select_fields())
        {
            $this->dbback->select($this->get_select_fields());
        }
        //ѯ
        $this->dbback->where('id', $id);
        return $this->dbback->get($this->_block_tbl)->row_array();
    }
    
    /**
     * СƺŻȡϢ
     * @param string $blockname С
     * @return int
     */
    public function find_by_blockname($blockname)
    {
        //ѯֶ
        if ($this->get_select_fields())
        {
            $this->dbback->select($this->get_select_fields());
        }
        $this->dbback->where('blockname', $blockname);
        return $this->dbback->get($this->_block_tbl)->row_array();
    }
    
    
    /**
     * ȡСϢ
     * @param string $cond_where ѯ
     * @return array С
     */
    public function find_by_cond($cond_where)
    {   
        $block_arr = array();
        
        if( $cond_where != '' )
        {
            //ѯֶ
            if ( $this->get_select_fields() )
            {
                $this->dbback->select($this->get_select_fields());
            }
            
            $this->dbback->where($cond_where);
            $block_arr =  $this->dbback->get($this->_block_tbl)->result_array();
        }
        
        return $block_arr;
    }
    
    /**
     * һͼ
     * @param string $blockname С
     * @param int $room 
     * @param int $hall 
     * @return int
     */
    public function find_room_img_count($blockname, $room, $hall)
    {
        $where = "b.blockname = '".$blockname. "' AND bi_room = '$room' "
                . "AND bi_hall = '$hall' AND (bi.bi_type = 0 OR bi.bi_type = 9)";
        $this->dbback->where($where);
        $this->dbback->join($this->_block_tbl . ' b', 'bi.bi_blockid = b.id');
        return $this->dbback->count_all_results($this->_block_img_tbl . ' bi');
    }
    
    /**
     * һͼļ¼
     * @param string $blockname С
     * @param int $room 
     * @param int $hall 
     * @param int $start ѯʼ
     * @param int $limit ƫ
     * @return array
     */
    public function find_room_img($blockname, $room, $hall, $start = 0, $limit = 20)
    {
        //ѯֶ
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
        $where = "b.blockname = '".$blockname. "' AND bi_room = '$room' "
                . "AND bi_hall = '$hall' AND (bi.bi_type = 0 OR bi.bi_type = 9)";
        $this->dbback->where($where);
        $this->dbback->join($this->_block_tbl . ' b', 'bi.bi_blockid = b.id');
        return $this->dbback->get($this->_block_img_tbl . ' bi', $start, $limit)
                ->result_array();
    }

    /**
     * ⾰ͼ
     * @param string $blockname С
     * @return int
     */
    public function find_outdoor_img_count($blockname)
    {
        $where = "b.blockname = '".$blockname.
                "' AND ( bi.bi_type = 51  OR bi.bi_type = 52  OR bi.bi_type = 53)";
        $this->dbback->where($where);
        $this->dbback->join($this->_block_tbl . ' b', 'bi.bi_blockid = b.id');
        return $this->dbback->count_all_results($this->_block_img_tbl . ' bi');
    }
    
    /**
     * ⾰ͼļ¼
     * @param string $blockname С
     * @param int $start ѯʼ
     * @param int $limit ƫ
     * @return array
     */
    public function find_outdoor_img($blockname, $start = 0, $limit = 20)
    {
        //ѯֶ
        /*
        if ($this->select_fields)
        {
            $this->dbback->select($this->select_fields);
        }
        $where = "b.blockname = '".$blockname.
                "' AND ( bi.bi_type = 51  OR bi.bi_type = 52  OR bi.bi_type = 53)";
        $this->dbback->where($where);
        $this->dbback->join($this->_block_tbl . ' b', 'bi.bi_blockid = b.id');
        $this->dbback->order_by('locate(52,bi_type) desc',false);
        print_r($this->dbback);die;
        return $this->dbback->get($this->_block_img_tbl . ' bi', $start, $limit)
                ->result_array();
        */

        $sql = "SELECT bi.id,bi.bi_img,bi.bi_type FROM block_img bi JOIN block b ON b.id = bi.bi_blockid WHERE b.blockname = '".$blockname."' AND ( bi_type = 51 OR bi_type = 52 OR bi_type = 53 ) ORDER BY locate(52, bi_type) DESC LIMIT ".$limit.",".$start;

        $result = $this->dbback->query($sql)->result_array();
        return $result;
    }
    
    /**
     * СģѯСļ¼
     * @param string $blockname С
     * @param int $num ʾ
     * @return array СϢɵĶά
     */
    public function find_like_by_blockname($blockname, $num = 10)
    {
        //ѯֶ
        if ($this->get_select_fields())
        {
            $this->dbback->select($this->get_select_fields());
        }
        $this->dbback->like('blockname', $blockname, 'after');
        $this->dbback->or_like('bi_s', $blockname, 'after');
        $this->dbback->or_like('bi_spell', $blockname, 'after');
		//$this->dbback->last_query();
        return $this->dbback->get($this->_block_tbl, $num)->result_array();
    }
    
    /**
     * ĳСƵĸ
     * @param string $blockname С.
     * @return int 
     */
    public function find_count_by_blockname($blockname)
    {
        $this->dbback->where('blockname', $blockname);
        return $this->dbback->count_all_results($this->_block_tbl);
    }
   
    
    /**
     * ĳСַĸ
     * @param string $address Сַ
     * @return int 
     */
    public function find_count_by_address($address)
    {
        $this->dbback->where('address', $address);
        return $this->dbback->count_all_results($this->_block_tbl);
    }
    
    /**
     * С¼
     * @param array $insert_data Դ
     * @return int ɹ زɹķԴid ʧ false
     */
    public function insert($insert_data)
    {
        if (isset($insert_data[0]) && is_array($insert_data[0]))
        {
            //
            if ($this->db->insert_batch($this->_block_tbl, $insert_data))
            {
                return $this->db->insert_id();
            }
        } 
        else 
        {
            //
            if ($this->db->insert($this->_block_tbl, $insert_data))
            {
                return $this->db->insert_id();
            }
        }
        return false;
    }
}

/* End of file block_model.php */
/* Location: ./models/block_model.php */
