<?php

/**
 * statistics
 * ĬϽַgbk,ҳַgbk,ֻ֧getʽ$dayʽdate("Ymd")
 * @package classes
 * @author alang
 * @copyright www.house365.com
 * @version 2010
 * @access public
 */
class statisticszhou {

    public $appName;
    public $appName_bak;
    public $method;
    public $channel;
    public $sourceCharSet;
    public $inChar;
    public $outChar;
    private $mc;

    /**
     * statistics::statistics()
     * 
     * @param mixed $appName Ӧ
     * @param string $sourceCharSet 
     * @return
     */
    public function __construct() 
	{
        $ci = & get_instance();
        $configStat = $ci->config->item('statistics');
		
        $configStatNew = $configStat[2]['new'];
        $configStatOld = $configStat[2]['old'];
        if (!$configStatNew || !$configStatOld) {
            error_log('ͳô');
            show_404();
        }
        $this->appName = $configStatOld['appName'];
        $this->appName_bak = $configStatNew['appName'];
        $this->city = $configStatNew['city'];
        $this->sourceCharSet = strtolower($configStatNew['charSet']);
        $ci->load->library('My_memcached',null,'memcached');
        if (!$ci->memcached) {
            show_404();
        }
        $this->mc = $ci->memcached;
    }

    /*** ȡ ***/
    
    /**
     * statistics::get_housecount()
     * ȡԴ
     * @param mixed $day 
     * @param array $array 
     * array('infofrom'=>'','infotype'=>'','uid'=>'','agentcode'=>'','partition'=>'','counttype'=>'')
     * @param string $app sell:ַ rent:ⷿ ĬΪsell
     * @return string
     */
    function get_housecount($day,$array=null,$app='sell')
    {
            $strSql = $this->tourl($array);
            $url = "http://".$this->appName."/gethousecount?day=".$day."&app=".$app.$strSql;
            // return $url;
            $strData = $this->curl_get_contents($url);
            return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }


    /**
     * statistics::get_graderhouse()
     * ȡĳǼԴ
     * @param mixed $day
     * @param mixed $uid ûuid
     * @param string $app
     * @return string
     */
    function get_graderhouse($day , $uid , $app = 'sell')
    {
        $url = "http://".$this->appName."/gethousecount?"
                . "type=gradehouse&day=".$day."&uid=".$uid."&app=".$app;

        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }


    /**
     * statistics::get_pricecount()
     * ȡͳ
     * @param mixed $day
     * @param array $array
     * array('infofrom'=>'','infotype'=>'','uid'=>'','agentcode'=>'','partition'=>'','counttype'=>'')
     * @param string $app
     * @return string
     */
    function get_pricecount($day,$array=null,$app='sell')
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getpricecount?day=".$day."&app=".$app.$strSql;

        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }


    /**
     * statistics::get_aver()
     * ȡĳ¶ľ
     * @param mixed $startday
     * @param array $array array('streetid'='') or array('blockid'='')
     * @param array $limit
     * @param string $app
     * @return string
     */
    function get_aver($startday,$array,$limit,$app='sell')
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getpricecount?"
                . "type=getaver&startday=".$startday."&limit=".$limit."&app=".$app.$strSql;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }


    /**
     * statistics::getcityaver()
     * ȫйƾ
     * @param mixed $startday
     * @param array $array array('streetid'='') or array('blockid'='')
     * @param array $limit
     * @param string $app
     * @return array
     */
    function getcityaver($day,$limit,$app='sell')
    {
        $url = "http://".$this->appName."/getpricecount?"
                . "type=getcityaver&day=".$day."&limit=".$limit."&app=".$app;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }
    
    
    /**
     * statistics::getaverbyuid()
     * uidȡĳ¶ľ
     * @param mixed $startday
     * @param int $uid
     * @param array $array array('streetid'='') or array('blockid'='')
     * @param array $limit
     * @param string $app
     * @return string
     */
    function getaverbyuid($startday,$uid,$array,$limit,$app='sell')
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getpricecount?"
                . "type=getaverbyuid&startday=".$startday."&uid=".$uid."&limit=".$limit."&app=".$app.$strSql;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }


    /**
     * statistics::getaverbyinfo()
     * infofromȡĳ¶ľ
     * @param mixed $startday
     * @param int $infofrom
     * @param array $array array('streetid'='') or array('blockid'='')
     * @param array $limit
     * @param string $app
     * @return string
     */
    function getaverbyinfo($startday,$infofrom,$array,$limit,$app='sell')
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getpricecount?"
                . "type=getaverbyinfo&startday=".$startday."&infofrom=".$infofrom."&"
                . "limit=".$limit."&app=".$app.$strSql;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }


    /**
     * statistics::getuidaver()
     * ĳ˷ķԴ
     * @param mixed $day
     * @param int $uid
     * @param array $limit
     * @param string $app
     * @return array
     */
    function getuidaver($uid,$day,$limit,$app='sell')
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getpricecount?"
                . "type=getuidaver&uid=".$uid."&day=".$day."&limit=".$limit."&app=".$app;
        
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }


    /**
     * statistics::get_housencount()
     * ȡԴ
     * @param mixed $day
     * @param array $array
     * array('infofrom'=>'','infotype'=>'','uid'=>'','agentcode'=>'','partition'=>'','counttype'=>'')
     * @param string $app
     * @return string
     */
    function get_housencount($day,$array=null,$app='sell')
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/gethousencount?day=".$day."&app=".$app.$strSql;
        
        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }
    
    
    /**
     * statistics::get_dayclickcount()
     * ȡ˷Դĳ
     * @param mixed $day
     * @param mixed $uid
     * @param string $app
     * @return array
     */
    function get_dayclickcount($day , $uid , $app = 'sell')
    {	
		$mem_key = 'nj_statistics_get_dayclickcount2_'.$day.'_'.$app.'_'.$uid.'v3';
        $cache = $this->mc->get($mem_key);
        $this->mc->delete($mem_key);
		$click_info = array();
        if($cache['is_ok'] == 1)
        {
            $click_info = $cache['data'];
        }
        else
        {
			$url = "http://".$this->appName."/getclickcount?"
					. "type=dayclickcount&day=".$day."&uid=".$uid."&app=".$app.'&city='.GB_CITY;
			
			$strData = $this->curl_get_contents($url);

			$strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
			$click_info = $this->json_decode($strData);
			$this->mc->add($mem_key, array('is_ok'=>1 , 'data' => $click_info ), 3600);
		}
		
		return $click_info;
    }


    /**
     * statistics::get_clickcount()
     * ȡʵʱ
     * @param mixed $day
     * @param string $uid
     * @param array $array
     * array('hour'=>'','grade'=>'');
     * @param string $app
     * @return string
     */
    function get_clickcount($day,$uid='',$array=null,$app='sell')
    {
        $strSql = $this->tourl($array);
        
        if($uid == '')
        {
            $url = "http://".$this->appName."/getclickcount?"
                    . "day=".$day."&app=".$app.$strSql;
        }
        else
        {
            $url = "http://".$this->appName."/getclickcount?"
                    . "day=".$day."&uid=".$uid."&app=".$app.$strSql;
        }

        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }
    
    
    /**
     *ͼԴ
     */
    function get_clickcountbygrade($day , $uid='',$app='sell')
    {
        $strSql = $this->tourl($array);
        
        if($uid)
        {
            $url = "http://".$this->appName."/getclickcount?"
                    . "type=getcountbygrade&day=".$day."&uid=".$uid."&app=".$app;
        }
        
        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }
    
    
    /**
      * statistics::get_clickcount()
      * ȡĪԴĳյ
      * @param mixed $dayռǰ
      * @param string $fid
      * @param string $app
      * @return string
      */
    function get_fidclickcount( $day , $fid , $app = 'sell' )
    {
        $mem_key = GB_CITY.'_nj_statistics_get_fidclickcount_'.$day.'_'.$app.'_'.$fid;
		//echo  $mem_key;
		$this->mc->delete($mem_key);
        $cache = $this->mc->get($mem_key);
        
        if($cache['isok'] == 1)
        {
            $str = $cache['data'];
        }
        else
        {
             $url = "http://".$this->appName."/getclickcount?type=getfidcount&"
                    . "day=".$day."&fid=".$fid."&app=".$app."&city=".GB_CITY;
			if(GB_CITY=='hf')
			{
				//echo $url;die;
			}
            $strData = $this->curl_get_contents($url);
            $str = $this->strIconv( $strData , 'gbk' , $this->sourceCharSet);
            $str = abs($str);
            $this->mc->add($mem_key, array( 'isok'=>1 , 'data' => $str ),  3600);
        }

        return $str;
    }


	 /**
      * statistics::getfidsclickcountnew()
      * ȡԴĳյ
      * @param mixed $dayռǰ
      * @param string $fids
      * @param string $app
      * @return string
      */
    function getfidsclickcountnew( $day , $fids , $app = 'sell' )
    {    
		
		$url = "http://zjj182.house365.com:2093/xxx-sell-count-api"."/click?type=getClickFidsCount".'&city='.GB_CITY.
				"&day=".$day."&app=".$app."&fids=".$fids;
		
		$strData = $this->curl_get_contents($url);

        return $this->json_decode($strData);
    }
    
    
    /**
     * statistics::get_dayclickcountbyuid()
     * ȡյ()
     * @param mixed $day
     * @param string $uid
     * @param string $app
     * @return array
     */
    function get_dayclickcountbyuid($day , $uid='',$app='sell')
    {
        if($uid != '')
        {
            $url = "http://".$this->appName."/getclickcount?"
                    . "type=dayclickcountbyuid&day=".$day."&app=".$app."&uid=".$uid;   
        }
		else
		{
			$url = "http://".$this->appName."/getclickcount?"
                . "type=dayclickcountbyuid&day=".$day."&app=".$app;
		}
                
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        
        return $this->json_decode($strData);
    }


    /**
     * statistics::getcountbylimit()
     * ȡǰĵ
     * @param string $uid
     * @param array $array
     * array('hour'=>'','grade'=>'');
     * @param string $app
     * @return string
     */
    function getcountbylimit($uid='',$limit='',$array=null,$app='sell')
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getclickcount"
                . "?type=getcountbylimit&uid=".$uid."&limit=".$limit."&app=".$app.$strSql;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }
    
    
    /**
     * statistics::get_csclickcount()
     * ȡĳĳ˸Դĵ
     * @param mixed $day
     * @param mixed $uid
     * @param string $limit 
     * @param string $app
     * @return array
     */
    function get_csclickcount( $day , $uid , $limit='1',$app='sell')
    {
        $url = "http://".$this->appName."/getclickcount?"
                . "type=csclickcount&day=".$day."&uid=".$uid."&limit=".$limit."&app=".$app;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }


    /**
     * statistics::get_cshourclickcount()
     * ȡĳĳĳԴ¸ʱεĵ
     * @param mixed $day
     * @param mixed $uid
     * @param mixed $clicksource Դַ
     * @param string $app
     * @return array
     */
    function get_cshourclickcount($day,$uid,$clicksource,$app='sell')
    {
        $url = "http://".$this->appName."/getclickcount?"
                . "type=cshourclickcount&day=".$day."&uid=".$uid."&"
                . "clicksource=".urlencode($clicksource)."&app=".$app;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }


    /**
     * statistics::get_searchcount()
     * ȡĳ
     * @param mixed $day
     * @param mixed $app
     * @param array $array
     * array('district'=>'','streetid'=>'','address'=>'','price'=>'','buildarea'=>'','room'=>'','floor'=>'','infotype'=>'','ip'=>'','hour'=>'');
     * @return string
     */
    function get_searchcount($day,$app,$array=null)
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getsearchcount?type=searchcount&day=".$day."&app=".$app.$strSql;
        
        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }


	//ʱõ
    function get_searchcount_bak($day,$app,$array=null)
	{
		$strSql = $this->tourl($array);
		$mem_key = md5(GB_CITY.'_get_searchcount_bak3_'.$day.'_'.$app.'_'.$strSql);
        $cache = $this->mc->get($mem_key);
		//$cache = $this->mc->delete($mem_key);
		$data = array();

        if(isset($cache['isok']) && $cache['isok'] == 1)
        {
            $data = $cache['data'];
        }
        else
        {
			if(GB_CITY=='nj')
			{
				$url = "http://".$this->appName_bak."/getsearchcount?type=searchcount&day=".$day."&app=".$app.$strSql;
			}else
			{
				$url = "http://".$this->appName_bak."/getsearchcount?type=searchcount&day=".$day."&app=".$app.$strSql.'&city='.GB_CITY;
			}
			$strData = $this->curl_get_contents($url);
			$data =  $this->strIconv($strData,"gbk",$this->sourceCharSet);
			$this->mc->add( $mem_key, array('isok'=>1,'data'=>$data) , 3600);
		}
		
		return $data;
	}

	//ʱõ
    function get_searchcount_bak_test($day,$app,$array=null)
	{
		$strSql = $this->tourl($array);
		$mem_key = md5('nj_get_searchcount_bak_'.$day.'_'.$app.'_'.$strSql);
        $cache = $this->mc->get($mem_key);
		//$cache = $this->mc->delete($mem_key);
		$data = array();

        if(isset($cache['isok']) && $cache['isok'] == 1 && false)
        {
            $data = $cache['data'];
        }
        else
        {
			$url = "http://".$this->appName_bak."/getsearchcount?type=searchcount&day=".$day."&app=".$app.$strSql;
			$strData = $this->curl_get_contents($url);
			$data =  $this->strIconv($strData,"gbk",$this->sourceCharSet);
			$this->mc->add( $mem_key, array('isok'=>1,'data'=>$data) , 3600);
		}
		
		return $data;
	}

	
    
    
    function get_searchhourcount($day,$app,$array=null)
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getsearchcount?"
                . "type=searchhourcount&day=".$day."&app=".$app.$strSql;
        
        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }


    /**
     * statistics::get_searchrank()
     * ȡĳؼ
     * @param mixed $day
     * @param string $searchtype ֶ
     * @param string $limit
     * @param string $app
     * @return array
     */
    function get_searchrank($day,$searchtype='address',$limit='100',$app='sell')
    {
        $url = "http://".$this->appName."/getsearchcount?"
                . "type=searchrank&day=".$day."&searchtype=".$searchtype."&limit=".$limit."&app=".$app;
        
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }


    /**
     * statistics::get_logincount()
     * ȡ½
     * @param mixed $day
     * @param mixed $uid
     * @param string $hour Сʱ(0-23)
     * @param string $agentcode н
     * @return string
     */
    function get_logincount($day,$uid,$hour='',$agentcode='')
    {
        $url = "http://".$this->appName."/getlogincount?"
                . "type=getlogincount&day=".$day."&uid=".$uid."&hour=".$hour."&agentcode=".$agentcode;

        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }


    /**
     * statistics::get_countrank()
     * ȡС
     * @param mixed $day
     * @param string $limit
     * @param string $app
     * @return array
     */
    function get_countrank($day,$limit='100',$app='sell')
    {
        $url = "http://".$this->appName."/getrank?"
                . "type=getcountrank&day=".$day."&limit=".$limit."&app=".$app;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }
    
    
    /**
     * statistics::get_pricerank()
     * ȡСƼ
     * @param mixed $day
     * @param string $limit
     * @param string $app
     * @return array
     */
    function get_pricerank($day,$limit='100',$app='sell')
    {
        $url = "http://".$this->appName."/getrank?"
                . "type=getpricerank&day=".$day."&limit=".$limit."&app=".$app;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }
    
    
    /**
     * statistics::get_operatecount()
     * ͨ־ȡ˻ŵĳˢ¡ɾԴ
     * @param mixed $day
     * @param array $array
     * array('uid'=>'','hour'=>'') or array('agentcode'=>'','hour'=>'')
     * @param string $operatetype
     * 1: 2ˢ 3ɾ
     * @param string $app
     * @return string
     */
    function get_operatecount($day,$array,$operatetype='1',$app='sell')
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getoperatecount?"
                . "type=getcount&day=".$day."&operatetype=".$operatetype."&app=".$app.$strSql;

        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }
    
    
    function get_dayoperatecount($day,$uid,$operatetype='1',$app='sell')
    {
        $url = "http://".$this->appName."/getoperatecount?"
            . "type=getdayoperate&uid=".$uid."&day=".$day."&operatetype=".$operatetype."&app=".$app;
        
        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }
    
    
    //ʱõ
    function get_dayoperatecount_bak($day,$uid,$operatetype='1',$app='sell')
    {
        $url = "http://".$this->appName_new."/getoperatecount?type=getdayoperate&"
                . "uid=".$uid."&day=".$day."&operatetype=".$operatetype."&app=".$app;

        $strData = $this->curl_get_contents($url);
        return $this->strIconv($strData,"gbk",$this->sourceCharSet);
    }

    
    /**
     * statistics::get_credit()
     * ȡ¼ϸϢ
     * @param mixed $day
     * @param array $array
     * array('uid'=>'','agentcode'=>'','event'=>'1','op'=>'','hour'=>'','start'=>'','limit'=>'','app'=>'sell')
     * @param string $app
     * @return array
     */
    function get_credit($day,$array,$app='sell')
    {
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getcredit?type=getdetail&day=".$day."&app=".$app.$strSql;

        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }


    /**
     * statistics::get_orderbyagentcode()
     * ȡĳշԴŵ
     * Author:
     * @param mixed $day (ʽ:20101219)
     * @param mixed $limit ʾ
     * @param string $app (ֵΪsellrent) ⻹ǳ
     * @param mixed $grade ͼԴ(ʱֵΪ3ĻǶͼԴΪյĻзԴ)
     * @return array
     */
    function get_orderbyagentcode($day,$limit='2',$app='sell',$grade='')
    {
        if($grade!='')
        {
            $url = "http://".$this->appName."/getclickcount?"
                    . "type=getorderbyagentcode&day=".$day."&limit=".$limit."&app=".$app."&grade=".$grade;
        }
        else
        {
            $url = "http://".$this->appName."/getclickcount?"
                    . "type=getorderbyagentcode&day=".$day."&limit=".$limit."&app=".$app;
        }
            
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }
    
    
    /**
     * ȡ˾idµľˢ¼¼
     * @param type getdayoperatebycid
     * @param startDay ʼʱYYYYMMDD
     * @param endDay ʱYYYYMMDD
     * @param pid qtype=1ʱpidΪid,qtype=2ʱpidΪ˾id
     * @param operatetype 2Ϊˢ²
     * @param app sellΪַrentΪⷿ
     * @param qType 1ʾˣ2ʾ˾
     */
    function getdayoperatebycid($startDay,$endDay, $pid, $operatetype, $qType)
    {
        $url = "http://".$this->appName."/getoperatecount?"
                . "type=getdayoperatebycid&startDay=".$startDay."&endDay=".$endDay
                 ."&pid=".$pid."&operatetype=".$operatetype ."&qType=".$qType;
        
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }
    
    
    //˾ͳˢ½ӿ
    function getdayoperatebyaid($startDay,$endDay, $pid, $operatetype, $qType)
    {
        $url = "http://".$this->appName."/getoperatecount?"
                . "type=getdayoperatebyaid&startDay=".$startDay."&endDay=".$endDay
                 ."&pid=".$pid."&operatetype=".$operatetype ."&qType=".$qType;
        
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }
    
    
    /**
     * statistics::get_orderbyuid()
     * ȡĳշԴ˵
     * Author:
     * @param mixed $day (ʽ:20101219)
     * @param mixed $limit ʾ
     * @param string $app (ֵΪsellrent) ⻹ǳ
     * @param mixed $grade ͼԴ(ʱֵΪ3ĻǶͼԴΪյĻзԴ)
     * @return array
     */
    function get_orderbyuid($day,$limit='2',$app='sell',$grade='')
    {
        if($grade!='')
        {
            $url = "http://".$this->appName."/getclickcount?"
                    . "type=getorderbyuid&day=".$day."&limit=".$limit."&app=".$app."&grade=".$grade;
        }
        else
        {
            $url = "http://".$this->appName."/getclickcount?"
                    . "type=getorderbyuid&day=".$day."&limit=".$limit."&app=".$app;
        }
            
        $strData = $this->curl_get_contents($url);
        $strData = $this->strIconv($strData,"gbk",$this->sourceCharSet);
        return $this->json_decode($strData);
    }


    /** ύ */
    
    /**
     * statistics::sub_clickcount()
     * ύӿ
     * @param mixed $fid Դid
     * @param mixed $uid
     * @param string $clicksource
     * @param string $ip
     * @param string $app
     * @return bool
     */
    function sub_clickcount($fid,$uid,$clicksource='',$ip='',$agentcode='B000',$app='sell',$grade='')
    {
        $clicksource = $clicksource == '' ? $_SERVER["HTTP_REFERER"] : $clicksource;
        $clicksource = $clicksource == '' ? 'unknown' : urlencode($clicksource);
        $ip = $ip == '' ? $this->GetIP() : $ip;
        
        $url = "http://".$this->appName."/getclickcount?"
                . "type=submit&fid=".$fid."&uid=".$uid."&clicksource=".$clicksource."&"
                . "ip=".$ip."&agentcode=".$agentcode."&app=".$app."&grade=".$grade;

        return $this->curl_get_contents_nocache($url);
    }


    /**
     * statistics::sub_searchcount()
     * ύ
     * @param array $array
     * array('district'=>'','streetid'=>'','address'=>'','price'=>'','buildarea'=>'','room'=>'','floor'=>'','infotype'=>'');
     * @param string $ip
     * @param string $app
     * @return bool
     */
    function sub_searchcount($array,$ip='',$app='sell')
    {
        $ip = $ip==''?$this->GetIP():$ip;
        $strSql = $this->tourl($array);
        $url = "http://".$this->appName."/getsearchcount?type=submit&ip=".$ip."&app=".$app.$strSql;

        return $this->curl_get_contents_nocache($url);
    }


    /**
     * statistics::sub_logincount()
     * ¼־ύӿ
     * @param mixed $uid
     * @param mixed $agentcode
     * @param string $ip
     * @return bool
     */
    function sub_logincount($uid,$agentcode,$ip='')
    {
        $ip = $ip==''?$this->GetIP():$ip;
        $url = "http://".$this->appName."/getlogincount?"
                . "type=submit&uid=".$uid."&agentcode=".$agentcode."&ip=".$ip."&city=".GB_CITY;
		
        $this->curl_get_contents_nocache("http://" .$this->appName_bak. "/getlogincount?type=submit&uid=" . $uid . "&agentcode=" . $agentcode . "&ip=" . $ip);
        return $this->curl_get_contents_nocache($url);
    }
    
    
    /**
     * statistics::sub_operatecount()
     * ־ύӿ
     * @param mixed $uid
     * @param mixed $agentcode
     * @param mixed $operatetype
     * @param mixed $fid
     * @param string $ip
     * @param string $app
     * @return bool
     */
    function sub_operatecount($uid , $agentcode , $operatetype , $fid , $ip = ''
            ,$app = 'sell' , $domain = '', $company = '')
    {
        if(!in_array($operatetype,array('0','1','2','3','4','5'))) 
        {
            return ;
        }
        
        $ip = $ip == '' ? $this->GetIP() : $ip;
        
		//modify xue 2015-09-22 мֻ37ύ
       // $url_new = "http://".$this->appName_bak."/getoperatecount?type=submit&uid=".$uid."&"
               // . "agentcode=".$agentcode."&operatetype=".$operatetype."&fid=".$fid."&"
              //  . "ip=".urlencode($ip)."&app=".$app."&domain=".$domain."&company=".$company;
        
		$url_old = "http://".$this->appName."/getoperatecount?type=submit&uid=".$uid."&"
                . "agentcode=".$agentcode."&operatetype=".$operatetype."&fid=".$fid."&"
                . "ip=".urlencode($ip)."&app=".$app."&domain=".$domain."&company=".$company;

        //$this->curl_get_contents_nocache($url_new);
        return $this->curl_get_contents_nocache($url_old);
    }


    /**
     * statistics::sub_credit()
     * ύӿ
     * @param mixed $uid
     * @param mixed $agentcode
     * @param mixed $op
     * @param mixed $credit  ֵ
     * @param string $ip
     * @param string $event  ¼ ĬΪ1
     * @param string $app
     * @return bool
     */
    function sub_credit($uid,$agentcode,$op,$credit,$ip='',$event='1',$app='sell')
    {
        $ip = $ip==''?$this->GetIP():$ip;
        $url = "http://".$this->appName."/getcredit?"
                . "type=submit&uid=".$uid."&agentcode=".$agentcode."&event=".$event."&"
                . "op=".$op."&credit=".$credit."&ip=".$ip."&app=".$app;

        return $this->curl_get_contents_nocache($url);
    }
    
    
    /**
     * statistics::tourl()
     * ʽ
     * @param array $array
     * @return string
     */
    function tourl($array)
    {	
		$ss = '';
        if(is_array($array) && !empty($array))
        {
            foreach($array as $k=>$v)
            {
                $ss .= "&".$k."=".urlencode($v);
            }
        }
        
        return $ss;
    }
    

    /**
     * statistics::GetIP()
     * ÿͻip
     * @return string
     */
    function GetIP()
    {
        $ip = $_SERVER["REMOTE_ADDR"];
        if(!empty($_SERVER["HTTP_X_FORWARDED_FOR"]))
        {
            $tip = split(",",$_SERVER["HTTP_X_FORWARDED_FOR"]);
            $ip = $tip[0];
        }
        
        return(trim($ip));
    }
    
    
    /**
     * statistics::aryIconv()
     * 鲢
     * @param array $array 
     * @param mixed $inChar ı
     * @param mixed $outChar ı
     * @return array
     */
    function aryIconv($array,$inChar,$outChar)
    {
        $this->inChar=$inChar;
        $this->outChar=$outChar;
        return $this->arraymyicov($array);
    }
    
    
    /**
     * statistics::arraymyicov()
     * ڲ,ѭ
     * @param array $array
     * @return array
     */
    function arraymyicov($array)
    {
        foreach ((array)$array as $key=>$value)
        {
            $key=$this->strIconv($key);
            if (!is_array($value))
            {
                $value=$this->strIconv($value);
            }
            else
            {
                $value=$this->arraymyicov($value);
            }
            
            $temparray[$key]=$value;
        }
        return $temparray;
    }
    
    
    /**
     * statistics::strIconv()
     * 滻
     * @param mixed $strInput
     * @param string $inChar
     * @param string $outChar
     * @return string
     */
    function strIconv($strInput,$inChar="",$outChar="")
    {
        if($inChar)
            $this->inChar = $inChar;
        
        if($outChar)
            $this->outChar = $outChar;
        
        $strOutput = iconv($this->inChar,$this->outChar,$strInput);
        if($strOutput !== false)
            return $strOutput;
        else
            return $strInput;
    }


    /**
     * statistics::json_decode()
     * php4json_decode
     * @param mixed $data
     * @return array
     */
    function json_decode($data) 
    {
        return json_decode($data,true);
    }
    
    
    function curl_get_contents($str,$t_url="")
    {
        $memkey = md5($str);
        $cache = $this->mc->get($memkey);
		//$this->mc->delete($memkey);
        if($cache['isok'] == 1)
        {
            $str = $cache['data'];
        }
        else
        {

			$startTime = time();//ʼʱ 

            $ch = curl_init();
            $t_url = $t_url ? $t_url : "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
            curl_setopt($ch, CURLOPT_URL, $str);
            curl_setopt($ch, CURLOPT_REFERER, $t_url);
			curl_setopt($ch, CURLOPT_TIMEOUT, 3);//
            curl_setopt($ch, CURLOPT_HEADER, 0);//
            curl_setopt($ch,CURLOPT_RETURNTRANSFER, 1);

            $str = curl_exec($ch);
            curl_close($ch);
			
			$endTime = time();//ʱ
			
			if($endTime-$startTime>3){
			   //־¼
				$time = date('Y-m-d H:i',time());
				$content = $time." ".$t_url." ".print_r($str,true)." \r\n";
				$fp1 = fopen('./applications/libraries/log_zjj_'.date('Ymd').'.txt','a');
				fwrite($fp1,"$content");
				fclose($fp1);
				
			}

            //־¼
            $errorArr = array('error');
            foreach($errorArr as $value){
				if(strpos($str,$value)!== FALSE){
					$content = $time." ".$t_url." ".print_r($str,true)." \r\n";
					$fp1 = fopen('./applications/libraries/log_zjj2_'.date('Ymd').'.txt','a');
					fwrite($fp1,"$content");
					fclose($fp1);
				
				}
			
			}		
             


            $this->mc->add( $memkey ,  array('isok'=>1,'data'=>$str) , 3600);
        }

        return $str;
    }
    
    
    function curl_get_contents_nocache($str,$t_url="")
    {

		$startTime = time();//ʼʱ new add 
        $ch = curl_init();
        $t_url = $t_url ? $t_url : "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
        curl_setopt($ch, CURLOPT_URL, $str);
        curl_setopt($ch, CURLOPT_REFERER, $t_url);
		curl_setopt($ch, CURLOPT_TIMEOUT, 3);//
        curl_setopt($ch, CURLOPT_HEADER, 0);//
        curl_setopt($ch,CURLOPT_RETURNTRANSFER, 1);

        $str = curl_exec($ch);
        curl_close($ch);

		$endTime = time();//ʱ new add
			
		if($endTime-$startTime>3){
		   //־¼
			$time = date('Y-m-d H:i',time());
			$content = $time." ".$t_url." ".print_r($str,true)." \r\n";
			$fp1 = fopen('./applications/libraries/log_zjj_'.date('Ymd').'.txt','a');
			fwrite($fp1,"$content");
			fclose($fp1);
			
		}

		//־¼
		$errorArr = array('error');
		foreach($errorArr as $value){
			if(strpos($str,$value)!== FALSE){
				$time = date('Y-m-d H:i',time());
				$content = $time." ".$t_url." ".print_r($str,true)." \r\n";
				$fp1 = fopen('./applications/libraries/log_zjj2_'.date('Ymd').'.txt','a');
				fwrite($fp1,"$content");
				fclose($fp1);
			
			}
		
		}	
		


        return $str;
    }
}
?>