<?php if (!defined('BASEPATH'))  exit('No direct script access allowed');

class Zmop_class
{
    private $rsaPriKeyFile = null;
    private $rsaPubKeyFile = null;
    private $gatewayUrl = 'https://zmopenapi.zmxy.com.cn/openapi.do';
    /**
     * ˽Կļ·
     * @param  String $path ˽Կļ·
     */
    public function setRsaPriKeyFile($path)
    {
        $this->rsaPriKeyFile = $path;
    }

    /**
     * ùԿļ·
     * @param  String $path Կļ·
     */
    public function setRsaPubKeyFile($path)
    {
        $this->rsaPubKeyFile = $path;
    }

    /**
     * ȡ
     * @param array $sParam 
     * @return string
     */
    public function getSignature($params)
    {
        $tempStr = $this->Assembling($params);		/** ƴӴǩַ */
        $sign = $this->Signature($tempStr);			/** ȡǩ */
        return $sign;
    }

    /**ǩַƴӺ
     * @param $params
     * @param bool $isEncode
     * @return string
     */
    private function Assembling($params, $isEncode = true)
    {
        ksort($params);			/** 鰴ռȻ˳ */
        $filterArr = array();
        foreach ($params as $k => $v) {
            if (false === empty($v) && 'sign' != $k) {
                // תĿַ
                //$v = mb_convert_encoding($v, $params['charset']);
                $filterArr[] = ($isEncode) ? $k.'='.urlencode($v) : $k.'='.$v;
            }
        }
        $stringToBeSigned = implode("&", $filterArr);		//ʹ & Ӳ
        unset ($k, $v);
        return $stringToBeSigned;
    }

    /**
     * ȡǩ
     * @param  string $tempStr ǩĲַ
     * @return mixed
     *         StringǩĲַ
     *         boolean˽Կļڣ
     */
    private function Signature($tempStr)
    {
        //ȡ˽Կļ
        $priKey = file_get_contents($this->rsaPriKeyFile);
        $priKey = openssl_get_privatekey($priKey);
        ($priKey) or die('ʹõ˽ԿʽRSA˽Կ');
        openssl_sign($tempStr, $sign, $priKey);
        openssl_free_key($priKey);
        $sign = base64_encode($sign);
        return $sign;
    }

    /**
     * ֤ǩ
     * @param  string $stringToBeSigned ǩĲ
     * @param  string $signature        ֤ǩ
     * @return boolean                   ֤
     */
    public function verify($stringToBeSigned, $signature)
    {
        /** ʹRSAǩͨǩַǩbase64룩֧Կ֤ǩ */
        //ȡԿļ
        $pubKey = file_get_contents($this->rsaPubKeyFile);
        //תΪopensslʽԿ
        $pubKey = openssl_get_publickey($pubKey);
        ($pubKey) or die('֧RSAԿ鹫ԿļʽǷȷ');
        //openssl÷ǩboolֵ
        $result = (bool)openssl_verify($stringToBeSigned, base64_decode($signature), $pubKey);
        openssl_free_key($pubKey);	//ͷԴ
        return $result;
    }

    /**
     * ݹԿм
     * @param array $params  ܲ
     * @return string        ַܺ
     */
    public function encrypt($params)
    {
        $paramStr = $this->Assembling($params);
        //ȡԿļ
        $pubKey = file_get_contents($this->rsaPubKeyFile);
        //תΪopensslʽԿ
        $pubKey = openssl_get_publickey($pubKey);
        ($pubKey) or die('֧RSAԿ鹫ԿļʽǷȷ');
        //openssl÷
        $encryptData = '';
        foreach (str_split($paramStr, 117) as $chunk) {
            openssl_public_encrypt($chunk, $chunkEncryptData, $pubKey);
            $encryptData .= $chunkEncryptData;
        }
        $encryptData = base64_encode($encryptData);
        openssl_free_key($pubKey);
        return $encryptData;
    }


    /**
     * ˽Կн
     * @param string $params  ַܲ
     * @return string         ַܺ
     */
    public function decrypt($params)
    {
        $priKey = file_get_contents($this->rsaPriKeyFile);
        $priKey = openssl_get_privatekey($priKey);
        ($priKey) or die('ʹõ˽ԿʽRSA˽Կ');
        //openssl÷
        $decryptData = '';
        foreach (str_split(base64_decode($params), 128) as $chunk) {
            openssl_private_decrypt($chunk, $chunkDecryptData, $priKey);
            $decryptData .= $chunkDecryptData;
        }
        openssl_free_key($priKey);
        return $decryptData;
    }
    /**
     * У$valueǷǿ
     * @param $value
     * @return bool
     */
    protected function checkEmpty($value) {
        if (!isset($value))
            return true;
        if ($value === null)
            return true;
        if (trim($value) === "")
            return true;

        return false;
    }

    /**
     * 
     * @param $params
     * @return string
     */
    public function request($params) {
        return $this->buildRequestForm($params);
    }


    /**
     * ԱHTMLʽ죨Ĭϣ
     * @param array $params 
     * @return string ύHTMLı
     */
    protected function buildRequestForm($params) {
        $sHtml = "<form id='alipaysubmit' name='alipaysubmit' action='".$this->gatewayUrl."' method='POST'>";
        foreach ($params as $key => $val) {
            if (false === $this->checkEmpty($val)) {
                //$val = $this->characet($val, $this->postCharset);
                $val = str_replace("'","&apos;",$val);
                //$val = str_replace("\"","&quot;",$val);
                $sHtml.= "<input type='hidden' name='".$key."' value='".$val."'/>";
            }
        }

        //submitťؼ벻Ҫname
        $sHtml = $sHtml."<input type='submit' value='ok' style='display:none;'></form>";
        $sHtml = $sHtml."<script>document.forms['alipaysubmit'].submit();</script>";

        return $sHtml;
    }
}