<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * User_Statistic_Model Class
 *
 * û־û¼־ûע᷽ʽûΪ¼
 *
 * @package         center
 * @subpackage      model
 * @category        model
 * @author          liuhu
 */
class Want_House_Model extends MY_Model
{

    /**
    * ûID
    *
    * @access private
    * @var integer
    */
    private  $_uid    = 0;

    /**
    * ûڵĳ
    *
    * @access private
    * @var string
    */
    private $_city  = 'nj';

    /**
    * Դ
    *
    * @access private
    * @var string
    */
    private  $_tbl_house    = NULL;

    /**
    * ƥ䷿ԴϢ
    *
    * @access private
    * @var string
    */
    private $_tbl_match  = NULL;


    /**
    * Դѯֶ
    *
    * @access private
    * @var array
    */
    private $_house_fields = array();


    /**
    * Constructor
    */
    public function __construct()
    {
        parent::__construct();

    }


    /**
    * set_tbl_house
    *
    * ʼԴ
    *
    * @access	public
    * @param	string $tbl Դ
    * @return	void
    */
    public function set_tbl_house($tbl)
    {
        $this->_tbl_house = strip_tags($tbl);
    }


    /**
    * set_tbl_match
    *
    * ʼƥ
    *
    * @access	public
    * @param	string $tbl ƥ
    * @return	void
    */
    public function set_tbl_match($tbl)
    {
        $this->_tbl_match = strip_tags($tbl);
    }



    /**
    * set_tbl_match
    *
    * ʼҪѯķԴϢֶ
    *
    * @access	public
    * @param	array $fields ֶ
    * @return	void
    */
    public function set_house_fields($fields)
    {
        $this->_house_fields = $fields;
    }


    /**
    * get_matched_by_id
    *
    * ȡ󹺡ƥ䷿ԴϢ
    *
    * @access	public
    * @param	int     $want_id ⡢󹺱
    * @param	int     $offset ƫ
    * @param	int     $pagesize ÿȡ
    * @param	string  $order 
    * @return	array   󹺼¼
    */
    function get_matched_by_id ($want_id , $offset = 0 , $pagesize = 0 , $order = 'DESC')
    {
        //ƥ䷿ԴԴ
        $MatchedHouseInfo = array();

        $want_id = intval($want_id);
        $tbl_house = $this->_tbl_house;
        $tbl_match = $this->_tbl_match;

        //ж⡢ϢǷΪ
        if($want_id == 0)
        {
            return $MatchedHouseInfo;
        }

        //ж󹺡 ͷԴǷΪ
        if( $tbl_house == NULL  || $tbl_match == NULL )
        {
            return $MatchedHouseInfo;
        }

        //ҪѯķԴֶϢ
        $house_fields_arr = $this->_house_fields;
        $fields_num = count ( $house_fields_arr );

        if( $fields_num >= 1 )
        {
            foreach ( $house_fields_arr as $key => $value )
            {
                $house_fields[$key] = $tbl_house.'.'.$value;
            }
        }
        $house_fields[] = $tbl_match.'.id as match_id';
        $house_fields[] = $tbl_match.'.isread as isread';

        //ѯ
        $cond_where = "$tbl_match.want_id = '".$want_id."' AND $tbl_match.esta = 0 and $tbl_house.esta=1 ";

        //òѯֶ
        $this->db_esfhousebak->select( $house_fields );

        //òѯ
        $this->db_esfhousebak->where($cond_where);

        //òѯı
        $this->db_esfhousebak->from($tbl_match);

        //ӱ
        $this->db_esfhousebak->join($tbl_house , $tbl_match.".match_id=".$tbl_house.".id" ,'left');

        //
        $this->db_esfhousebak->order_by( $tbl_match.'.creattime',$order);

        //LIMIT
        $this->db_esfhousebak->limit( $pagesize , $offset );

        //ѯ
        $MatchedHouseInfo = $this->db_esfhousebak->get()->result_array();
		//if($want_id==103023){
		//echo $this->db_esfhousebak->last_query();
		//}


        return $MatchedHouseInfo;
    }


    /**
    * get_matched_num_by_id
    *
    * ȡ󹺡ƥ䷿Դ
    *
    * @access	public
    * @param	int   $want_id ⡢󹺱
    * @return	int   ƥ䷿Դ
    */
    function get_matched_num_by_id ($want_id)
    {
        $want_id = intval($want_id);

        $tbl_house = $this->_tbl_house;
        $tbl_match = $this->_tbl_match;

        //ԼķԴ
        $MatchedNum = 0;
        $cond_where = "$tbl_match.want_id = '".$want_id."' AND $tbl_match.esta = 0 and $tbl_house.esta=1";

        $this->db_esfhousebak->where($cond_where);
        $this->db_esfhousebak->from($tbl_match);
        $this->db_esfhousebak->join($tbl_house,"$tbl_match.match_id = $tbl_house.id ");
        $MatchedNum = $this->db_esfhousebak->count_all_results();
		//if($want_id==103023){
		//echo $this->db_esfhousebak->last_query();
		//}

        return $MatchedNum;
    }
}