<?php
/**
* 2015-06-29 ޸ǩ
**/
require_once "WxPay.Config.php";
require_once "WxPay.Exception.php";

/**
 * 
 * ݶ࣬жΪ
 * //ȡǩxmlʽĲxmlȡݶ
 * @author widyhu
 *
 */
class WxPayDataBase
{
	protected $values = array();
	
	/**
	* ǩǩ㷨
	* @param string $value 
	**/
	public function SetSign()
	{
		$sign = $this->MakeSign();
		$this->values['sign'] = $sign;
		return $sign;
	}
	
	/**
	* ȡǩǩ㷨ֵ
	* @return ֵ
	**/
	public function GetSign()
	{
		return $this->values['sign'];
	}
	
	/**
	* жǩǩ㷨Ƿ
	* @return true  false
	**/
	public function IsSignSet()
	{
		return array_key_exists('sign', $this->values);
	}

	/**
	 * xmlַ
	 * @throws WxPayException
	**/
	public function ToXml()
	{
		if(!is_array($this->values) 
			|| count($this->values) <= 0)
		{
    		throw new WxPayException("쳣");
    	}
    	
    	$xml = "<xml>";
    	foreach ($this->values as $key=>$val)
    	{
    		if (is_numeric($val)){
    			$xml.="<".$key.">".$val."</".$key.">";
    		}else{
    			$xml.="<".$key."><![CDATA[".$val."]]></".$key.">";
    		}
        }
        $xml.="</xml>";
        return $xml; 
	}
	
    /**
     * xmlתΪarray
     * @param string $xml
     * @throws WxPayException
     */
	public function FromXml($xml)
	{	
		if(!$xml){
			throw new WxPayException("xml쳣");
		}
        //XMLתΪarray
        //ֹⲿxmlʵ
        libxml_disable_entity_loader(true);
        $this->values = json_decode(json_encode(simplexml_load_string($xml, 'SimpleXMLElement', LIBXML_NOCDATA)), true);		
		return $this->values;
	}
	
	/**
	 * ʽʽurl
	 */
	public function ToUrlParams()
	{
		$buff = "";
		foreach ($this->values as $k => $v)
		{
			if($k != "sign" && $v != "" && !is_array($v)){
				$buff .= $k . "=" . $v . "&";
			}
		}
		
		$buff = trim($buff, "&");
		return $buff;
	}
	
	/**
	 * ǩ
	 * @return ǩsignԱҪǩҪSetSignֵ
	 */
	public function MakeSign()
	{
		//ǩһֵ
		ksort($this->values);
		$string = $this->ToUrlParams();
		//ǩstringKEY
		$string = $string . "&key=".WxPayConfig::KEY;
		//ǩMD5
		$string = md5($string);
		//ǩģַתΪд
		$result = strtoupper($string);
		return $result;
	}
	
	/**
	 * ȡõֵ
	 */
	public function GetValues()
	{
		return $this->values;
	}
}

/**
 * 
 * ӿڵý
 * @author widyhu
 *
 */
class WxPayResults extends WxPayDataBase
{
	/**
	 * 
	 * ǩ
	 */
	public function CheckSign()
	{
		//fix쳣
		if(!$this->IsSignSet()){
			throw new WxPayException("ǩ");
		}
		
		$sign = $this->MakeSign();
		if($this->GetSign() == $sign){
			return true;
		}
		throw new WxPayException("ǩ");
	}
	
	/**
	 * 
	 * ʹʼ
	 * @param array $array
	 */
	public function FromArray($array)
	{
		$this->values = $array;
	}
	
	/**
	 * 
	 * ʹʼ
	 * @param array $array
	 * @param Ƿǩ $noCheckSign
	 */
	public static function InitFromArray($array, $noCheckSign = false)
	{
		$obj = new self();
		$obj->FromArray($array);
		if($noCheckSign == false){
			$obj->CheckSign();
		}
        return $obj;
	}
	
	/**
	 * 
	 * ò
	 * @param string $key
	 * @param string $value
	 */
	public function SetData($key, $value)
	{
		$this->values[$key] = $value;
	}
	
    /**
     * xmlתΪarray
     * @param string $xml
     * @throws WxPayException
     */
	public static function Init($xml)
	{	
		$obj = new self();
		$obj->FromXml($xml);
		//fix bug 2015-06-29
		if($obj->values['return_code'] != 'SUCCESS'){
			 return $obj->GetValues();
		}
		$obj->CheckSign();
        return $obj->GetValues();
	}
}

/**
 * 
 * ص
 * @author widyhu
 *
 */
class WxPayNotifyReply extends  WxPayDataBase
{
	/**
	 * 
	 * ô FAIL  SUCCESS
	 * @param string
	 */
	public function SetReturn_code($return_code)
	{
		$this->values['return_code'] = $return_code;
	}
	
	/**
	 * 
	 * ȡ FAIL  SUCCESS
	 * @return string $return_code
	 */
	public function GetReturn_code()
	{
		return $this->values['return_code'];
	}

	/**
	 * 
	 * ôϢ
	 * @param string $return_code
	 */
	public function SetReturn_msg($return_msg)
	{
		$this->values['return_msg'] = $return_msg;
	}
	
	/**
	 * 
	 * ȡϢ
	 * @return string
	 */
	public function GetReturn_msg()
	{
		return $this->values['return_msg'];
	}
	
	/**
	 * 
	 * ÷ز
	 * @param string $key
	 * @param string $value
	 */
	public function SetData($key, $value)
	{
		$this->values[$key] = $value;
	}
}

/**
 * 
 * ͳһµ
 * @author widyhu
 *
 */
class WxPayUnifiedOrder extends WxPayDataBase
{	
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ΢֧ն豸ţ̻Զ
	* @param string $value 
	**/
	public function SetDevice_info($value)
	{
		$this->values['device_info'] = $value;
	}
	/**
	* ȡ΢֧ն豸ţ̻Զֵ
	* @return ֵ
	**/
	public function GetDevice_info()
	{
		return $this->values['device_info'];
	}
	/**
	* ж΢֧ն豸ţ̻ԶǷ
	* @return true  false
	**/
	public function IsDevice_infoSet()
	{
		return array_key_exists('device_info', $this->values);
	}


	/**
	* ַ32λƼ㷨
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡַ32λƼ㷨ֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַ32λƼ㷨Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}

	/**
	* Ʒ֧Ҫ
	* @param string $value 
	**/
	public function SetBody($value)
	{
		$this->values['body'] = $value;
	}
	/**
	* ȡƷ֧Ҫֵ
	* @return ֵ
	**/
	public function GetBody()
	{
		return $this->values['body'];
	}
	/**
	* жƷ֧ҪǷ
	* @return true  false
	**/
	public function IsBodySet()
	{
		return array_key_exists('body', $this->values);
	}


	/**
	* Ʒϸб
	* @param string $value 
	**/
	public function SetDetail($value)
	{
		$this->values['detail'] = $value;
	}
	/**
	* ȡƷϸбֵ
	* @return ֵ
	**/
	public function GetDetail()
	{
		return $this->values['detail'];
	}
	/**
	* жƷϸбǷ
	* @return true  false
	**/
	public function IsDetailSet()
	{
		return array_key_exists('detail', $this->values);
	}


	/**
	* øݣڲѯAPI֧֪ͨԭأֶҪ̻ЯԶ
	* @param string $value 
	**/
	public function SetAttach($value)
	{
		$this->values['attach'] = $value;
	}
	/**
	* ȡݣڲѯAPI֧֪ͨԭأֶҪ̻ЯԶݵֵ
	* @return ֵ
	**/
	public function GetAttach()
	{
		return $this->values['attach'];
	}
	/**
	* жϸݣڲѯAPI֧֪ͨԭأֶҪ̻ЯԶǷ
	* @return true  false
	**/
	public function IsAttachSet()
	{
		return array_key_exists('attach', $this->values);
	}


	/**
	* ̻ϵͳڲĶ,32ַڡɰĸ, ˵̻
	* @param string $value 
	**/
	public function SetOut_trade_no($value)
	{
		$this->values['out_trade_no'] = $value;
	}
	/**
	* ȡ̻ϵͳڲĶ,32ַڡɰĸ, ˵̻ŵֵ
	* @return ֵ
	**/
	public function GetOut_trade_no()
	{
		return $this->values['out_trade_no'];
	}
	/**
	* ж̻ϵͳڲĶ,32ַڡɰĸ, ˵̻Ƿ
	* @return true  false
	**/
	public function IsOut_trade_noSet()
	{
		return array_key_exists('out_trade_no', $this->values);
	}


	/**
	* ÷ISO 4217׼λĸ룬ĬңCNYֵб
	* @param string $value 
	**/
	public function SetFee_type($value)
	{
		$this->values['fee_type'] = $value;
	}
	/**
	* ȡISO 4217׼λĸ룬ĬңCNYֵб͵ֵ
	* @return ֵ
	**/
	public function GetFee_type()
	{
		return $this->values['fee_type'];
	}
	/**
	* жϷISO 4217׼λĸ룬ĬңCNYֵбǷ
	* @return true  false
	**/
	public function IsFee_typeSet()
	{
		return array_key_exists('fee_type', $this->values);
	}


	/**
	* öܽֻΪ֧
	* @param string $value 
	**/
	public function SetTotal_fee($value)
	{
		$this->values['total_fee'] = $value;
	}
	/**
	* ȡܽֻΪֵ֧
	* @return ֵ
	**/
	public function GetTotal_fee()
	{
		return $this->values['total_fee'];
	}
	/**
	* ж϶ܽֻΪ֧Ƿ
	* @return true  false
	**/
	public function IsTotal_feeSet()
	{
		return array_key_exists('total_fee', $this->values);
	}


	/**
	* APPҳ֧ύûipNative֧΢֧APIĻIP
	* @param string $value 
	**/
	public function SetSpbill_create_ip($value)
	{
		$this->values['spbill_create_ip'] = $value;
	}
	/**
	* ȡAPPҳ֧ύûipNative֧΢֧APIĻIPֵ
	* @return ֵ
	**/
	public function GetSpbill_create_ip()
	{
		return $this->values['spbill_create_ip'];
	}
	/**
	* жAPPҳ֧ύûipNative֧΢֧APIĻIPǷ
	* @return true  false
	**/
	public function IsSpbill_create_ipSet()
	{
		return array_key_exists('spbill_create_ip', $this->values);
	}


	/**
	* öʱ䣬ʽΪyyyyMMddHHmmss2009122591010ʾΪ20091225091010ʱ
	* @param string $value 
	**/
	public function SetTime_start($value)
	{
		$this->values['time_start'] = $value;
	}
	/**
	* ȡʱ䣬ʽΪyyyyMMddHHmmss2009122591010ʾΪ20091225091010ʱֵ
	* @return ֵ
	**/
	public function GetTime_start()
	{
		return $this->values['time_start'];
	}
	/**
	* ж϶ʱ䣬ʽΪyyyyMMddHHmmss2009122591010ʾΪ20091225091010ʱǷ
	* @return true  false
	**/
	public function IsTime_startSet()
	{
		return array_key_exists('time_start', $this->values);
	}


	/**
	* öʧЧʱ䣬ʽΪyyyyMMddHHmmss2009122791010ʾΪ20091227091010ʱ
	* @param string $value 
	**/
	public function SetTime_expire($value)
	{
		$this->values['time_expire'] = $value;
	}
	/**
	* ȡʧЧʱ䣬ʽΪyyyyMMddHHmmss2009122791010ʾΪ20091227091010ʱֵ
	* @return ֵ
	**/
	public function GetTime_expire()
	{
		return $this->values['time_expire'];
	}
	/**
	* ж϶ʧЧʱ䣬ʽΪyyyyMMddHHmmss2009122791010ʾΪ20091227091010ʱǷ
	* @return true  false
	**/
	public function IsTime_expireSet()
	{
		return array_key_exists('time_expire', $this->values);
	}


	/**
	* ƷǣȯŻݹܵĲ˵ȯŻ
	* @param string $value 
	**/
	public function SetGoods_tag($value)
	{
		$this->values['goods_tag'] = $value;
	}
	/**
	* ȡƷǣȯŻݹܵĲ˵ȯŻݵֵ
	* @return ֵ
	**/
	public function GetGoods_tag()
	{
		return $this->values['goods_tag'];
	}
	/**
	* жƷǣȯŻݹܵĲ˵ȯŻǷ
	* @return true  false
	**/
	public function IsGoods_tagSet()
	{
		return array_key_exists('goods_tag', $this->values);
	}


	/**
	* ý΢֧첽֪ͨصַ
	* @param string $value 
	**/
	public function SetNotify_url($value)
	{
		$this->values['notify_url'] = $value;
	}
	/**
	* ȡ΢֧첽֪ͨصֵַ
	* @return ֵ
	**/
	public function GetNotify_url()
	{
		return $this->values['notify_url'];
	}
	/**
	* жϽ΢֧첽֪ͨصַǷ
	* @return true  false
	**/
	public function IsNotify_urlSet()
	{
		return array_key_exists('notify_url', $this->values);
	}


	/**
	* ȡֵ£JSAPINATIVEAPPϸ˵涨
	* @param string $value 
	**/
	public function SetTrade_type($value)
	{
		$this->values['trade_type'] = $value;
	}
	/**
	* ȡȡֵ£JSAPINATIVEAPPϸ˵涨ֵ
	* @return ֵ
	**/
	public function GetTrade_type()
	{
		return $this->values['trade_type'];
	}
	/**
	* жȡֵ£JSAPINATIVEAPPϸ˵涨Ƿ
	* @return true  false
	**/
	public function IsTrade_typeSet()
	{
		return array_key_exists('trade_type', $this->values);
	}


	/**
	* trade_type=NATIVE˲شidΪάаƷID̻ж塣
	* @param string $value 
	**/
	public function SetProduct_id($value)
	{
		$this->values['product_id'] = $value;
	}
	/**
	* ȡtrade_type=NATIVE˲شidΪάаƷID̻ж塣ֵ
	* @return ֵ
	**/
	public function GetProduct_id()
	{
		return $this->values['product_id'];
	}
	/**
	* жtrade_type=NATIVE˲شidΪάаƷID̻ж塣Ƿ
	* @return true  false
	**/
	public function IsProduct_idSet()
	{
		return array_key_exists('product_id', $this->values);
	}


	/**
	* trade_type=JSAPI˲شû̻appidµΨһʶµǰҪáҳȨȡûϢӿڻȡûOpenid 
	* @param string $value 
	**/
	public function SetOpenid($value)
	{
		$this->values['openid'] = $value;
	}
	/**
	* ȡtrade_type=JSAPI˲شû̻appidµΨһʶµǰҪáҳȨȡûϢӿڻȡûOpenid ֵ
	* @return ֵ
	**/
	public function GetOpenid()
	{
		return $this->values['openid'];
	}
	/**
	* жtrade_type=JSAPI˲شû̻appidµΨһʶµǰҪáҳȨȡûϢӿڻȡûOpenid Ƿ
	* @return true  false
	**/
	public function IsOpenidSet()
	{
		return array_key_exists('openid', $this->values);
	}
}

/**
 * 
 * ѯ
 * @author widyhu
 *
 */
class WxPayOrderQuery extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ΢ŵĶţʹ
	* @param string $value 
	**/
	public function SetTransaction_id($value)
	{
		$this->values['transaction_id'] = $value;
	}
	/**
	* ȡ΢ŵĶţʹõֵ
	* @return ֵ
	**/
	public function GetTransaction_id()
	{
		return $this->values['transaction_id'];
	}
	/**
	* ж΢ŵĶţʹǷ
	* @return true  false
	**/
	public function IsTransaction_idSet()
	{
		return array_key_exists('transaction_id', $this->values);
	}


	/**
	* ̻ϵͳڲĶţûṩtransaction_idʱҪ
	* @param string $value 
	**/
	public function SetOut_trade_no($value)
	{
		$this->values['out_trade_no'] = $value;
	}
	/**
	* ȡ̻ϵͳڲĶţûṩtransaction_idʱҪֵ
	* @return ֵ
	**/
	public function GetOut_trade_no()
	{
		return $this->values['out_trade_no'];
	}
	/**
	* ж̻ϵͳڲĶţûṩtransaction_idʱҪǷ
	* @return true  false
	**/
	public function IsOut_trade_noSet()
	{
		return array_key_exists('out_trade_no', $this->values);
	}


	/**
	* ַ32λƼ㷨
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡַ32λƼ㷨ֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַ32λƼ㷨Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}
}

/**
 * 
 * رն
 * @author widyhu
 *
 */
class WxPayCloseOrder extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ̻ϵͳڲĶ
	* @param string $value 
	**/
	public function SetOut_trade_no($value)
	{
		$this->values['out_trade_no'] = $value;
	}
	/**
	* ȡ̻ϵͳڲĶŵֵ
	* @return ֵ
	**/
	public function GetOut_trade_no()
	{
		return $this->values['out_trade_no'];
	}
	/**
	* ж̻ϵͳڲĶǷ
	* @return true  false
	**/
	public function IsOut_trade_noSet()
	{
		return array_key_exists('out_trade_no', $this->values);
	}


	/**
	* ̻ϵͳڲĶ,32ַڡɰĸ, ˵̻
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡ̻ϵͳڲĶ,32ַڡɰĸ, ˵̻ŵֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* ж̻ϵͳڲĶ,32ַڡɰĸ, ˵̻Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}
}

/**
 * 
 * ύ˿
 * @author widyhu
 *
 */
class WxPayRefund extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ΢֧ն豸ţµһ
	* @param string $value 
	**/
	public function SetDevice_info($value)
	{
		$this->values['device_info'] = $value;
	}
	/**
	* ȡ΢֧ն豸ţµһµֵ
	* @return ֵ
	**/
	public function GetDevice_info()
	{
		return $this->values['device_info'];
	}
	/**
	* ж΢֧ն豸ţµһǷ
	* @return true  false
	**/
	public function IsDevice_infoSet()
	{
		return array_key_exists('device_info', $this->values);
	}


	/**
	* ַ32λƼ㷨
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡַ32λƼ㷨ֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַ32λƼ㷨Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}

	/**
	* ΢Ŷ
	* @param string $value 
	**/
	public function SetTransaction_id($value)
	{
		$this->values['transaction_id'] = $value;
	}
	/**
	* ȡ΢Ŷŵֵ
	* @return ֵ
	**/
	public function GetTransaction_id()
	{
		return $this->values['transaction_id'];
	}
	/**
	* ж΢ŶǷ
	* @return true  false
	**/
	public function IsTransaction_idSet()
	{
		return array_key_exists('transaction_id', $this->values);
	}


	/**
	* ̻ϵͳڲĶ,transaction_idout_trade_noѡһͬʱȼtransaction_id> out_trade_no
	* @param string $value 
	**/
	public function SetOut_trade_no($value)
	{
		$this->values['out_trade_no'] = $value;
	}
	/**
	* ȡ̻ϵͳڲĶ,transaction_idout_trade_noѡһͬʱȼtransaction_id> out_trade_noֵ
	* @return ֵ
	**/
	public function GetOut_trade_no()
	{
		return $this->values['out_trade_no'];
	}
	/**
	* ж̻ϵͳڲĶ,transaction_idout_trade_noѡһͬʱȼtransaction_id> out_trade_noǷ
	* @return true  false
	**/
	public function IsOut_trade_noSet()
	{
		return array_key_exists('out_trade_no', $this->values);
	}


	/**
	* ̻ϵͳڲ˿ţ̻ϵͳڲΨһͬһ˿Ŷֻһ
	* @param string $value 
	**/
	public function SetOut_refund_no($value)
	{
		$this->values['out_refund_no'] = $value;
	}
	/**
	* ȡ̻ϵͳڲ˿ţ̻ϵͳڲΨһͬһ˿Ŷֻһʵֵ
	* @return ֵ
	**/
	public function GetOut_refund_no()
	{
		return $this->values['out_refund_no'];
	}
	/**
	* ж̻ϵͳڲ˿ţ̻ϵͳڲΨһͬһ˿ŶֻһǷ
	* @return true  false
	**/
	public function IsOut_refund_noSet()
	{
		return array_key_exists('out_refund_no', $this->values);
	}


	/**
	* öܽλΪֻ֣Ϊ֧
	* @param string $value 
	**/
	public function SetTotal_fee($value)
	{
		$this->values['total_fee'] = $value;
	}
	/**
	* ȡܽλΪֻ֣Ϊֵ֧
	* @return ֵ
	**/
	public function GetTotal_fee()
	{
		return $this->values['total_fee'];
	}
	/**
	* ж϶ܽλΪֻ֣Ϊ֧Ƿ
	* @return true  false
	**/
	public function IsTotal_feeSet()
	{
		return array_key_exists('total_fee', $this->values);
	}


	/**
	* ˿ܽܽλΪֻ֣Ϊ֧
	* @param string $value 
	**/
	public function SetRefund_fee($value)
	{
		$this->values['refund_fee'] = $value;
	}
	/**
	* ȡ˿ܽܽλΪֻ֣Ϊֵ֧
	* @return ֵ
	**/
	public function GetRefund_fee()
	{
		return $this->values['refund_fee'];
	}
	/**
	* ж˿ܽܽλΪֻ֣Ϊ֧Ƿ
	* @return true  false
	**/
	public function IsRefund_feeSet()
	{
		return array_key_exists('refund_fee', $this->values);
	}


	/**
	* ûͣISO 4217׼λĸ룬ĬңCNYֵб
	* @param string $value 
	**/
	public function SetRefund_fee_type($value)
	{
		$this->values['refund_fee_type'] = $value;
	}
	/**
	* ȡͣISO 4217׼λĸ룬ĬңCNYֵб͵ֵ
	* @return ֵ
	**/
	public function GetRefund_fee_type()
	{
		return $this->values['refund_fee_type'];
	}
	/**
	* жϻͣISO 4217׼λĸ룬ĬңCNYֵбǷ
	* @return true  false
	**/
	public function IsRefund_fee_typeSet()
	{
		return array_key_exists('refund_fee_type', $this->values);
	}


	/**
	* òԱʺ, ĬΪ̻
	* @param string $value 
	**/
	public function SetOp_user_id($value)
	{
		$this->values['op_user_id'] = $value;
	}
	/**
	* ȡԱʺ, ĬΪ̻ŵֵ
	* @return ֵ
	**/
	public function GetOp_user_id()
	{
		return $this->values['op_user_id'];
	}
	/**
	* жϲԱʺ, ĬΪ̻Ƿ
	* @return true  false
	**/
	public function IsOp_user_idSet()
	{
		return array_key_exists('op_user_id', $this->values);
	}
}

/**
 * 
 * ˿ѯ
 * @author widyhu
 *
 */
class WxPayRefundQuery extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ΢֧ն豸
	* @param string $value 
	**/
	public function SetDevice_info($value)
	{
		$this->values['device_info'] = $value;
	}
	/**
	* ȡ΢֧ն豸ŵֵ
	* @return ֵ
	**/
	public function GetDevice_info()
	{
		return $this->values['device_info'];
	}
	/**
	* ж΢֧ն豸Ƿ
	* @return true  false
	**/
	public function IsDevice_infoSet()
	{
		return array_key_exists('device_info', $this->values);
	}


	/**
	* ַ32λƼ㷨
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡַ32λƼ㷨ֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַ32λƼ㷨Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}

	/**
	* ΢Ŷ
	* @param string $value 
	**/
	public function SetTransaction_id($value)
	{
		$this->values['transaction_id'] = $value;
	}
	/**
	* ȡ΢Ŷŵֵ
	* @return ֵ
	**/
	public function GetTransaction_id()
	{
		return $this->values['transaction_id'];
	}
	/**
	* ж΢ŶǷ
	* @return true  false
	**/
	public function IsTransaction_idSet()
	{
		return array_key_exists('transaction_id', $this->values);
	}


	/**
	* ̻ϵͳڲĶ
	* @param string $value 
	**/
	public function SetOut_trade_no($value)
	{
		$this->values['out_trade_no'] = $value;
	}
	/**
	* ȡ̻ϵͳڲĶŵֵ
	* @return ֵ
	**/
	public function GetOut_trade_no()
	{
		return $this->values['out_trade_no'];
	}
	/**
	* ж̻ϵͳڲĶǷ
	* @return true  false
	**/
	public function IsOut_trade_noSet()
	{
		return array_key_exists('out_trade_no', $this->values);
	}


	/**
	* ̻˿
	* @param string $value 
	**/
	public function SetOut_refund_no($value)
	{
		$this->values['out_refund_no'] = $value;
	}
	/**
	* ȡ̻˿ŵֵ
	* @return ֵ
	**/
	public function GetOut_refund_no()
	{
		return $this->values['out_refund_no'];
	}
	/**
	* ж̻˿Ƿ
	* @return true  false
	**/
	public function IsOut_refund_noSet()
	{
		return array_key_exists('out_refund_no', $this->values);
	}


	/**
	* ΢˿refund_idout_refund_noout_trade_notransaction_idĸһͬʱȼΪrefund_id>out_refund_no>transaction_id>out_trade_no
	* @param string $value 
	**/
	public function SetRefund_id($value)
	{
		$this->values['refund_id'] = $value;
	}
	/**
	* ȡ΢˿refund_idout_refund_noout_trade_notransaction_idĸһͬʱȼΪrefund_id>out_refund_no>transaction_id>out_trade_noֵ
	* @return ֵ
	**/
	public function GetRefund_id()
	{
		return $this->values['refund_id'];
	}
	/**
	* ж΢˿refund_idout_refund_noout_trade_notransaction_idĸһͬʱȼΪrefund_id>out_refund_no>transaction_id>out_trade_noǷ
	* @return true  false
	**/
	public function IsRefund_idSet()
	{
		return array_key_exists('refund_id', $this->values);
	}
}

/**
 * 
 * ض˵
 * @author widyhu
 *
 */
class WxPayDownloadBill extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ΢֧ն豸ţдֶΣֻظ豸ŵĶ˵
	* @param string $value 
	**/
	public function SetDevice_info($value)
	{
		$this->values['device_info'] = $value;
	}
	/**
	* ȡ΢֧ն豸ţдֶΣֻظ豸ŵĶ˵ֵ
	* @return ֵ
	**/
	public function GetDevice_info()
	{
		return $this->values['device_info'];
	}
	/**
	* ж΢֧ն豸ţдֶΣֻظ豸ŵĶ˵Ƿ
	* @return true  false
	**/
	public function IsDevice_infoSet()
	{
		return array_key_exists('device_info', $this->values);
	}


	/**
	* ַ32λƼ㷨
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡַ32λƼ㷨ֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַ32λƼ㷨Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}

	/**
	* ض˵ڣʽ20140603
	* @param string $value 
	**/
	public function SetBill_date($value)
	{
		$this->values['bill_date'] = $value;
	}
	/**
	* ȡض˵ڣʽ20140603ֵ
	* @return ֵ
	**/
	public function GetBill_date()
	{
		return $this->values['bill_date'];
	}
	/**
	* жض˵ڣʽ20140603Ƿ
	* @return true  false
	**/
	public function IsBill_dateSet()
	{
		return array_key_exists('bill_date', $this->values);
	}


	/**
	* ALLصжϢĬֵSUCCESSصճɹ֧ĶREFUNDص˿REVOKEDѳĶ
	* @param string $value 
	**/
	public function SetBill_type($value)
	{
		$this->values['bill_type'] = $value;
	}
	/**
	* ȡALLصжϢĬֵSUCCESSصճɹ֧ĶREFUNDص˿REVOKEDѳĶֵ
	* @return ֵ
	**/
	public function GetBill_type()
	{
		return $this->values['bill_type'];
	}
	/**
	* жALLصжϢĬֵSUCCESSصճɹ֧ĶREFUNDص˿REVOKEDѳĶǷ
	* @return true  false
	**/
	public function IsBill_typeSet()
	{
		return array_key_exists('bill_type', $this->values);
	}
}

/**
 * 
 * ϱ
 * @author widyhu
 *
 */
class WxPayReport extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ΢֧ն豸ţ̻Զ
	* @param string $value 
	**/
	public function SetDevice_info($value)
	{
		$this->values['device_info'] = $value;
	}
	/**
	* ȡ΢֧ն豸ţ̻Զֵ
	* @return ֵ
	**/
	public function GetDevice_info()
	{
		return $this->values['device_info'];
	}
	/**
	* ж΢֧ն豸ţ̻ԶǷ
	* @return true  false
	**/
	public function IsDevice_infoSet()
	{
		return array_key_exists('device_info', $this->values);
	}


	/**
	* ַ32λƼ㷨
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡַ32λƼ㷨ֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַ32λƼ㷨Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}


	/**
	* ϱӦĽӿڵURLƣhttps://api.mch.weixin.qq.com/pay/unifiedorderڱɨ֧Ϊõĺ̻ͬһҵΪʱֽģʽ붼ŵһαɨΪһεϱϱURLָΪhttps://api.mch.weixin.qq.com/pay/micropay/totalֽģʽɲοĵ½ڣɨ֧̻ģʽӿڵȻյһΣϱһС
	* @param string $value 
	**/
	public function SetInterface_url($value)
	{
		$this->values['interface_url'] = $value;
	}
	/**
	* ȡϱӦĽӿڵURLƣhttps://api.mch.weixin.qq.com/pay/unifiedorderڱɨ֧Ϊõĺ̻ͬһҵΪʱֽģʽ붼ŵһαɨΪһεϱϱURLָΪhttps://api.mch.weixin.qq.com/pay/micropay/totalֽģʽɲοĵ½ڣɨ֧̻ģʽӿڵȻյһΣϱһСֵ
	* @return ֵ
	**/
	public function GetInterface_url()
	{
		return $this->values['interface_url'];
	}
	/**
	* жϱӦĽӿڵURLƣhttps://api.mch.weixin.qq.com/pay/unifiedorderڱɨ֧Ϊõĺ̻ͬһҵΪʱֽģʽ붼ŵһαɨΪһεϱϱURLָΪhttps://api.mch.weixin.qq.com/pay/micropay/totalֽģʽɲοĵ½ڣɨ֧̻ģʽӿڵȻյһΣϱһСǷ
	* @return true  false
	**/
	public function IsInterface_urlSet()
	{
		return array_key_exists('interface_url', $this->values);
	}


	/**
	* ýӿںʱλΪ
	* @param string $value 
	**/
	public function SetExecute_time_($value)
	{
		$this->values['execute_time_'] = $value;
	}
	/**
	* ȡӿںʱλΪֵ
	* @return ֵ
	**/
	public function GetExecute_time_()
	{
		return $this->values['execute_time_'];
	}
	/**
	* жϽӿںʱλΪǷ
	* @return true  false
	**/
	public function IsExecute_time_Set()
	{
		return array_key_exists('execute_time_', $this->values);
	}


	/**
	* SUCCESS/FAILֶͨűʶǽױʶǷɹҪ鿴trade_stateж
	* @param string $value 
	**/
	public function SetReturn_code($value)
	{
		$this->values['return_code'] = $value;
	}
	/**
	* ȡSUCCESS/FAILֶͨűʶǽױʶǷɹҪ鿴trade_stateжϵֵ
	* @return ֵ
	**/
	public function GetReturn_code()
	{
		return $this->values['return_code'];
	}
	/**
	* жSUCCESS/FAILֶͨűʶǽױʶǷɹҪ鿴trade_stateжǷ
	* @return true  false
	**/
	public function IsReturn_codeSet()
	{
		return array_key_exists('return_code', $this->values);
	}


	/**
	* ÷ϢǿգΪԭǩʧܲʽУ
	* @param string $value 
	**/
	public function SetReturn_msg($value)
	{
		$this->values['return_msg'] = $value;
	}
	/**
	* ȡϢǿգΪԭǩʧܲʽУֵ
	* @return ֵ
	**/
	public function GetReturn_msg()
	{
		return $this->values['return_msg'];
	}
	/**
	* жϷϢǿգΪԭǩʧܲʽУǷ
	* @return true  false
	**/
	public function IsReturn_msgSet()
	{
		return array_key_exists('return_msg', $this->values);
	}


	/**
	* SUCCESS/FAIL
	* @param string $value 
	**/
	public function SetResult_code($value)
	{
		$this->values['result_code'] = $value;
	}
	/**
	* ȡSUCCESS/FAILֵ
	* @return ֵ
	**/
	public function GetResult_code()
	{
		return $this->values['result_code'];
	}
	/**
	* жSUCCESS/FAILǷ
	* @return true  false
	**/
	public function IsResult_codeSet()
	{
		return array_key_exists('result_code', $this->values);
	}


	/**
	* ORDERNOTEXISTSYSTEMERRORϵͳ
	* @param string $value 
	**/
	public function SetErr_code($value)
	{
		$this->values['err_code'] = $value;
	}
	/**
	* ȡORDERNOTEXISTSYSTEMERRORϵͳֵ
	* @return ֵ
	**/
	public function GetErr_code()
	{
		return $this->values['err_code'];
	}
	/**
	* жORDERNOTEXISTSYSTEMERRORϵͳǷ
	* @return true  false
	**/
	public function IsErr_codeSet()
	{
		return array_key_exists('err_code', $this->values);
	}


	/**
	* ýϢ
	* @param string $value 
	**/
	public function SetErr_code_des($value)
	{
		$this->values['err_code_des'] = $value;
	}
	/**
	* ȡϢֵ
	* @return ֵ
	**/
	public function GetErr_code_des()
	{
		return $this->values['err_code_des'];
	}
	/**
	* жϽϢǷ
	* @return true  false
	**/
	public function IsErr_code_desSet()
	{
		return array_key_exists('err_code_des', $this->values);
	}


	/**
	* ̻ϵͳڲĶ,̻ϱʱṩ̻ŷ΢֧õ߷ 
	* @param string $value 
	**/
	public function SetOut_trade_no($value)
	{
		$this->values['out_trade_no'] = $value;
	}
	/**
	* ȡ̻ϵͳڲĶ,̻ϱʱṩ̻ŷ΢֧õ߷ ֵ
	* @return ֵ
	**/
	public function GetOut_trade_no()
	{
		return $this->values['out_trade_no'];
	}
	/**
	* ж̻ϵͳڲĶ,̻ϱʱṩ̻ŷ΢֧õ߷ Ƿ
	* @return true  false
	**/
	public function IsOut_trade_noSet()
	{
		return array_key_exists('out_trade_no', $this->values);
	}


	/**
	* ÷ӿڵʱĻIP 
	* @param string $value 
	**/
	public function SetUser_ip($value)
	{
		$this->values['user_ip'] = $value;
	}
	/**
	* ȡӿڵʱĻIP ֵ
	* @return ֵ
	**/
	public function GetUser_ip()
	{
		return $this->values['user_ip'];
	}
	/**
	* жϷӿڵʱĻIP Ƿ
	* @return true  false
	**/
	public function IsUser_ipSet()
	{
		return array_key_exists('user_ip', $this->values);
	}


	/**
	* ϵͳʱ䣬ʽΪyyyyMMddHHmmss2009122791010ʾΪ20091227091010ʱ
	* @param string $value 
	**/
	public function SetTime($value)
	{
		$this->values['time'] = $value;
	}
	/**
	* ȡϵͳʱ䣬ʽΪyyyyMMddHHmmss2009122791010ʾΪ20091227091010ʱֵ
	* @return ֵ
	**/
	public function GetTime()
	{
		return $this->values['time'];
	}
	/**
	* жϵͳʱ䣬ʽΪyyyyMMddHHmmss2009122791010ʾΪ20091227091010ʱǷ
	* @return true  false
	**/
	public function IsTimeSet()
	{
		return array_key_exists('time', $this->values);
	}
}

/**
 * 
 * ת
 * @author widyhu
 *
 */
class WxPayShortUrl extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ҪתURLǩԭURL encode
	* @param string $value 
	**/
	public function SetLong_url($value)
	{
		$this->values['long_url'] = $value;
	}
	/**
	* ȡҪתURLǩԭURL encodeֵ
	* @return ֵ
	**/
	public function GetLong_url()
	{
		return $this->values['long_url'];
	}
	/**
	* жҪתURLǩԭURL encodeǷ
	* @return true  false
	**/
	public function IsLong_urlSet()
	{
		return array_key_exists('long_url', $this->values);
	}


	/**
	* ַ32λƼ㷨
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡַ32λƼ㷨ֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַ32λƼ㷨Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}
}

/**
 * 
 * ύɨ
 * @author widyhu
 *
 */
class WxPayMicroPay extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ն豸(̻Զ壬ŵ)
	* @param string $value 
	**/
	public function SetDevice_info($value)
	{
		$this->values['device_info'] = $value;
	}
	/**
	* ȡն豸(̻Զ壬ŵ)ֵ
	* @return ֵ
	**/
	public function GetDevice_info()
	{
		return $this->values['device_info'];
	}
	/**
	* жն豸(̻Զ壬ŵ)Ƿ
	* @return true  false
	**/
	public function IsDevice_infoSet()
	{
		return array_key_exists('device_info', $this->values);
	}


	/**
	* ַ32λƼ㷨
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡַ32λƼ㷨ֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַ32λƼ㷨Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}

	/**
	* Ʒ֧Ҫ
	* @param string $value 
	**/
	public function SetBody($value)
	{
		$this->values['body'] = $value;
	}
	/**
	* ȡƷ֧Ҫֵ
	* @return ֵ
	**/
	public function GetBody()
	{
		return $this->values['body'];
	}
	/**
	* жƷ֧ҪǷ
	* @return true  false
	**/
	public function IsBodySet()
	{
		return array_key_exists('body', $this->values);
	}


	/**
	* Ʒϸб
	* @param string $value 
	**/
	public function SetDetail($value)
	{
		$this->values['detail'] = $value;
	}
	/**
	* ȡƷϸбֵ
	* @return ֵ
	**/
	public function GetDetail()
	{
		return $this->values['detail'];
	}
	/**
	* жƷϸбǷ
	* @return true  false
	**/
	public function IsDetailSet()
	{
		return array_key_exists('detail', $this->values);
	}


	/**
	* øݣڲѯAPI֧֪ͨԭأֶҪ̻ЯԶ
	* @param string $value 
	**/
	public function SetAttach($value)
	{
		$this->values['attach'] = $value;
	}
	/**
	* ȡݣڲѯAPI֧֪ͨԭأֶҪ̻ЯԶݵֵ
	* @return ֵ
	**/
	public function GetAttach()
	{
		return $this->values['attach'];
	}
	/**
	* жϸݣڲѯAPI֧֪ͨԭأֶҪ̻ЯԶǷ
	* @return true  false
	**/
	public function IsAttachSet()
	{
		return array_key_exists('attach', $this->values);
	}


	/**
	* ̻ϵͳڲĶ,32ַڡɰĸ, ˵̻
	* @param string $value 
	**/
	public function SetOut_trade_no($value)
	{
		$this->values['out_trade_no'] = $value;
	}
	/**
	* ȡ̻ϵͳڲĶ,32ַڡɰĸ, ˵̻ŵֵ
	* @return ֵ
	**/
	public function GetOut_trade_no()
	{
		return $this->values['out_trade_no'];
	}
	/**
	* ж̻ϵͳڲĶ,32ַڡɰĸ, ˵̻Ƿ
	* @return true  false
	**/
	public function IsOut_trade_noSet()
	{
		return array_key_exists('out_trade_no', $this->values);
	}


	/**
	* öܽλΪֻ֣Ϊ֧
	* @param string $value 
	**/
	public function SetTotal_fee($value)
	{
		$this->values['total_fee'] = $value;
	}
	/**
	* ȡܽλΪֻ֣Ϊֵ֧
	* @return ֵ
	**/
	public function GetTotal_fee()
	{
		return $this->values['total_fee'];
	}
	/**
	* ж϶ܽλΪֻ֣Ϊ֧Ƿ
	* @return true  false
	**/
	public function IsTotal_feeSet()
	{
		return array_key_exists('total_fee', $this->values);
	}


	/**
	* ÷ISO 4217׼λĸ룬ĬңCNYֵб
	* @param string $value 
	**/
	public function SetFee_type($value)
	{
		$this->values['fee_type'] = $value;
	}
	/**
	* ȡISO 4217׼λĸ룬ĬңCNYֵб͵ֵ
	* @return ֵ
	**/
	public function GetFee_type()
	{
		return $this->values['fee_type'];
	}
	/**
	* жϷISO 4217׼λĸ룬ĬңCNYֵбǷ
	* @return true  false
	**/
	public function IsFee_typeSet()
	{
		return array_key_exists('fee_type', $this->values);
	}


	/**
	* õ΢֧APIĻIP 
	* @param string $value 
	**/
	public function SetSpbill_create_ip($value)
	{
		$this->values['spbill_create_ip'] = $value;
	}
	/**
	* ȡ΢֧APIĻIP ֵ
	* @return ֵ
	**/
	public function GetSpbill_create_ip()
	{
		return $this->values['spbill_create_ip'];
	}
	/**
	* жϵ΢֧APIĻIP Ƿ
	* @return true  false
	**/
	public function IsSpbill_create_ipSet()
	{
		return array_key_exists('spbill_create_ip', $this->values);
	}


	/**
	* öʱ䣬ʽΪyyyyMMddHHmmss2009122591010ʾΪ20091225091010ʱ
	* @param string $value 
	**/
	public function SetTime_start($value)
	{
		$this->values['time_start'] = $value;
	}
	/**
	* ȡʱ䣬ʽΪyyyyMMddHHmmss2009122591010ʾΪ20091225091010ʱֵ
	* @return ֵ
	**/
	public function GetTime_start()
	{
		return $this->values['time_start'];
	}
	/**
	* ж϶ʱ䣬ʽΪyyyyMMddHHmmss2009122591010ʾΪ20091225091010ʱǷ
	* @return true  false
	**/
	public function IsTime_startSet()
	{
		return array_key_exists('time_start', $this->values);
	}


	/**
	* öʧЧʱ䣬ʽΪyyyyMMddHHmmss2009122791010ʾΪ20091227091010ʱ
	* @param string $value 
	**/
	public function SetTime_expire($value)
	{
		$this->values['time_expire'] = $value;
	}
	/**
	* ȡʧЧʱ䣬ʽΪyyyyMMddHHmmss2009122791010ʾΪ20091227091010ʱֵ
	* @return ֵ
	**/
	public function GetTime_expire()
	{
		return $this->values['time_expire'];
	}
	/**
	* ж϶ʧЧʱ䣬ʽΪyyyyMMddHHmmss2009122791010ʾΪ20091227091010ʱǷ
	* @return true  false
	**/
	public function IsTime_expireSet()
	{
		return array_key_exists('time_expire', $this->values);
	}


	/**
	* ƷǣȯŻݹܵĲ˵ȯŻ
	* @param string $value 
	**/
	public function SetGoods_tag($value)
	{
		$this->values['goods_tag'] = $value;
	}
	/**
	* ȡƷǣȯŻݹܵĲ˵ȯŻݵֵ
	* @return ֵ
	**/
	public function GetGoods_tag()
	{
		return $this->values['goods_tag'];
	}
	/**
	* жƷǣȯŻݹܵĲ˵ȯŻǷ
	* @return true  false
	**/
	public function IsGoods_tagSet()
	{
		return array_key_exists('goods_tag', $this->values);
	}


	/**
	* ɨ֧Ȩ룬豸ȡû΢е߶άϢ
	* @param string $value 
	**/
	public function SetAuth_code($value)
	{
		$this->values['auth_code'] = $value;
	}
	/**
	* ȡɨ֧Ȩ룬豸ȡû΢е߶άϢֵ
	* @return ֵ
	**/
	public function GetAuth_code()
	{
		return $this->values['auth_code'];
	}
	/**
	* жɨ֧Ȩ룬豸ȡû΢е߶άϢǷ
	* @return true  false
	**/
	public function IsAuth_codeSet()
	{
		return array_key_exists('auth_code', $this->values);
	}
}

/**
 * 
 * 
 * @author widyhu
 *
 */
class WxPayReverse extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}


	/**
	* ΢ŵĶţʹ
	* @param string $value 
	**/
	public function SetTransaction_id($value)
	{
		$this->values['transaction_id'] = $value;
	}
	/**
	* ȡ΢ŵĶţʹõֵ
	* @return ֵ
	**/
	public function GetTransaction_id()
	{
		return $this->values['transaction_id'];
	}
	/**
	* ж΢ŵĶţʹǷ
	* @return true  false
	**/
	public function IsTransaction_idSet()
	{
		return array_key_exists('transaction_id', $this->values);
	}


	/**
	* ̻ϵͳڲĶ,transaction_idout_trade_noѡһͬʱȼtransaction_id> out_trade_no
	* @param string $value 
	**/
	public function SetOut_trade_no($value)
	{
		$this->values['out_trade_no'] = $value;
	}
	/**
	* ȡ̻ϵͳڲĶ,transaction_idout_trade_noѡһͬʱȼtransaction_id> out_trade_noֵ
	* @return ֵ
	**/
	public function GetOut_trade_no()
	{
		return $this->values['out_trade_no'];
	}
	/**
	* ж̻ϵͳڲĶ,transaction_idout_trade_noѡһͬʱȼtransaction_id> out_trade_noǷ
	* @return true  false
	**/
	public function IsOut_trade_noSet()
	{
		return array_key_exists('out_trade_no', $this->values);
	}


	/**
	* ַ32λƼ㷨
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡַ32λƼ㷨ֵ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַ32λƼ㷨Ƿ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}
}

/**
 * 
 * ύJSAPI
 * @author widyhu
 *
 */
class WxPayJsApiPay extends WxPayDataBase
{
	/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appId'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appId'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appId', $this->values);
	}


	/**
	* ֧ʱ
	* @param string $value 
	**/
	public function SetTimeStamp($value)
	{
		$this->values['timeStamp'] = $value;
	}
	/**
	* ȡ֧ʱֵ
	* @return ֵ
	**/
	public function GetTimeStamp()
	{
		return $this->values['timeStamp'];
	}
	/**
	* ж֧ʱǷ
	* @return true  false
	**/
	public function IsTimeStampSet()
	{
		return array_key_exists('timeStamp', $this->values);
	}
	
	/**
	* ַ
	* @param string $value 
	**/
	public function SetNonceStr($value)
	{
		$this->values['nonceStr'] = $value;
	}
	/**
	* ȡnotifyֵַ
	* @return ֵ
	**/
	public function GetReturn_code()
	{
		return $this->values['nonceStr'];
	}
	/**
	* жַǷ
	* @return true  false
	**/
	public function IsReturn_codeSet()
	{
		return array_key_exists('nonceStr', $this->values);
	}


	/**
	* öչַ
	* @param string $value 
	**/
	public function SetPackage($value)
	{
		$this->values['package'] = $value;
	}
	/**
	* ȡչֵַ
	* @return ֵ
	**/
	public function GetPackage()
	{
		return $this->values['package'];
	}
	/**
	* ж϶չַǷ
	* @return true  false
	**/
	public function IsPackageSet()
	{
		return array_key_exists('package', $this->values);
	}
	
	/**
	* ǩʽ
	* @param string $value 
	**/
	public function SetSignType($value)
	{
		$this->values['signType'] = $value;
	}
	/**
	* ȡǩʽ
	* @return ֵ
	**/
	public function GetSignType()
	{
		return $this->values['signType'];
	}
	/**
	* жǩʽǷ
	* @return true  false
	**/
	public function IsSignTypeSet()
	{
		return array_key_exists('signType', $this->values);
	}
	
	/**
	* ǩʽ
	* @param string $value 
	**/
	public function SetPaySign($value)
	{
		$this->values['paySign'] = $value;
	}
	/**
	* ȡǩʽ
	* @return ֵ
	**/
	public function GetPaySign()
	{
		return $this->values['paySign'];
	}
	/**
	* жǩʽǷ
	* @return true  false
	**/
	public function IsPaySignSet()
	{
		return array_key_exists('paySign', $this->values);
	}
}

/**
 * 
 * ɨ֧ģʽһɶά
 * @author widyhu
 *
 */
class WxPayBizPayUrl extends WxPayDataBase
{
		/**
	* ΢ŷĹ˺ID
	* @param string $value 
	**/
	public function SetAppid($value)
	{
		$this->values['appid'] = $value;
	}
	/**
	* ȡ΢ŷĹ˺IDֵ
	* @return ֵ
	**/
	public function GetAppid()
	{
		return $this->values['appid'];
	}
	/**
	* ж΢ŷĹ˺IDǷ
	* @return true  false
	**/
	public function IsAppidSet()
	{
		return array_key_exists('appid', $this->values);
	}


	/**
	* ΢֧̻
	* @param string $value 
	**/
	public function SetMch_id($value)
	{
		$this->values['mch_id'] = $value;
	}
	/**
	* ȡ΢֧̻ŵֵ
	* @return ֵ
	**/
	public function GetMch_id()
	{
		return $this->values['mch_id'];
	}
	/**
	* ж΢֧̻Ƿ
	* @return true  false
	**/
	public function IsMch_idSet()
	{
		return array_key_exists('mch_id', $this->values);
	}
	
	/**
	* ֧ʱ
	* @param string $value 
	**/
	public function SetTime_stamp($value)
	{
		$this->values['time_stamp'] = $value;
	}
	/**
	* ȡ֧ʱֵ
	* @return ֵ
	**/
	public function GetTime_stamp()
	{
		return $this->values['time_stamp'];
	}
	/**
	* ж֧ʱǷ
	* @return true  false
	**/
	public function IsTime_stampSet()
	{
		return array_key_exists('time_stamp', $this->values);
	}
	
	/**
	* ַ
	* @param string $value 
	**/
	public function SetNonce_str($value)
	{
		$this->values['nonce_str'] = $value;
	}
	/**
	* ȡֵַ
	* @return ֵ
	**/
	public function GetNonce_str()
	{
		return $this->values['nonce_str'];
	}
	/**
	* жַǷ
	* @return true  false
	**/
	public function IsNonce_strSet()
	{
		return array_key_exists('nonce_str', $this->values);
	}
	
	/**
	* ƷID
	* @param string $value 
	**/
	public function SetProduct_id($value)
	{
		$this->values['product_id'] = $value;
	}
	/**
	* ȡƷIDֵ
	* @return ֵ
	**/
	public function GetProduct_id()
	{
		return $this->values['product_id'];
	}
	/**
	* жƷIDǷ
	* @return true  false
	**/
	public function IsProduct_idSet()
	{
		return array_key_exists('product_id', $this->values);
	}
}
