<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * statistic Class
 *
 * ûͳҳ
 *
 * @package         esf_system
 * @subpackage      Libraries
 * @category        Libraries
 * @author          liuhu
 */
class statistic extends MY_Controller {

    /**
    * ûѡĳ
    *
    * @access private
    * @var string
    */
    protected  $_city = 'nj';

    /**
    * ǰûID
    *
    * @access private
    * @var int
    */
    private  $_uid = 0;

    /**
    * ǰҳ
    *
    * @access private
    * @var string
    */
    private $_current_page = 1;

    /**
    * ÿҳĿ
    *
    * @access private
    * @var int
    */
    private $_limit = 10;

    /**
    * ƫ
    *
    * @access private
    * @var int
    */
    private $_offset = 0;

    /**
    * Ŀ
    *
    * @access private
    * @var int
    */
    private $_total_count = 0;


    /**
    * 
    *
    * @access public
    * @return void
    */
    public function __construct()
    {
        parent::__construct();

        $this->load->helper('url');
    }


    /**
    * ʼҳ
    *
    * @access public
    * @param  int  $current_page
    * @param  int  $page_size
    * @return void
    */
    private function _init_pagination($current_page = 1 , $page_size = 0)
    {
        /** ǰҳ */
        $this->_current_page = ( $current_page && is_numeric( $current_page ) ) ? intval( $current_page ) : 1;

        /** ÿҳ */
        $this->_limit = ( $page_size && is_numeric( $page_size ) ) ? intval( $page_size ) : $this->_limit;

        /** ƫ */
        $this->_offset = ( $this->_current_page - 1 ) * $this->_limit;

        if($this->_offset < 0)
        {
            redirect(uri_string());
        }
    }

    //Ĭҳ
    public function index()
    {
        $this->opreate_log();
    }
	

    /**
    * Դ־
    *
    * @access public
    * @param  
    * @return void
    */
    public function operate_log()
    {
       $this->user_id = checklogin();

        if( $this->user_id <= 0)
        {
            jumptotk(USER_CENTER.'login',"¼ٽв",3000,'tipswaring');
            exit;
        }

        //ȡ
        $page = $this->input->post('page',TRUE);
        $count_date = $this->input->post('count_date',TRUE);
        $operate_type = $this->input->post('operate_type',TRUE);
        $operate_type = intval($operate_type);

        if(!$operate_type){
            $operate_type = 1; //Ĭ
        }
        //ʱƣһǰ
        $count_date = $count_date ? $count_date : date('Y-m-d',time());

        /** ҳ */
        $this->_init_pagination($page);

        $this->_city = GB_CITY;
        $this->_uid = $this->session->userdata('esfuserid');

        //вûŲΪգתҳ
        if( empty($this->_city) || $this->_uid <= 0 )
        {
             redirect(site_url());
        }

        //طԴͳ
        $this->load->model('house_statistic_model');

        //ʼкuid
        $this->house_statistic_model->set_city($this->_city);
        $this->house_statistic_model->set_uid($this->_uid);

        //
        $this->_total_count = $this->house_statistic_model->get_operate_count( $operate_type , $count_date);

        //ҳ
        $pages  = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;

        //ȡԴ
        $rowid = 0;
        $statistic_data    = $this->house_statistic_model->get_operate_list( $operate_type , $rowid , $count_date , $this->_offset , $this->_limit );

        //
        $this->load->helper('form');

        //Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $this->load->helper('pagination');
            $pagination   = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }

        /** ҳʼ */
        $data['title'] = 'ͳƷ-־';
        $data['conf_where'] = 'statistic';
        $data['show_type'] = 'operate_log';
        $data['operate_data'] = $statistic_data;
        $data['count_date'] = $count_date;
        $data['operate_type'] = $operate_type;
        $data['page'] = $this->_current_page;
        $data['form_attributes'] = array('name' => 'search_form', 'id' => 'search_form');
        $data['operate_arr'] = $this->house_statistic_model->get_operate_type();
//        $data['operate_arr'] = array_merge(array('0'=>'ȫ'),$data['operate_arr']);
//        $data['operate_arr'][0] = 'ȫ';
        $data['house_type']  = $this->house_statistic_model->get_house_type();
        $data['js'] = "<script type='text/javascript' src='".USER_CENTER."js/My97DatePicker/WdatePicker.js'></script>";
        $data['pagination'] =   $pagination;
		//BIͳ ----- start----->
		 
		$data['isa_website'] = '2,19,1366';
	    $data['isa_city'] = GB_CITY;
	    $data['isa_addones'] = '';
	    $data['isa_url'] = 'isa.house365.com/js/analyze.js?v=2.1';
		//BIͳ ----- ent----->

        //ģ
        $this->load->view('my_statistic',$data);
    }

	
    /**
    * û¼־
    *
    * @access public
    * @param  
    * @return void
    */
    public function login_log()
    {
        $this->user_id = checklogin();

        if( $this->user_id <= 0)
        {
            jumptotk(USER_CENTER.'login',"¼ٽв",3000,'tipswaring');
            exit;
        }
        //ȡ
        $page = $this->input->post('page',TRUE);
        $count_date = $this->input->post('count_date',TRUE);
        //ʱƣһǰ
        $count_date = $count_date ? $count_date : date('Y-m-d',time() - 86400 );

        //ҳ
        $this->_init_pagination($page);

        //ûϢ
        $this->_city = GB_CITY;
        $this->_uid = $this->session->userdata('esfuserid');


        //вûŲΪգתҳ
        if(empty($this->_city) || $this->_uid <= 0 )
        {
             redirect(site_url());
        }

        //طԴͳ
        $this->load->model('user_statistic_model');

        //ʼкuid
        $this->user_statistic_model->set_city($this->_city);
        $this->user_statistic_model->set_uid($this->_uid);

        //
        $this->_total_count = $this->user_statistic_model->get_login_count( $count_date );

        //ҳ
        $pages = $this->_total_count > 0 ? ceil( $this->_total_count / $this->_limit ) : 0;

        //ȡԴ
        $statistic_data = $this->user_statistic_model->get_login_list( $count_date , $this->_offset , $this->_limit );

        //
        $this->load->helper('form');

        //Ƿʾҳ
        $pagination = NULL;
        if( $this->_total_count > $this->_limit)
        {
            $this->load->helper('pagination');
            $pagination   = helper_pagination( $this->_current_page , $pages , $this->_total_count );
        }

        /** ҳʼ */
        $data['title'] = 'ͳƷ-¼ʷ';
        $data['conf_where'] = 'statistic';
        $data['show_type'] = 'login_log';
        $data['operate_data'] = $statistic_data;    //ͳ
        $data['count_date'] = $count_date;
        $data['page'] = $this->_current_page;
        $data['form_attributes'] = array('name' => 'search_form', 'id' => 'search_form');
        $data['js'] = "<script type='text/javascript' src='".USER_CENTER."js/My97DatePicker/WdatePicker.js'></script>";
        $data['pagination'] =   $pagination;
		//BIͳ ----- start----->
		 
		$data['isa_website'] = '2,19,1367';
	    $data['isa_city'] = GB_CITY;
	    $data['isa_addones'] = '';
	    $data['isa_url'] = 'isa.house365.com/js/analyze.js?v=2.1';
		//BIͳ ----- ent----->

        //ģ
        $this->load->view('my_statistic',$data);
    }


    /**
    * ûԴͳ
    *
    * @access public
    * @param  
    * @return void
    */
    public function house_click()
    {

        $this->user_id = checklogin();

        if( $this->user_id <= 0)
        {
            jumptotk(USER_CENTER.'login',"¼ٽв",3000,'tipswaring');
            exit;
        }
        //ȡ
        $house_type = $this->input->post( 'house_type' , TRUE);
        $count_date = $this->input->post('count_date',TRUE);

        //鿴
        $house_type = !empty($house_type)  ? $house_type  : 'all';

        //ʱƣһǰ
        $count_date = $count_date ? $count_date : date('Y-m-d',time() - 86400 );

        //ûϢ
        $this->_city = GB_CITY;
        $this->_uid = $this->session->userdata('esfuserid');

        //вûŲΪգתҳ
        if( empty( $this->_city ) || $this->_uid <= 0 )
        {
             redirect(site_url());
        }

        //طԴͳ
        $this->load->model('house_statistic_model');

        //ʼкuid
        $this->house_statistic_model->set_city($this->_city);
        $this->house_statistic_model->set_uid($this->_uid);

        //ȡԴ
        $click_data = $this->house_statistic_model->get_house_click_by_hour( $count_date , $house_type );

        //ܵ
        $total_click = count( $click_data );

        //
        $click_group = array();
        if( $total_click > 0 )
        {
            foreach ( $click_data as $key =>$value)
            {
                $click_group[$value['tbl']][$value['hour']][] = $value;
            }
        }

        //ѭÿСʱ
        $house_click_hour   = array();
        $sell_total_click   = 0;
        $rent_total_click   = 0;
        for( $i = 0 ; $i < 24 ; $i++ )
        {
            //ۡⷿԴÿСʱĵ
            $sell_click_hour = isset($click_group['sell'][$i]) ? count($click_group['sell'][$i]) : 0;
            $rent_click_hour = isset($click_group['rent'][$i]) ? count($click_group['rent'][$i]) : 0;

            //۵
            $sell_total_click += $sell_click_hour;

            //
            $rent_total_click += $rent_click_hour;

            //Сʱܺ
            if( $house_type == 'all' )
            {
                $house_click_hour[$i]  = $sell_click_hour + $rent_click_hour;
            }
            else if($house_type == 'sell')
            {
                $house_click_hour[$i]  = $sell_click_hour;
            }
            else if($house_type == 'rent')
            {
                $house_click_hour[$i]  = $rent_click_hour;
            }

            //x
            $x_axis[$i] = $i;
        }

        //׼ʾ
        $x_axis_json = json_encode( $x_axis );
        $click_num_json = !empty($house_click_hour) ? json_encode( $house_click_hour ) : NULL;

        //
        $this->load->helper('form');

        $house_type_name = array('all'=>'ȫ','sell'=>'','rent'=>'');

        /** ҳʼ */
        $data['title'] = 'ͳƷ-ͳ';
        $data['conf_where'] = 'statistic';
        $data['show_type'] = 'house_click';
        $data['click_num_json'] = $click_num_json;
        $data['x_axis_json'] = $x_axis_json;
        $data['total_click'] = $total_click;
        $data['sell_total_click'] = $sell_total_click;
        $data['rent_total_click'] = $rent_total_click;
        $data['count_date'] = $count_date;
        $data['house_type'] = $house_type;
        $data['house_type_name'] = $house_type_name[$house_type];
        $js = "<script type='text/javascript' src='".USER_CENTER."js/My97DatePicker/WdatePicker.js'></script>";
        $js .= "<script type='text/javascript' src='".USER_CENTER."js/jquery_Highcharts/js/highcharts.js'></script>";
        $data['js'] = $js;
        //$data['pagination'] =   NULL;
		//BIͳ ----- start----->
		 
		$data['isa_website'] = '2,19,1368';
	    $data['isa_city'] = GB_CITY;
	    $data['isa_addones'] = '';
	    $data['isa_url'] = 'isa.house365.com/js/analyze.js?v=2.1';
		//BIͳ ----- ent----->

        //ģ
        $this->load->view('my_statistic',$data);
    }


    /**
    * ύ½ӿ
    *
    * @access public
    * @param  
    * @return void
    */
    function api_sub_login_log()
    {
		$this->load->model('user_statistic_model');
		$login_from = $this->input->get('login_from');
		$device = $this->input->get('device');
		$uid = $this->input->get('uid');
		$code = $this->input->get('code');
		$city = $this->input->get('city');
		if( $code != md5('my365house'.$uid) )
		{
			exit;
		}

 		$this->user_statistic_model->set_city($city);
		$this->user_statistic_model->set_uid($uid);
		$result = $this->user_statistic_model->sub_login_log($login_from,$device);
        echo 1;
    }


    /**
    * ύˢ´ӿ
    *
    * @access public
    * @param  
    * @return void
    */
    function api_add_refresh_num()
    {
        $this->load->model('house_model');
        $uid = $this->input->get("uid");
        $id = $this->input->get("id");
        $tbl = $this->input->get("tbl");
        $num = $this->input->get("num");
        $city_name = $this->input->get("city");
        $code = $this->input->get("code");

		if($code != md5('my365house'.$uid))
		{
			exit;
		}

        $this->house_model->addrefrshnum($uid,$id,$tbl,$num,$city_name);
        echo 1;
		exit;
    }

}

/* End of file statistic.php */
/* Location: ./center/controllers/statistic.php */