<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class dev_block_model extends MY_Model
{
    function __construct()
    {
        parent::__construct();

        $this->memkey='block'.GB_CITY;
    }

    /**
    * ȡֵ
    * @param type $streetid
    * @return string
    */
    function getstreetname($streetid)
    {
		$key = $this->memkey.'_getstreetname_'.$streetid;

		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}

		$return = $this->memcached_class->get($key);

        if(isset($_GET['wmc'])){
           var_dump($this->memcached_class); exit;
        }
		if( empty($return) )
		{
        $return =  $this->get_data(array('form_name' => 'street','where'=>array('id'=>$streetid),'select'=>array('streetname')),'esfhousebak');
		$this->memcached_class->add($key, $return,3600);
        }     
        if(!empty($return[0]))
        {
            return $return[0];
        }else{
            return 0;
        }
    }

    /**
     * ȡվ
     * @param type $stid
     * @return string
     */
    function getstname($stid)
    {
		$key = $this->memkey.'getstname'.$stid;

		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}

		$return = $this->memcached_class->get($key);

		if( empty($return) )
		{
        $return =  $this->get_data(array('form_name' => 'traffic','where'=>array('bid'=>$stid),'select'=>array('station')),'esfhousebak');
		$this->memcached_class->add($key, $return,3600);
		}
        if(!empty($return[0]['station']))
        {
        return $return[0]['station'];
        }else{
        return 0;
        }

    }

     /**
     * ȡСϸϢ
     * @param array $blockname
     * @return array
     */
    function getblockdetailbyname($blockname,$select)
    {
		$key = $this->memkey.'getblockdetailbyname'.$blockname.serialize($select);

		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}

		$block = $this->memcached_class->get($key);

		if( empty($block) )
		{
        $block =  $this->get_data(array('form_name' => 'block','where'=>array('blockname'=>trim($blockname)),'where'=>array('esta'=>2),'select'=>$select),'esfhousebak');
		$this->memcached_class->add($key, $block,3600);
        }
        if(!empty($block[0]))
        {
            return $block[0];
        }
        else
        {
            return 0;
        }
    }
	
	 /**
     * ȡϸϢ
     * @param array $blockname
     * @return array
     */
    function getstreetdetailbyname($streetname,$select)
    {
		$key = $this->memkey.'getstreetdetailbyname'.$streetname.serialize($select);

		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}

		$street = $this->memcached_class->get($key);

		if( empty($street) )
		{
        $street=  $this->get_data(array('form_name' => 'street','where'=>array('streetname'=>trim($streetname)),'select'=>$select),'esfhousebak');
		$this->memcached_class->add($key, $block,3600);
        }
        if(!empty($street[0]))
        {
            return $street[0];
        }
        else
        {
            return 0;
        }
    }
    
    
    /**
     * ȡվ
     * @param type $stid
     * @return string
     */
    function getline()
    {
        $key = $this->memkey.'getline';
        if($this->input->get('update') == 1)
        {
            $this->memcached_class->delete($key);
        }

        $arr_list_line = $this->memcached_class->get($key);

        if(empty($arr_list_line) )
        {
        $sql = "select bid,sid,station,line,tofor from traffic where type=1  ORDER BY line ASC , sid ASC ";
        $query = $this->db_esfhousebak->query($sql);
        $arr = $query->result_array();

        $num = count($arr);
        if(!empty($arr)){
            for ($i=0;$i<$num;$i++){
                $bid   = $arr[$i]['bid'];
                $sid   = $arr[$i]['sid'];
                $line  = $arr[$i]['line'];

                $station_info [$line]['bid']= $arr[$i]['bid'];
                $station_info [$line]['line']= $arr[$i]['line'];
                $station = $arr[$i]['station'];
                if($arr[$i]['tofor'] == 1){
                    $station_info[$line]['bus_up'][$sid]   = $station;
                }elseif($arr[$i]['tofor'] == 2){
                    $station_info[$line]['bus_down'][$sid] = $station;
                }elseif($arr[$i]['tofor'] == 3){
                    $station_info[$line]['single'][$sid] = $station;
                }
            }

        }
        $arr_list_line = array();
        $j = 1;
        if($station_info){
        foreach($station_info as $key => $value){
            if(isset($value['bus_up']) && $value['bus_up']){

               $st_station = csubstr2(array_shift($value['bus_up']),8);
               $end_station = csubstr2(array_pop($value['bus_up']),8);
               $arr_list_line[$key.'1'] = '('.$st_station.'-'.$end_station.')';
               $arr_list_line[$j] = $key;
               $arr_list_line[$key.'1k'] = $j;
               $arr_list_line[$j.'tf'] = 1;
               $j++;
            }
            
            if(isset($value['bus_down']) && $value['bus_down']){
               $st_station = csubstr2(array_shift($value['bus_down']),8);
               $end_station = csubstr2(array_pop($value['bus_down']),8);
               $arr_list_line[$key.'2'] = '('.$st_station.'-'.$end_station.')';
               $arr_list_line[$j] = $key;
               $arr_list_line[$key.'2k'] = $j;
               $arr_list_line[$j.'tf'] = 2;
               $j++;
            }
            
            if(isset($value['single']) && $value['single']){
               $st_station = csubstr2(array_shift($value['single']),8);
               $end_station = csubstr2(array_pop($value['single']),8);
               $arr_list_line[$key.'3'] = '('.$st_station.'-'.$end_station.')';
               $arr_list_line[$j] = $key;
               $arr_list_line[$key.'3k'] = $j;
               $arr_list_line[$j.'tf'] = 3;
               $j++;
            }
        }}
         $this->memcached_class->add($key, $arr_list_line,3600);
        }
        return $arr_list_line;
    }

    /**
     * ȡСͳϢ
     * @param int $id  Сid
     * @param date $updateDate 
     * @return array
     */
    public function getBlockHouseNumById($id, $updateDate = '') {
        //Ĭȡǰһ
        if ($updateDate == '') {$updateDate = date('Y-m-d');}

        $key = $this->memkey.'block_count_'.$updateDate.'_'.$id;
        if($this->input->get('update') == 1)
        {
            $this->memcached_class->delete($key);
        }
         
        $arrBlockCountDetail = $this->memcached_class->get($key);
        if(!isFullArray($arrBlockCountDetail))
        {
            $arrBlockCountDetail =  $this->get_data(array('form_name' => 'block_count','where'=>array('blockid'=>$id,'updatedate'=>$updateDate)),'esfhousebak');
            $this->memcached_class->add($key, $arrBlockCountDetail,600);
        }
        return $arrBlockCountDetail;
    }

	 public function getBlockPriceById($id) {
        //Ĭȡǰһ
        //if ($updateDate == '') {$updateDate = date('Y-m-d');}

        $key = $this->memkey.'block_count_'.'_'.$id;
        if($this->input->get('update') == 1)
        {
            $this->memcached_class->delete($key);
        }
         
        $arrBlockCountDetail = $this->memcached_class->get($key);
        if(!isFullArray($arrBlockCountDetail))
        {
            $arrBlockCountDetail =  $this->get_data(array('form_name' => 'block_price','where'=>array('blockid'=>$id)),'esfhousebak');
			//print_r($arrBlockCountDetail);die;
            $this->memcached_class->add($key, $arrBlockCountDetail,600);
        }
        return $arrBlockCountDetail;
    }


     /**
     * ȡСϸϢ
     * @param type $blockid
     * @return array
     */
    function getblockdetail($blockid,$select)
    {
        $block =  $this->get_data(array('form_name' => 'block','where'=>array('id'=>$blockid),'select'=>$select),'esfhousebak');
        if(!empty($block[0]))
        {
            return $block[0];
        }else{
            return 0;
        }
    }
    
    
     /**
     * ȡСϸϢ
     * @param array $blockids
     * @return array
     */
    function getarrayblockdetail($blockids,$select)
    {
        $block =  $this->get_data(array('form_name' => 'block','where_in'=>array('id',$blockids),'where'=>array('esta'=>2),'select'=>$select),'esfhousebak');
        return $block;
    }


     /**
     * ȡСС
     * @param arary $blockid ѯС
     * @param array $hidden_bid_arr ӦųС
     * @param int $num ѯ
     * @return array
     */
    function getsearchBlockNearly( $blockid , $hidden_bid_arr , $num = 4 )
    {
        //ѯС
        $serach_ids =  '';

        $blockid = intval($blockid);

        if( $blockid <= 0)
        {
            return $serach_ids;
        }

        //ȡСϢ
        $Info = $this->getblockdetail( $blockid , array('id','b_map_x','b_map_y'));

        if( $Info['id'] > 0 )
        {
            $b_map_x = $Info['b_map_x'];
            $b_map_y = $Info['b_map_y'];
            $map_x_min = $b_map_x > 0 ? $b_map_x - 0.01 : 0 ;
            $map_x_max = $b_map_x > 0 ? $b_map_x + 0.01 : 0 ;
            $map_y_min = $b_map_y > 0 ? $b_map_y - 0.01 : 0 ;
            $map_y_max = $b_map_y > 0 ? $b_map_y + 0.01 : 0 ;

            //ҪСnum+count(ųС)С
            $search_num = $num + count($hidden_bid_arr);
            $blockNearly = $this->getBlockInfoByMap( $map_x_min , $map_x_max , $map_y_min , $map_y_max , $search_num );

            if(is_array($blockNearly)&& !empty($blockNearly) )
            {
                $i = 0;
                foreach($blockNearly as $key => $vlaue)
                {
                    if( $i >= $num)
                    {
                        break;
                    }

                    //ҪصС
                    if( !in_array( $vlaue['id'] , $hidden_bid_arr) )
                    {
                        //ѯСID
                        $serach_ids .= $serach_ids != '' ? ','.$vlaue['id'] : $vlaue['id'];
                        $i++;
                    }
                }
            }
        }
        return $serach_ids;
    }


    /**
    *ݵͼȡС
    *@param     float  $map_x_min Ҫľ
    *@param     float  $map_x_max ľ
    *@param     float  $map_y_min Сγ
    *@param     float  $map_y_max γ
    *@param     int	 $count ȡСĸ
    *@return    array  Ϣ
    *@author    xue
    *@since     2013-12-2
    **/
    public function getBlockInfoByMap( $map_x_min , $map_x_max , $map_y_min , $map_y_max , $count=8)
    {
        $cond_where = " WHERE b_map_x >= '".$map_x_min."' AND b_map_x <= '".$map_x_max."'  AND b_map_y >= '".$map_y_min."' AND b_map_y <= '".$map_y_max."'  AND esta = 2";

        $cond_limit = " LIMIT 0, ".intval($count);
        $cond_order = ' ORDER BY id DESC ';

        $sql	= " SELECT id,blockname FROM block ";
        $sql	.= $cond_where . $cond_order . $cond_limit;
        $query = $this->db_esfhousebak->query($sql);
        $blockInfo = $query->result_array();

        return $blockInfo;
    }



	
	/**
    *ҳСͼ
    *@param     int	 $school ѧУid
	*@param     array	 $blockArr С
    *@return    array  Ϣ
    *@author    xue   
    **/
	public function getBlockPrice($school,$blockArr)
	{
		$key = $this->memkey.'get_school_block_price_'.$school;
		if($this->input->get('update') == 1)
		{
		  $this->memcached_class->delete($key);
		}
		$price = $this->memcached_class->get($key);
		if(empty($price) )
		{
			if(is_array($blockArr)&&!empty($blockArr))
			{			
				$blockPrice = $this->getarrayblockdetail($blockArr,array('averprice'));//block_modelҪĳthis
				$maxPrice = $this->getPrice($blockPrice,'max');
				$minPrice = $this->getPrice($blockPrice,'min');
				$price = array('min'=>$minPrice,'max'=>$maxPrice);
			}
			$this->memcached_class->add($key, $price,3600);

		}
		return $price;
	}


	
	
  
   /**
    *ҵ߼
    *@param     string	 $type ߻
	*@param     array	 $blockPrice С
    *@return    array  Ϣ
    *@author    xue   
    **/
	private function getPrice($blockPrice,$type) 
	{
		$re = 0;
		if($blockPrice) 
		{
			foreach($blockPrice as $k=>$b) 
			{
				if($type == 'max') 
				{
					$x = $b['averprice'] > $re;	
				}
				if($type == 'min') 
				{
					$x = $b['averprice'] < $re;
				}
				if($k == 0) 
				{
					$re = $b['averprice'];
				}
				if( $x && intval($b['averprice']) ) 
				{
					$re = $b['averprice'];
				}
			}
			return $re;
		} 
		else 
		{
			return false;
		}
	}
	
}