"use strict";
!(function($) {
    var pluginName = "ajaxImageUpload",
        defaults   = {
            fileInput: '', // ϴťinput[type=file]nameֵ
            postUrl: '', // POSTϴַ
            width: 150, // ͼƬ
            height: 150, // ͼƬ߶
            imageUrl: [], // ϴͼƬ
            postData: {}, // 
            allowZoom: true, // Ƿ
            allowType: ["gif", "jpeg", "jpg", "bmp", "png"],
            maxNum: 5, // ϴ
            maxSize: 1, // ϴͼƬߴ磬λM
            appendMethod: 'before',  // ׷ӷʽ
            before: $.noop, // ϴǰص
            success: $.noop, // ϴɹʱĻص
            error: $.noop, // ϴʧʱĻص
            complete: $.noop // ϴʱĻص
        };

    function Plugin(element, options) {
        this.element   = element;
        this.settings  = $.extend({}, defaults, options);
        this._defaults = defaults;
        this._name     = pluginName;
        this.complete  = true;
        this.code = 0;
        this.msg  = '';
        this.init();
    }

    Plugin.prototype = {
        init: function() {
            var $self = this,
                $this = $(this.element),
                $imageUrl = $self.settings.imageUrl;

            $self.createSectionBox();

            // ѾڵͼƬչʾ
            if ($imageUrl.length > 0) {
                for (var $i = 0; $i < $imageUrl.length; $i++) {
                    $self.createImageSection($imageUrl[$i]);
                }
            }

            $this.find("input[type=file]").on('change', function() {
                $self.selectFile();
            });

        },
        /**
         * ѡļ
         * @returns {boolean}
         */
        selectFile: function() {
            var $self = this,
                $this = $(this.element),
                $maxNum  = $self.settings.maxNum,
                $maxSize = $self.settings.maxSize,
                $postUrl = $self.settings.postUrl,
                $fileInput = $self.settings.fileInput,
                $before    = $self.settings.before,
                $complete  = $self.settings.complete,
                $uploadInput  = $this.find("input[type=file]"),
                $imageSection = $this.find('.ggy-image-section');

            if (!$postUrl) {
                $self.callError("300", "ûpostUrl");
                $self.resetFile();
                return false;
            }

            if (!$fileInput) {
                $self.callError("301", "ûfileInput");
                $self.resetFile();
                return false;
            }

            if ($before && $before() === false) {
                $self.resetFile();
                return false;
            }

            var $files = $uploadInput[0].files;

            if ($files.length + $imageSection.length > $maxNum) {
                $self.callError("302", "ϴͼƬĿܳ" + $maxNum + "");
                $self.resetFile();
                return false;
            }

            for (var $i = 0; $i < $files.length; $i++) {
                var $file = $files[$i];

                if (!$self.isAllowFile($file)) {
                    $self.callError("303", $file.name + " ͼƬͲ֧");
                    $self.resetFile();
                    break;
                }

                if ($self.getFileSize($file) > $maxSize) {
                    $self.callError("304", 'ϴͼƬܳ' + $maxSize + 'MǰϴͼƬĴСΪ' + $fileSize.toFixed(2) + 'M');
                    $self.resetFile();
                    break;
                }

                $self.createImageSection();
                $self.ajaxUpload($file);
            }

            if ($self.complete == true) {
                $complete();
            }
            $self.resetFile();
        },

        /**
         * 
         * @returns {*|jQuery|HTMLElement}
         */
        createSectionBox: function() {
            var $self = this,
                $this = $(this.element),
                $fileInput  = $self.settings.fileInput,
                $sectionBox = $("<div class='ggy-section-box'></div>"),
                $uploadSection = $("<section class='ggy-upload-section'></section>"),
                $modalSection  = $("<section class='ggy-modal-section'></section>"),
                $uploadIcon    = $("<i class='ggy-upload-icon'></i>"),
                $uploadInput   = $("<input type='file' name='" + $fileInput + "_upload' class='ggy-upload-input' accept='image/*' multiple='multiple'>");

            $sectionBox.appendTo($this);
            $uploadSection.appendTo($sectionBox);
            $uploadIcon.appendTo($uploadSection);
            $uploadInput.appendTo($uploadSection);
            $modalSection.appendTo($sectionBox);

            $modalSection.on('click', function(event) {
                event.stopPropagation();
                $modalSection.hide();
            });

        },

        /**
         * ϴͼƬƬ
         * @param $src
         * @returns {*|jQuery|HTMLElement}
         */
        createImageSection: function($src) {
            var $self = this,
                $this = $(this.element),
                $width  = $self.settings.width,
                $height = $self.settings.height,
                $fileInput = $self.settings.fileInput,
                $allowZoom = $self.settings.allowZoom,
                $appendMethod = $self.settings.appendMethod,
                $sectionBox   = $this.find(".ggy-section-box"),
                $uploadSection = $this.find(".ggy-upload-section"),
                $imageSection  = $("<section class='ggy-image-section loading'></section>"),
                $imageShade    = $("<div class='ggy-image-shade'></div>"),
                $hiddenInput   = $("<input type='hidden' name='" + $fileInput + "[]' value='" + $src + "'>"),
                $imageShow     = $("<img class='ggy-image-show shade' src='" + $src + "'/>");

            if ($src) {
                $imageShow = $("<img class='ggy-image-show' src='" + $src + "'/>");
            }

            $imageSection.css({ 'width':$width, 'height':$height });
            $uploadSection.css({ 'width':$width, 'height':$height });

            switch ($appendMethod) {
                case "before":
                    $sectionBox.prepend($imageSection);
                    break;
                case "after":
                    $uploadSection.before($imageSection);
                    break;
            }

            $hiddenInput.appendTo($imageSection);
            $imageShow.appendTo($imageSection);
            $imageShade.appendTo($imageSection);

            $self.createDeleteNode($imageSection);

            if ($src && $allowZoom === true) {
                $self.createZoomNode($imageSection);
            }
        },

        createDeleteNode: function($imageSection) {
            var $this = $(this.element),
                $modalSection = $this.find(".ggy-modal-section"),
                $deleteIcon   = $("<i class='ggy-delete-icon'></i>"),
                $deleteBox    = $("<div class='ggy-modal-box ggy-delete-box'><p class='ggy-delete-tip'>ȷҪɾ</p><p class='ggy-delete-btn'> <span class='ggy-confirm-btn'>ȷ</span><span class='ggy-cancel-btn'>ȡ</span></p></div>");

            $deleteIcon.appendTo($imageSection);

            // ʾɾȷϵ
            $imageSection.find(".ggy-delete-icon").on('click', function(event) {
                event.stopPropagation();
                $modalSection.html($deleteBox);
                $modalSection.show();
            });

            // ȷɾ
            $deleteBox.find(".ggy-confirm-btn").on('click', function(event) {
                event.stopPropagation();
                $modalSection.hide();
                $imageSection.remove();
                $deleteBox.remove();
            });

            // ȡɾ
            $deleteBox.find(".ggy-cancel-btn").on('click', function(event) {
                event.stopPropagation();
                $modalSection.hide();
                return false;
            });
        },

        createZoomNode: function($imageSection) {
            var $this = $(this.element),
                $imageShow    = $imageSection.find(".ggy-image-show"),
                $modalSection = $this.find(".ggy-modal-section"),
                $zoomIcon = $("<i class='ggy-zoom-icon'></i>"),
                $zoomBox  = $("<div class='ggy-modal-box ggy-zoom-box'><img src=''/></div>");

            $zoomBox.find('img').attr('src', $imageShow.attr('src'));
            $zoomIcon.appendTo($imageSection);

            // ʾ
            $imageSection.find(".ggy-zoom-icon").on('click', function(event) {
                event.stopPropagation();
                $modalSection.html($zoomBox);
                $modalSection.show();
            });

        },

        /**
         * ϴļ
         * @param $file
         */
        ajaxUpload: function($file) {
            var $self = this,
                $this = $(this.element),
                $fileInput = $self.settings.fileInput,
                $postData  = $self.settings.postData,
                $postUrl   = $self.settings.postUrl,
                $allowZoom = $self.settings.allowZoom,
                $success   = $self.settings.success,
                $appendMethod = $self.settings.appendMethod;

            switch ($appendMethod) {
                case "before":
                    var $imageSection = $this.find('.ggy-image-section:first');
                    var $imageShow    = $this.find('.ggy-image-show:first');
                    break;
                case "after":
                    var $imageSection = $this.find('.ggy-image-section:last');
                    var $imageShow    = $this.find('.ggy-image-show:last');
                    break;
            }

            var $formData = new FormData();

            $formData.append($fileInput, $file);

            for (var $key in $postData) {
                $formData.append($key, $postData[$key]);
            }

            $.ajax({
                url: $postUrl,
                type: 'post',
                async: false,
                data: $formData,
                processData: false,
                contentType: false,
                dataType: 'json',
                mimeType: "multipart/form-data",
                success: function($json) {
                    console.log($json);
                    if ($json.status != 'success') {
                        $self.callError($json.status, $json.msg);
                        $imageSection.remove();
                        return false;
                    }
                    $imageShow.removeClass("shade").attr('src', $json.pic_url);
                    $imageSection.find('input[type=hidden]').val($json.pic_url);
                    if ($allowZoom === true) {
                        $self.createZoomNode($imageSection);
                    }
                    $self.complete *= true;
                    $success($json);
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    $self.callError(jqXHR.status, 'AjaxUrl Service Error:' + jqXHR.statusText);
                    $imageSection.remove();
                }
            });
        },

        /**
         * Ƿϴļ
         * @param $file
         * @returns {boolean}
         */
        isAllowFile: function($file) {
            var $allowType = this.settings.allowType,
                $fileExt   = this.getFileExt($file);
            if ($.inArray($fileExt, $allowType) != -1) {
                return true;
            }
            return false;
        },

        /**
         * ȡļչ
         * @param $file
         * @returns {string}
         */
        getFileExt: function($file) {
            var $fileName = $file.name,
                $index    = $fileName.lastIndexOf('.');
            if ($index < 1) {
                return '';
            }
            return $fileName.substr($index + 1).toLowerCase();
        },

        /**
         * ȡļС
         * @param $file
         * @returns {number}
         */
        getFileSize: function($file) {
            return ($file.size) / (1024 * 1024);
        },

        /**
         * ϴ
         */
        resetFile: function() {
            $(this.element).find("input[type=file]").val(null);
        },

        /**
         * error
         * @param $code
         * @param $msg
         */
        callError: function($code, $msg) {
            var $self  = this,
                $error = $self.settings.error;

            $self.complete *= false;

            $self.code = $code;
            $self.msg  = $msg;
            $error($self);
        }
    };

    $.fn[pluginName] = function(options) {
        return this.each(function() {
            if (!$.data(this, "plugin_" + pluginName)) {
                $.data(this, "plugin_" + pluginName, new Plugin(this, options));
            }
        });
    };
})(jQuery, window, document);
