<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * User_Statistic_Model Class
 *
 * û־û¼־ûע᷽ʽûΪ¼
 *
 * @package         center
 * @subpackage      model
 * @category        model
 * @author          liuhu
 */
class User_Statistic_Model extends MY_Model {

    /**
    * ûID
    *
    * @access private
    * @var integer
    */
    private  $_uid    = 0;

    /**
    * ûڵĳ
    *
    * @access private
    * @var string
    */
    private $_city  = 'nj';

    /**
    * ûͻIP
    *
    * @access private
    * @var string
    */
    private $_ip    = '';

    /**
    *  û¼־
    *
    * @access private
    * @var string
    */
    private  $_log_login_tbl    = "log_login";

    /**
    *  ¼Դ
    *
    * @access private
    * @var array
    */
    private  $_login_from   = array(
								1 => 'center' ,2 => 'sell' ,3 => 'rent' ,4 => 'block' ,
								5 => 'news', 6 => 'broker',7 => 'ask', 8 => 'haiwai' , 
								9 => 'other', 10 => 'publish', 11 => 'mobile'
							);

    /**
    *  û¼豸
    *
    * @access private
    * @var array
    */
    private  $_device   = array( 1 => 'pc' , 2 => 'andriod' , 3 => 'iphone' );

    /**
    * Constructor
    */
    public function __construct()
    {
        parent::__construct();
        $this->memkey = 'user_statistic'.GB_CITY;
    }


    /**
    * set_uid
    *
    * ʼuid
    *
    * @access	public
    * @param	int     $uid û
    * @return	void
    */
    public function set_uid($uid)
    {
        $this->_uid = $uid;
    }


    /**
    * get_uid
    *
    * ʼuid
    *
    * @access	public
    * @return	int     $uid û
    */
    public function get_uid( )
    {
        return $this->_uid ;
    }

    /**
    * set_city
    *
    * ʼв
    *
    * @access	public
    * @param	string  $city в
    * @return	void
    */
    public function set_city($city)
    {
        $this->_city    = $city;
    }


    /**
    * get_city
    *
    * ó
    *
    * @access	public
    * @return	string  $city 
    */
    public function get_city()
    {
        return $this->_city ;
    }


    /**
    * set_ip
    *
    * ʼIP
    *
    * @access	public
    * @return	string  $ip IP
    */
    public function set_ip($ip)
    {
       $this->_ip    = $ip;
    }


    /**
    * get_device
    *
    * ȡ豸
    *
    * @access	public
    * @param	void
    * @return	array   ¼豸
    */
    public function get_device()
    {
        return $this->_device;
    }


    /**
    * get_login_from
    *
    * ȡ¼Դ
    *
    * @access	public
    * @param	void
    * @return	array   ¼Դ
    */
    public function get_login_from()
    {
        return $this->_login_from;
    }


    /**
    * sub_login_log
    *
    * ύû¼־
    *
    * @access	public
    * @param	int     $login_from ¼Դ
    * @param	int     $device ¼豸 pc
    * @return	array   ¼־¼
    */
    public function sub_login_log( $login_from = 'center', $device = 'pc' )
    {
        $arr_from   = array_flip( $this->_login_from );
        $arr_device = array_flip($this->_device);

        //¼Դ
        $login_from = ( !empty( $arr_from[$login_from] ) && $arr_from[$login_from] > 0 )
                        ? $arr_from[$login_from] : 0 ;

        //豸
        $device = ( !empty( $arr_device[$device] ) && $arr_device[$device] > 0 )
                    ? $arr_device[$device] : 0 ;

        //ipַ
        $ip = empty($this->_ip) ? get_ip() : $this->_ip;

        //ύ־
        $data   = array(
                    'uid'           => $this->_uid,
                    'city'          => $this->_city,
                    'login_from'    => $login_from,
                    'device'        => $device,
                    'datetime'      => date('Y-m-d H:i:s'),
                    'ip'            =>  $ip
                    );

        //
       $this->set_table( $this->_log_login_tbl );
       $insert_id  = $this->add( $data );

       //
       $result = array();
       if( $insert_id > 0 )
       {
            $result['is_ok']    = 1;
            $result['insert_id']    = $insert_id;
            $result['msg']    = '¼־¼ɹ';
       }
       else
       {
            $result['is_ok']    = 0;
            $result['insert_id']    = 0;
            $result['msg']    = '¼־¼ʧ';
       }

       return  $result ;
    }


    /**
    * get_login_count
    *
    * ȡû¼¼
    *
    * @access	public
    * @param	mixed   $datetime ¼
    * @param	int     $login_from ¼Դ
    * @param	int     $device ¼豸
    * @return	array   ¼¼
    */
    public function get_login_count( $datetime , $login_from = '' , $device = '')
    {
        $key = $this->memkey.'get_login_count'.$datetime.$login_from.$device.$this->_city.$this->_uid;

		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}

		$total_num = $this->memcached_class->get($key);

		if(empty($total_num) )
		{
            //base_filter
            $where_cond = "city = '".$this->_city."' AND uid = '".$this->_uid."' ";

            //login_from
            if( !empty( $login_from ) && is_numeric( $login_from ) )
            {
                $where_cond .= " AND login_from = '".$login_from."' ";
            }

            //device
            if( !empty( $device ) && is_numeric( $device ) )
            {
                $where_cond .= " AND device = '".$device."' ";
            }

            //ʱ
            $datetime = !empty( $datetime ) ? $datetime : date( 'Y-m-d' , time() - 86400 );
            //ʼʱ
            $datetime_start  = date('Y-m-d H:i:s', strtotime($datetime) ) ;
            //ʱ
            $datetime_end  = date('Y-m-d H:i:s', strtotime($datetime) + 86400 ) ;

            $where_cond .= " AND datetime BETWEEN '".$datetime_start."' AND  '".$datetime_end."'";

            $this->db_esfbak->where( $where_cond );
            $this->db_esfbak->from($this->_log_login_tbl);

            $total_num  =  $this->db_esfbak->count_all_results();
            $this->memcached_class->add($key, $total_num,3600);
        }
        return intval( $total_num ) ;
    }


    /**
    * get_login_list
    *
    * ȡû¼¼
    *
    * @access	public
    * @param	mixed   $datetime ¼
    * @param	int     $offset ƫ
    * @param	int     $limti ÿȡ
    * @param	int     $login_from ¼Դ
    * @param	int     $device ¼豸
    * @param	string  $order 
    * @return	array   ¼¼
    */
    public function get_login_list( $datetime , $offset = 0 , $limit = 10  , $login_from = '' , $device = '' , $order = 'DESC')
    {
        $key = $this->memkey.'get_login_list'.$datetime.$offset.$limit.$login_from.$device.$order.$this->_city.$this->_uid;
		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}

		$arr_data = $this->memcached_class->get($key);

		if(empty($arr_data) )
		{
            $arr_data = array();

            //base_filter
            $where_cond = "city = '".$this->_city."' AND uid = '".$this->_uid."' ";

            //login_from
            if( !empty( $login_from ) && is_numeric( $login_from ) )
            {
                $where_cond .= " AND login_from = '".$login_from."' ";
            }

            //device
            if( !empty( $device ) && is_numeric( $device ) )
            {
                $where_cond .= " AND device = '".$device."' ";
            }

            //Ӳʱ䣬ֻȡһ½ʱ
            if( $datetime != 'notime')
            {
                //ʱ
                $datetime = !empty( $datetime ) ? $datetime : date( 'Y-m-d' , time() - 86400 );
                //ʼʱ
                $datetime_start  = date('Y-m-d H:i:s', strtotime($datetime) ) ;
                //ʱ
                $datetime_end  = date('Y-m-d H:i:s', strtotime($datetime) + 86400 ) ;

                $where_cond .= " AND datetime BETWEEN '".$datetime_start."' AND  '".$datetime_end."'";
            }

            $this->db_esfbak->where( $where_cond );
            $this->db_esfbak->order_by( 'datetime' , $order );
            $arr_data = $this->db_esfbak->get( $this->_log_login_tbl , $limit , $offset )->result_array();

            $this->memcached_class->add($key, $arr_data,3600);
        }
        return $arr_data ;
    }
}

/* End of file user_statistic_model.php */
/* Location: ./center/model/user_statistic_model.php*/