<?php if (!defined('BASEPATH'))  exit('No direct script access allowed');


class Test_model extends MY_Model
{

	function __construct()
	{
		parent::__construct();
		$this->memkey = 'usercent'.GB_CITY;
        $this->load->library('session');
        $this->load->model("house_model");
        $this->load->model("block_model");
	}


	/**
	*Ȥѧmodelģ
	*@param int $uid 
	*@return array
	*/
	public function getLikeSchoolHouse($uid){

		$key = $this->memkey.'get_lise_school_house_'.$uid;
		if($this->input->get('update') == 1)
		{
		  $this->memcached_class->delete($key);
		}
		
		$house = $this->memcached_class->get($key);
		
		if(empty($house))
		{
			$houseNum = 0;
			//ȡעѧУ
			$block = array();		
			$school = $this->getCollectSchool($uid,$city=GB_CITY);		
			if(is_array($school)&&!empty($school))
			{
				foreach($school as $value)
				{
					$tempBlock = $this->getSchoolBlock($value);
					if(!empty($tempBlock))
					{
						$block = array_merge($tempBlock,$block); 
					}else{
						$block = $tempBlock;
					}
					 
				}
				$block = array_unique($block);
				if(is_array($block)&&!empty($block))
				{
					$blockStr = implode(",",$block);
					$blockStr = rtrim($blockStr,',');
					$sql = "SELECT id,district,streetid,blockshowname,room,hall,"
										. "buildarea,updatetime,floor,subfloor,totalfloor,fitment,"
										. "forward,buildyear,pic1,address,price FROM sell "
										. "WHERE blockid  IN (".$blockStr.") AND esta = 1 "
										. "ORDER BY creattime DESC LIMIT 0,4 luc";								
					$info = $this->server_sell->query($sql);
					$house = $info['Record'];
					$houseNum = count($house);
				}
			
			}    
			
			if($houseNum < 4)
			{   //¼
				if(GB_CITY == 'nj')
				{
					$sellinfoBlock = isset($_COOKIE['sellinfo_blockid']) ? $_COOKIE['sellinfo_blockid'] : '';
				}else{
					$sellinfoBlock = isset($_COOKIE['sellinfo_blockid_'.GB_CITY]) ? $_COOKIE['sellinfo_blockid_'.GB_CITY] : ''; 
				}

				//ȡcookie¼ȡ´ķԴ
				if(!empty($sellinfoBlock))
				{
					$remainNum = 4-$houseNum;               				
					$blockStr = rtrim($sellinfoBlock,',');
					$sql = "SELECT id,district,streetid,blockshowname,room,hall,"
									. "buildarea,updatetime,floor,subfloor,totalfloor,fitment,"
									. "forward,buildyear,pic1,address,price FROM sell "
									. "WHERE blockid  IN (".$blockStr.") AND esta = 1 "
									. "ORDER BY creattime DESC LIMIT 0,$remainNum luc";				
				   
					$info= $this->server_sell->query($sql);
					$tempHouse = $info['Record'];
					if($remainNum==4)
					{
						$house = $tempHouse;
					}else{
						$house = array_merge($tempHouse,$house);
					}
					$houseNum += count($house);

				}
			}
			if($houseNum < 4)
			{
				$remainNum = 4-$houseNum;               				
				$blockStr = "ѧ";
				$sql = "SELECT id,district,streetid,blockshowname,room,hall,"
								. "buildarea,updatetime,floor,subfloor,totalfloor,fitment,"
								. "forward,buildyear,pic1,address,price FROM sell "
								. "WHERE address  like '%".$blockStr."%' AND esta = 1 "
								. "ORDER BY creattime DESC LIMIT 0,$remainNum luc";
				
				$info = $this->server_sell->query($sql);
				$tempHouse = $info['Record'];
				 
				if($remainNum==4)
				{
					$house = $tempHouse;
				}else{
					$house = array_merge($tempHouse,$house);
				}
				$houseNum += count($house);
			
			}

			$this->memcached_class->add($key, $house,1000);
		}
		return $house;
		
	}




	



	
	/**
	*ȡעѧУmodelģ
	*@param int $uid 
	*@param string $city 
	*@param int $limit ȡѧУĸ
	*@return array
	*/
	public function getCollectSchool($uid,$city=GB_CITY,$limit=10)
	{

		$school_array =  $this->get_data(array('form_name' => 'personal_collection','where'=>array('uid'=>$uid,'city_name'=>$city,'collect_id <>'=>0,'kind'=>7),'select'=>array('collect_id'),'order_by'=>'id DESC',),'esfbak');
		if(is_array($school_array) && !empty($school_array))
		{
			 foreach($school_array as $key=>$value)
             {
				 if($key<$limit)//ƻȡĸ
			     {					
					 $school[] = $value['collect_id'];
				 }
                    
             }
        }
		return $school;

	}

	
	/**
	*ȡѧУСmodelģ
	*@param int schoolId	
	*@return array
	*/
	public function getSchoolBlock($schoolId)
	{	
		$key = $this->memkey.'get_school_block_arr_'.$schoolId;
		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}
		$block = $this->memcached_class->get($key);
		if(empty($block) )
		{
			$schoolBlock = $this->get_data(array('form_name' => 'school_block','where'=>array('school_id'=>$schoolId),'select'=>array('block_id')),'esfhousebak');
			if(is_array($schoolBlock) && !empty($schoolBlock))
			{
				 foreach($schoolBlock as $value)
				 {
					 $block[] = $value['block_id'];
				 }
			}
			$this->memcached_class->add($key, $block,3600);
		}
		return $block;
	}  
	



	 /**
	 * ѧУidȡѧ·ԴϢ
	 * @param int $school
	 * @return array
	 */
	public function getSchoolLastestHouse($school)
	{
		$key = $this->memkey.'get_school_house_lastest_'.$school;
		if($this->input->get('update') == 1)
		 {
		  $this->memcached_class->delete($key);
		 }
		$housedetail = $this->memcached_class->get($key);
		if(empty($housedetail) )
		{
		  $block = $this->getSchoolBlock($school);
		  $selldetail = array();
		  if(is_array($block)&&!empty($block))
		  {
			  $blockStr = implode(",",$block);
		      $blockStr = rtrim($blockStr,',');		  
		      $sql = "select id,district,streetid,blockshowname,room,hall,buildarea,updatetime,forward,fitment,subfloor,floor,totalfloor,buildyear from sell where blockid in (".$blockStr.") order by updatetime desc  limit 0,1 luc";
		      $selldetail = $this->server_sell->query($sql);
		  }	
          if(!empty($selldetail))
          {
			  $housedetail = $selldetail['Record'][0];
			  $housedetail['time'] = time_tran($housedetail['UPDATETIME']);
			  $streetname = $this->block_model->getstreetname($housedetail['STREETID']);
			  $housedetail['streetname'] = $streetname['streetname'];
          }else{
            $housedetail=array();
          }
		  $this->memcached_class->add($key, $housedetail,60);
		}

		return $housedetail;
	}



	
	/**
	 * ȡעѧϢ
	 * @param int $kind ע
	 * @param int $uid ûid
	 * @param int $offset
	 * @param int $pagesize
	 * @return array
	 */
	public function getCollectSchoolList($kind,$uid,$offset,$pagesize)
	{	
		global $school_type,$school_pap,$school_rank;
		$collectSchool = $this->getcollect($kind,$uid,$offset,$pagesize);//޸user_model
        if(is_array($collectSchool)&&!empty($collectSchool))
		{
			foreach($collectSchool as $key=>$value){
				//$value['collect_id'];//ѧУid	
				$collectValue = unserialize($value['collect_value']);
				$collectSchool[$key]['feature'] = $this->getSchoolFeature($collectValue['features']);
				$blockArr = $this->getSchoolBlock($value['collect_id']);
				$collectSchool[$key]['blockNum'] = count($blockArr);
                $collectSchool[$key]['sellNum'] = $this->getSchoolHouseNum($value['collect_id'],$blockArr,'sell');
				$collectSchool[$key]['rentNum'] = $this->getSchoolHouseNum($value['collect_id'],$blockArr,'rent');
				$collectSchool[$key]['lastestHouse'] = $this->getSchoolLastestHouse($value['collect_id']);//·Դ
				$collectSchool[$key]['price'] = $this->block_model->getBlockPrice($value['collect_value'],$blockArr);//ĵblock_modelµ
				$collectSchool[$key]['schoolName'] = $collectValue['schoolname'];
				$collectSchool[$key]['address'] = $collectValue['address'];
				$collectSchool[$key]['streetname'] = $collectValue['streetname']['streetname'];
				$collectSchool[$key]['district'] = $collectValue['district'];
				$collectSchool[$key]['schoolType'] = $school_type[$collectValue['school_type']];
				$collectSchool[$key]['schoolPap'] = $school_pap[$collectValue['ispublic']];//
				$collectSchool[$key]['schoolRank'] = $school_rank[$collectValue['rank']];//
				$collectSchool[$key]['coverphoto'] = $collectValue['coverphoto'];

			}
		}

		return $collectSchool;
		
	}


	


   
   /**
	 * ȡԴ
	 * @param int $school ѧУid
	 * @param array $blockArr С
	 * @param string $type ַⷿ 	
	 * @return array
	 */
   public function getSchoolHouseNum($school,$blockArr,$type='sell')
   {
	   $key = $this->memkey.'get_school_house_num_'.$type."_".$school;
	   if($this->input->get('update') == 1)
	   {
		  $this->memcached_class->delete($key);
	   }
	   $houseNum = $this->memcached_class->get($key);
       if(empty($houseNum))
	   {
		   if(is_array($blockArr)&&!empty($blockArr))
	       {
			  $blockStr = implode(",",$blockArr);
			  $blockStr = rtrim($blockStr,',');		  
			  $sql = "select id,district,streetid,blockshowname,room,hall,buildarea,updatetime,forward,fitment,subfloor,floor,totalfloor,buildyear from ".$type." where blockid in (".$blockStr.") order by updatetime desc  limit 0,1 luc";
			  if($type=='sell')
			  {
				  $detail = $this->server_sell->query($sql);
			  }elseif($type=='rent'){
			      $detail = $this->server_rent->query($sql);
			  }
			  
			  $houseNum = $detail['TOTAL'];
			  $this->memcached_class->add($key, $houseNum,3600);
	      }	

	   }
	   return $houseNum;	   

   }



   //ѧУɫ
   public function getSchoolFeature($features)
   {
	   global $school_features;	
	   if(isset($features))
       {	     
		   $match_num = 0;
		   $school_feature = array();
		   //#2#,#9#
		   $match_num = preg_match_all('/[0-9]+/',$features,$school_feature);
		   $node['features'] = $match_num > 0 ? $school_feature[0] : array();		
		   foreach($school_feature[0] as $key=>$value)
		   {	
				$s_shchool_feature[] .= $school_features[$value];
		   }
	    }
		return $s_shchool_feature;
   }
	



}