<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');
/**
 * Created by ¦.
 * Description:
 * Date: 2018\7\31 0031
 */

class lucky_model extends MY_Model {
    public $houses = array(); //ûԴ
    public $origin_rowids   = array(); //ԴķԴid
    public $origin_telnos   = array();  //ԴķԴ绰
    public $no_record_rowids = array();
    public $no_record_telnos = array();
//    public $verified_rowids = array(); //ͨȨ֤ķԴ
//    public $verified_telno  = array(); //ͨȨ֤ķԴӦĵ绰
//    public $white_telno     = array(); //˹ںĲҾȨ֤ĺ
//    public $white_rowids    = array(); //˹벻ںĲҾȨ֤ķԴ
    public $start_time;
    public $end_time;
    public $used_all;   //齱Ѿ
    public $qualifiedtelno;//Ӫӵܹ齱

    public function __construct()
    {
        parent::__construct();
        $this->start_time = strtotime(date('2018-08-09'));
        $this->end_time   = strtotime(date('2018-10-07'));
    }

    public function getLuckyRecords(){
        $sql = "select telno,prize_name from lucky_draw_record where status in (1,2) order by id desc limit 10";
        $data = $this->db_esfhousebak->query($sql)->result_array();
        foreach($data as &$each){
            $each['telno'] = substr($each['telno'],0,3)."****".substr($each['telno'],7,4);
        }
        return $data;
    }

    public function getLuckyRecordByUid($uid){
        $sql = "select telno,prize_name,status from lucky_draw_record where uid =".$uid;
        $data = $this->db_esfhousebak->query($sql)->result_array();
        return $data;
    }

    /**
     * ȡҵн¼
     * @param $uid
     * @return mixed
     */
    public function parseRecord($uid){
        $res = array('status'=>0,'prize_name'=>'');
        $win = 0;  //й
        $not_win = 0;  //ûй
        $prize_name = '';
        $records = $this->getLuckyRecordByUid($uid);
        if(empty($records)){
            return $res;
        }else{
            foreach($records as $record){
                if(in_array($record['status'],array(1,2,3))){
                    $win = 1;
                    $prize_name = $record['prize_name'];
                }
                if($record['status'] == 4){
                    $not_win = 1;
                }
            }
        }
        //н¼
        if($win == 1){
            $res['status'] = 1;
            $res['prize_name'] = $prize_name;
        }
        elseif($not_win == 1){   //û
            $res['status'] = 4;
        }
        return $res;
    }

    /**
     * ֻн
     * @param $uid
     * @return array
     */
    public function checkIfWonBefore($uid){
        $res = array();
        $sql = "select telno,prize_name,status from lucky_draw_record where uid =".$uid." and status in (1,2,3)";
        $data = $this->db_esfhousebak->query($sql)->result_array();
        if(!empty($data)){
             $res['prize_name'] = $data[0]['prize_name'];
        }
        return $res;
    }

    /**
     * ûнļ¼
     * @param $uid
     * @return bool
     */
    public function InsertNoRecord($uid){
        if(!$uid){
            return false;
        }
        $data = $this->prepareData();
        $winning_time = 0;
        $status = 4; //û鵽
        $prize_name = '';

        $sql_insert = "insert into lucky_draw_record (`rowid`,`uid`,`telno`,`winning_time`,`prize_name`,`status`) value ('{$data['rowid']}',$uid,'{$data['telno']}',$winning_time,"."'{$prize_name}'".",$status)";
        $res = $this->db_esfhouse->query($sql_insert);
        if(!$res){
            return false;
        }
        return true;
    }

    /**
     * дݿǰȡ
     * @return array
     */
    protected function prepareData(){
        $data = array();
        $rowids = $this->no_record_rowids;
        $telnos = $this->no_record_telnos;
        $data['rowid'] = $rowids[0];
        $data['telno'] = $telnos[0];
        return $data;
    }
    /**
     * н
     * @return bool
     */
    public function InsertYesRecord($uid,$prize_name){
        if(!$uid || !$prize_name){
            return false;
        }
        $data = $this->prepareData();
        $winning_time = time();
        $status = 2;
        $begin_date = date('Y-m-d');

        //۳Ʒʣ
        $sql_update = "update lucky_draw_prize set left_num = left_num-1 where begin_date = "."'{$begin_date}'"." and name = "."'{$prize_name}'";

        $sql_insert = "insert into lucky_draw_record (`rowid`,`uid`,`telno`,`winning_time`,`prize_name`,`status`) value ('{$data['rowid']}',$uid,'{$data['telno']}',$winning_time,"."'{$prize_name}'".",$status)";

        $this->db_esfhouse->trans_start();
        $this->db_esfhouse->query($sql_update);
        $this->db_esfhouse->query($sql_insert);
        $this->db_esfhouse->trans_complete();
        if ($this->db_esfhouse->trans_status() === FALSE)
        {
            return false;
            // generate an error... or use the log_message() function to log your error
        }
        //н¼

        return true;
    }

    /**
     * Ƿ齱Ѿ
     * @return mixed
     */
    public function getUsedAll(){
        return $this->used_all;
    }
    /**
     * ûг齱ʸ
     * 1. ڼ дģ
     * 2. Ͼ (⣺ȨģһϾ)
     * 3. Դ
     * 4. ͨϵͳ
     * 5. 绰ں
     * 6. ˳ⷿԴн
     * 7. һֻܳ齱һ
     * @param $uid
     * @return bool
     */
    public function checkIfQualified($uid){
        //Ƿڼ
        if(!$this->checkIfWithinActivity()){
            return false;
        }
        //Ƿи˼Դ
        if(!$this->checkValidHouses($uid)){
            return false;
        }

        //Ƿ齱ĺ
        if(!$this->checkQualifiedTelno()){
            return false;
        }

        //ĺǷ
        if(!$this->checkIfUsedAll($uid)){
            $this->used_all = 1;
            return false;
        }
        //Ĳȥ֤ˡӪָЩܹ齱
//        //ǷͨȨ֤
//        if(!$this->checkPublicVerification()){
//            return false;
//        }
//        //Ƿں
//        if(!$this->checkIfBlacklistTel()){
//            return false;
//        }

        return true;
    }

    /**
     * ûԴĵ绰ڲ齱ĺ
     * @return bool
     *
     */
    protected function checkQualifiedTelno(){
        $this->parseHouses();
        $telnos = implode(',',$this->origin_telnos);
        $sql = "select telno from lucky_draw_qualified_list where telno in (".$telnos.")";
        $data = $this->db_esfhousebak->query($sql)->result_array();

        if(empty($data)){
            return false;
        }
        $qualifiedtelno = array();
        foreach($data as $item){
            $qualifiedtelno[] = $item['telno'];
        }
        $this->qualifiedtelno = $qualifiedtelno;
        return true;
    }
    /**
     * ǷѾ,˳ûгĺͷԴ
     * @return bool
     */
    protected function checkIfUsedAll($uid){
        $telnos = implode(',',$this->qualifiedtelno);

        $sql = "select telno from lucky_draw_record where telno in (".$telnos.")"." and uid =".$uid;
        $data = $this->db_esfhousebak->query($sql)->result_array();
        $no_record_telno = $this->qualifiedtelno;

        if(!empty($data)){
            if(count($data) == count($this->qualifiedtelno)){
                return false; //еĺ붼
            }else{
                foreach($data as $item){
                    if(in_array($item['telno'],$this->qualifiedtelno)){
                        $index = array_search($item['telno'],$this->qualifiedtelno);
                        unset($no_record_telno[$index]);
                    }
                }
            }
        }

       $this->no_record_telnos = $no_record_telno;

       if($no_record_telno == $telnos){
            $this->no_record_rowids = $this->origin_rowids;
            return true;
       }else{
           $no_record_rowids = array();
           foreach($this->houses as $house){
               if(in_array($house['telno'],$this->no_record_telnos)){
                   $no_record_rowids[] = $house['id'];
               }
           }
           $this->no_record_rowids = $no_record_rowids;
       }

        return true;
    }

    /**
     * ûµļԴлȡԴidͷԴ绰
     */
    protected function parseHouses(){
        $houses = $this->houses;
        $origin_telnos = array();
        $origin_rowids = array();
        foreach($houses as $house){
            $origin_rowids[] = $house['id'];
            $origin_telnos[] = $house['telno'];
        }
        $this->origin_rowids = $origin_rowids;
        $this->origin_telnos = $origin_telnos;
    }
    protected function getVerfiedTel(){
        $telnos = array();
        foreach($this->houses as $house){
            if(in_array($house['id'],$this->verified_rowids)){
                $telnos[] = $house['telno'];
            }
        }

        return $telnos;
    }

    /**
     * ѾȨ֤ķԴȡںĺ
     * @return bool
     */
    protected function checkIfBlacklistTel(){
        $white_telno = $this->verified_telno;

        $telnos_str = implode(',',$this->verified_telno);
        $sql = "select telno from agencytel where telno in (".$telnos_str.")";
        $data = $this->db_esfhousebak->query($sql)->result_array();

        if(!empty($data)){
            foreach($data as $item){
                if(in_array($item['telno'],$this->verified_telno)){
                    $index = array_search($item['telno'],$this->verified_telno);
                    unset($white_telno[$index]);
                }
            }
        }
        $this->white_telno = $white_telno;
        if(empty($this->white_telno)){
            return false;
        }else{
            //ȡյķԴid
            $white_rowids = array();
            foreach($this->houses as $house){
                if(in_array($house['telno'],$this->white_telno)){
                    $white_rowids[] = $house['id'];
                }
            }
            $this->white_rowids = $white_rowids;
            return true;
        }
    }
    /**
     * ǷмԴ
     * @param $uid
     * @return bool
     */
    public function checkValidHouses($uid){
        $this->houses = $this->getHousesByUid($uid);
        if(empty($this->houses)){
            return false;
        }
        return true;
    }

    /**
     * ǷڻڼͨȨ֤ȡͨȨ֤ķ
     * @return bool
     */
    protected function checkPublicVerification(){
        $rowids = implode(',',$this->no_record_rowids);
        if(empty($rowids)){
            return false;
        }

        $sql = "select house_id from owner_rent where owner_real = 1 and house_id in (".$rowids.") and update_time between ".$this->start_time." and ".$this->end_time;
        $data = $this->db_esfhousebak->query($sql)->result_array();
        if(empty($data)){
            return false;
        }
        $verified_rowids = array();
        foreach($data as $item){
            $verified_rowids[] = $item['house_id'];
        }
        $this->verified_rowids = $verified_rowids;
        $this->verified_telno = $this->getVerfiedTel();
        return true;
    }

    /**
     * ȡ˵ļԴ,ų
     * @param $uid
     * @return mixed
     */
    public function getHousesByUid($uid){
        $sql = "select id,telno from rent where esta = 1 and infofrom = 1 and uid=".$uid;
        $data = $this->db_esfhousebak->query($sql)->result_array();
        return $data;
    }
    /**
     * жǷڻڼ
     * @return bool
     */
    public function checkIfWithinActivity(){
        $start_time = strtotime('2018-08-09');
        $end_time   = strtotime('2018-10-07');
        $now = time();
        if($now >= $start_time && $now <=$end_time){
            return true;
        }else{
            return false;
        }
    }

    /**
     * жǷż齱
     * @return bool
     */
    public function checkIfEven(){
        $total = $this->getCountRecords();
        $num = $total+1;
        if($num%2==0){
            return true;
        }else{
            return false;
        }
    }
    /**
     * ȡܼ¼Ҳ齱
     * @return mixed
     */
    public function getCountRecords(){
        $sql = "select count(*) as total from lucky_draw_record";
        $data = $this->db_esfhousebak->query($sql)->result_array();
        return $data[0]['total'];
    }

    /**
     * ƷǷнƷ
     * @return bool
     */
    public function checkIfLeftPrizePool(){
        $date = date('Y-m-d');
        $sql = "select sum(left_num) as total from lucky_draw_prize where begin_date ="."'{$date}'";
        $data = $this->db_esfhousebak->query($sql)->result_array();
        if(!empty($data)){
            $num = $data[0]['total'];
            if($num>0){
                return true;
            }else{
                return false;
            }
        }
        return false;
    }

    public function getPoolPrize(){
        $default = array(
            '1'=>'Сֻ',
            '2'=>'л',
            '3'=>'뵶',
            '4'=>'ե֭',
            '5'=>'ˮ',
            '6'=>'˱'
        );
        $default1 = array_flip($default);

        $data = $this->getExistsPrize();
        if(empty($data)){
            return false;
        }
        $prize = array();
        $ids   = array();
        //װ
        foreach($data as $each){
            if(in_array($each['name'],$default)){
                $ids[] = $default1[$each['name']];
            }
        }

        //ʳ齱
        $rand_num = $this->get_rand($ids);

        //ؽƷͽƷid
        $prize['prize_id'] = $ids[$rand_num];
        $prize['prize_name'] = $default[$ids[$rand_num]];
        return $prize;
    }

    /**
     * ȡؽʣཱƷ
     * @return mixed
     */
    protected function getExistsPrize(){
        $date = date('Y-m-d');
        $sql = "select name from lucky_draw_prize where begin_date ="."'{$date}'"." and left_num >0";
        $data = $this->db_esfhousebak->query($sql)->result_array();
        return $data;
    }

    /**
     * ʳ
     * @param $proArr
     * @return int|string
     */
    protected function get_rand($proArr) {
        $result = '';
        //ܸʾ
        $proSum = array_sum($proArr);
        //ѭ
        foreach ($proArr as $key => $proCur) {
            $randNum = mt_rand(1, $proSum);
            if ($randNum <= $proCur) {
                $result = $key;
                break;
            } else {
                $proSum -= $proCur;
            }
        }
        unset ($proArr);
        return $result;
    }

}