<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * House_Statistic_Model Class
 *
 * ˷ԴݣԴ־ݵ
 *
 * @package         center
 * @subpackage      model
 * @category        model
 * @author          liuhu
 */
class House_Statistic_Wang_Model extends MY_Model {

    /**
    * ûID
    *
    * @access private
    * @var integer
    */
    private  $_uid = 0;

    /**
    * ûڵĳ
    *
    * @access private
    * @var string
    */
    private $_city = 'nj';

    /**
    * ûͻIP
    *
    * @access private
    * @var string
    */
    private $_ip = '';

    /**
    *  û־
    *
    * @access private
    * @var string
    */
    private  $_log_tbl = "log_house_operate";

    /**
    *  û־
    *
    * @access private
    * @var string
    */
    private  $_log_click_tbl = "log_house_click";

    /**
    *  Դ
    *
    * @access private
    * @var int
    */
    private  $_rowid = 0;


    /**
    *  Ƿл棬0л棬1ûл
    *
    * @access private
    * @var int
    */
    private  $_nocache = 0;

    /**
    *  ͼֵ
    *
    * @access private
    * @var array
    */
    private  $_operate_type = array( 1 => '' , 2 => 'ˢ' , 3 => 'ɾ' , 4 => '޸', 5 => 'ٷ' );

    /**
    *  ͼֵ
    *
    * @access private
    * @var array
    */
    private  $_house_type = array( 'sell' => '' , 'rent' => '' , 'buy' => '' , 'rentwanted' => '');

    /**
    *  ѯֶ
    *
    * @access private
    * @var array
    */
    private  $_select_fields    = array();

    /**
    * Constructor
    */
    public function __construct()
    {
        parent::__construct();
        $this->memkey = 'home_statistic'.GB_CITY;
    }


    /**
    * set_uid
    *
    * ʼuid
    *
    * @access	public
    * @param	int     $uid û
    * @return	void
    */
    public function set_uid( $uid )
    {
        $this->_uid = $uid;
    }


    /**
    * get_uid
    *
    * ʼuid
    *
    * @access	public
    * @return	int     $uid û
    */
    public function get_uid( )
    {
        return $this->_uid ;
    }


    /**
    * set_city
    *
    * ʼв
    *
    * @access	public
    * @param	string  $city в
    * @return	void
    */
    public function set_city($city)
    {
        $this->_city    = $city;
    }


    /**
    * get_city
    *
    * ó
    *
    * @access	public
    * @return	string  $city 
    */
    public function get_city()
    {
        return $this->_city ;
    }


    /**
    * set_ip
    *
    * ʼIP
    *
    * @access	public
    * @param	string  $ip ip
    * @return	void
    */
    public function set_ip($ip)
    {
       $this->_ip    = $ip;
    }

    /**
    * set_nocache
    *
    * ʼIP
    *
    * @access	public
    * @param	string  $ip ip
    * @return	void
    */
    public function set_nocache($nocache)
    {
       $this->_nocache    = $nocache;
    }


    /**
    * get_operate_type
    *
    * ȡ
    *
    * @access	public
    * @param	void
    * @return	array   
    */
    public function get_operate_type()
    {
        return $this->_operate_type;
    }


    /**
    * get_house_type
    *
    * ȡԴ
    *
    * @access	public
    * @param	void
    * @return	array   Դ
    */
    public function get_house_type()
    {
        return $this->_house_type;
    }


    /**
    * òѯֶ
    *
    * @access	public
    * @param	array $fields  ѯֶ
    * @return  void
    */
    public function set_select_fields($fields)
    {
       $this->_select_fields   = $fields;
    }


    /**
    * ÷Դ
    *
    * @access	public
    * @param	int $rowid  Դ
    * @return  void
    */
    public function set_rowid($rowid)
    {
       $this->_rowid = $rowid;
    }


	/**
    * _tbl_exists
    *
    * жݿǷ
    *
    * @access	private
    * @param	int		 $tbl_name   
    * @return	boolean  true/false
    */
	private function _tbl_exists($tbl_name)
	{
		$sql = "SHOW TABLES LIKE '".$tbl_name."'";
		$result = $this->db_esf->query($sql);
		$tbl_info = $result->result_array();

		if( is_array($tbl_info) && !empty($tbl_info) )
		{
			return true;
		}
		else
		{
			return false;
		}
	}


	/**
    * _get_tblname_by_date
    *
    * ɱֶ
    *
    * @access	private
	* @param	string	$date   (eg:20140313)
    * @param	string	$tbl_name  
    * @return	string	$tblname 
    */
	private function _get_tblname_by_date($date , $base_tblname = '')
	{
		$base_tblname = $base_tblname == '' ?
						$this->_log_click_tbl : strip_tags($base_tblname);

		$tblname = $base_tblname . $date;

		return $tblname;
	}


	/**
    * _creat_tbl_by_copy
    *
    * $tblname ± $tblname_new
    *
    * @access	private
	* @param	string	$tblname_new  ±
    * @param	string	$tblname	  Ƶı
    * @return	boolean true/false
    */
	private function _creat_tbl_by_copy ( $tblname_new , $tblname )
	{
		if( trim($tblname_new) == trim($tblname) )
		{
			return false;
		}

		//5.0֮ǰ(CREATE TABLE ± SELECT * FROM ɱ WHERE 1=2)
		// MYSQL5.0ϲ֧
		$sql = " CREATE TABLE $tblname_new LIKE $tblname ";
		$result = $this->db_esf->query($sql);

		if($result)
		{
			return true;
		}
		else
		{
			return false;
		}
	}


    /**
    * sub_operate_log
    *
    * ύûûԴ־
    *
    * @access	public
    * @param	string      $tbl Դ:ַ(sell)/ⷿ(rent)
    * @param	int         $rowid Դı
    * @param	int         $operate_type 
    * @param	string 	    $device 豸( 1pc , 2andriod , 3iphone)
    * @return	array       
    */
    public function sub_operate_log( $tbl , $rowid , $operate_type , $device = 1)
    {
        //ipַ
        $this->_ip = empty($this->_ip) ? get_ip() : $this->_ip;

       //ύ־
       $data   = array(
            'city'      => $this->_city,
            'uid'       => $this->_uid,
            'tbl'       => $tbl,
            'rowid'     => intval( $rowid ),
            'type'      => $operate_type,
            'datetime'  => date('Y-m-d H:i:s'),
            'ip'        => $this->_ip,
            'device'    => $device,
		    'add_time'  => time()
        );

       //
       $this->set_table($this->_log_tbl);
       $insert_id  = $this->add($data);

       //
       $result = array();
       if( $insert_id > 0)
       {
            $result['is_ok']	= 1;
            $result['msg']	= $this->_operate_type[$operate_type].'ɹ';
       }
       else
       {
            $result['is_ok']	= 0;
            $result['msg']	= $this->_operate_type[$operate_type].'ʧ';
       }

       return  $result ;
    }


    /**
    * get_operate_count
    *
    * ȡûķԴ־
    *
    * @access	public
    * @param	int     $type 
    * @param	mixed   $data 
    * @return	$int    $num
    */
    public function get_operate_count( $type = 0 , $datetime = '' )
    {

		$key = $this->memkey.'get_operate_count'.$type.$datetime.$this->_city.$this->_uid;
		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}

		$total_num = $this->memcached_class->get($key);
        if($this->_nocache==1)
        {
          $total_num='';
        }

		if(empty($total_num) )
		{
			$arr_data = array();

			//base_filter
			$where_cond = "city = '".$this->_city."' AND uid = '".$this->_uid."' ";

			//type_filter
			if( !empty( $type ) && is_numeric($type) )
			{
				$where_cond .= " AND type = '".$type."' ";
			}

			//ʱ
			$datetime = !empty( $datetime ) ? $datetime : date( 'Y-m-d' , time() - 86400 );
			//ʼʱ
			$datetime_start  = date('Y-m-d H:i:s', strtotime($datetime) ) ;
			//ʱ
			$datetime_end  = date('Y-m-d H:i:s', strtotime($datetime) + 86400 ) ;
			$where_cond .= " AND datetime BETWEEN '".$datetime_start."' AND  '".$datetime_end."'";
			$this->db_esfbak->where( $where_cond );
			$this->db_esfbak->from($this->_log_tbl);
			$total_num  =  $this->db_esfbak->count_all_results();
			$this->memcached_class->add($key, $total_num,3600);
        }

        return intval( $total_num ) ;
    }


    /**
    * get_operate_list
    *
    * ȡûķԴ־
    *
    * @access	public
    * @param	int     $type 
    * @param	string  $data 
    * @param	int     $offset ƫ
    * @param	int     $limti ÿȡ
    * @param	string  $order 
    * @return	array   ־
    */
    public function get_operate_list ( $type = 0 , $rowid = 0 , $datetime = '' , $offset = 0 , $limit = 10 , $order = 'DESC' )
    {

        $key = $this->memkey.'get_operate_list'.$type.$rowid.$datetime.$offset.$limit.$order.$this->_city.$this->_uid;
		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}
		$this->memcached_class->delete($key);
		$arr_data = $this->memcached_class->get($key);

        if($this->_nocache==1)
        {
          $arr_data=array();
        }

		if(empty($arr_data) )
		{
            $arr_data = array();

            //base_filter
            $where_cond = "city = '".$this->_city."' AND uid = '".$this->_uid."' ";

            //type_filter
            if( !empty( $type ) && is_numeric($type) )
            {
                $where_cond .= " AND type = '".$type."' ";
            }

            //rowid_filter
            if( !empty( $rowid ) && is_numeric($rowid) )
            {
                $where_cond .= " AND rowid = '".$rowid."' ";
            }

            //ʱ
            $datetime = !empty( $datetime ) ? $datetime : date( 'Y-m-d' , time() - 86400 );
            //ʼʱ
            $datetime_start  = date('Y-m-d H:i:s', strtotime($datetime) ) ;
            //ʱ
            $datetime_end  = date('Y-m-d H:i:s', strtotime($datetime) + 86400 ) ;

            $where_cond .= " AND datetime BETWEEN '".$datetime_start."' AND  '".$datetime_end."'";
			//echo $where_cond;die;
            $this->db_esfbak->where( $where_cond );
            $this->db_esfbak->order_by( 'datetime' , $order );
            $arr_data = $this->db_esfbak->get( $this->_log_tbl , $limit , $offset )->result_array();
            $this->memcached_class->add($key, $arr_data,3600);
        }

        return $arr_data ;
    }


	/**
	* sub_house_click
	*
	* ύûԴϢ
	*
	* @access	public
	* @param	string  $tbl Դ:ַ(sell)/ⷿ(rent)
	* @param	int     $rowid Դı
	* @param	string  $district Դڵ
	* @param	int     $blockid С
	* @param	int     $streetid 
	* @param	int     $room Դ
	* @param	float   $price Դ۸
	* @param	int     $buildarea Դ
    * @param	string 	$device 豸( 1pc , 2andriod , 3iphone)
	* @return	array   ύ
	*/
	public function sub_house_click( $tbl , $rowid ,  $district , $blockid , $streetid , $room , $price ,$buildarea , $device)
	{
		//ʱ
		$time = time();
		$click_time  = date('Y-m-d H:i:s',$time);
		$hour    = date( 'G' , $time );
		$day	= date('Ymd', $time );

		//ipַ
		$this->_ip = empty($this->_ip) ? get_ip() : $this->_ip;

		//ύ־
		$data   = array(
				'city'      => $this->_city,
				'uid'       => $this->_uid,
				'tbl'       => $tbl,
				'rowid'     => intval( $rowid ),
				'district'  => strip_tags($district),
				'blockid'   => intval($blockid),
				'streetid'  => intval($streetid),
				'room'      => intval($room),
				'price'     => floatval($price),
				'buildarea' => intval($buildarea),
				'click_time'=> $click_time ,
				'hour'      => $hour ,
				'ip'        => $this->_ip,
                'device'    => $device
		);

		//
		$tbl_name = $this->_get_tblname_by_date( $day , $this->_log_click_tbl);

		//жϱǲǴڣ½mc棩
		$is_exist = $this->_tbl_exists($tbl_name);

		//򴴽
		if( ! $is_exist )
		{
			$creat_result = $this->_creat_tbl_by_copy( $tbl_name , $this->_log_click_tbl);
		}

		if( $is_exist || $creat_result )
		{
			$this->set_table($tbl_name);
			$insert_id  = $this->add($data);
		}

		//
		$result = array();

		if( $insert_id > 0)
		{
			$result['is_ok'] = 1;
			$result['msg'] = '¼ɹ';
		}
		else
		{
			$result['is_ok'] = 0;
			$result['msg'] = '¼ʧ';
		}

		return  $result ;
	}


    /**
    * _get_house_click_num
    *
    * ȡûķԴ
    *
    * @access	public
    * @param	mixed   $data 
    * @param	string  $tbl Դ ĬУsell\rentsellԴrentԴ
    * @return	array   ־
    */
    private function _get_house_click_num( $datetime = '' , $tbl = '',$city='' )
    {
		$this->_city = $city!="" ? $city : $this->_city;
        $key = $this->memkey.'_get_house_click_num_'.$datetime.'_'.$tbl.'_'.$this->_city.'_'.$this->_uid.'_'.$this->_rowid;

        if($this->input->get('update') == 1)
        {
                $this->memcached_class->delete($key);
        }

        $click_num = array();

	$cache_data = $this->memcached_class->get($key);

        if( $cache_data['is_ok'] == 1 )
        {
            $click_num = $cache_data['data'];
        }
        else
        {
            //base_filter
            $where_cond = "city = '".$this->_city."' AND uid = '".$this->_uid."' ";

            //type_filter
            if( in_array( $tbl , array( 'sell' , 'rent' ) ) )
            {
                $where_cond .= " AND tbl = '".$tbl."' ";
            }

            //ѯĳԴĵ
            if( $this->_rowid > 0 )
            {
                $where_cond .= " AND rowid = '".$this->_rowid."' ";
            }

            //ʱ
            $datetime = !empty( $datetime ) ? $datetime : date( 'Y-m-d' , time() - 86400 );
            //ʼʱ
            $datetime_start  = date('Y-m-d H:i:s', strtotime($datetime) ) ;
            //ʱ
            $datetime_end  = date('Y-m-d H:i:s', strtotime($datetime) + 86400 ) ;

            $where_cond .= " AND click_time BETWEEN '".$datetime_start."' AND  '".$datetime_end."'";

            $day = date('Ymd',strtotime( $datetime_start ) );

            $tbl_name = $this->_get_tblname_by_date( $day, $this->_log_click_tbl );

            //жϱǲǴ
            $is_exist = $this->_tbl_exists($tbl_name);
			
            if( $is_exist )
            {

                //ѯ
                $this->db_esfbak->where( $where_cond );

                //ѯ
                $this->db_esfbak->from($tbl_name);

                //ȡ
                $click_num = $this->db_esfbak->count_all_results();
            }
            else
            {
                 $click_num = 0;
            }

            $this->memcached_class->add($key, array('is_ok'=>1,'data'=>$click_num),1800);
        }

        return $click_num ;
    }


    /**
    * get_house_click
    *
    * ȡûķԴ
    *
    * @access	public
    * @param	mixed   $data 
    * @param	string  $tbl Դ ĬУsell\rentsellԴrentԴ
    * @param	int     $offset ƫ
    * @param	int     $limit ÿȡ
    * @param	string  $order 
    * @return	array   ־
    */
    private function _get_house_click_list( $datetime , $tbl = '', $offset = 0  , $limit = 0 , $order = 'DESC' )
    {
        $key = $this->memkey.'_get_house_click_list_'.$datetime.'_'.$tbl.'_'.$offset.'_'.$limit.'_'.$order.'_'.$this->_city.$this->_uid;

		if($this->input->get('update') == 1)
		{
			$this->memcached_class->delete($key);
		}

        $arr_data = array();

		$cache_data = $this->memcached_class->get($key);

		if( $cache_data['is_ok'] == 1 )
		{
            $arr_data = $cache_data['data'];
        }
        else
        {
            //base_filter
            $where_cond = "city = '".$this->_city."' AND uid = '".$this->_uid."' ";

            //type_filter
            if( in_array( $tbl , array( 'sell' , 'rent' ) ))
            {
                $where_cond .= " AND tbl = '".$tbl."' ";
            }

            //ѯĳԴĵ
            if( $this->_rowid > 0 )
            {
                $where_cond .= " AND rowid = '".$this->_rowid."' ";
            }

            //ʱ
            $datetime = !empty( $datetime ) ? $datetime : date( 'Y-m-d' , time() - 86400 );
            //ʼʱ
            $datetime_start  = date('Y-m-d H:i:s', strtotime($datetime) ) ;
            //ʱ
            $datetime_end  = date('Y-m-d H:i:s', strtotime($datetime) + 86400 ) ;

            $where_cond .= " AND click_time BETWEEN '".$datetime_start."' AND  '".$datetime_end."'";

            $day = date('Ymd',strtotime( $datetime_start ) );

            $tbl_name = $this->_get_tblname_by_date( $day, $this->_log_click_tbl );

            //жϱǲǴ
            $is_exist = $this->_tbl_exists($tbl_name);

            if( $is_exist === true )
            {
                //ѯֶ
                if( !empty($this->_select_fields)  &&  is_array( $this->_select_fields ) )
                {
                    $fields_str = implode(',',$this->_select_fields );
                    $this->db_esfbak->select( $fields_str );
                }

                //ѯ
                $this->db_esfbak->where( $where_cond );

                //
                $this->db_esfbak->order_by( 'click_time' , $order );

                //limit offset
                if( $limit > 0 || $offset > 0 )
                {
                    $this->db_esfbak->limit( $limit , $offset );
                }

                //ѯ
                $this->db_esfbak->from($tbl_name);

                //ȡ
                $arr_data = $this->db_esfbak->get()->result_array();
            }
            else
            {
                 $arr_data = array();
            }

            $this->memcached_class->add( $key , array( 'is_ok' => 1,'data' => $arr_data) , 1800 );
        }

        return $arr_data ;
    }


    /**
    * get_house_click_by_hour
    *
    * ȡûķԴ
    *
    * @access	public
    * @param	mixed   $data 
    * @param	string  $tbl Դ ĬУsell\rentsellԴrentԴ
    * @param	int     $offset ƫ
    * @param	int     $limit ÿȡ
    * @param	string  $order 
    * @return	array   ־
    */
    public function get_house_click_by_hour( $date , $tbl = '' , $offset = 0  , $limit = 0 , $order = 'DESC')
    {
        //òѯֶ
        $this->set_select_fields(  array( 'uid' , 'tbl' , 'rowid' , 'hour' ) );

        //ѯԴ
        $date_click = $this->_get_house_click_list( $date, $tbl, $offset, $limit, $order);

        return $date_click;
    }


    /**
    * get_house_clicknum_by_id
    *
    * ȡûĳԴ
    *
    * @access	public
    * @param	int     $rowid Դ
    * @param	string  $tbl Դ ĬУsell\rentsellԴrentԴ
    * @param	mixed   $data 
    * @return	int     $click_num  ־
    */
    public function get_house_clicknum_by_id( $rowid , $tbl = '' , $date = '',$city='' )
    {
        //
        $click_num = 0;

        //Դ
        $rowid = intval($rowid);

        if( $rowid > 0)
        {
            //ҪѯķԴ
            $this->set_rowid($rowid);

            //ѯԴ
            $click_num = $this->_get_house_click_num( $date , $tbl ,$city );
        }

        return intval($click_num);
    }


    /**
    * get_house_click_by_id
    *
    * ȡûĳԴ
    *
    * @access	public
    * @param	int     $rowid Դ
    * @param	string  $tbl Դ ĬУsell\rentsellԴrentԴ
    * @param	mixed   $data 
    * @param	int     $offset ƫ
    * @return	array   ־
    */
    public function get_house_click_by_id( $rowid ,  $tbl = '' , $date = '')
    {
        //
        $date_click = array();

        //Դ
        $rowid = intval($rowid);

        if( $rowid > 0)
        {
            //òѯֶ
            $this->set_select_fields( array( 'uid' , 'tbl' , 'rowid' , 'hour' ) );

            //ҪѯķԴ
            $this->set_rowid($rowid);

            //ѯԴ
            $date_click = $this->_get_house_click_list( $date , $tbl );
        }

        return $date_click;
    }


	 /**
    * get_telno_state
    *
    * ȡû״̬
	* 
	* 1ʾһֻѾ͹
	* 2ʾһ֮Ѿ10ζ
    * 3ʾԷ
    */
    public function get_telno_state( $telno)
    {
		$time =time();
		$time_one =$time-60;
		
		$time_start =strtotime(date('Y-m-d 00:00:00') );
		$time_end =strtotime(date('Y-m-d 23:59:59') );
		$ip =$_SERVER['REMOTE_ADDR'];
		$where_cond = "telno = '".$telno."' AND ip = '".$ip."' AND ctime >='".$time_one."' ";
        //ѯ
		$this->db_esfbak->where( $where_cond );
		//ѯ
		$this->db_esfbak->from('api_sms');
		//ȡ
		$arr_data = $this->db_esfbak->get()->result_array();
		if($arr_data)
		{
			return 1;
		}

		$where_cond1 = "telno = '".$telno."' AND ip = '".$ip."' AND ctime >='".$time_start."' AND ctime <='".$time_end."' ";
        //ѯ
		$this->db_esfbak->where( $where_cond1 );
		//ѯ
		$this->db_esfbak->from('api_sms');
		//ȡ
		$arr_data = $this->db_esfbak->get()->result_array();
		if(count($arr_data)>10)
		{
			return 2;
		}

		return 3;
    }

	/**
    * check_validcode_state
    *
    * ֤֤״̬
	* 
	* 1ʾ֤ͨ
	* 0ʾ֤δͨ
    */
	public function check_validcode_state($telno,$validcode)
	{
		$time =time();
		$time_one =$time-60*3;
		$ip =$_SERVER['REMOTE_ADDR'];
		$status =0;
		$where_cond = "telno = '".$telno."' AND ctime >='".$time_one."' AND status ='".$status."' AND validcode ='".$validcode."' ";
		
        //ѯ
		$this->db_esf->where( $where_cond );
		//ѯ
		$this->db_esf->from('api_sms');
		//ȡ
		$arr_data = $this->db_esf->get()->result_array();
		
		if(empty($arr_data))
		{
			return 0;
		}
		else
		{
			return 1;
		}
		
	}
	
   /**
    * update_validcode_state
    *
    * ֤״̬
	* 
	* 1ͨ
	* 0ʧ
    */

	public function update_validcode_state($telno,$validcode)
	{
		$ip =$_SERVER['REMOTE_ADDR'];
		$arr=array('telno'=>$telno,'ip'=>$ip,'status'=>0,'validcode'=>$validcode);
		$up= array('status'=>1);

		$this->set_table('api_sms');
		$result = $this->save($arr,$up,'esf');

		if($result)
		{
			return 1;
		}
		else
		{
			return 0;
		}
		
		
	
	}
}

/* End of file house_statistic_model.php */
/* Location: ./center/model/house_statistic_model.php */