<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * job_center_cron Class
 *
 * ûĶʱ
 *
 * @package         esf_system
 * @subpackage      Libraries
 * @category        Libraries
 * @author          liuhu
 */
class job_center_cron_zhou extends MY_Controller {

    /**
    * ûѡĳ
    *
    * @access private
    * @var string
    */
    protected  $_city = 'nj';


    /**
    * 
    *
    * @access public
    * @return void
    */
    public function __construct()
    {
        parent::__construct();

        $this->load->helper('url');
        $this->load->library("apply_class");
    }


    //Ĭҳ
    public function index()
    {
       redirect(site_url());
    }
	

    /**
    * ˷Դƥ
    *
    * @access public
    * @param  
    * @return void
    */
    public function personal_house2match_buy( $city = 'nj' )
    {
		
        $this->_city = $city;
		
        //вûŲΪգתҳ
        if( empty($this->_city))
        {
             redirect(site_url());
        }
		

        $tbl_want = 'buy';
        $tbl_match = 'buy_match';
        $tbl_house = 'sell';

        //طԴͳ
        $this->load->model('house_model');
		$this->load->model('house_zhou_model');
        $perpage_num = 300;
        $total_num_yesterday = $this->house_model->get_personal_house_num_yesterday($tbl_house);
        $while_num = ceil($total_num_yesterday/$perpage_num);

        $result = array();
		
        for( $i = 0 ; $i < $while_num ; $i++ )
        {
            $offset = $i * $perpage_num;

            //շ۸˷Դ
            $houseinfo = $this->house_model->get_personal_house_yesterday($tbl_house,$offset,$perpage_num);
            $houseinfo = array_key_to_case($houseinfo);//KEYתΪСд
			
			
            //ѭȡԴϢ
            if( is_array($houseinfo) && !empty( $houseinfo ) )
            {
                foreach ( $houseinfo as $key => $value)
                {
                    //ѯԴǷϵϢ
                    $buy_want  = $this->house_zhou_model->get_buy_want_by_house( $value['infotype'] , 
						$value['streetid'] , $value['buildarea'] , $value['price'] , $value['buildyear'] );
					file_put_contents('buy_want.log', date('Y-m-d h:m:s').var_export($buy_want,true),FILE_APPEND);
					
                    for($j = 0 ; $j < count($buy_want) ; $j++)
                    {
                        //ƥϢ
                        $msg = $this->house_model->add_match_info( $tbl_want , $buy_want[$j]['id'] , 
							$buy_want[$j]['uid'] , $value['id'] , $value['uid'] );

                        if( isset($msg) && $msg['is_ok'] == 1 )
                        {
                            $matched_uid[$buy_want[$j]['id']]['uid'] = $buy_want[$j]['uid'];
                            $matched_uid[$buy_want[$j]['id']]['address'] = $buy_want[$j]['address'];
                        }
                    }
                }

                $result['msg'] = '˷Դƥ乤';
            }

            sleep(1);
        }
		die("vvvvvvvv");
        //վ
        $subject = 'Ϣµƥ䷿Դ';
        foreach($matched_uid as $key => $value)
        {
            $msg = 'Ϣ'.$value['address'].'µķԴƥɹ'
					.'<a href="http://user.house365.com/want/buylist" target="_blank">鿴</a>';
            $this->apply_class->send_systemmsg($value['uid'] , $subject , $msg , 1 , $this->_city);
        }

        if( $total_num_yesterday <= 0)
        {
            $result['msg'] = '˷Դ';
        }

        echo $result['msg'];
        exit;
    }
	

    /**
    * ˷Դƥ
    *
    * @access public
    * @param  
    * @return void
    */
    public function personal_house2match_rent( $city = 'nj' )
    {
        $this->_city = strip_tags($city);

        //вûŲΪգתҳ
        if( empty($this->_city))
        {
             redirect(site_url());
        }

        $tbl_want = 'rentwanted';
        $tbl_match = 'rentwanted_match';
        $tbl_house = 'rent';
		
        //طԴͳ
        $this->load->model('house_model');
		$this->load->model('house_zhou_model');
        $perpage_num = 300;
        $total_num_yesterday = $this->house_model->get_personal_house_num_yesterday($tbl_house);
        $while_num = ceil($total_num_yesterday/$perpage_num);
		
        $result = array();
        $matched_uid = array();
        for( $i = 0 ; $i < $while_num ; $i++ )
        {
            $offset = $i * $perpage_num;

            //շ۸˷Դ
            $houseinfo = $this->house_model->get_personal_house_yesterday($tbl_house,$offset,$perpage_num);
            $houseinfo = array_key_to_case($houseinfo);//KEYתΪСд
			
            //ѭȡԴϢ
            if( is_array($houseinfo) && !empty( $houseinfo ) )
            {
                foreach ( $houseinfo as $key => $value)
                {
                    //ѯ÷ԴЩϢ
					//print_r($value);die;
                    $rent_want  = $this->house_zhou_model->get_rent_want_by_house( $value['infotype'] , 
						$value['streetid'] , $value['buildarea'] , $value['price'] , $value['renttype'] );
					print_r($rent_want);die;
                    for($j = 0 ; $j < count( $rent_want ) ; $j++)
                    {
                        //ƥϢ
                        if( $rent_want[$j]['id'] > 0 && $rent_want[$j]['uid'] > 0)
                        {
                            $msg = $this->house_model->add_match_info( $tbl_want , $rent_want[$j]['id'] , 
								$rent_want[$j]['uid'] , $value['id'] , $value['uid'] );

                            if( $msg['is_ok'] == 1 )
                            {
                                $matched_uid[$rent_want[$j]['id']]['uid'] = $rent_want[$j]['uid'];
                                $matched_uid[$rent_want[$j]['id']]['address'] = $rent_want[$j]['address'];
                            }
                        }
                    }
                }

                $result['msg'] = '˷Դƥ乤';
            }

            sleep(1);
        }
		die("ccccccccc");
        //վ
        $subject = 'Ϣµƥ䷿Դ';
        foreach($matched_uid as $key => $value)
        {
            $msg = 'ⷿϢ'.$value['address'].'µķԴƥɹ'
					.'<a href="http://user.house365.com/want/rentlist" target="_blank">鿴</a>';
            $this->apply_class->send_systemmsg($value['uid'],$subject,$msg,1,$this->_city);
        }

        if( $total_num_yesterday <= 0)
        {
            $result['msg'] = '˷Դ';
        }
        echo $result['msg'];
        exit;
    }


    /**
    * ʧЧڷԴ
    *
    * @access public
    * @param  city в
    * @return void
    */
    public function invalid_expired_info( $city = 'nj' )
    {
		
		//2016-1-13 JOB־ ----- start ------->
		$time_start =time();
		$referer ="http://".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
		$this->job_ext_stat($referer,$time_start,0);

		//2016-1-13 JOB־ ----- end ------->
		
        $this->_city = strip_tags($city);

        //вûŲΪգתҳ
        if( empty($this->_city) )
        {
             redirect(site_url());
        }

        //طԴͳ
        $this->load->model('house_model');
        $result_buy = $this->house_model->invalid_buy_rentwanted_info('buy');

        sleep(2);//ͣ

        $result_rentwanted = $this->house_model->invalid_buy_rentwanted_info('rentwanted');

        echo $result_buy['msg'].'-'.$result_rentwanted['msg'];

		$time_end =time();
		$this->job_ext_stat($referer,$time_end,1);

        exit;
    }


	public function  job_ext_stat($referer,$time,$value)
	{
		
		$referer =urlencode($referer);
		if($value==0)
		{
			$url = 'http://jobsadmin.house365.com/index.php?a=track&m=Api&referer='.$referer.'&start='.$time;
		}
		else
		{
			$url = 'http://jobsadmin.house365.com/index.php?a=track&m=Api&referer='.$referer.'&end='.$time;
		}
		//echo $url."<br/>";
		$curl = curl_init();
		curl_setopt($curl, CURLOPT_URL, $url);
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($curl, CURLOPT_TIMEOUT, 3);
		$output = curl_exec($curl);
		//print_r($output);die;
		curl_close($curl);
		//return $output;
	}
	

    /**
    * ˷Դ400״̬
    *
    * @access public
    * @param  city в
    * @return void
    */
	public function telno400_state_manage($city = 'nj' , $state = 1)
	{	
		$this->load->model('esf_400_model');
		
		$group_num = $this->esf_400_model->count_group_num(1,1);
		$limit = 20;
		$do_count = (isset($group_num) && $group_num > 0) ? ceil($group_num/$limit) : 0;
		
		if( $do_count > 0 )
		{	
			for($i = 0 ; $i < $do_count ; $i ++)
			{	
				$offset = $i * $limit;
				$arr_group = $this->esf_400_model->get_group_num(1, 1 , $offset , $limit);

				if(is_array($arr_group) && !empty($arr_group))
				{	
					//طԴMODEL
					$this->load->model('house_model');

					foreach ($arr_group as $key => $value )
					{	
						$uid = intval($value['uid']);

						if( $uid > 0)
						{	
							//echo $uid.':';
							//жÿûǷ񻹴ڼԴ
							$house_num = $this->house_model->gethousenumbyuid( $uid , 'sell' , 1);
							if( intval($house_num) == 0)
							{
								$house_num = $this->house_model->gethousenumbyuid( $uid , 'sell' , 0);
							}

							//echo ',Դ:'.$house_num;
							if( 0 == intval($house_num))
							{	
								//ѷ400ʧЧΪ״̬
								$this->esf_400_model->release($uid);
								continue;
							}
							
							//ûڼԴǲ400Դͣ״̬
							$arr_house_400 = array();
							$where_cond = "uid = '".$uid."' AND infofrom = '1' AND tel400 = '1'";
							$house_400_num = $this->house_model->get_house_num_by_where( $where_cond , 'sell');
							//echo ',400Դ:'.$house_num.'<br>';
							if(intval($house_400_num) == 0 )
							{	
								//ѷ400ĳͣ״̬
								$arr_where = array("uid" => $uid , 'status' => 1);
								$this->esf_400_model->update_staus($arr_where , 2);
							}
						}
					}
				}
			}
		}

		echo 'over';
		exit;
	}
	
	
	/**
    * ͷѾڵֻ
    *
    * @access public
    * @return void
    */
	public function telno400_release()
	{	
		$this->load->model('esf_400_model');
		$this->esf_400_model->release_telno();
	}
}


/* End of file job_center_cron.php */
/* Location: ./center/controllers/job_center_cron.php */