package com.jshx.zzhxm.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwjzpz.dao.YzscwjzpzDao;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhkppj.dao.ZzhkppjDao;
import com.jshx.zzhkppj.entity.Zzhkppj;
import com.jshx.zzhxm.dao.ZzhxmDao;
import com.jshx.zzhxm.dao.ZzhxmEntityHistoryDao;
import com.jshx.zzhxm.entity.Zzhxm;
import com.jshx.zzhxm.entity.ZzhxmEntityHistory;
import com.jshx.zzhxm.service.ZzhxmService;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zzhxmService")
public class ZzhxmServiceImpl extends BaseServiceImpl implements ZzhxmService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("zzhxmDao")
	private ZzhxmDao zzhxmDao;

	@Autowired()
	@Qualifier("zzhkppjDao")
	private ZzhkppjDao zzhkppjDao;

	@Autowired()
	@Qualifier("yzscwjzpzDao")
	private YzscwjzpzDao yzscwjzpzDao;

	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("zzhxmEntityHistoryDao")
	private ZzhxmEntityHistoryDao zzhxmEntityHistoryDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return zzhxmDao.findByPage(page, paraMap);
	}

	@Override
	public Pagination findByPageReview(Pagination page, Map<String, Object> paraMap) {
		return zzhxmDao.findByPageReview(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Zzhxm getById(String id)
	{
		return zzhxmDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param zzhxm 信息
	 */
	@Transactional
	public void save(Zzhxm zzhxm)
	{
		zzhxmDao.save(zzhxm);
	}

	/**
	 * 修改信息
	 * @param zzhxm 信息
	 */
	@Transactional
	public void update(Zzhxm zzhxm)
	{
		zzhxmDao.update(zzhxm);
	}
	@Transactional
	@Override
	public void updateNotSave(Zzhxm zzhxm)
	{
		zzhxmDao.update(zzhxm);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=zzhxmDao.findZzhxm(paraMap);

		zzhxmDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					zzhxmDao.deleteWithFlag(id);
			}
		}
	}

	@Transactional
	@Override
	public void updateByTrans(Zzhxm byId, ZzhxmEntityHistory zzhxmEntityHistory) {
		zzhxmEntityHistoryDao.save(zzhxmEntityHistory);
		zzhxmDao.update(byId);
	}

	@Override
	public List<Zzhxm> findZzhxm(Map<String, Object> paraMap) {

		return zzhxmDao.findZzhxm(paraMap);

	}

	@Override
	public Zzhxm getByXmdm(String xmdm){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("xmdm",xmdm);
		Zzhxm zzhxm = (Zzhxm)zzhxmDao.findObjectByFieldsMap(Zzhxm.class,paramMap);
		return zzhxm;
	}

	@Override
	public Zzhxm getByJfdmwybh(String jfdmwybh){
		Map<String,Object> paramMap =  new HashMap<>();
		paramMap.put("jfdmwybh",jfdmwybh);
		Zzhxm zzhxm = (Zzhxm)zzhxmDao.findObjectByFieldsMap(Zzhxm.class,paramMap);
		return zzhxm;
	}

	/**
	 * 保存接口4
	 * @param zzhkppj 信息
	 */
	@Transactional
	public void saveJk4(List<Zzhkppj> zzhkppjList, Zzhkppj zzhkppj){
		if(CollectionUtils.isEmpty(zzhkppjList) || zzhkppjList.size() == 0){
			zzhkppjDao.save(zzhkppj);
		}
	}

	/**
	 * 保存接口6
	 * @param yzscwjzpz 信息
	 */
	@Transactional
	public void saveJk6(Zzhkppj zzhkppj, Yzscwjzpz yzscwjzpz){
		zzhkppjDao.update(zzhkppj);
		yzscwjzpzDao.save(yzscwjzpz);
	}
}
