package com.jshx.yzssfgl.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzssfgl.dao.YzssfglDao;
import com.jshx.yzssfgl.entity.Yzssfgl;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("yzssfglDao")
public class YzssfglDaoImpl extends BaseDaoImpl implements YzssfglDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findYzssfglByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findYzssfgl(Map<String, Object> paraMap){
		return this.findListByHqlId("findYzssfglByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzssfgl getById(String id)
	{
		return (Yzssfgl)this.getObjectById(Yzssfgl.class, id);
	}

	/**
	 * 保存信息
	 * @param yzssfgl 信息
	 */
	public void save(Yzssfgl yzssfgl)
	{
		yzssfgl.setId(null);
		this.saveOrUpdateObject(yzssfgl);
	}

	/**
	 * 修改信息
	 * @param yzssfgl 信息
	 */
	public void update(Yzssfgl yzssfgl)
	{
		this.saveOrUpdateObject(yzssfgl);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Yzssfgl.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Yzssfgl yzssfgl = (Yzssfgl)this.getObjectById(Yzssfgl.class, id);
		yzssfgl.setDelFlag(1);
		this.saveObject(yzssfgl);
	}

	/**
	 * 获取一站式收费区域
	 */
	public List<String> getYzssfqy(Map<String,Object> paramMap){
		return this.findListBySqlId("getYzssfqy",paramMap);
	}

	/**
	 * 获取一站式代收单位
	 */
	public List<String> getYzsdsdw(Map<String,Object> paramMap){
		return this.findListBySqlId("getYzsdsdw",paramMap);
	}

	/**
	 * 获取一站式收费项目名称
	 */
	public List<String> getYzssfxmmc(Map<String,Object> paramMap){
		return this.findListBySqlId("getYzssfxmmc",paramMap);
	}

	/**
	 * 获取一站式审核部门
	 */
	public List<String> getYzsshbm(Map<String,Object> paramMap){
		return this.findListBySqlId("getYzsshbm",paramMap);
	}

	/**
	 * 获取通知书自定义备注
	 */
	public List<String> getJktzsRemarks(Map<String,Object> paramMap){
		return this.findListBySqlId("getJktzsRemarks",paramMap);
	}
}
