package com.jshx.yzssfgl.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzssfgl.dao.YzsdicglDao;
import com.jshx.yzssfgl.entity.Yzsdicgl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Component("yzsdicglDao")
public class YzsdicglDaoImpl extends BaseDaoImpl implements YzsdicglDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findYzsdicglByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findYzsdicgl(Map<String, Object> paraMap){
		return this.findListByHqlId("findYzsdicglByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Yzsdicgl getById(String id)
	{
		return (Yzsdicgl)this.getObjectById(Yzsdicgl.class, id);
	}

	/**
	 * 保存信息
	 * @param yzsdicgl 信息
	 */
	public void save(Yzsdicgl yzsdicgl)
	{
		yzsdicgl.setId(null);
		this.saveOrUpdateObject(yzsdicgl);
	}

	/**
	 * 修改信息
	 * @param yzsdicgl 信息
	 */
	public void update(Yzsdicgl yzsdicgl)
	{
		this.saveOrUpdateObject(yzsdicgl);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Yzsdicgl.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Yzsdicgl yzsdicgl = (Yzsdicgl)this.getObjectById(Yzsdicgl.class, id);
		yzsdicgl.setDelFlag(1);
		this.saveObject(yzsdicgl);
	}

	/**
	 * 获取一站式事项类型
	 */
	public List<String> getYzssxlx(Map<String,Object> paramMap){
		return this.findListBySqlId("getYzssflx",paramMap);
	}

	/**
	 * 获取一站式事项名称
	 */
	public List<String> getYzssxmc(Map<String,Object> paramMap){
		return this.findListBySqlId("getYzssfmc",paramMap);
	}
}
