package com.jshx.yzscw.yzscwpzgl.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.yzscw.yzscwpzgl.dao.YzscwpzglSfxxDao;
import com.jshx.yzscw.yzscwpzgl.entity.YzscwpzglSfxx;
import com.jshx.yzscw.yzscwpzgl.service.YzscwpzglSfxxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("yzscwpzglSfxxService")
public class YzscwpzglSfxxServiceImpl extends BaseServiceImpl implements YzscwpzglSfxxService
{
	/**
	 * Dao类
	 */

	@Autowired()
	@Qualifier("yzscwpzglSfxxDao")
	private YzscwpzglSfxxDao yzscwpzglSfxxDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return yzscwpzglSfxxDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public YzscwpzglSfxx getById(String id)
	{
		return yzscwpzglSfxxDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(YzscwpzglSfxx model)
	{
		yzscwpzglSfxxDao.save(model);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(YzscwpzglSfxx model)
	{
		yzscwpzglSfxxDao.update(model);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects= yzscwpzglSfxxDao.findYzscwpzglSfxx(paraMap);
		yzscwpzglSfxxDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(List<String> ids) {
		Map<String, Object> paraMap = new HashMap<>();
		for (String id : ids) {
			yzscwpzglSfxxDao.deleteWithFlag(id.trim());
		}
	}

	@Override
	public List<YzscwpzglSfxx> findYzscwpzglSfxx(Map<String, Object> paraMap) {
		return yzscwpzglSfxxDao.findYzscwpzglSfxx(paraMap);
	}

}
