package com.jshx.spjlb.web;

import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;
import com.jshx.common.utils.Constant;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.StringUtil;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.jkmx.entity.Jkmx;
import com.jshx.jkmx.service.JkmxService;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.service.UserService;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.paymentItemPending.entity.PaymentItemPending;
import com.jshx.paymentItemPending.service.PaymentItemPendingService;
import com.jshx.qtfymx.entity.Qtfymx;
import com.jshx.qtfymx.service.QtfymxService;
import com.jshx.returnItem.entity.ReturnItem;
import com.jshx.returnItem.service.ReturnItemService;
import com.jshx.sdjd.entity.Sdjd;
import com.jshx.sdjd.service.SdjdService;
import com.jshx.spjkjl.entity.Spjkjl;
import com.jshx.spjkjl.service.SpjkjlService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.szys.entity.Szys;
import com.jshx.szys.service.SzysService;
import com.jshx.tfspb.entity.Tfspb;
import com.jshx.tfspb.service.TfspbService;
import com.jshx.xmhf.entity.Xmhf;
import com.jshx.xmhf.service.XmhfService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;

import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

public class SpjlbAction extends BaseAction {

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;

	private String spjlbid;

	/**
	 * 实体类
	 */
	private Spjlb spjlb = new Spjlb();
	private Xmhf xmhf = new Xmhf();
	private Szys szys = new Szys();
	private Sdjd sdjd = new Sdjd();
	private Xmxxb xmxxb = new Xmxxb();
	private ReturnItem returnItemGQ = new ReturnItem();
	private ReturnItem returnItemZF = new ReturnItem();
	
	private List<FawenAttach> attach;
	/**
	 * 业务类
	 */
	@Autowired
	private SpjlbService spjlbService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private SpjkjlService spjkjlService;
	@Autowired
	private QtfymxService qtfymxService;
	@Autowired
	private JkmxService jkmxService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private FawenAttachService fawenAttachService;
	@Autowired
	private PaymentItemPendingService paymentItemPendingService;
	@Autowired
	private CktzsService cktzsService;
	@Autowired
	private PaymentItemHisService paymentItemHisService;
	@Autowired
	private PaymentVoucherHisService paymentVoucherHisService;
	@Autowired
	private XmhfService xmhfService;
	@Autowired
	private SzysService szysService;
	@Autowired
	private SdjdService sdjdService;
	@Autowired
	private UserService userService;
	@Autowired
	private JktzsService jktzsService;
	@Autowired
	private ReturnItemService returnItemService;
	@Autowired
	private TfspbService tfspbService;

	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	private String isYbjks;

	private String voucherCode;

	private String isZslxd;

	private String ECN;
	private String blztid;

	public String getBlztid() {
		return blztid;
	}

	public void setBlztid(String blztid) {
		this.blztid = blztid;
	}

	private String viewTag;
	/**
	 * 分页信息
	 */
	private Pagination pagination;

	private Date queryFhsjStart;

	private Date queryFhsjEnd;

	private Date queryShsjStart;

	private Date queryShsjEnd;

	private Date queryPzsjStart;

	private Date queryPzsjEnd;

	private Date querySlsjStart;

	private Date querySlsjEnd;

	private Date queryCssjStart;

	private Date queryCssjEnd;

	private Date querySlfhsjStart;

	private Date querySlfhsjEnd;

	private Date queryLcjssjStart;

	private Date queryLcjssjEnd;

	private Date querySlshsjStart;

	private Date querySlshsjEnd;

	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;

	DecimalFormat df = new DecimalFormat("######0.00");

	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		// 是否可以打印审批表
		paraMap.put("isdyspb", "1");
		if (pagination == null)
			pagination = new Pagination(this.getRequest());

		if (null != spjlb) {
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != spjlb.getSlbh()) && (0 < spjlb.getSlbh().trim().length())) {
				paraMap.put("slbh", "%" + spjlb.getSlbh().trim() + "%");
			}

			if ((null != spjlb.getXxbbh()) && (0 < spjlb.getXxbbh().trim().length())) {
				paraMap.put("xxbbh", "%" + spjlb.getXxbbh().trim() + "%");
			}

			if ((null != spjlb.getCkbh()) && (0 < spjlb.getCkbh().trim().length())) {
				paraMap.put("ckbh", "%" + spjlb.getCkbh().trim() + "%");
			}

			if ((null != spjlb.getJsdwmc()) && (0 < spjlb.getJsdwmc().trim().length())) {
				paraMap.put("jsdwmc", "%" + spjlb.getJsdwmc().trim() + "%");
			}

			if ((null != spjlb.getGcxmmc()) && (0 < spjlb.getGcxmmc().trim().length())) {
				paraMap.put("gcxmmc", "%" + spjlb.getGcxmmc().trim() + "%");
			}

			if ((null != spjlb.getLxr()) && (0 < spjlb.getLxr().trim().length())) {
				paraMap.put("lxr", "%" + spjlb.getLxr().trim() + "%");
			}

			if ((null != spjlb.getShouliren()) && (0 < spjlb.getShouliren().trim().length())) {
				paraMap.put("shouliren", "%" + spjlb.getShouliren().trim() + "%");
			}

			if (null != querySlsjStart) {
				paraMap.put("startSlsj", querySlsjStart);
			}

			if (null != querySlsjEnd) {
				paraMap.put("endSlsj", querySlsjEnd);
			}
		}

		String dwdm = "";
		if (!this.getLoginUser().getIsSuperAdmin()) {
			dwdm = zsdwService.getDwdm(this.getLoginUserDepartmentId());
		}
		if (!"".equals(dwdm)) {
			paraMap.put("dwdm", dwdm);
		}

		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|slbh|xxbbh|zjbh|jzmj|ckbh|bllb|zclb|lstd|jsdwmc|jsdwdz|gcxmdz|lxr|lxdh|shouliren|slsj|gcxmmc|zsdw|yjje|ymje|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = spjlbService.findByPage(pagination, paraMap);
		List<Spjlb> lpjlbs=pagination.list;
		if(null!=lpjlbs&&lpjlbs.size()>0){
			for (Spjlb spjlb : lpjlbs) {
			Map<String, Object> paraMap2 = new HashMap<String, Object>();
			paraMap2.put("slbh", spjlb.getSlbh());
			List<Spjkjl> ls = spjkjlService.findSpjkjlall(paraMap2);
			 if(null!=ls&&ls.size()>0){
				 spjlb.setYjje(ls.get(0).getPtyjje());
				 spjlb.setYmje(ls.get(0).getPtymje());
			 }else if("直接缴费".equals(spjlb.getBllb())){
				    	Xmxxb xbm=xmxxbService.getById(spjlb.getXmbzj());
				    	spjlb.setYjje(xbm.getYjje());
				    	spjlb.setYmje(xbm.getYmje());
			 }
			 List<Jktzs> jkts=jktzsService.findByAll(paraMap2);
			 if(null!=jkts&&jkts.size()>0){
				 spjlb.setZsdw(jkts.get(0).getDzbh());
			 }
			 
		   }
			
		}

		convObjectToJson(pagination, config);
	}

	public void list1() throws Exception
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null)
		{
			pagination = new Pagination(this.getRequest());
		}
		if (null != spjlb)
		{
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != spjlb.getSlbh()) && (0 < spjlb.getSlbh().trim().length()))
			{
				paraMap.put("slbh", "%" + spjlb.getSlbh().trim() + "%");
			}

			if ((null != spjlb.getXxbbh()) && (0 < spjlb.getXxbbh().trim().length()))
			{
				paraMap.put("xxbbh", "%" + spjlb.getXxbbh().trim() + "%");
			}

			if ((null != spjlb.getCkbh()) && (0 < spjlb.getCkbh().trim().length()))
			{
				paraMap.put("ckbh", "%" + spjlb.getCkbh().trim() + "%");
			}

			if ((null != spjlb.getJsdwmc()) && (0 < spjlb.getJsdwmc().trim().length()))
			{
				paraMap.put("jsdwmc", "%" + spjlb.getJsdwmc().trim() + "%");
			}

			if ((null != spjlb.getGcxmmc()) && (0 < spjlb.getGcxmmc().trim().length()))
			{
				paraMap.put("gcxmmc", "%" + spjlb.getGcxmmc().trim() + "%");
			}
			if ((null != spjlb.getGcxmdz()) && (0 < spjlb.getGcxmdz().trim().length()))
			{
				paraMap.put("gcxmdz", "%" + spjlb.getGcxmdz().trim() + "%");
			}
			if ((null != spjlb.getZjbh()) && (0 < spjlb.getZjbh().trim().length()))
			{
				paraMap.put("zjbh", "%" + spjlb.getZjbh().trim() + "%");
			}
			if ((null != spjlb.getDwdm()) && (0 < spjlb.getDwdm().trim().length())&& !"99".equals(spjlb.getDwdm()))
			{
				paraMap.put("dwdmid", "%" + spjlb.getDwdm().trim() + "%");
				//统计范围
				if((null != spjlb.getTjfw()) && (0 < spjlb.getTjfw().trim().length())&& !"99".equals(spjlb.getTjfw())){
					paraMap.put("tjfw", "%" + spjlb.getTjfw().trim() + "%");
				}
			}

			if ((null != spjlb.getLxr()) && (0 < spjlb.getLxr().trim().length()))
			{
				paraMap.put("lxr", "%" + spjlb.getLxr().trim() + "%");
			}
			if ((null != spjlb.getBllb()) && (0 < spjlb.getBllb().trim().length())&& !"99".equals(spjlb.getBllb()))
			{
				if("0".equals(spjlb.getBllb())){
					paraMap.put("bllb", "%直接缴费%");
				}
				if("1".equals(spjlb.getBllb())){
					paraMap.put("bllb", "%减免%");
				}
			}
			if ((null != spjlb.getZclb()) && (0 < spjlb.getZclb().trim().length())&& !"99".equals(spjlb.getZclb()))
			{
				paraMap.put("zclb", "%" + spjlb.getZclb().trim() + "%");
			}

			if ((null != spjlb.getShouliren()) && (0 < spjlb.getShouliren().trim().length()))
			{
				paraMap.put("shouliren", "%" + spjlb.getShouliren().trim() + "%");
			}

			if (null != querySlsjStart)
			{
				paraMap.put("startSlsj", querySlsjStart);
			}
			
			if (null != querySlsjEnd)
			{
				paraMap.put("endSlsj", querySlsjEnd);
			}
			if (null != queryLcjssjStart)
			{
				paraMap.put("startlcjssj", queryLcjssjStart);
			}
			
			if (null != queryLcjssjEnd)
			{
				paraMap.put("endlcjssj", queryLcjssjEnd);
			}
		}

		String dwdm = "";
		if (!this.getLoginUser().getIsSuperAdmin())
		{
			dwdm = zsdwService.getDwdm(this.getLoginUserDepartmentId());
		}
		if (!"".equals(dwdm) && !"sf".equals(dwdm))
		{
//----------2020-7-24 放开其他区域查询限制,除江北、经开外，其他地区均可查询所有数据 start -------------------
			if("jb".equals(dwdm) || "jk".equals(dwdm)) {
				paraMap.put("dwdm", dwdm);
			}
//---------- end --------------------------------
		}

		
		//状态查询
		if(null!=blztid&&!"".equals(blztid)&&!"99".equals(blztid)){
			if("1".equals(blztid)){
				//审核中
				paraMap.put("shz", "111");
			}
			if("2".equals(blztid)){
				paraMap.put("ysh", "111");
				//已审核
			}
			if("3".equals(blztid)){
				Map<String, Object> paraMap1 = new HashMap<String, Object>();
				paraMap1.put("wgd", "0");
				paraMap1.put("lcjk", "1");
				//未归档
			}
			if("4".equals(blztid)){
				Map<String, Object> paraMap1 = new HashMap<String, Object>();
				paraMap1.put("ygd", "1");
				List<Xmxxb> lxs=xmxxbService.findXmxxb(paraMap1);
				if(null!=lxs&&lxs.size()>0){
                    List a=new ArrayList<>();
					for (int i = 0; i < lxs.size(); i++) {
						  if(null!=lxs.get(i).getSlbh()&&!"".equals(lxs.get(i).getSlbh())){
          						a.add(lxs.get(i).getSlbh());
						  }
					}
					paraMap.put("slbhs", a);
				}else{
					
					paraMap.put("slbhs", "");
				}
				//已归档
			}
			if("5".equals(blztid)){
				Map<String, Object> paraMap1 = new HashMap<String, Object>();
				paraMap1.put("yjkwrk", "2222");
				paraMap1.put("lcjk", "1");
				paraMap1.put("isxmcx", "2");
//				paraMap1.put("issptg", "0");
				List<Xmxxb> lxs=xmxxbService.findXmxxb(paraMap1);
				if(null!=lxs&&lxs.size()>0){
                    List a=new ArrayList<>();
					for (int i = 0; i < lxs.size(); i++) {
						  if(null!=lxs.get(i).getSlbh()&&!"".equals(lxs.get(i).getSlbh())){
          						a.add(lxs.get(i).getSlbh());
						  }
					}
					paraMap.put("slbhs", a);
				}
				//未交费
			}
			if("6".equals(blztid)){
				Map<String, Object> paraMap1 = new HashMap<String, Object>();
				paraMap1.put("yjkrk", "0");
				paraMap1.put("lcjk", "1");
//				paraMap1.put("issptg", "0");
				List<Xmxxb> lxs=xmxxbService.findXmxxb(paraMap1);
				if(null!=lxs&&lxs.size()>0){
                    List a=new ArrayList<>();
					for (int i = 0; i < lxs.size(); i++) {
						  if(null!=lxs.get(i).getSlbh()&&!"".equals(lxs.get(i).getSlbh())){
          						a.add(lxs.get(i).getSlbh());
						  }
					}
					paraMap.put("slbhs", a);
				}
				//已缴费
			}
		}
		
		
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|slbh|xxbbh|zjbh|jzmj|ckbh|bllb|zclb|lstd|jsdwmc|jsdwdz|gcxmdz|lxr|lxdh|shouliren|slsj|gcxmmc|zsdw|yjje|ymje|jfpzbh|dzjgh|dananhao|tjfw|";
		if (filter != null && filter.length() > 1)
		{
			config.setJsonPropertyFilter(new PropertyFilter()
			{
				public boolean apply(Object source, String name, Object value)
				{
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = spjlbService.findByPage(pagination, paraMap);
		List<Spjlb> lsps=pagination.list;
		if(null!=lsps&&lsps.size()>0){
			Xmxxb xb;
			
			for (Spjlb sp : lsps) {
				xb=xmxxbService.getById(sp.getXmbzj());
				Map<String, Object> paraMap11 = new HashMap<String, Object>();
				paraMap11.put("slbh", xb.getSlbh());
				List<Spjkjl> lss = spjkjlService.findSpjkjlall(paraMap11);
				if(xb!=null){
					sp.setZsdw(xb.getZsdw());
					
					//退件后应激金额显示,主要考虑退件后 直接缴费变减免
					if(null==xb.getIstj()&&"".equals(xb.getIstj())){
					sp.setYjje(xb.getYjje());
					}
					if(lss.size()>0){
					sp.setYmje(lss.get(0).getPtymje());
					    if(null!=xb.getIstj()||!"".equals(xb.getIstj())){
						   sp.setYjje(lss.get(0).getPtyjje());
					    }
					}else{
						sp.setYmje(xb.getYmje());
						
					}
					if("2".equals(xb.getIsgd())){
						sp.setDananhao(StringUtil.getDANO(xb.getSlbh(), xb.getDwdm()));
					}
				}
				Map<String, Object> paraMap2= new HashMap<String, Object>();
				paraMap2.put("slbh", sp.getSlbh());
				List<PaymentItemHis> lpayhiss=paymentItemHisService.findall(paraMap2);
				if(null!=lpayhiss&&lpayhiss.size()>0){
					sp.setDzjgh(lpayhiss.get(0).getECN());
					sp.setJfpzbh(lpayhiss.get(0).getZslxdbh());
				}
				
			}
		}

		convObjectToJson(pagination, config);
	}

	public void list2() throws Exception {
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if (pagination == null) {
			pagination = new Pagination(this.getRequest());
		}
		if (null != spjlb) {
			// 设置查询条件，开发人员可以在此增加过滤条件
			if ((null != spjlb.getSlbh()) && (0 < spjlb.getSlbh().trim().length())) {
				paraMap.put("slbh", "%" + spjlb.getSlbh().trim() + "%");
			}

			if ((null != spjlb.getXxbbh()) && (0 < spjlb.getXxbbh().trim().length())) {
				paraMap.put("xxbbh", "%" + spjlb.getXxbbh().trim() + "%");
			}

			if ((null != spjlb.getCkbh()) && (0 < spjlb.getCkbh().trim().length())) {
				paraMap.put("ckbh", "%" + spjlb.getCkbh().trim() + "%");
			}

			if ((null != spjlb.getJsdwmc()) && (0 < spjlb.getJsdwmc().trim().length())) {
				paraMap.put("jsdwmc", "%" + spjlb.getJsdwmc().trim() + "%");
			}

			if ((null != spjlb.getGcxmmc()) && (0 < spjlb.getGcxmmc().trim().length())) {
				paraMap.put("gcxmmc", "%" + spjlb.getGcxmmc().trim() + "%");
			}

			if ((null != spjlb.getLxr()) && (0 < spjlb.getLxr().trim().length())) {
				paraMap.put("lxr", "%" + spjlb.getLxr().trim() + "%");
			}

			if ((null != spjlb.getShouliren()) && (0 < spjlb.getShouliren().trim().length())) {
				paraMap.put("shouliren", "%" + spjlb.getShouliren().trim() + "%");
			}

			if (null != querySlsjStart) {
				paraMap.put("startSlsj", querySlsjStart);
			}

			if (null != querySlsjEnd) {
				paraMap.put("endSlsj", querySlsjEnd);
			}
		}

		String dwdm = "";
		if (!this.getLoginUser().getIsSuperAdmin()) {
			dwdm = zsdwService.getDwdm(this.getLoginUserDepartmentId());
		}
		if (!"".equals(dwdm) && !"sf".equals(dwdm)) {
			paraMap.put("dwdm", dwdm);
		}
		paraMap.put("createUserID", this.getLoginUser().getId());
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
		Map<String, String> codeMap = new HashMap<String, String>();
		// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

		config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
		final String filter = "id|slbh|xxbbh|zjbh|jzmj|ckbh|bllb|zclb|lstd|jsdwmc|jsdwdz|gcxmdz|lxr|lxdh|shouliren|slsj|gcxmmc|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = spjlbService.findByPage(pagination, paraMap);

		convObjectToJson(pagination, config);
	}

	/**
	 * 打印
	 */
	public String dyspb() throws Exception {
		// 征收标准
//		String danjia = SysPropertiesUtil.getProperty("danweijine");
		String danjia = (String) Constant.CONSTANT_MAP.get("ptf");
		// 基础数据..
		Spjlb spjlb = spjlbService.getById(spjlbid);
		if(null!=spjlb.getCsbz()&&!"".equals(spjlb.getCsbz())){
			spjlb.setCsbz(spjlb.getCsbz().replace("\n", "<br/>"));
			spjlb.setCsbz(spjlb.getCsbz().replace(" ", "&nbsp;"));
		}
		if(null!=spjlb.getPtfbz()&&!"".equals(spjlb.getPtfbz())){
			danjia=spjlb.getPtfbz();
		}
		Xmxxb xm = xmxxbService.getById(spjlb.getXmbzj());
		setRequestAttribute("xm", xm);
		// 收费处的项目都没有其他费用类型
		 if(!"hx".equals(spjlb.getDwdm())&&!"xl".equals(spjlb.getDwdm())) {
			// 只有一条
			if ("0".equals(spjlb.getZjdyjks())&&"sf".equals(spjlb.getDwdm())) {
				// 直接打印,无减免,无抵扣,无其他
				setRequestAttribute("spjlb", spjlb);
				// setRequestAttribute("xm", xm);
				setRequestAttribute("zsbz", danjia);
				return "success11";
			}

			// 减免类型判断 1减免,0直接缴费
			if ("1".equals(xm.getBllb())) {
				// 多条
				Map<String, Object> paraMap = new HashMap<String, Object>();
				paraMap.put("slbh", spjlb.getSlbh());
				List<Spjkjl> ls = spjkjlService.findSpjkjlall(paraMap);// 参考可能不需要里面数据
				ls.get(0).getCsmj();// 建设面积
				List<Jkmx> ljk = jkmxService.findall(paraMap);

				// 缴款类别0:应免,1:应缴 jklb
				// 将jkmx数据整合 多条.....应缴只要一条总和,应免显示多条
				cost(ljk, danjia);
				setRequestAttribute("spjlb", spjlb);
				if("sf".equals(spjlb.getDwdm())||"pk".equals(spjlb.getDwdm())){
					return "success12";
				}else if("nb".equals(spjlb.getDwdm())){
					return "success12nb";
				}else if("rj".equals(spjlb.getDwdm())){
					return "success12rj";
				}else if("ql".equals(spjlb.getDwdm())){
					return "success12ql";
				}else if("xy".equals(spjlb.getDwdm())){
					return "success12xy";
				}else if("jk".equals(spjlb.getDwdm())){
					return "success12jk";
				}else if("jb".equals(spjlb.getDwdm())){
					return "success12jb";
				}else{
					return "successqt01";
				}
				
			} else {
				// 只有一条
				Map<String, Object> paraMap = new HashMap<String, Object>();
				paraMap.put("slbh", spjlb.getSlbh());
				Map<String, String> map = new HashMap<String, String>();
				List<Spjkjl> ls = spjkjlService.findSpjkjlall(paraMap);
                 if(null!=ls&&ls.size()>0){
                	 map.put("yjmj", df.format(Double.parseDouble(ls.get(0).getPtyjmj())));
                	 map.put("yjje", df.format(Double.parseDouble(ls.get(0).getPtyjje())));
                 }else{
                	 map.put("yjmj", df.format(Double.parseDouble(xm.getYjmj())));
                	 map.put("yjje", df.format(Double.parseDouble(xm.getYjje())));
                 }
				map.put("danjia", df.format(Double.parseDouble(danjia)));
				setRequestAttribute("spjlb", spjlb);
				setRequestAttribute("map", map);
				if("sf".equals(spjlb.getDwdm())||"pk".equals(spjlb.getDwdm())){
					return "success13";
				}else if("nb".equals(spjlb.getDwdm())){
					return "success13nb";
				}else if("rj".equals(spjlb.getDwdm())){
					return "success13rj";
				}else if("ql".equals(spjlb.getDwdm())){
					return "success13ql";
				}else  if("xy".equals(spjlb.getDwdm())){
					return "success13xy";
				}else if("jk".equals(spjlb.getDwdm())){
					return "success13jk";
				}else if("jb".equals(spjlb.getDwdm())){
					return "success13jb";
				}else{
					return "successqt02";
				}
			}

		}

		// 仙林河西其他地方打印
		// 1减免,0直接缴费
		if ("1".equals(xm.getBllb())) {
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", spjlb.getSlbh());
			List<Spjkjl> ls = spjkjlService.findSpjkjlall(paraMap);// 参考可能不需要里面数据
			List<Jkmx> ljk = jkmxService.findall(paraMap);
			// 将jkmx数据整合 多条.....

			double[] money = cost(ljk, danjia);
			setRequestAttribute("spjlb", spjlb);

			otherCoat(spjlb, money[0], money[1],money[2],money[3]);
            
			if ("xl".equals(spjlb.getDwdm())) {
				// 仙林
				return "success21";
			} else if("hx".equals(spjlb.getDwdm())){// 河西
				return "success31";
			}

		} else {
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", spjlb.getSlbh());
			List<Spjkjl> ls = spjkjlService.findSpjkjlall(paraMap);

			Map<String, String> map = new HashMap<String, String>();
			map.put("yjmj", df.format(Double.parseDouble(ls.get(0).getPtyjmj())));
			map.put("yjje", df.format(Double.parseDouble(ls.get(0).getPtyjje())));

			map.put("zsbz", danjia);
			setRequestAttribute("spjlb", spjlb);
			setRequestAttribute("map", map);

			otherCoat(spjlb, Double.parseDouble(ls.get(0).getPtyjje()), 0,Double.parseDouble(ls.get(0).getPtyjmj()),0);

			if ("xl".equals(spjlb.getDwdm())) {
				// 仙林
				return "success22";
			} else  if("hx".equals(spjlb.getDwdm())){// 河西
				return "success32";
			}
		}
		// 存在其他费用,人防,白蚁,新墙体
     return null;
	}

	private void otherCoat(Spjlb spjlb, double je, double me, double yjmj01,double ymmj01) {
		if ("1".equals(spjlb.getIsqitalx())) {
			Map<String, Object> paraMap1 = new HashMap<String, Object>();
			paraMap1.put("slbh", spjlb.getSlbh());
			List<Qtfymx> liqt = qtfymxService.findall(paraMap1);

			List<Map<String, String>> rfList = new ArrayList<Map<String, String>>();
			List<Map<String, String>> byList = new ArrayList<Map<String, String>>();
			List<Map<String, String>> xqtList = new ArrayList<Map<String, String>>();

			// 合计
			// 人防
			double rfyjmjhj = 0;
			double rfyjjehj = 0;
			double rfymmjhj = 0;
			double rfymjehj = 0;
			// 白蚁
			double byyjmjhj = 0;
			double byyjjehj = 0;
			double byymmjhj = 0;
			double byymjehj = 0;
			// 新墙体
			double qtyjmjhj = 0;
			double qtyjjehj = 0;
			double qtymmjhj = 0;
			double qtymjehj = 0;

			for (Qtfymx bean : liqt) {
				if ("qtlx1".equals(bean.getFylx())) {
					double yjmj = Double.parseDouble(bean.getYjmj());
					double yjje = Double.parseDouble(bean.getYjje());
					double ymmj = Double.parseDouble(bean.getYmmj());
					double ymje = Double.parseDouble(bean.getYmje());

					// rfyjmjhj += yjmj;
					// rfyjjehj += yjje;
					// rfymmjhj += ymmj;
					// rfymjehj += ymje;

					rfyjmjhj = SysPropertiesUtil.addd(rfyjmjhj, yjmj);
					rfyjjehj = SysPropertiesUtil.addd(rfyjjehj, yjje);
					rfymmjhj = SysPropertiesUtil.addd(rfymmjhj, ymmj);
					rfymjehj = SysPropertiesUtil.addd(rfymjehj, ymje);

					Map<String, String> map = new HashMap<String, String>();
					map.put("yjmj", yjmj == 0 ? "" : df.format(yjmj));
					map.put("yjje", yjje == 0 ? "" : df.format(yjje));
					map.put("ymmj", ymmj == 0 ? "" : df.format(ymmj));
					map.put("ymje", ymje == 0 ? "" : df.format(ymje));
					map.put("zsbz", bean.getSfbz());

					rfList.add(map);
				} else if ("qtlx2".equals(bean.getFylx())) {
					double yjmj = Double.parseDouble(bean.getYjmj());
					double yjje = Double.parseDouble(bean.getYjje());
					double ymmj = Double.parseDouble(bean.getYmmj());
					double ymje = Double.parseDouble(bean.getYmje());

					// byyjmjhj += yjmj;
					// byyjjehj += yjje;
					// byymmjhj += ymmj;
					// byymjehj += ymje;
					//
					byyjmjhj = SysPropertiesUtil.addd(byyjmjhj, yjmj);
					byyjjehj = SysPropertiesUtil.addd(byyjjehj, yjje);
					byymmjhj = SysPropertiesUtil.addd(byymmjhj, ymmj);
					byymjehj = SysPropertiesUtil.addd(byymjehj, ymje);

					Map<String, String> map = new HashMap<String, String>();
					map.put("yjmj", yjmj == 0 ? "" : df.format(yjmj));
					map.put("yjje", yjje == 0 ? "" : df.format(yjje));
					map.put("ymmj", ymmj == 0 ? "" : df.format(ymmj));
					map.put("ymje", ymje == 0 ? "" : df.format(ymje));
					map.put("zsbz", bean.getSfbz());

					byList.add(map);
				} else if ("qtlx3".equals(bean.getFylx())) {
					double yjmj = Double.parseDouble(bean.getYjmj());
					double yjje = Double.parseDouble(bean.getYjje());
					double ymmj = Double.parseDouble(bean.getYmmj());
					double ymje = Double.parseDouble(bean.getYmje());

					qtyjmjhj = SysPropertiesUtil.addd(qtyjmjhj, yjmj);
					qtyjjehj = SysPropertiesUtil.addd(qtyjjehj, yjje);
					qtymmjhj = SysPropertiesUtil.addd(qtymmjhj, ymmj);
					qtymjehj = SysPropertiesUtil.addd(qtymjehj, ymje);

					Map<String, String> map = new HashMap<String, String>();
					map.put("yjmj", yjmj == 0 ? "" : df.format(yjmj));
					map.put("yjje", yjje == 0 ? "" : df.format(yjje));
					map.put("ymmj", ymmj == 0 ? "" : df.format(ymmj));
					map.put("ymje", ymje == 0 ? "" : df.format(ymje));
					map.put("zsbz", bean.getSfbz());

					xqtList.add(map);
				}
			}
			// 总合计
			// double yjje = rfyjjehj + byyjjehj + qtyjjehj + je;
			// double ymje = rfymjehj + byymjehj + qtymjehj + me;

			double yjje = SysPropertiesUtil.addd(rfyjjehj, byyjjehj);
			yjje = SysPropertiesUtil.addd(yjje, qtyjjehj);
			yjje = SysPropertiesUtil.addd(yjje, je);
			
			double yjmj001 = SysPropertiesUtil.addd(rfyjmjhj, byyjmjhj);
			yjmj001 = SysPropertiesUtil.addd(yjmj001, qtyjmjhj);
			yjmj001 = SysPropertiesUtil.addd(yjmj001, yjmj01);
			

			double ymje = SysPropertiesUtil.addd(rfymjehj, byymjehj);
			ymje = SysPropertiesUtil.addd(ymje, qtymjehj);
			ymje = SysPropertiesUtil.addd(ymje, me);
			
			double ymmj001 = SysPropertiesUtil.addd(rfymmjhj, byymmjhj);
			ymmj001 = SysPropertiesUtil.addd(ymmj001, qtymmjhj);
			ymmj001 = SysPropertiesUtil.addd(ymmj001, ymmj01);

			Map<String, String> hejiMap = new HashMap<String, String>();

			if(0!=rfyjmjhj){
				hejiMap.put("rfyjmjhj", df.format(rfyjmjhj));
				
			}
			if(0!=rfyjjehj){
				hejiMap.put("rfyjjehj", df.format(rfyjjehj));
				
			}
			if(0!=rfymmjhj){
				hejiMap.put("rfymmjhj", df.format(rfymmjhj));
				
			}
			if(0!=rfymjehj){
				
				hejiMap.put("rfymjehj", df.format(rfymjehj));
			}

			hejiMap.put("byyjmjhj", df.format(byyjmjhj));
			hejiMap.put("byyjjehj", df.format(byyjjehj));
			hejiMap.put("byymmjhj", df.format(byymmjhj));
			hejiMap.put("byymjehj", df.format(byymjehj));

			hejiMap.put("qtyjmjhj", df.format(qtyjmjhj));
			hejiMap.put("qtyjjehj", df.format(qtyjjehj));
			hejiMap.put("qtymmjhj", df.format(qtymmjhj));
			hejiMap.put("qtymjehj", df.format(qtymjehj));
             
			if(yjje!=0){
				hejiMap.put("yjje", df.format(yjje));
			}
			if(ymje!=0){
				
				hejiMap.put("ymje", df.format(ymje));
			}
	      if(ymmj001!=0){
				
		   hejiMap.put("ymmj", df.format(ymmj001));
			}
	    if(yjmj001!=0){
		hejiMap.put("yjmj", df.format(yjmj001));
	     }

			setRequestAttribute("rfList", rfList);
			setRequestAttribute("byList", byList);
			setRequestAttribute("xqtList", xqtList);
			setRequestAttribute("hejiMap", hejiMap);
		} else {
			Map<String, String> hejiMap = new HashMap<String, String>();
			if(je!=0){
				hejiMap.put("yjje", df.format(je));
			}
			if(me!=0){
				hejiMap.put("ymje", df.format(me));
			}
			setRequestAttribute("hejiMap", hejiMap);
		}

	}

	private double[] cost(List<Jkmx> ljk, String danjia) {
		List<Map<String, String>> list = new ArrayList<Map<String, String>>();
		double manji = 0;
		double jine = 0;
		int i = 0;
		double ymmj = 0;
		double ymje = 0;
		Map<String, String> map1 = new HashMap<String, String>();
		Map<String, String> map2 = new HashMap<String, String>();
		for (Jkmx bea : ljk) {
			if ("0".equals(bea.getJklb())) {
				ymmj = SysPropertiesUtil.addd(ymmj, Double.parseDouble(bea.getMianji()));
				ymje = SysPropertiesUtil.addd(ymje, Double.parseDouble(bea.getJine()));
				if (map1.isEmpty() && map2.isEmpty()) {
					map1.put("mjmj", df.format(Double.parseDouble(bea.getMianji())));
					map1.put("mjje", df.format(Double.parseDouble(bea.getJine())));
					map1.put("zsbz", danjia);
					map1.put("tkdm", bea.getJktk());
				} else if (map1.get("tkdm").equals(bea.getJktk())) {
					double mj = SysPropertiesUtil.addd(Double.parseDouble(map1.get("mjmj")),
							Double.parseDouble(bea.getMianji()));
					double je = SysPropertiesUtil.addd(Double.parseDouble(map1.get("mjje")),
							Double.parseDouble(bea.getJine()));
					map1.put("mjmj", df.format(mj));
					map1.put("mjje", df.format(je));
					map1.put("zsbz", danjia);
					map1.put("tkdm", bea.getJktk());
				} else if (map2.isEmpty()) {
					map2.put("mjmj", df.format(Double.parseDouble(bea.getMianji())));
					map2.put("mjje", df.format(Double.parseDouble(bea.getJine())));
					map2.put("zsbz", danjia);
					map2.put("tkdm", bea.getJktk());
				} else if (map2.get("tkdm").equals(bea.getJktk())) {
					double mj = SysPropertiesUtil.addd(Double.parseDouble(map2.get("mjmj")),
							Double.parseDouble(bea.getMianji()));
					double je = SysPropertiesUtil.addd(Double.parseDouble(map1.get("mjje")),
							Double.parseDouble(bea.getJine()));
					map2.put("mjmj", df.format(mj));
					map2.put("mjje", df.format(je));
					map2.put("zsbz", danjia);
					map2.put("tkdm", bea.getJktk());
				}
			} else {
				// if(bea.getMianji() != null &&
				// !("0").equals(bea.getMianji())){
				if (bea.getMianji() != null) {
					manji = SysPropertiesUtil.addd(manji, Double.parseDouble(bea.getMianji()));
					jine = SysPropertiesUtil.addd(jine, Double.parseDouble(bea.getJine()));
					Map<String, String> map = new HashMap<String, String>();
					map.put("yjmj", df.format(manji));
					map.put("yjje", df.format(jine));

					map.put("zsbz", danjia);
					map.put("tkdm", "宁政规字[2016]5号");
					list.add(map);
				} else {
					manji = 0.0;
					jine = 0.0;
					Map<String, String> map = new HashMap<String, String>();
					map.put("yjmj", df.format(manji));
					map.put("yjje", df.format(jine));

					map.put("zsbz", danjia);
					map.put("tkdm", "宁政规字[2016]5号");
					list.add(map);

				}
			}
		}
		list.add(map1);
		list.add(map2);
		setRequestAttribute("list", list);
		setRequestAttribute("ymjehj", ymje);
		setRequestAttribute("ymmjhj", ymmj);
		setRequestAttribute("yjmjhj", manji);
		setRequestAttribute("yjjehj", jine);
		double[] je = { jine, ymje ,manji,ymmj};
		return je;

	}

	/**
	 * 查看详细信息
	 */
	public String view() throws Exception {
		if ((null != spjlb) && (null != spjlb.getId())) {
			spjlb = spjlbService.getById(spjlb.getId());
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("xmxxbzj", spjlb.getXmbzj());
			List<Xmhf> lx = xmhfService.findXmhf(paraMap);
			List<Szys> ls = szysService.findSzys(paraMap);

			List<Sdjd> lsd = new ArrayList<>();
			if (null != spjlb.getXxbbh() && !"".equals(spjlb.getXxbbh())) {
				Map<String, Object> paraMap1 = new HashMap<String, Object>();
				paraMap1.put("xxbbh", "%" + spjlb.getXxbbh().trim() + "%");
				lsd = sdjdService.findSdjd(paraMap1);
			}
			if (lx.size() > 0) {
				xmhf = lx.get(0);
			}
			if (ls.size() > 0) {
				szys = ls.get(0);
			}
			if (lsd.size() > 0) {
				sdjd = lsd.get(0);
				User cu = userService.findUserById(sdjd.getCreateUserID());
				User uu = userService.findUserById(sdjd.getUpdateUserID());
				String cuname = "";
				String uuname = "";
				if (null != cu) {
					cuname = cu.getDisplayName();
				}
				if (null != uu) {
					uuname = uu.getDisplayName();
				}
				sdjd.setCreateUserID(cuname);
				sdjd.setUpdateUserID(uuname);
			}
		}

		return VIEW;
	}

	public String shview() throws Exception {
		if ((null != xmxxb) && (null != xmxxb.getId())) {
			xmxxb = xmxxbService.getById(xmxxb.getId());
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("xmxxbzj", xmxxb.getId());
			List<Xmhf> lx = xmhfService.findXmhf(paraMap);
			List<Szys> ls = szysService.findSzys(paraMap);

			Map<String, Object> paraMap1 = new HashMap<String, Object>();
			paraMap1.put("xxbbh", "%" + xmxxb.getXxylb().trim() + "%");
			List<Sdjd> lsd = sdjdService.findSdjd(paraMap1);
			List<Spjlb> lssp = spjlbService.findSpjlball(paraMap1);
			if (lssp.size() > 0) {
				spjlb = lssp.get(0);
			}
			if (lx.size() > 0) {
				xmhf = lx.get(0);
			}
			if (ls.size() > 0) {
				szys = ls.get(0);
			}
			if (lsd.size() > 0) {
				sdjd = lsd.get(0);
				User cu = userService.findUserById(sdjd.getCreateUserID());
				User uu = userService.findUserById(sdjd.getUpdateUserID());
				String cuname = "";
				String uuname = "";
				if (null != cu) {
					cuname = cu.getDisplayName();
				}
				if (null != uu) {
					uuname = uu.getDisplayName();
				}
				sdjd.setCreateUserID(cuname);
				sdjd.setUpdateUserID(uuname);
			}
		}
		return VIEW;
	}

	/**
	 * 综合查询
	 * 
	 * @return
	 * @throws Exception
	 */
	public String view1() throws Exception {
		if ((null != spjlb) && (null != spjlb.getId())) {
			spjlb = spjlbService.getById(spjlb.getId());
		}
		Xmxxb xmb = xmxxbService.getById(spjlb.getXmbzj());
	
		this.setRequestAttribute("xmb", xmb);
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("slbh", spjlb.getSlbh());
		List<Spjkjl> ls = spjkjlService.findSpjkjlall(paraMap);// 参考可能不需要里面数据
		
		Tfspb  tf=tfspbService.getBYslbh(spjlb.getSlbh());
		if(null!=tf){
			this.setRequestAttribute("tf", tf);
		}
		
		if (ls.size() > 0) {
			this.setRequestAttribute("sp", ls.get(0));

		}
		// List<Jkmx> ljk=jkmxService.findall(paraMap);
		//
		// if("1".equals(spjlb.getIsqitalx())){
		// Map<String, Object> paraMap1 = new HashMap<String, Object>();
		// paraMap1.put("slbh", spjlb.getSlbh());
		// List<Qtfymx> liqt=qtfymxService.findall(paraMap1);
		// }
		PaymentItemHis paymentItemHis = paymentItemHisService.getByOrderId(spjlb.getSlbh());
		if (null != paymentItemHis) {
			ECN = paymentItemHis.getZslxdbh();
		}
		PaymentVoucherHis paymentVoucherHis = paymentVoucherHisService.getPayMentByorderId(spjlb.getSlbh());
		if (null != paymentVoucherHis) {
			voucherCode = paymentVoucherHis.getVoucherCode();
		}
		//查询退件记录表
		returnItemGQ = returnItemService.getByXmbzjWithGQEnd(xmb.getId());
		returnItemZF = returnItemService.getByXmbzjWithZFEnd(xmb.getId());

//--------- 如果不是收费处账号,则需要屏蔽下半部分信息 2020-7-27 start ---------------------------------------------
		String deptCode = this.getLoginUser().getDeptCode();
		User loginUser = this.getLoginUser();
		if ("002001".equals(deptCode)) {
			viewTag = "yes";
		}else {
			viewTag = "no";
		}
//---------- end --------------------------------------------
	if("1".equals(xmb.getIsgd())){
			
			this.setRequestAttribute("dahao", StringUtil.getDANO(xmb.getSlbh(), xmb.getDwdm()));;
		}
		return VIEW;
	}

	public String view2() throws Exception {
		Xmxxb xmb = xmxxbService.getById(spjlb.getId());
		if ((null != xmb) && (null != spjlb.getId())) {
			Map<String, Object> paraMap1 = new HashMap<String, Object>();
			paraMap1.put("slbh", xmb.getSlbh());
			spjlb = spjlbService.findSpjlball(paraMap1).get(0);
		}
		this.setRequestAttribute("xmb", xmb);
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("slbh", xmb.getSlbh());
		List<Spjkjl> ls = spjkjlService.findSpjkjlall(paraMap);// 参考可能不需要里面数据
		if (ls.size() > 0) {
			this.setRequestAttribute("sp", ls.get(0));

		}
		// List<Jkmx> ljk=jkmxService.findall(paraMap);
		//
		// if("1".equals(spjlb.getIsqitalx())){
		// Map<String, Object> paraMap1 = new HashMap<String, Object>();
		// paraMap1.put("slbh", spjlb.getSlbh());
		// List<Qtfymx> liqt=qtfymxService.findall(paraMap1);
		// }
		PaymentItemHis paymentItemHis = paymentItemHisService.getByOrderId(spjlb.getSlbh());
		if (null != paymentItemHis) {
			ECN = paymentItemHis.getZslxdbh();
		}
		PaymentVoucherHis paymentVoucherHis = paymentVoucherHisService.getPayMentByorderId(spjlb.getSlbh());
		if (null != paymentVoucherHis) {
			voucherCode = paymentVoucherHis.getVoucherCode();
		}
	if("2".equals(xmb.getIsgd())){
			
			this.setRequestAttribute("dahao", StringUtil.getDANO(xmb.getSlbh(), xmb.getDwdm()));;
		}
		return VIEW;
	}

	/**
	 * 初始化修改信息
	 */
	public String initEdit() throws Exception {
		view();
		return EDIT;
	}

	public String zhecx() throws Exception {

		Map<String, String> paramMap = new HashMap<String, String>();
		paramMap.put("bizrowid", ids);
		List<FawenAttach> attachnew;
		attachnew = fawenAttachService.queryAttachListByTempleId(paramMap);
		if(null!=attachnew&&attachnew.size()>0){
			attach=new ArrayList<FawenAttach>();
		   for (int i = 0; i < attachnew.size(); i++) {
			if(!"CAD初审图".equals(attachnew.get(i).getXmType())&&!"CAD原型图".equals(attachnew.get(i).getXmType())){
				attach.add(attachnew.get(i));
			}
		  }
		}
		return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception {
		FileInputStream in = null;
		try {
			// 设置Blob字段
			setBlobField(in);
		} finally {
			if (null != in) {
				try {
					in.close();
				} catch (Exception ex) {
				}
			}
		}

		if ("add".equalsIgnoreCase(this.flag)) {
			spjlb.setDeptId(this.getLoginUserDepartmentId());
			spjlb.setDelFlag(0);
			spjlbService.save(spjlb);
		} else {
			spjlbService.update(spjlb);
		}

		return RELOAD;
	}

	/**
	 * 将File对象转换为Blob对象，并设置到实体类中 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in) {
		if (null != spjlb) {
			try {
				// 此处将File对象转换成blob对象，并设置到spjlb中去

			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
	}

	/**
	 * 删除信息
	 */
	public String delete() throws Exception {
		try {
			spjlbService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		} catch (Exception e) {
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	public String spjlbslbh() throws Exception {
		try {
			String spjlbid="";
			Map<String, Object> paraMap = new HashMap<String, Object>();
			paraMap.put("slbh", ids);
			List<Spjlb> ls = spjlbService.findSpjlball(paraMap);
			if (ls.size() > 0) {

				Spjlb sp=ls.get(0);
					spjlbid= sp.getId();
			}
			
			this.getResponse().getWriter().println("{\"result\":true,\"spjlbid\":\"" + spjlbid + "\"}");
		} catch (Exception e) {
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	/**
	 * 
	 * 缴款状态查询
	 * 
	 * @throws Exception
	 */
	public String jkztcx() throws Exception {
		try {
			// spjlbService.deleteWithFlag(ids);
			// Xmxxb xm=xmxxbService.getById(ids);
			Map<String, Object> paramMap3 = new HashMap<String, Object>();
			Map<String, Object> cjmap = new HashMap<String, Object>();
			paramMap3.put("slbh", ids);
			cjmap.put("slbh", ids);
			cjmap.put("isjk", "0");
			List<PaymentItemPending> lps = paymentItemPendingService.findPaymentItemPending(paramMap3);
			List<Cktzs> cks = cktzsService.findByall(cjmap);
			List<PaymentItemHis> lphs = paymentItemHisService.findsuoyou(paramMap3);
			String message = "";
			if (cks.size() > 0) {
				SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
				String dateString = formatter.format(cks.get(0).getCreateTime());
				message = "未缴,已超时!  超时时间:" + dateString;
			} else {
				if (lps.size() > 0) {
					SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
					String dateString = formatter.format(lps.get(0).getCreateTime());
					message = "待缴款!  缴款通知时间:" + dateString;
				} else if (lphs.size() > 0) {
					SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
					String dateString = formatter.format(lphs.get(0).getCreateTime());
					message = "已交款! 时间:" + dateString;
				}

			}

			this.getResponse().getWriter().println("{\"result\":true,\"message\":\"" + message + "\"}");
		} catch (Exception e) {
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}

	/**
	 * 跟收费处相同的处理流程
	 * 
	 * @return
	 */

	private boolean islcbysfc(String dwdm) {
		if ("sf".equals(dwdm) || "pk".equals(dwdm) || "nb".equals(dwdm) || "ql".equals(dwdm) || "rj".equals(dwdm)
				|| "jn".equals(dwdm) || "pz".equals(dwdm) || "ls".equals(dwdm)) {
			return true;
		}
		return false;
	}

	public String getIds() {
		return ids;
	}

	public void setIds(String ids) {
		this.ids = ids;
	}

	public Pagination getPagination() {
		return pagination;
	}

	public void setPagination(Pagination pagination) {
		this.pagination = pagination;
	}

	public Spjlb getSpjlb() {
		return this.spjlb;
	}

	public void setSpjlb(Spjlb spjlb) {
		this.spjlb = spjlb;
	}

	public String getFlag() {
		return flag;
	}

	public void setFlag(String flag) {
		this.flag = flag;
	}

	public String getIsYbjks() {
		return isYbjks;
	}

	public void setIsYbjks(String isYbjks) {
		this.isYbjks = isYbjks;
	}

	public String getECN() {
		return ECN;
	}

	public void setECN(String eCN) {
		ECN = eCN;
	}

	public String getVoucherCode() {
		return voucherCode;
	}

	public void setVoucherCode(String voucherCode) {
		this.voucherCode = voucherCode;
	}

	public String getIsZslxd() {
		return isZslxd;
	}

	public void setIsZslxd(String isZslxd) {
		this.isZslxd = isZslxd;
	}

	public Date getQueryFhsjStart() {
		return this.queryFhsjStart;
	}

	public void setQueryFhsjStart(Date queryFhsjStart) {
		this.queryFhsjStart = queryFhsjStart;
	}

	public Date getQueryFhsjEnd() {
		return this.queryFhsjEnd;
	}

	public void setQueryFhsjEnd(Date queryFhsjEnd) {
		this.queryFhsjEnd = queryFhsjEnd;
	}

	public Date getQueryShsjStart() {
		return this.queryShsjStart;
	}

	public void setQueryShsjStart(Date queryShsjStart) {
		this.queryShsjStart = queryShsjStart;
	}

	public Date getQueryShsjEnd() {
		return this.queryShsjEnd;
	}

	public void setQueryShsjEnd(Date queryShsjEnd) {
		this.queryShsjEnd = queryShsjEnd;
	}

	public Date getQueryPzsjStart() {
		return this.queryPzsjStart;
	}

	public void setQueryPzsjStart(Date queryPzsjStart) {
		this.queryPzsjStart = queryPzsjStart;
	}

	public Date getQueryPzsjEnd() {
		return this.queryPzsjEnd;
	}

	public void setQueryPzsjEnd(Date queryPzsjEnd) {
		this.queryPzsjEnd = queryPzsjEnd;
	}

	public Date getQuerySlsjStart() {
		return this.querySlsjStart;
	}

	public void setQuerySlsjStart(Date querySlsjStart) {
		this.querySlsjStart = querySlsjStart;
	}

	public Date getQuerySlsjEnd() {
		return this.querySlsjEnd;
	}

	public void setQuerySlsjEnd(Date querySlsjEnd) {
		this.querySlsjEnd = querySlsjEnd;
	}

	public Date getQueryCssjStart() {
		return this.queryCssjStart;
	}

	public void setQueryCssjStart(Date queryCssjStart) {
		this.queryCssjStart = queryCssjStart;
	}

	public Date getQueryCssjEnd() {
		return this.queryCssjEnd;
	}

	public void setQueryCssjEnd(Date queryCssjEnd) {
		this.queryCssjEnd = queryCssjEnd;
	}

	public Date getQuerySlfhsjStart() {
		return this.querySlfhsjStart;
	}

	public void setQuerySlfhsjStart(Date querySlfhsjStart) {
		this.querySlfhsjStart = querySlfhsjStart;
	}

	public Date getQuerySlfhsjEnd() {
		return this.querySlfhsjEnd;
	}

	public void setQuerySlfhsjEnd(Date querySlfhsjEnd) {
		this.querySlfhsjEnd = querySlfhsjEnd;
	}

	public Date getQueryLcjssjStart() {
		return this.queryLcjssjStart;
	}

	public void setQueryLcjssjStart(Date queryLcjssjStart) {
		this.queryLcjssjStart = queryLcjssjStart;
	}

	public Date getQueryLcjssjEnd() {
		return this.queryLcjssjEnd;
	}

	public void setQueryLcjssjEnd(Date queryLcjssjEnd) {
		this.queryLcjssjEnd = queryLcjssjEnd;
	}

	public Date getQuerySlshsjStart() {
		return this.querySlshsjStart;
	}

	public void setQuerySlshsjStart(Date querySlshsjStart) {
		this.querySlshsjStart = querySlshsjStart;
	}

	public Date getQuerySlshsjEnd() {
		return this.querySlshsjEnd;
	}

	public void setQuerySlshsjEnd(Date querySlshsjEnd) {
		this.querySlshsjEnd = querySlshsjEnd;
	}

	public String getSpjlbid() {
		return spjlbid;
	}

	public void setSpjlbid(String spjlbid) {
		this.spjlbid = spjlbid;
	}

	public List<FawenAttach> getAttach() {
		return attach;
	}

	public void setAttach(List<FawenAttach> attach) {
		this.attach = attach;
	}

	public Xmhf getXmhf() {
		return xmhf;
	}

	public void setXmhf(Xmhf xmhf) {
		this.xmhf = xmhf;
	}

	public Szys getSzys() {
		return szys;
	}

	public void setSzys(Szys szys) {
		this.szys = szys;
	}

	public Sdjd getSdjd() {
		return sdjd;
	}

	public void setSdjd(Sdjd sdjd) {
		this.sdjd = sdjd;
	}

	public Xmxxb getXmxxb() {
		return xmxxb;
	}

	public void setXmxxb(Xmxxb xmxxb) {
		this.xmxxb = xmxxb;
	}

	public ReturnItem getReturnItemGQ() {
		return returnItemGQ;
	}

	public void setReturnItemGQ(ReturnItem returnItemGQ) {
		this.returnItemGQ = returnItemGQ;
	}

	public ReturnItem getReturnItemZF() {
		return returnItemZF;
	}

	public void setReturnItemZF(ReturnItem returnItemZF) {
		this.returnItemZF = returnItemZF;
	}

	public String getViewTag() {
		return viewTag;
	}

	public void setViewTag(String viewTag) {
		this.viewTag = viewTag;
	}
}
