package com.jshx.recordvoucher.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Blob;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

import javax.servlet.http.HttpServletResponse;

import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.struts2.ServletActionContext;
import org.hibernate.LobHelper;
import org.hibernate.SessionFactory;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.activiti.service.ActivitiService;
import com.jshx.billManager.entity.Indeticur;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.Struts2Util;
import com.jshx.jizihao.service.JizihaoService;
import com.jshx.jtqd.entity.Jtqd;
import com.jshx.jtqd.service.JtqdService;
import com.jshx.kjkmb.entity.Kjkmb;
import com.jshx.kjkmb.service.KjkmbService;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.User;
import com.jshx.module.form.service.AttachfileService;
import com.jshx.paymentItemDelay.entity.PaymentItemDelay;
import com.jshx.paymentItemDelay.service.PaymentItemDelayService;
import com.jshx.pjjx.entity.Pjjx;
import com.jshx.pjjx.service.PjjxService;
import com.jshx.pjjx.service.impl.PjjxServiceImpl;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.recordvoucher.entity.RecodeVoucher;
import com.jshx.recordvoucher.service.RecodeVoucherService;
import com.jshx.refundManager.entity.RefundManager;
import com.jshx.refundManager.service.RefundManagerService;
import com.jshx.tfspb.entity.Tfspb;
import com.jshx.tfspb.service.TfspbService;
import com.jshx.xmdrb.service.GenericManager;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;
import com.opensymphony.xwork2.ActionContext;

public class RecodeVoucherAction extends BaseAction
{

	/**
	 * 主键ID列表，用于接收页面提交的多条主键ID信息
	 */
	private String ids;
	private String taskId;
    private String outcome;
    private String comment;
    private String type;
    private Double salary;
    private Double salary1;
    private String zdrq;
    private String shijian;
    private String zddsj;
    private Date zdrqdate;
	/**
	 * 实体类
	 */
	private RecodeVoucher recodeVoucher = new RecodeVoucher();
	private RecodeVoucher recodeVoucher1 = new RecodeVoucher();
	/**
	 * 业务类
	 */
	@Autowired
	private JizihaoService jizihaoService;
	@Autowired
	private RecodeVoucherService recodeVoucherService;
	@Autowired
	private JtqdService jtqdService;
	@Autowired
	private PaymentVoucherHisService paymentVoucherHisService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private KjkmbService kjkmbService;
    @Autowired
    protected RuntimeService runtimeService;
    @Autowired
    protected TaskService taskService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private ActivitiService activitiService;
	@Autowired
	private TfspbService tfspbService;
	@Autowired
	private GenericManager  genericManager;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private PaymentItemDelayService paymentItemDelayService;
	@Autowired
	private RefundManagerService refundManagerService;
	/**
	 * 修改新增标记，add为新增、mod为修改
	 */
	private String flag;

	/**
	 * 分页信息
	 */
	private Pagination pagination;
	
	
	
	@Autowired()
	@Qualifier("sessionFactory")
	private SessionFactory sessionFactory;
	
	/**
	 * 执行查询的方法，返回json数据
	 */
	public void list() throws Exception{
		Map<String, Object> paraMap = new HashMap<String, Object>();

		if(pagination==null)
		    pagination = new Pagination(this.getRequest());
		    
		if(null != recodeVoucher){
		    //设置查询条件，开发人员可以在此增加过滤条件
		}
		JsonConfig config = new JsonConfig();
		config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  
		Map<String, String> codeMap = new HashMap<String, String>();
		//此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId
		
		config.registerJsonValueProcessor(String.class,new CodeJsonValueProcessor(codeMap)); 
		final String filter = "id|shDate|count|summary|caption|salary|direction|jzr|zdr|slate|zdDate|";
		if (filter != null && filter.length() > 1) {
			config.setJsonPropertyFilter(new PropertyFilter() {
				public boolean apply(Object source, String name, Object value) {
					if (filter.indexOf(name + "|") != -1)
						return false;
					else
						return true;
				}
			});
		}
		pagination = recodeVoucherService.findByPage(pagination, paraMap);
		
		convObjectToJson(pagination, config);
	}
	
	
	public String dayin() throws Exception{
	//	Xmxxb xmxxb = xmxxbService.getBySlbh(ids);
		 recodeVoucher = recodeVoucherService.getByslbh(ids, "0");
         recodeVoucher1 =recodeVoucherService.getByslbh(ids, "1"); 
		return "dayin";
	}
	public String dayintuifei() throws Exception{
		//Xmxxb xmxxb = xmxxbService.getBySlbh(ids);
		 recodeVoucher = recodeVoucherService.getByslbh(ids, "0");
         recodeVoucher1 =recodeVoucherService.getByslbh(ids, "1"); 
		return "dayin";
	}
	public String nmdayin()
	{
		 recodeVoucher = recodeVoucherService.getByslbh(ids, "0");
         recodeVoucher1 =recodeVoucherService.getByslbh(ids, "1"); 
		return "dayin";
	}
	
	/**
	 * 查看详细信息
	 */
	public String view() throws Exception{
		if((null != recodeVoucher)&&(null != recodeVoucher.getId()))
			recodeVoucher = recodeVoucherService.getById(recodeVoucher.getId());
		
		return VIEW;
	}
	


	/**
	 * 初始化修改信息正常凭证界面
	 */
	public String initEdit() throws Exception{
		
		//view();
	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");	
	SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMM");
		Xmxxb xmxxb = xmxxbService.getBySlbh(ids);
		PaymentItemDelay pa=null;
		if(xmxxb==null){
			 pa= paymentItemDelayService.getBySlbh(ids);
		}
		String sequence ="";
		Jtqd recode = jtqdService.getBySequenctId(type);
		if(recode!=null)
		{
			if("2".equals(recode.getState()))
			{
				sequence = recode.getSlate();
			}else
			{
				sequence =jizihaoService.zijibynianyuezck(sdf2.format(new Date()));
			}
		}else
		{
			sequence =jizihaoService.zijibynianyuezck(sdf2.format(new Date()));
		}
		PaymentVoucherHis his = paymentVoucherHisService.getPayMentByorderId(ids);
		
		String summary ="";
		if(xmxxb==null){
			summary = "收到"+pa.getSlbh()+pa.getDwmc()+sdf.format(his.getPrintDate())+"配套费缴费";
			recodeVoucher.setSlbh(pa.getId());
			recodeVoucher1.setSlbh(pa.getId());
		}else{
			summary = "收到"+xmxxb.getSlbh()+xmxxb.getJsdw()+sdf.format(his.getPrintDate())+"配套费缴费";
			recodeVoucher.setSlbh(xmxxb.getId());
			recodeVoucher1.setSlbh(xmxxb.getId());
		}
		Kjkmb Kjkmb =kjkmbService.getByslbh(ids, "2102");
		Kjkmb Kjkmb1 =kjkmbService.getByslbh(ids, "1030156");
		recodeVoucher.setCount(1L);
		recodeVoucher.setSlate(sequence);
		recodeVoucher.setSequenctId(type);
		recodeVoucher1.setSequenctId(type);
		recodeVoucher.setDirection("0");
		recodeVoucher.setKjkm(Kjkmb.getKjkm());
		recodeVoucher.setSalary(his.getAmount());
		recodeVoucher.setSummary(summary);
		recodeVoucher.setCaption(Kjkmb.getKemuma());
		recodeVoucher1.setCount(1L);
		recodeVoucher1.setSalary(his.getAmount());
		recodeVoucher1.setSummary(summary);
		recodeVoucher1.setCaption(Kjkmb1.getKemuma());
		recodeVoucher1.setKjkm(Kjkmb1.getKjkm());
		recodeVoucher1.setDirection("1");
	    return EDIT;
	}
	
	
	
	/**
	 * 退费界面
	 */
	public String recodeVouchertuifei() throws Exception{
		//view();
	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");	
	SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMM");
		Xmxxb xmxxb = xmxxbService.getBySlbh(ids);
		//
		String sequence ="";
		Jtqd recode = jtqdService.getBySequenctId(type);
		if(recode!=null)
		{
			if("2".equals(recode.getState()))
			{
				sequence = recode.getSlate();
			}else
			{
				sequence =jizihaoService.zijibynianyuezck(sdf2.format(new Date()));
			}
		}else
		{
			sequence =jizihaoService.zijibynianyuezck(sdf2.format(new Date()));
		}
		List<RefundManager> rms=new ArrayList<RefundManager>();
		RefundManager rm=null;
		//缓缴款表主键,新项目用退件审批表主键
		Tfspb tfspb = tfspbService.getBYslbh(ids);
		String slbhid="";
			if(null==xmxxb){
				Map<String, Object> paraMap = new HashMap<String, Object>();
				paraMap.put("slbh", ids);
				rms=refundManagerService.findRefundManager(paraMap);
				if(rms.size()>0){
					rm=rms.get(0);
					slbhid=rm.getId();
				}
			}else{
				slbhid=xmxxb.getSlbh();
			}
		
		
		flag="1";
		
		
		String summary = "收到"+tfspb.getSlbh()+tfspb.getJsdw()+sdf.format(tfspb.getCreateTime())+"配套费退费";
		Kjkmb Kjkmb =kjkmbService.getByslbhtf(ids, "2102");
		Kjkmb Kjkmb1 =kjkmbService.getByslbhtf(ids, "1030156");
		
		recodeVoucher.setCount(1L);
		recodeVoucher.setSlate(sequence);
		recodeVoucher.setDirection("0");
		recodeVoucher.setSequenctId(type);
		recodeVoucher1.setSequenctId(type);
		recodeVoucher.setSlbh(slbhid);
		recodeVoucher.setKjkm(Kjkmb.getKjkm());
		recodeVoucher.setSummary(summary);
		recodeVoucher.setCaption(Kjkmb.getKemuma());
		recodeVoucher1.setCount(1L);
		recodeVoucher1.setSummary(summary);
		recodeVoucher1.setCaption(Kjkmb1.getKemuma());
		recodeVoucher1.setKjkm(Kjkmb1.getKjkm());
		recodeVoucher1.setSlbh(slbhid);
		recodeVoucher1.setDirection("1");
	    return EDIT;
	}

	/**
	 * 保存信息（包括新增和修改）
	 */
	public String save() throws Exception{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
		 
			recodeVoucher.setDeptId(this.getLoginUserDepartmentId());
			recodeVoucher.setDelFlag(0);
			if(flag.equals("1"))
			{
				recodeVoucher.setType("1");
				recodeVoucher1.setType("1");
				recodeVoucher.setSalary("-"+recodeVoucher.getSalary());
				recodeVoucher1.setSalary(recodeVoucher.getSalary());
			} 
			else
			{
				
				recodeVoucher.setType("0");
				recodeVoucher1.setType("0");
			}
			//recodeVoucher.setZdDate(sdf.format(new Date()));
			recodeVoucher.setZdr(this.getLoginUser().getDisplayName());
			SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMM");
			
			Date date = sdf.parse(recodeVoucher.getZdDate());
			String sequence =jizihaoService.zijibynianyue(sdf2.format(date));
			
//			String sequence =jizihaoService.zijibynianyue(sdf2.format(new Date()));
			recodeVoucher.setSlate(sequence);
			recodeVoucherService.save(recodeVoucher);
			recodeVoucher1.setDeptId(this.getLoginUserDepartmentId());
			recodeVoucher1.setDelFlag(0);
			recodeVoucher1.setSlate(recodeVoucher.getSlate());
			recodeVoucher1.setZdDate(recodeVoucher.getZdDate());
			recodeVoucherService.save(recodeVoucher1);
			
				//Xmxxb xmxxb = xmxxbService.getById(recodeVoucher.getSlbh());
				Jtqd jtqd=jtqdService.getBySequenctId(recodeVoucher.getSequenctId());
				jtqd.setIszd("0");
				jtqdService.update(jtqd);
				String businessKey =recodeVoucher.getSequenctId();
			
		        Map<String, Object> variables = new HashMap<String, Object>();
		        try {
		            identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
		           runtimeService.startProcessInstanceByKey("pzzz", businessKey, variables);

		        } finally {
		            identityService.setAuthenticatedUserId(null);
		        }
		return RELOAD;
	}
	//配套费
public String tohandleTask() {
    	
        Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
        
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
         String businessKey =  processInstance.getBusinessKey();
        // Xmxxb xmxxb = xmxxbService.getById(businessKey);
         Jtqd jtqd = jtqdService.getBySequenctId(businessKey);
         flag=jtqd.getPzlx();
         recodeVoucher = recodeVoucherService.getByslbh(businessKey, "0");
         recodeVoucher1 =recodeVoucherService.getByslbh(businessKey, "1"); 
         if("1".equals(recodeVoucher.getType())&&recodeVoucher.getSalary().contains("-"))
         {
	         salary = Double.parseDouble(recodeVoucher.getSalary().substring(1));
	       
	         salary1 =  Double.parseDouble(recodeVoucher1.getSalary().substring(1));
	      
         }
        	 
        
         List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
         Set<String> myList =new HashSet<String>();
         for(String s:outcomeList)
         {
        	 myList.add(s);
         }
         outcomeList = new ArrayList(myList);
        
         ActionContext.getContext().put("outcomeList", outcomeList);
         return SUCCESS;
     }
//配套费
    public void submitTask() throws Exception{
        try {
        	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        	SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy");
        
            Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
            activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
            ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            String businessKey =  processInstance.getBusinessKey();
           // Xmxxb xmxxb = xmxxbService.getById(businessKey);
            recodeVoucher = recodeVoucherService.getByslbh(businessKey, "0");
            recodeVoucher1 = recodeVoucherService.getByslbh(businessKey, "1");
      	  Jtqd jtqd = jtqdService.getBySequenctId(businessKey);
          Map<String, Object> variables = new HashMap<String, Object>();
          if("驳回".equals(outcome)&&"凭证审核".equals(task.getName()))
          {
        	 
        	  jtqd.setIszd("");
        	  jtqd.setSlate(recodeVoucher.getSlate());
        	  jtqd.setState("2");
        	  jtqdService.update(jtqd);
        	  //审批驳回
        	  recodeVoucher.setDelFlag(1);
        	  recodeVoucherService.update(recodeVoucher);
        	  recodeVoucher1 = recodeVoucherService.getByslbh(businessKey, "1");
        	  recodeVoucher1.setDelFlag(1);
        	  recodeVoucherService.update(recodeVoucher1);
          }
          if("通过".equals(outcome)&&"凭证审核".equals(task.getName()))
          {
        	  
             
              recodeVoucher.setShDate(sdf.format(new Date()));
              recodeVoucher.setShr(this.getLoginUser().getDisplayName());
              recodeVoucherService.update(recodeVoucher);
          }
          if("通过".equals(outcome)&&"凭证记账".equals(task.getName()))
          { 
        	 // String sequence =jizihaoService.zijibynianyue(sdf2.format(new Date()));
        	  recodeVoucher.setJzr(this.getLoginUser().getDisplayName());
        	  recodeVoucher.setState("1");
        	  recodeVoucher.setJzDate(sdf1.format(new Date()));
        	 // recodeVoucher.setSlate(sequence);
        	  recodeVoucherService.update(recodeVoucher);
        	  recodeVoucher1.setState("1");
        	  recodeVoucherService.update(recodeVoucher1);
        	  jtqd.setIszd("1");
        	  jtqdService.update(jtqd);
          }
            variables.put("outcome", outcome);
            taskService.complete(taskId, variables);
            this.getResponse().getWriter().println("{\"result\":true}");
        }catch (Exception e) {
            this.getResponse().getWriter().println("{\"result\":false}");
        }
    }
    
    //年末制单启动流程
	public String startnmzdflow() throws Exception{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		FileInputStream in = null;
		try
		{
			//设置Blob字段
			setBlobField(in);
		}
		finally
		{
			if (null != in)
			{
				try
				{
					in.close();
				}
				catch (Exception ex)
				{
				}
			}
		}		
		 	Jtqd jtqd = new Jtqd();
		 	jtqd.setXmmc(recodeVoucher.getSummary());
		 	Kjkmb Kjkmb =kjkmbService.getBykmlx(recodeVoucher.getKjkm());
		 	String zsdw = zsdwService.getDwdwByzsdm(Kjkmb.getDwdm());
		 	String businessKey= UUID.randomUUID().toString().replaceAll("-", "");
		 	jtqd.setZsdw(Kjkmb.getDwdm());
		 	jtqd.setDelFlag(0);
		 	jtqd.setZsdw(zsdw);
		 	jtqd.setPzlx("2");
		 	jtqd.setSequenceId(businessKey);
		 	jtqd.setIszd("0");
		 	jtqdService.save(jtqd);
			recodeVoucher.setDeptId(this.getLoginUserDepartmentId());
			recodeVoucher.setZdDate(recodeVoucher1.getZdDate());
			recodeVoucher.setDelFlag(0);
			recodeVoucher.setSequenctId(businessKey);
			recodeVoucher.setType("2");
			recodeVoucher1.setType("2");
			//recodeVoucher1.setZdDate(sdf.format(new Date()));
			recodeVoucher1.setZdr(this.getLoginUser().getDisplayName());
			recodeVoucher1.setSequenctId(businessKey);
			
            SimpleDateFormat sdf2 = new SimpleDateFormat("yyyyMM");
			Date date = sdf.parse(recodeVoucher.getZdDate());
			String sequence =jizihaoService.zijibynianyue(sdf2.format(date));
			recodeVoucher.setSlate(sequence);
			recodeVoucher1.setSlate(sequence);
			
			//报存之前先查看 有没有删除
			
			Map<String, Object> recu = new HashMap<String, Object>();
			recu.put("type","2");
			List<String> kjs=new ArrayList<>();
			kjs.add(recodeVoucher.getKjkm());
			kjs.add(recodeVoucher1.getKjkm());
			
			recu.put("kjkm",kjs);
			
			SimpleDateFormat sdf222 = new SimpleDateFormat("yyyy");
			Date datec = sdf222.parse(recodeVoucher.getZdDate());
			recu.put("zdDate",sdf222.format(datec)+"%");
			List<RecodeVoucher> ls=recodeVoucherService.findall(recu);
			if(ls.size()>0){
				String[] array = new String[ls.size()];
				for (int i = 0; i < ls.size(); i++) {
					array[i]=ls.get(i).getId();
				}
				recodeVoucherService.delete(array);
			}
			
			
			recodeVoucherService.save(recodeVoucher);
			recodeVoucher1.setDeptId(this.getLoginUserDepartmentId());
			recodeVoucher1.setDelFlag(0);
			recodeVoucher1.setSlbh(ids);
			recodeVoucherService.save(recodeVoucher1);

		     Map<String, Object> variables = new HashMap<String, Object>();
		     try {
		            identityService.setAuthenticatedUserId(this.getLoginUser().getLoginId());
		           runtimeService.startProcessInstanceByKey("qmclpz",businessKey, variables);

		        } finally {
		            identityService.setAuthenticatedUserId(null);
		        }
		return RELOAD;
	}
	
	public Double getSalary() {
		return salary;
	}


	public void setSalary(Double salary) {
		this.salary = salary;
	}


	public Double getSalary1() {
		return salary1;
	}


	public void setSalary1(Double salary1) {
		this.salary1 = salary1;
	}


//
public String toendhandleTask() {
    	
        Task task  = taskService.createTaskQuery().taskId(taskId).singleResult();
        
         ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
         String businessKey =  processInstance.getBusinessKey();
         Jtqd jtqd = jtqdService.getBySequenctId(businessKey);
         flag=jtqd.getPzlx();
         recodeVoucher = recodeVoucherService.getByslbh(businessKey, "0");
         recodeVoucher1 =recodeVoucherService.getByslbh(businessKey, "1"); 
         List<String> outcomeList = activitiService.findOutComeListByTaskId(taskId);
         Set<String> myList =new HashSet<String>();
         for(String s:outcomeList)
         {
        	 myList.add(s);
         }
         outcomeList = new ArrayList(myList);
        
         ActionContext.getContext().put("outcomeList", outcomeList);
         return SUCCESS;
     }


public void endsubmitTask() throws Exception{
    try {
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    	SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy");
    	SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy");
        Task task = taskService.createTaskQuery().taskId(taskId).singleResult();
        activitiService.addComment(task, this.getLoginUser().getLoginId(), comment);
        ProcessInstance processInstance = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        String businessKey =  processInstance.getBusinessKey();
        recodeVoucher = recodeVoucherService.getByslbh(businessKey, "1");
        recodeVoucher1= recodeVoucherService.getByslbh(businessKey, "0");
  	  Jtqd jtqd = jtqdService.getBySequenctId(businessKey);
      Map<String, Object> variables = new HashMap<String, Object>();
      if("驳回".equals(outcome)&&"凭证审核".equals(task.getName()))
      {
    	  jtqd.setDelFlag(1);
    	  jtqdService.update(jtqd);
    	  //审批驳回
    	  recodeVoucher.setDelFlag(1);
    	  recodeVoucherService.update(recodeVoucher);
    	  recodeVoucher1.setDelFlag(1);
    	  recodeVoucherService.update(recodeVoucher1);
      }
      if("通过".equals(outcome)&&"凭证审核".equals(task.getName()))
      {
    	  
         
          recodeVoucher.setShDate(sdf.format(new Date()));
          recodeVoucher.setShr(this.getLoginUser().getDisplayName());
          recodeVoucherService.update(recodeVoucher);
      }
      if("通过".equals(outcome)&&"凭证记账".equals(task.getName()))
      {
    	 
    	  recodeVoucher.setJzr(this.getLoginUser().getDisplayName());
    	  recodeVoucher.setState("1");
    	  recodeVoucher.setJzDate(sdf1.format(new Date()));
    	  recodeVoucherService.update(recodeVoucher);
    	  recodeVoucher1.setState("1");
    	  recodeVoucherService.update(recodeVoucher1);
    	  jtqd.setIszd("1");
    	  jtqdService.update(jtqd);
      }
        variables.put("outcome", outcome);
        taskService.complete(taskId, variables);
        this.getResponse().getWriter().println("{\"result\":true}");
    }catch (Exception e) {
        this.getResponse().getWriter().println("{\"result\":false}");
    }
} 
    
    //下拉框动态改变
    public void dynamchange() throws ParseException
    {
    	 JSONObject jsonObject = new JSONObject();
    	String[] kjkm = ids.split("\\|");
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
    	SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMM");
    	
    	SimpleDateFormat ccc=new SimpleDateFormat("yyyy-MM-dd");//小写的mm表示的是分钟  
    	Date now=ccc.parse(shijian);  
  
//    	shijian.toString();
//    	Calendar ca = Calendar.getInstance();
//    	ca.add(Calendar.YEAR, -1);
//    	Date now = ca.getTime();
    	String sequence =jizihaoService.zijibynianyuezck(sdf1.format(now));
    	DecimalFormat df = new DecimalFormat("0.00"); 
    	Map<String, Object> paraMap = new HashMap<String, Object>();
		Map<String, Object> paraMap1 = new HashMap<String, Object>();
		paraMap.put("kjkm", kjkm[0]);
		paraMap1.put("kjkm", kjkm[0]);
		
		paraMap.put("jzDate","%"+sdf.format(now)+"%");
		paraMap1.put("jzDate","%"+sdf.format(now)+"%");
		List pjjxlist = recodeVoucherService.getsum(paraMap);
		BigDecimal storange = (BigDecimal) pjjxlist.get(0);
		
		Kjkmb Kjkmb =kjkmbService.getBykmlx(kjkm[1]);
		Kjkmb Kjkmb1 =kjkmbService.getBykmlx(kjkm[0]);
		String summary = "结"+sdf.format(now)+Kjkmb.getKemuma().substring(Kjkmb.getKemuma().lastIndexOf("\\")+1)+"配套费";
		try {
			getResponse().setContentType("application/json;charset=UTF-8");
			getResponse().setCharacterEncoding("utf-8");
			getResponse().setHeader("Charset", "utf-8");
			getResponse().setHeader("Cache-Control", "no-cache");
			
			Map<String, Object> recu = new HashMap<String, Object>();
			recu.put("type","2");
			List<String> kjs=new ArrayList<>();
			kjs.add(kjkm[0]);
			kjs.add(kjkm[1]);
			
			recu.put("kjkm",kjs);
			recu.put("zdDate",sdf.format(now)+"%");
			List<RecodeVoucher> ls=recodeVoucherService.findall(recu);
			if(ls.size()>0){
				String panduan="1";
				for (RecodeVoucher bean : ls) {
					if("1".equals(bean.getState())){
						//已经走完流程审批 记账了...
						panduan="2";
						jsonObject.put("summary", summary);
						jsonObject.put("salary",df.format(storange.doubleValue()));
						jsonObject.put("caption",Kjkmb.getKemuma());
						jsonObject.put("captiond",Kjkmb1.getKemuma());
						jsonObject.put("slate",sequence);
					}
				}
				jsonObject.put("panduan", panduan);
			}else{
				
				jsonObject.put("panduan", "0");
				jsonObject.put("summary", summary);
				jsonObject.put("salary",df.format(storange.doubleValue()));
				jsonObject.put("caption",Kjkmb.getKemuma());
				jsonObject.put("captiond",Kjkmb1.getKemuma());
				jsonObject.put("slate",sequence);
			}
			
			getResponse().getWriter().println(jsonObject.toString());
			
		} catch (IOException e) {
			e.printStackTrace();
		}
    }
	
//年末制单
    public String recodeVoucherpmclpz()
    {
    	SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
    	SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMM");
    	
    
    	Calendar ca = Calendar.getInstance();
    	ca.add(Calendar.YEAR, -1);
    	Date now = ca.getTime();
    	String sequence =jizihaoService.zijibynianyuezck(sdf.format(now)+"12");
    	Map<String, Object> paraMap = new HashMap<String, Object>();
		Map<String, Object> paraMap1 = new HashMap<String, Object>();
		paraMap.put("kjkm", "21020101");
		paraMap1.put("kjkm", "21020101");
		paraMap.put("jzDate","%"+sdf.format(now)+"%");
		paraMap1.put("jzDate","%"+sdf.format(now)+"%");
		List pjjxlist = recodeVoucherService.getsum(paraMap);
		BigDecimal storange = (BigDecimal) pjjxlist.get(0);
		//List tflist = recodeVoucherService.getsum(paraMap1);
		//BigDecimal tfstorange = (BigDecimal) tflist.get(0);
	//	Double salary =storange.doubleValue()-tfstorange.doubleValue();
		Kjkmb Kjkmb =kjkmbService.getBykmlx("1031560101");
		Kjkmb Kjkmb1 =kjkmbService.getBykmlx("21020101");
		String summary = "结"+sdf.format(now)+Kjkmb.getKemuma().substring(Kjkmb.getKemuma().lastIndexOf("\\")+1)+"配套费";
		
		recodeVoucher1.setCount(1L);
		recodeVoucher.setSalary(storange.toString());
		recodeVoucher.setSlate(sequence);
		recodeVoucher1.setSlate(sequence);
		recodeVoucher.setDirection("0");
		recodeVoucher.setKjkm(Kjkmb.getKjkm());
		recodeVoucher.setSummary(summary);
		recodeVoucher.setCaption(Kjkmb.getKemuma());
		recodeVoucher1.setSummary(summary);
		recodeVoucher1.setCaption(Kjkmb1.getKemuma());
		recodeVoucher1.setKjkm(Kjkmb1.getKjkm());
		recodeVoucher1.setSalary(storange.toString());
		recodeVoucher1.setDirection("1");
    	
    	return SUCCESS;
    }
	/**
	 * 将File对象转换为Blob对象，并设置到实体类中
	 * 如果没有File对象，可删除此方法，并一并删除save方法中调用此方法的代码
	 */
	private void setBlobField(FileInputStream in)
	{
		if (null != recodeVoucher)
		{
			try
			{
				//此处将File对象转换成blob对象，并设置到recodeVoucher中去
				
            }
            catch (Exception ex)
            {
                ex.printStackTrace();
            }
        }
    }

	/**
	 * 删除信息
	 */
	public String delete() throws Exception{
	    try{
			recodeVoucherService.deleteWithFlag(ids);
			this.getResponse().getWriter().println("{\"result\":true}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	/**
	 * 查看记字号
	 * @return
	 * @throws Exception
	 */
	public String ckjzh() throws Exception{
		try{
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			Date date = sdf.parse(zdrq);
			SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMM");
			String sequence =jizihaoService.zijibynianyuezck(sdf1.format(date));
//			this.getResponse().getWriter().println("{\"result\":true}");
			this.getResponse().getWriter().println("{\"result\":true,\"message\":\"" + sequence + "\"}");
		}catch(Exception e){
			this.getResponse().getWriter().println("{\"result\":false}");
		}
		return null;
	}
	
	public String getIds(){
		return ids;
	}

	public void setIds(String ids){
		this.ids = ids;
	}

	public Pagination getPagination(){
		return pagination;
	}

	public void setPagination(Pagination pagination){
		this.pagination = pagination;
	}

	public RecodeVoucher getRecodeVoucher(){
		return this.recodeVoucher;
	}

	public void setRecodeVoucher(RecodeVoucher recodeVoucher){
		this.recodeVoucher = recodeVoucher;
	}

	public String getFlag(){
		return flag;
	}

    public void setFlag(String flag){
        this.flag = flag;
    }

	public String getTaskId() {
		return taskId;
	}

	public void setTaskId(String taskId) {
		this.taskId = taskId;
	}

	public String getOutcome() {
		return outcome;
	}

	public void setOutcome(String outcome) {
		this.outcome = outcome;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public RecodeVoucher getRecodeVoucher1() {
		return recodeVoucher1;
	}

	public void setRecodeVoucher1(RecodeVoucher recodeVoucher1) {
		this.recodeVoucher1 = recodeVoucher1;
	}


	public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}


	public String getZdrq() {
		return zdrq;
	}


	public void setZdrq(String zdrq) {
		this.zdrq = zdrq;
	}


	public String getShijian() {
		return shijian;
	}


	public void setShijian(String shijian) {
		this.shijian = shijian;
	}


	public String getZddsj() {
		return zddsj;
	}


	public void setZddsj(String zddsj) {
		this.zddsj = zddsj;
	}


	public Date getZdrqdate() {
		return zdrqdate;
	}


	public void setZdrqdate(Date zdrqdate) {
		this.zdrqdate = zdrqdate;
	}
       
    
}
