package com.jshx.paymentItemDelayFree.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.paymentItemDelayFree.entity.PaymentItemDelayFree;
import com.jshx.paymentItemDelayFree.dao.PaymentItemDelayFreeDao;

@Component("paymentItemDelayFreeDao")
public class PaymentItemDelayFreeDaoImpl extends BaseDaoImpl implements PaymentItemDelayFreeDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findPaymentItemDelayFreeByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findPaymentItemDelayFree(Map<String, Object> paraMap){
		return this.findListByHqlId("findPaymentItemDelayFreeByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public PaymentItemDelayFree getById(String id)
	{
		return (PaymentItemDelayFree)this.getObjectById(PaymentItemDelayFree.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(PaymentItemDelayFree paymentItemDelayFree)
	{
		paymentItemDelayFree.setId(null);
		this.saveOrUpdateObject(paymentItemDelayFree);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(PaymentItemDelayFree paymentItemDelayFree)
	{
		this.saveOrUpdateObject(paymentItemDelayFree);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(PaymentItemDelayFree.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		PaymentItemDelayFree paymentItemDelayFree = (PaymentItemDelayFree)this.getObjectById(PaymentItemDelayFree.class, id);
		paymentItemDelayFree.setDelFlag(1);
		this.saveObject(paymentItemDelayFree);
	}
}
