package com.jshx.mobile.web;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

import org.activiti.engine.FormService;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;

import com.jshx.account.paymentVoucherHis.entity.PaymentVoucherHis;
import com.jshx.account.paymentVoucherHis.service.PaymentVoucherHisService;
import com.jshx.activiti.service.ActivitiService;
import com.jshx.common.utils.Constant;
import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.dao.JdbcUtil;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.json.CodeJsonValueProcessor;
import com.jshx.core.json.DateJsonValueProcessor;
import com.jshx.core.utils.CodeUtil;
import com.jshx.core.utils.Constants;
import com.jshx.fawen.entity.Fawen;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.fawen.entity.FawenReceiveinfo;
import com.jshx.fawen.service.FawenAttachService;
import com.jshx.fawen.service.FawenReceiveinfoService;
import com.jshx.fawen.service.FawenService;
import com.jshx.jktzs.entity.Jktzs;
import com.jshx.jktzs.service.JktzsService;
import com.jshx.makereport.entity.Makereport;
import com.jshx.makereport.service.MakereportService;
import com.jshx.mobile.service.MobileManager;
import com.jshx.mobile.utils.DecodeStr;
import com.jshx.mobile.utils.JsonUtil;
import com.jshx.module.admin.entity.Code;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.entity.UserRight;
import com.jshx.module.admin.entity.UserRole;
import com.jshx.module.admin.service.CodeService;
import com.jshx.module.admin.service.DeptService;
import com.jshx.module.admin.service.UserLinkedDeptService;
import com.jshx.module.admin.service.UserRoleService;
import com.jshx.module.admin.service.UserService;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.returnItem.entity.ReturnItem;
import com.jshx.schedule.entity.Schedule1;
import com.jshx.schedule.service.Schedule1Service;
import com.jshx.spjkjl.entity.Spjkjl;
import com.jshx.spjkjl.service.SpjkjlService;
import com.jshx.spjlb.entity.Spjlb;
import com.jshx.spjlb.service.SpjlbService;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.zsdw.service.ZsdwService;

import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import net.sf.json.util.PropertyFilter;

/**
 * 
 * @author 毛颖飞
 */

public class TbScheduleAction extends BaseAction {

	private String para;

	private String callback;

	private String cpage; // 当前页数

	private String len; // 每页条数

	private String jsonString; // 返回JSON

	private Pagination pagination;

	@Autowired
	private UserService userService;
	@Autowired
	private MobileManager mobileManager;
	@Autowired
	private RuntimeService runtimeService;
	@Autowired
	private IdentityService identityService;
	@Autowired
	private TaskService taskService;
	@Autowired
	private JdbcUtil jdbcUtil;
	@Autowired
	private HistoryService historyService;
	@Autowired
	private UserRoleService userRoleService;
	@Autowired
	private ActivitiService activitiService;
	@Autowired
	protected FormService formService;
	@Autowired
	protected RepositoryService repositoryService;
	@Autowired
	protected ProcessEngine processEngine;
	@Autowired
	private DeptService deptService;
	@Autowired
	private UserLinkedDeptService userLinkedDeptService;
	@Autowired
	private CodeService codeService;
	@Autowired
	private XmxxbService xmxxbService;
	@Autowired
	private ZsdwService zsdwService;
	@Autowired
	private Schedule1Service schedule1Service;
	@Autowired
	private FawenService fawenService;
	@Autowired
	private FawenAttachService fawenAttachService;
	@Autowired
	private FawenReceiveinfoService fawenReceiveService;
	@Autowired
	private MakereportService makereportService;
	@Autowired
	private SpjlbService spjlbService;
	@Autowired
	private PaymentVoucherHisService paymentVoucherHisService;
	@Autowired
	private PaymentItemHisService paymentItemHisService;
	@Autowired
	private JktzsService jktzsService;
	@Autowired
	private SpjkjlService spjkjlService;
	
	/**
	 * 用户信息修改接口
	 */
	public void userInfoModify() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		/**
		 * map中包含 userName 用户名 主键，判断是否注册 realName 真实姓名 password 密码 telephone 手机号
		 */
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {

			String str = "{ \"message\": \"更新失败\",\"code\": \"1000\"}";
			User user = new User();
			user = userService.findUserByLoginId(map.get("userName"));

			if (null != map.get("oldPassword")
					&& CodeUtil.encode(map.get("oldPassword").toString(), "MD5").endsWith(user.getPassword())) {
				if (null != map.get("realName"))
					user.setDisplayName(map.get("realName"));
				if (null != map.get("newPassword"))
					user.setPassword(CodeUtil.encode(map.get("newPassword").toString(), "MD5"));
				if (null != map.get("telephone"))
					user.setMobile(map.get("telephone"));
				try {
					str = "{ \"message\": \"更新成功\",\"code\": \"0\"}";
					mobileManager.saveOrUpdate(user);
				} catch (Exception e1) {
					// TODO Auto-generated catch block
					str = "{ \"message\": \"更新失败\",\"code\": \"1000\"}";
					e1.printStackTrace();
				}
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}

	/**
	 * 用户密码修改
	 * 
	 * @throws Exception
	 */
	public void passwdModify() throws Exception {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		/**
		 * map中包含 userName 用户名 oldPassword 用户老密码 newPassword 用户新密码
		 */
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {

			String str = "{ \"message\": \"修改失败\",\"code\": \"1000\"}";
			User user = new User();

			user = userService.checkPassword(map.get("userName"),
					CodeUtil.encode(map.get("oldPassword"), CodeUtil.MD5));
			if (null != user) {
				userService.modifyPassword(user.getId(), map.get("newPassword"));
				str = "{ \"message\": \"密码修改成功\",\"code\": \"0\"}";
			} else {
				str = "{ \"message\": \"原密码错误\",\"code\": \"1000\"}";
			}

			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	/**
	 * 用户登录接口
	 */
	public void userLogin() {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		String isSendDoc = "";
		String isAssessment = "";
		String isAdmin = "";
		String isInspectionDept="";
		/**
		 * map中包含 userName;password 增加用户登录成功时返回邮箱信息
		 */
		map = der.getPostPara(para, callback);

		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String str = "{ \"message\": \"登录失败\",\"code\": \"1000\"}";
			paraMap.put("SqlId", map.get("userName"));
			paraMap.put("loginId", "login");

			User user = (User) mobileManager.getObjectByProperty(User.class, new String[] { "delFlag", "loginId" },
					new Object[] { 0, map.get("userName").toString() });
			if (user == null) {
				str = "{ \"message\": \"用户名或密码错误\",\"code\": \"1000\"}";
			} else {
				if (user.getId().isEmpty()) {
					str = "{ \"message\": \"用户名不存在\",\"code\": \"1000\"}";
				}
				if (!CodeUtil.encode(map.get("password").toString(), "MD5").equals(user.getPassword())) {
					str = "{ \"message\": \"密码错误\",\"code\": \"1000\"}";
				}
				List list = user.getUserRoles();
				String strObj = "";
				int i = 0;
				if (list != null && list.size() > 0) {
					for (Object object : list) {
						UserRight userRigh = (UserRight) object;
						UserRole userRole = userRigh.getRole();
						if (i != 0) {
							strObj += ",\"roleType" + i + "\":\"" + userRole.getRoleType() + "\",\"roleCode" + i
									+ "\":\"" + userRole.getRoleCode() + "\",\"roleName" + i + "\":\""
									+ userRole.getRoleName() + "\"";
						}else
						{
							strObj = ",\"roleType\":\"" + userRole.getRoleType() + "\",\"roleCode\":\""
									+ userRole.getRoleCode() + "\",\"roleName\":\"" + userRole.getRoleName() + "\"";
						}
						i++;
					}
				}

				if (user.getMobile() == null) {
					user.setMobile("");
				}

				if (null != user && !user.getId().isEmpty()) {
					if (user.getDisplayName() == null) {
						user.setDisplayName("");
					}
					ResourceBundle rb = ResourceBundle.getBundle("system");
					String userPic = "";
					String lng = "";
					String lat = "";

					Map jfmap = new HashMap();
					jfmap.put("SqlId", "getPartyIntegralStatistics");
					List jflist = mobileManager.findListBySqlId(jfmap);
					String rank = "0";
					String allRank = "0";
					String myPoint = "0";
					if (null != jflist && jflist.size() > 0) {
						for (int j = 0; j < jflist.size(); j++) {
							Map m = (Map) jflist.get(j);
							if (m.get("userId").equals(user.getId())) {
								myPoint = String.valueOf(m.get("total"));
								allRank = String.valueOf(j + 1);
								break;
							}

						}
					}
					if (!myPoint.equals("0")) {
						jfmap.put("deptId", user.getDept().getId());
						List zblist = mobileManager.findListBySqlId(jfmap);
						if (null != zblist && zblist.size() > 0) {
							for (int j = 0; j < zblist.size(); j++) {
								Map m = (Map) zblist.get(j);
								if (m.get("userId").equals(user.getId())) {
									rank = String.valueOf(j + 1);
									break;
								}

							}
						}
					}

					if (CodeUtil.encode(map.get("password").toString(), "MD5").equals(user.getPassword())) {
						str = "{ \"message\": \"登录成功\",\"code\": \"0\",\"userId\": \"" + user.getId()
								+ "\",\"userName\": \"" + user.getLoginId() + "\",\"realName\": \""
								+ user.getDisplayName() + "\", \"email\": \"" + user.getEmail()
								+"\", \"isSendDoc\": \"" + isSendDoc+"\", \"isAssessment\": \"" + isAssessment
								+"\", \"isAdmin\": \"" + isAdmin+"\", \"isInspectionDept\": \"" + isInspectionDept
								+ "\", \"telephone\": \"" + user.getMobile() + "\", \"deptId\": \""
								+ user.getDept().getId() + "\", \"deptName\": \"" + user.getDept().getDeptName()
								+ "\",\"lng\": \"" + lng + "\",\"lat\": \"" + lat + "\",\"rank\": \"" + rank
								+ "\",\"allRank\": \"" + allRank + "\",\"myPoint\": \"" + myPoint + "\",\"userPic\": \""
								+ userPic + "\"" + strObj + "}";
					}
				}
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}

	/**
	 * 自动更新
	 */
	public void autoUpdate() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			ResourceBundle rb = ResourceBundle.getBundle("system");
			// 从系统常量获取系统版本
			Map<String,Object> paraMap=new HashMap<>();
			paraMap.put("codeName", "安卓版本");
            pagination = new Pagination(0,20);
            pagination=codeService.findCodeByPage(pagination, paraMap);
            List<Code> codeList=pagination.getListOfObject();
            if(codeList!=null&&codeList.size()>0){
            	paraMap.put("codeId", codeList.get(0).getId());
     			paraMap.put("SqlId", "apkSql");
     			List list=  mobileManager.findListBySqlId(paraMap);
     			if(list!=null&&list.size()>0){
     				String version =(String) ((Map)list.get(0)).get("item_value");
     				String str = "{ \"message\": \"成功\",\"code\": \"0\" ,\"url\":\"" + rb.getString("sysUrl")
     						+ "upload1/apk/njzsc.apk\",\"version\":\"" + version + "\"}";
     				JsonUtil.printJsonString(getResponse(), str);
     			}
     			else{
                	String str = "{ \"message\": \"失败\",\"code\": \"1000\" }";
                	JsonUtil.printJsonString(getResponse(), str);
     			}
            }
            else{
            	String str = "{ \"message\": \"失败\",\"code\": \"1000\" }";
            	JsonUtil.printJsonString(getResponse(), str);
            }
           
			
			
		}
	}
	
	
	
	public void toAssigneeList(){
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			String uu=map.get("userId");
			
//			String userId = map.get("userId");
			String pageNum = map.get("cpage");
			String pageSize = map.get("len");
			try {
	            // 综合用户ID\角色\角色部门组合等
	            List<String> groups = new ArrayList<>();
//	            User loginUser = userService.findUserByLoginId(userId);
	            User loginUser= userService.findUserById(uu);
	            List<UserRight> roles = (List<UserRight>) loginUser.getUserRoles();
	            if (roles != null) {
	                for (UserRight role : roles) {
	                    groups.add(role.getRole().getRoleName());
	                    groups.add(loginUser.getDeptCode() + "|" + role.getRole().getRoleName());
	                }
	            }

	            pagination = new Pagination(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
//	            TaskQuery claimedTaskQuery = taskService.createTaskQuery().taskCandidateGroupIn(groups);
	            TaskQuery claimedTaskQuery = taskService.createTaskQuery().taskCandidateOrAssigned(loginUser.getLoginId());
	            /*if(null != processDefName && !"".equals(processDefName.trim())){
	            	claimedTaskQuery = claimedTaskQuery.processDefinitionNameLike("%"+this.processDefName+"%");
	            }*/
	            
	            if (!groups.isEmpty())
	                claimedTaskQuery.taskCandidateGroupIn(groups);

	            claimedTaskQuery.active().orderByTaskId().desc(); 
	            List<Task> claimedTaskList = claimedTaskQuery.listPage(0, 30);
	                    
	            //刷新任务列表
//	            claimedTaskList = claimedTaskQuery.listPage(pagination.getFirstResult(), pagination.getPageSize());
	            
	            List<HashMap<String, Object>> mapList = new ArrayList<>();
	            List<HashMap<String, Object>> mapListyr = new ArrayList<>();
	            List<HashMap<String, Object>> mapListwr = new ArrayList<>();
	            for (Task task : claimedTaskList) {
	                HashMap<String, Object> resultMap = new HashMap<>();
	                Date claimTime = historyService.createHistoricTaskInstanceQuery().taskId(task.getId()).singleResult().getClaimTime();
	                String businesskey = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult().getBusinessKey();
	                if(null!=businesskey){
	                	Xmxxb xmxxb = xmxxbService.getById(businesskey);
	                	 if(null!=xmxxb){
	                		 resultMap.put("XMMC", xmxxb.getXmmc());
	                		 resultMap.put("DWMC", xmxxb.getJsdw());
	                		 resultMap.put("SLBH", xmxxb.getSlbh());
	                     }else{
	                    	 resultMap.put("XMMC", "");
	                    	 resultMap.put("DWMC", "");
	                    	 resultMap.put("SLBH", "");
	                     }
	                }else{
	                	resultMap.put("XMMC", "");
	                	 resultMap.put("DWMC", "");
	                	resultMap.put("SLBH", "");
	                }
	                resultMap.put("processInstanceId", task.getProcessInstanceId());
	                resultMap.put("TASK_ID", task.getId());
	                resultMap.put("TASK_NAME", task.getName());
	                resultMap.put("BUSINESS_KEY", businesskey);
	                resultMap.put("CREATE_TIME", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(task.getCreateTime()));
//	                List<Comment> commentList = taskService.getProcessInstanceComments(task.getProcessInstanceId());
//	                String syjfqr="";
//	                if(null!=commentList&&commentList.size()>0){
//	                	User uu=userService.findUserByLoginId(commentList.get(0).getUserId());
//	                	   if(null!=uu){
//	                		   syjfqr=uu.getDisplayName() ;
//	                       }else{
//	                    	   syjfqr= commentList.get(0).getUserId();
//	                       }
//	                }
//	                map.put("syjfqr", syjfqr);
	                if(null!=claimTime){
	                	resultMap.put("claimTime", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(claimTime));
	                }else{
	                	resultMap.put("claimTime", "");
	                }
	                resultMap.put("description", task.getDescription());
	                resultMap.put("assignee", task.getAssignee());
	                if(null!=task.getAssignee()&&!"".equals(task.getAssignee())){
//	                	mapListyr.add(resultMap);
	                }else if(pd(task.getName())){
	                	
	                	mapListwr.add(resultMap);
	                }
	            }
	            if(mapListwr.size()>0){
	            	for (HashMap<String, Object> hashMapwr : mapListwr) {
	            		mapList.add(hashMapwr);
	            	}
	            }

	            StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\", \"totalCount\": \"");
				sb.append(mapList.size());
				sb.append("\",\"data\": ");
				sb.append(JSONArray.fromObject(mapList));
				sb.append("}");
	            
	            str = sb.toString();
	        	System.out.println("传输到手机端：" + str);
	        } catch (Exception e) {
	        	e.printStackTrace();
	        }
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	
	private boolean pd(String name) {
         if("缴费审核".equals(name)||"缴费审定".equals(name)||"缴费批准".equals(name)||"面积修改审核".equals(name)||"退件审核".equals(name)||"解锁审核".equals(name)||"催缴审阅".equals(name)){
        	 return true;
         }
		return false;
	}

	public void todoList(){
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			Map<String,Object> paraMap = new HashMap<String,Object>();
			Pagination pagination = new Pagination(this.getRequest());
			pagination.setPageNumber(null == map.get("cpage") ? 10 : Integer.parseInt(map.get("cpage")));
			pagination.setPageSize(null == map.get("len") ? 1 : Integer.parseInt(map.get("len")));

			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				String userId = map.get("userId");
				User  user=userService.findUserById(userId);
				paraMap.put("SqlId", "todoList");
				paraMap.put("loginId", user.getLoginId());
				pagination = mobileManager.findBySqlId(pagination, paraMap);
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\", \"totalCount\": \"");
				sb.append(pagination.getTotalCount());
				sb.append("\",\"data\": ");
				sb.append(JsonUtil.listmapToJsonString(pagination.getList()));
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	

	public void authUser(){
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String userName=map.get("userName");
			String newPassword=map.get("newPassword");
			Subject currentUser = SecurityUtils.getSubject();

			UsernamePasswordToken token= new UsernamePasswordToken(userName, CodeUtil.encode(newPassword, CodeUtil.MD5));
			token.setRememberMe(false);
			try
			{
				currentUser.login(token);
			} catch (AuthenticationException e)
			{
				String str = "{ \"message\": \"用户名密码错误\",\"code\": \"1000\"}";

				JsonUtil.printJsonString(getResponse(), str);
				return ;
			}
			
			if (currentUser.isAuthenticated()){
				User user=getLoginUser();
				StringBuilder sb = new StringBuilder();

				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				
				sb.append(",\"userId\": ");
				sb.append("\""+user.getId()+"\"");
				sb.append(",\"phone\": ");
				sb.append("\""+user.getMobile()+"\"");
				sb.append(",\"deptId\": ");
				sb.append("\""+user.getDept().getId()+"\"");
				sb.append(",\"deptName\": ");
				sb.append("\""+user.getDept().getDeptName()+"\"");
				sb.append(",\"dwdm\": ");
				sb.append("\""+zsdwService.getDwdm(user.getDept().getId())+"\"");
				sb.append(",\"realName\": ");
				sb.append("\""+user.getDisplayName()+"\"");
				
				sb.append("}");
				String  str = sb.toString();
				System.out.println("传输到手机端：" + str);
				JsonUtil.printJsonString(getResponse(), str);
			}
			else{
				String str = "{ \"message\": \"用户未通过验证\",\"code\": \"1000\"}";

				JsonUtil.printJsonString(getResponse(), str);
				return ;
			}
			
			
			
		}
	}
	
	/**
	 * 日程安排列表接口
	 * 
	 * @return
	 */

	public void schedule1Query() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			Pagination pagination = new Pagination(this.getRequest());
			pagination.setPageNumber(null == map.get("cpage") ? 1 : Integer.parseInt(map.get("cpage")));
			pagination.setPageSize(null == map.get("len") ? 100 : Integer.parseInt(map.get("len")));
			
//			String userId=map.get("userId");
			String startYearsDate=map.get("startYearsDate");
			String endYearsDate=map.get("endYearsDate");

			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				if (null != startYearsDate){
					paraMap.put("startYearsDate", startYearsDate);
				}
				if (null != endYearsDate){
					paraMap.put("endYearsDate", endYearsDate);
				}
//				paraMap.put("createUserID", userId);
				
				JsonConfig config = new JsonConfig();
				config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor()); 
				final String filter = "id|operator|startdate|enddate|event|remark|location|week|noon|";
				if (filter != null && filter.length() > 1) {
					config.setJsonPropertyFilter(new PropertyFilter() {
						public boolean apply(Object source, String name, Object value) {
							if (filter.indexOf(name + "|") != -1)
								return false;
							else
								return true;
						}
					});
				}
				
				pagination=schedule1Service.findByPage(pagination, paraMap);
				List<Schedule1> list = pagination.getListOfObject();
				for(Schedule1 schedule1 : list)
				{
					schedule1.setExtPro(schedule1);
				}
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\", \"totalCount\": \"");
				sb.append(pagination.getTotalCount());
				sb.append("\",\"data\": ");
				sb.append(JSONArray.fromObject(pagination.getListOfObject(), config));
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	/**
	 * 日程安排列表接口
	 * 
	 * @return
	 */

	public void scheduleView() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			
			
			String infoid=map.get("infoid");
			String userId=map.get("userId");

			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

				Schedule1 schedule1 = schedule1Service.getById(infoid);
				
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				sb.append(",\"startdate\": ");
				sb.append("\""+schedule1.getStartdate()+"\"");
                sb.append(",\"enddate\": ");
				sb.append("\""+schedule1.getEnddate()+"\"");

				sb.append(",\"location\": ");
				sb.append("\""+schedule1.getLocation()+"\"");

				sb.append(",\"event\": ");
				sb.append("\""+schedule1.getEvent()+"\"");

				sb.append(",\"remark\": ");
				sb.append("\""+schedule1.getRemark()+"\"");
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	

	/**
	 * 文件管理列表接口
	 * 
	 * @return
	 */

	public void fawenListreceiveQuery() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			Pagination pagination = new Pagination(this.getRequest());
			pagination.setPageNumber(null == map.get("cpage") ? 0 : Integer.parseInt(map.get("cpage")));
			pagination.setPageSize(null == map.get("len") ? 10 : Integer.parseInt(map.get("len")));
			
			String userId=map.get("userId");
			String startYearsDate=map.get("startYearsDate");
			String endYearsDate=map.get("endYearsDate");

			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				if (null != startYearsDate){
					paraMap.put("startSendtime", startYearsDate);

				}
				if (null != endYearsDate){
					paraMap.put("endSendtime", endYearsDate);
				}
				paraMap.put("userId", userId);
				
				JsonConfig config = new JsonConfig();
				config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
				// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

				final String filter = "id|title|content|senduserid|senddate|senduserName|receiveuserName|state|receiveList|notReceiveList|";
				if (filter != null && filter.length() > 1)
				{
					config.setJsonPropertyFilter(new PropertyFilter()
					{
						public boolean apply(Object source, String name, Object value)
						{
							if (filter.indexOf(name + "|") != -1)
								return false;
							else
								return true;
						}
					});
				}
				pagination = fawenService.findMailSendByPage(pagination, paraMap);
				List list = pagination.list;
				List<Fawen> fawenList = new ArrayList<Fawen>();

				for (int i = 0; i < list.size(); i++)
				{
					Object[] obj = (Object[]) list.get(i);
					Fawen f = new Fawen();
					f.setId(obj[0].toString());
					f.setTitle(obj[1].toString());
					f.setSenduserName(obj[3].toString());
					f.setSenddate(obj[4].toString());
					f.setState(obj[5].toString());
					fawenList.add(f);
				}
				pagination.setList(fawenList);
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\", \"totalCount\": \"");
				sb.append(pagination.getTotalCount());
				sb.append("\",\"data\": ");
				sb.append(JSONArray.fromObject(pagination.getListOfObject(), config));
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	/**
	 * 日程安排列表接口
	 * 
	 * @return
	 */

	public void fawenvied() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			
			
			String infoid=map.get("infoid");
			String userId=map.get("userId");
			User user=userService.findUserById(userId);
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

				Fawen fawen  = fawenService.getById(infoid);
				
			
				
				
				Map<String, String> paramMap = new HashMap<String, String>();
				Map<String, String> paramMap1 = new HashMap<String, String>();
				paramMap.put("bizrowid", fawen.getId());
				List<FawenAttach> attach = fawenAttachService.queryAttachListByTempleId(paramMap);
				paramMap1.put("inneremailid", fawen.getId());
				paramMap1.put("receiveuserid", userId);
				FawenReceiveinfo info = fawenReceiveService.oaReceiveinfo_recieverList(paramMap1);
				info.setReceivestatus("2");
				fawenReceiveService.update(info);
			
				if(fawen.getNotReceiveList()!=null){
					if(fawen.getNotReceiveList().indexOf(user.getDisplayName())!=-1){
						String flag=fawen.getNotReceiveList().substring(fawen.getNotReceiveList().indexOf(user.getDisplayName()));	
						if(flag.indexOf(",")==-1){
							String notReceiveList=fawen.getNotReceiveList().replace(user.getDisplayName(), "");
							fawen.setNotReceiveList(notReceiveList);
						}else{
							String notReceiveList=fawen.getNotReceiveList().replace(user.getDisplayName()+",", "");
							fawen.setNotReceiveList(notReceiveList);
						}
						
						if(fawen.getReceiveList()==null){
							String receiveList=user.getDisplayName()+",";	
							fawen.setReceiveList(receiveList);
						}else{
							String receiveList=new StringBuffer(fawen.getReceiveList()).append(user.getDisplayName()+",").toString();	
							fawen.setReceiveList(receiveList);
						}
						fawenService.update(fawen);
					}
				}
				
				List<Map<String,Object>> list=new ArrayList<>();
				if(attach!=null&&attach.size()>0){
					for(FawenAttach  att: attach){
						Map<String,Object> attachMap=new HashMap<>();
						attachMap.put("fjAddr", att.getAttachpath());
						attachMap.put("attachname", att.getAttachname());
						list.add(attachMap);
					}
				}
				
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				sb.append(",\"senddate\": ");
				sb.append("\""+fawen.getSenddate()+"\"");
				
				sb.append(",\"receiveuserName\": ");
				sb.append("\""+fawen.getReceiveuserName()+"\"");

				sb.append(",\"title\": ");
				sb.append("\""+fawen.getTitle()+"\"");

				sb.append(",\"content\": ");
				sb.append("\""+fawen.getContent()+"\"");
				sb.append(",\"senduserName\": ");
				sb.append("\""+fawen.getSenduserName()+"\"");
				sb.append(",\"fjlist\": ");
				sb.append(JsonUtil.listmap_to_json_string(list));
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	
	

	/**
	 * 政策文件列表接口
	 * 
	 * @return
	 */

	public void makereportQuery() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			Pagination pagination = new Pagination(this.getRequest());
			pagination.setPageNumber(null == map.get("cpage") ? 0 : Integer.parseInt(map.get("cpage")));
			pagination.setPageSize(null == map.get("len") ? 10 : Integer.parseInt(map.get("len")));
			
			String userId=map.get("userId");
			String startSendtime=map.get("startSendtime");
			String endSendtime=map.get("endSendtime");

			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				if (null != startSendtime){
					paraMap.put("startSendtime", startSendtime);

				}
				if (null != endSendtime){
					paraMap.put("endSendtime", endSendtime);
				}
				
				JsonConfig config = new JsonConfig();
				config.registerJsonValueProcessor(java.util.Date.class,new DateJsonValueProcessor());  

				final String filter = "id|filename|referenceNumber|publishedDate|abolitionDate|jianmianType|clauses|receivename|deptName|";
				if (filter != null && filter.length() > 1) {
					config.setJsonPropertyFilter(new PropertyFilter() {
						public boolean apply(Object source, String name, Object value) {
							if (filter.indexOf(name + "|") != -1)
								return false;
							else
								return true;
						}
					});
				}
				pagination = makereportService.findByPage(pagination, paraMap);
				
				
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\", \"totalCount\": \"");
				sb.append(pagination.getTotalCount());
				sb.append("\",\"data\": ");
				sb.append(JSONArray.fromObject(pagination.getListOfObject(), config));
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	/**
	 * 政策文件详情接口
	 * 
	 * @return
	 */

	public void makereportView() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			
			
			String infoid=map.get("id");

			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

				Makereport makereport = makereportService.getById(infoid);
				
			
				Map<String, String> paramMap = new HashMap<String, String>();
				paramMap.put("bizrowid", makereport.getId());
				List<FawenAttach> attach= fawenAttachService.queryAttachListByTempleId(paramMap);
				
				
				List<Map<String,Object>> list=new ArrayList<>();
				if(attach!=null&&attach.size()>0){
					for(FawenAttach  att: attach){
						Map<String,Object> attachMap=new HashMap<>();
						attachMap.put("fjAddr", att.getAttachpath());
						attachMap.put("attachname", att.getAttachname());
						list.add(attachMap);
					}
				}
				
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				sb.append(",\"publishedDate\": ");
				
				sb.append("\""+makereport.getPublishedDate()+"\"");
				
				sb.append(",\"filename\": ");
				sb.append("\""+makereport.getFilename()+"\"");

				sb.append(",\"referenceNumber\": ");
				sb.append("\""+makereport.getReferenceNumber()+"\"");

				sb.append(",\"deptName\": ");
				sb.append("\""+makereport.getDeptName()+"\"");
				
				sb.append(",\"fjlist\": ");
				sb.append(JsonUtil.listmap_to_json_string(list));
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	
	/**
	 * 申报项目列表接口
	 * 
	 * @return
	 */

	public void csztcxQuery() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			Pagination pagination = new Pagination(this.getRequest());
			pagination.setPageNumber(null == map.get("cpage") ? 0 : Integer.parseInt(map.get("cpage")));
			pagination.setPageSize(null == map.get("len") ? 10 : Integer.parseInt(map.get("len")));
			
			String userId=map.get("userId");
			User uu=userService.findUserById(userId);
			
			//规划审批开始时间
			String querySlsjStart=map.get("querySlsjStart");
			//规划审批结束时间
			String querySlsjEnd=map.get("querySlsjEnd");
			
//			String dwdm=zsdwService.getDwdm(uu.getDept().getId());
			//单位代码
			
//			String dwdm=map.get("dwdm");
			//单位名称
			String dwmc=map.get("dwmc");
			
			//工程项目名称
			String xmmc=map.get("xmmc");
			
			//政策类别
			String zclb=map.get("zclb");
			//办理类别
			String bllb=map.get("bllb");
			
			//是否申报
			String isDeclare=map.get("isDeclare");
			
			//受理编号
			String slbh=map.get("slbh");
			
			SimpleDateFormat  format=new SimpleDateFormat("yyyy-MM-dd");
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
			
				
				if ((null != xmmc) && (0 < xmmc.trim().length()))
				{
					paraMap.put("xmmc", "%" + xmmc.trim() + "%");
				}
//				if(!"sf".equals(dwdm)&&!"0".equals(isDeclare)){
//				  if ((null != dwdm) && (0 < dwdm.trim().length()))
//				  {
//					paraMap.put("dwdm", "%" + dwdm.trim() + "%");
//				  }
//				}
					if ((null != dwmc) && (0 < dwmc.trim().length())){
						paraMap.put("jsdw", "%" +dwmc.trim() + "%");
				}
				
				if ((null != zclb) && (0 < zclb.trim().length()))
				{
					paraMap.put("zclb",  zclb.trim() );
				}
				
				
				if ((null != bllb) && (0 < bllb.trim().length()))
				{
					paraMap.put("bllb",  bllb.trim() );
				}
				if ((null != slbh) && (0 < slbh.trim().length()))
				{
					paraMap.put("slbh",  "%"+slbh.trim()+ "%" );
				}
				if ("0".equals(isDeclare))//未申报
				{
					paraMap.put("isDeclare",  isDeclare.trim() );
					if (null != querySlsjStart)
					{
						paraMap.put("qst", format.parse(querySlsjStart));
					}
					
					if (null != querySlsjEnd)
					{
						paraMap.put("qend", format.parse(querySlsjEnd));
					}
					//规划部门
					String ghbm=map.get("ghbm");
					if (null != ghbm&&!"".equals(ghbm)&&!"999".equals(ghbm))
					{
						paraMap.put("jbcss", "%"+ghbm.trim()+ "%" );
					}
					
				}else{
					//已申报
					//征收部门
					String dwdm=map.get("dwdm");
					if (null != dwdm&&!"".equals(dwdm)&&!"999".equals(dwdm))
					{
						paraMap.put("dwdm", "%"+dwdm.trim()+ "%" );
					}
					
					paraMap.put("declare",  isDeclare.trim() );
					Map<String, Object> paraMapsp = new HashMap<String, Object>();
					String biaoji="0";
					if (null != querySlsjStart) {
						paraMapsp.put("startSlsj", format.parse(querySlsjStart));
						biaoji="1";
					}

					if (null != querySlsjEnd) {
						paraMapsp.put("endSlsj", format.parse(querySlsjEnd));
						biaoji="1";
					}
					List<Spjlb> lsp=spjlbService.findSpjlball(paraMapsp);
					List<String> lss=new ArrayList<>();
					if(lsp.size()>0){
						for (Spjlb bean : lsp) {
							lss.add(bean.getSlbh());
						}
						paraMap.put("isinspslbh", lss);
					}else if("1".equals(biaoji)){
						paraMap.put("slbh",  "ffffffff" );
					}
					
				}
				
				
				
				JsonConfig config = new JsonConfig();
				config.registerJsonValueProcessor(java.util.Date.class, new DateJsonValueProcessor());
				Map<String, String> codeMap = new HashMap<String, String>();
				// 此处添加需要转换的一维代码，key是一维代码在数据对象中的属性名，value是一维代码的codeId

				config.registerJsonValueProcessor(String.class, new CodeJsonValueProcessor(codeMap));
				final String filter = "id|gzlbh|slbh|xmlsh|hfsz|xxylb|jsdw|czgs|bllb|ghspsj|ckbh|lsck|zjdyjks|zsdw|zsfw|issdxm|lianxiren|xkzh|xmmc|csje|jsdd|mjyj|beizhu|";
				if (filter != null && filter.length() > 1)
				{
					config.setJsonPropertyFilter(new PropertyFilter()
					{
						public boolean apply(Object source, String name, Object value)
						{
							if (filter.indexOf(name + "|") != -1)
								return false;
							else
								return true;
						}
					});
				}
				pagination= xmxxbService.findByPage2(pagination, paraMap);
				
				
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\", \"totalCount\": \"");
				sb.append(pagination.getTotalCount());
				sb.append("\",\"data\": ");
				sb.append(JSONArray.fromObject(pagination.getListOfObject(), config));
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	/**
	 * 申报项目详情接口
	 * 
	 * @return
	 */

	public void jfslView() {
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			
			
			String infoid=map.get("infoid");
			String userId=map.get("userId");
//			User user=userService.findUserById(userId);
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

				Xmxxb xmxxb = xmxxbService.getById(infoid);
				
				String slbh=xmxxb.getSlbh();
				Spjlb spjlb=spjlbService.getByslbh(slbh);
				
//				Map<String, Object> paraMaptt = new HashMap<String, Object>();
//				paraMaptt.put("slbh", spjlb.getSlbh());
//				List<Spjkjl> ls = spjkjlService.findSpjkjlall(paraMaptt);
				
				Map<String, String> vm = new HashMap<String, String>();
				vm.put("bizrowid", xmxxb.getId());
				vm.put("xmType", "缴费受理");
				vm.put("attachType", "核准信息一览表");
				List<FawenAttach> attach = fawenAttachService.queryAttachListByTempleId(vm);
				String hzxxylb="";
				String hzxxylbmc="";
				if(attach.size()>0){
					hzxxylb=attach.get(0).getAttachpath();
					hzxxylbmc=attach.get(0).getAttachname();
				}
				
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\"");
				
				sb.append(",\"slbh\": ");
				sb.append("\""+xmxxb.getSlbh()+"\"");

				sb.append(",\"xxylb\": ");
				sb.append("\""+xmxxb.getXxylb()+"\"");
				sb.append(",\"jsdw\": ");
				sb.append("\""+xmxxb.getJsdw()+"\"");
				sb.append(",\"xmmc\": ");
				sb.append("\""+xmxxb.getXmmc()+"\"");
				
				sb.append(",\"mjyj\": ");
				sb.append("\""+xmxxb.getMjyj()+"\"");
				sb.append(",\"zjzmj\": ");
				sb.append("\""+xmxxb.getZjsmj()+"\"");
				
//				sb.append(",\"ymmj\": ");
//				sb.append("\""+xmxxb.getYmmj()+"\"");
				sb.append(",\"zsfw\": ");
				sb.append("\""+xmxxb.getZsfw()+"\"");
				sb.append(",\"zsdw\": ");
				sb.append("\""+xmxxb.getZsdw()+"\"");
				sb.append(",\"zclb\": ");
				sb.append("\""+tozclbype(xmxxb.getZclb())+"\"");
				
				sb.append(",\"jsdd\": ");
				sb.append("\""+xmxxb.getJsdd()+"\"");
				sb.append(",\"xmbh\": ");
				sb.append("\""+xmxxb.getXmbh()+"\"");
				
				sb.append(",\"ghspsj\": ");
				sb.append("\""+xmxxb.getGhspsj()+"\"");
				
				sb.append(",\"spjssj\": ");
				sb.append("\""+spjlb.getLcjssj()+"\"");
				sb.append(",\"bllb\": ");
				sb.append("\""+tobllbtype(xmxxb.getBllb())+"\"");
				sb.append(",\"zsdw\": ");
				sb.append("\""+xmxxb.getZsdw()+"\"");

				sb.append(",\"tjfw\": ");
				sb.append("\""+xmxxb.getZsfw()+"\"");
				sb.append(",\"hzxxylb\":");
				sb.append("\""+hzxxylb+"\"");
				sb.append(",\"hzxxylbmc\":");
				sb.append("\""+hzxxylbmc+"\"");
				paraMap.put("slbh", slbh);
				List<Spjkjl> ls = spjkjlService.findSpjkjlall(paraMap);// 参考可能不需要里面数据
				String ymmj="";
				String ymje="";
				if(ls!=null&&ls.size()>0){
					ymmj=ls.get(0).getPtymmj();
					ymje=ls.get(0).getPtymje();
					if("1".equals(xmxxb.getZjdyjks())){
						sb.append(",\"yjmj\": ");
						sb.append("\""+ls.get(0).getPtyjmj()+"\"");
						sb.append(",\"yjje\": ");
						sb.append("\""+ls.get(0).getPtyjje()+"\"");
					}
					else{
						sb.append(",\"yjmj\": ");
						sb.append("\""+xmxxb.getYjmj()+"\"");
						sb.append(",\"yjje\": ");
						sb.append("\""+xmxxb.getYjje()+"\"");
					}
				}else{
					sb.append(",\"yjmj\": ");
					sb.append("\""+xmxxb.getYjmj()+"\"");
					sb.append(",\"yjje\": ");
					sb.append("\""+spjlb.getYjje()+"\"");
				}
				
					sb.append(",\"ymmj\": ");
					sb.append("\""+ymmj+"\"");
					sb.append(",\"ymje\": ");
					sb.append("\""+ymje+"\"");
				
				
				Map<String, Object> paraM = new HashMap<String, Object>();
				paraMap.put("xmbzj", infoid);
				List<Jktzs> ljs= jktzsService.findByAll(paraM);
				String jkts="";
				if(null!=ljs&&ljs.size()>0){
					jkts=ljs.get(0).getDzbh();
				}
					//缴款通知书编号
					sb.append(",\"jktzs\": ");
					sb.append("\""+jkts+"\"");
				PaymentItemHis paymentItemHis = paymentItemHisService.getByOrderId(spjlb.getSlbh());
				String pz="";
				if (null != paymentItemHis) {
					pz=paymentItemHis.getZslxdbh();
					//缴费凭证
				}
				sb.append(",\"jfpz\": ");
				sb.append("\""+ pz+"\"");
	            	//一般缴款书编号
				PaymentVoucherHis paymentVoucherHis = paymentVoucherHisService.getPayMentByorderId(spjlb.getSlbh());
				String pvh="";
				if(null!=paymentVoucherHis){
					pvh=paymentVoucherHis.getVoucherCode();
				}
					sb.append(",\"ybjks\": ");
					sb.append( "\""+pvh+"\"");
				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	/**
	 * 项目统计
	 */
	public void xmCount(){
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {
			String zsdw=map.get("zsdw");
			String startSendtime=map.get("startSendtime");
			String endSendtime=map.get("endSendtime");
			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {
				if (null != startSendtime){
					paraMap.put("startSendtime", startSendtime);
				}
				if (null != endSendtime){
					paraMap.put("endSendtime", endSendtime);
				}
				
				if (null != zsdw){
					String[] array=zsdw.split("-");
					paraMap.put("zsdws", Arrays.asList(array));
				}
				paraMap.put("SqlId", "xmCountSql");
				List list=  mobileManager.findListBySqlId(paraMap);
				
				double totalCount=0,jfjeCount=0,jmxmCount=0,jmjeCount=0;
				if(list!=null){
					for(int i=0;i<list.size();i++){
						if(((Map)list.get(i)).get("TOTAL")!=null){
							totalCount+=((BigDecimal)((Map)list.get(i)).get("TOTAL")).doubleValue();
						}
						if(((Map)list.get(i)).get("YJ")!=null){
							jfjeCount+=((BigDecimal)((Map)list.get(i)).get("YJ")).doubleValue();
						}
						if(((Map)list.get(i)).get("JMSM")!=null){
							jmxmCount+=((BigDecimal)((Map)list.get(i)).get("JMSM")).doubleValue();
						}
						if(((Map)list.get(i)).get("YMJE")!=null){
							jmjeCount+=((BigDecimal)((Map)list.get(i)).get("YMJE")).doubleValue();
						}
					}
				}
				
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\", \"totalCount\": ");
				sb.append(totalCount);
				sb.append(",\"jfjeCount\": ");
				sb.append(jfjeCount);
				
				
				sb.append(",\"jmxmCount\": ");
				sb.append(jmxmCount);
				
				sb.append(",\"jmjeCount\": ");
				sb.append(jmjeCount);
				
								
				sb.append(",\"data\": ");
				sb.append(JsonUtil.listmapToJsonString(list));

				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	
	/**
	 * 项目单位
	 */
	public void xmdwQuery(){
		DecodeStr der = new DecodeStr();
		Map<String, String> map = new HashMap<String, String>();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		map = der.getPostPara(para, callback);
		if (null == map || map.isEmpty()) {
			JsonUtil.printJsonString(getResponse(), der.getNothingInReq());
		} else {

			String str = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
			try {

				paraMap.put("SqlId", "xmdwSql");
				List list=  mobileManager.findListBySqlId(paraMap);
				
				
				StringBuilder sb = new StringBuilder();
				sb.append("{ \"message\": \"查询成功\",\"code\": \"0\" ");
								
				sb.append(",\"data\": ");
				sb.append(JsonUtil.listmapToJsonString(list));

				sb.append("}");
				str = sb.toString();
				System.out.println("传输到手机端：" + str);
			} catch (Exception e) {
				e.printStackTrace();
			}
			JsonUtil.printJsonString(getResponse(), str);
		}
	}
	
	

	/**
	 * 办理类别
	 * @return
	 */
	private String tobllbtype(String bllb){
		if("1".equals(bllb)){
			return "减免";
		}
		return "直接缴费";
	}
	
	/**
	 * 项目来源(面积依据)
	 * @return
	 */
	private String tomjyjtype(String mjyj){
		if("001".equals(mjyj)){
			return "规划(正常)";
		}
		if("002".equals(mjyj)){
			return "房产测绘(超建面积)";
		}
		if("003".equals(mjyj)){
			return "交易登记(紫金科创)";
		}
		if("004".equals(mjyj)){
			return "房改办(经营用房)";
		}
		if("005".equals(mjyj)){
			return "规划(变更)";
		}
		return "";
	}
	/**
	 * 政策类别
	 * @return
	 */
	private String tozclbype(String zclb){
		if("001".equals(zclb)){
			return "宁政规字[2016]5号";
		}
		if("002".equals(zclb)){
			return "办文单";
		}
		if("003".equals(zclb)){
			return "会议纪要";
		}
	
		return "";
	}
	
	
	public String getPara() {
		return para;
	}

	public void setPara(String para) {
		this.para = para;
	}

	public String getCallback() {
		return callback;
	}

	public void setCallback(String callback) {
		this.callback = callback;
	}

	public Pagination getPagination() {
		return pagination;
	}

	public void setPagination(Pagination pagination) {
		this.pagination = pagination;
	}

	public String getJsonString() {
		return jsonString;
	}

	public void setJsonString(String jsonString) {
		this.jsonString = jsonString;
	}

	public String getCpage() {
		return cpage;
	}

	public void setCpage(String cpage) {
		this.cpage = cpage;
	}

	public String getLen() {
		return len;
	}

	public void setLen(String len) {
		this.len = len;
	}

}
