package com.jshx.jkmx.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import com.jshx.common.utils.Constant;
import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.utils.SysPropertiesUtil;
import com.jshx.jkmx.dao.JkmxDao;
import com.jshx.jkmx.entity.Jkmx;
import com.jshx.jkmx.service.JkmxService;
import com.jshx.jmmx.entity.Jmmx;
import com.jshx.qtfymx.dao.QtfymxDao;
import com.jshx.qtfymx.entity.Qtfymx;
import com.jshx.spjkjl.dao.SpjkjlDao;
import com.jshx.spjkjl.entity.Spjkjl;
import com.jshx.xmxxb.dao.XmxxbDao;
import com.jshx.xmxxb.entity.Xmxxb;

@Service("jkmxService")
public class JkmxServiceImpl extends BaseServiceImpl implements JkmxService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("jkmxDao")
	private JkmxDao jkmxDao;
	@Autowired() 
	private SpjkjlDao spjkjlDao;
	@Autowired() 
	private QtfymxDao qtfymxDao;
	@Autowired() 
	private XmxxbDao xmxxbDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return jkmxDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Jkmx getById(String id)
	{
		return jkmxDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Jkmx jkmx)
	{
		jkmxDao.save(jkmx);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Jkmx jkmx)
	{
		jkmxDao.update(jkmx);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=jkmxDao.findJkmx(paraMap);
		
		jkmxDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    jkmxDao.deleteWithFlag(id);
			}
		}
	}

	@Transactional
	public String savelist(List<Jkmx> list) throws Exception {
		String message="0";
        try{
        	for (Jkmx jkmx : list) {
    			jkmxDao.save(jkmx);
    		}	
        }catch(Exception ex){
        	message="1";
        	TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        	
        }
        return message;
	}

	@Transactional
	public String caozuo(List<Jkmx> jihe, Spjkjl spjkjl, List<Qtfymx> qtxmlist, Xmxxb xmbbean, String dikoumj,
			String yjmj,String message) throws Exception {
		   try {
				  if(jihe.size()>0){
					  for (Jkmx jkmx : jihe) {
			    			jkmxDao.save(jkmx);
			    		}
			  		  }
			  		 //待审核
			  		  spjkjl.setStarts("0");
			  		  spjkjl.setDelFlag(0);
			  		  spjkjlDao.save(spjkjl);
			  		//保存其他信息
			  		  if(qtxmlist.size()>0){
			  			   for (Qtfymx qtfymx : qtxmlist) {
			  				 qtfymx.setDelFlag(0);
			  				 qtfymxDao.save(qtfymx);
						   }
			  		     }
			  		    if(!"0".equals(dikoumj)){
			  		       xmbbean.setZjsmj(yjmj);
//			  			  String danjia=SysPropertiesUtil.getProperty("danweijine");
			  			  String danjia=(String) Constant.CONSTANT_MAP.get("ptf");
			  			  
			  			  
			  			  xmbbean.setSjcsje(SysPropertiesUtil.jinehuoqu(xmbbean.getZjsmj(), danjia));
			  		       xmxxbDao.update(xmbbean);
			  		     }
			  		    message="0";
		} catch (Exception e) { 
			message="1";
			TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
		}
		return message;
	}

	@Override
	public List<Jkmx> findall(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return jkmxDao.findJkmx(paraMap);
	}


	
}
