package com.jshx.hisxlsfxxb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.hisxlsfxxb.entity.Hisxlsfxxb;
import com.jshx.hisxlsfxxb.dao.HisxlsfxxbDao;

@Component("hisxlsfxxbDao")
public class HisxlsfxxbDaoImpl extends BaseDaoImpl implements HisxlsfxxbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findHisxlsfxxbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findHisxlsfxxb(Map<String, Object> paraMap){
		return this.findListByHqlId("findHisxlsfxxbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Hisxlsfxxb getById(String id)
	{
		return (Hisxlsfxxb)this.getObjectById(Hisxlsfxxb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Hisxlsfxxb hisxlsfxxb)
	{
		hisxlsfxxb.setId(null);
		this.saveOrUpdateObject(hisxlsfxxb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Hisxlsfxxb hisxlsfxxb)
	{
		this.saveOrUpdateObject(hisxlsfxxb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Hisxlsfxxb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Hisxlsfxxb hisxlsfxxb = (Hisxlsfxxb)this.getObjectById(Hisxlsfxxb.class, id);
		hisxlsfxxb.setDelFlag(1);
		this.saveObject(hisxlsfxxb);
	}
}
