package com.jshx.fstzs.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fstzs.dao.FstzsDao;
import com.jshx.fstzs.dao.FstzsXmDao;
import com.jshx.fstzs.entity.Fstzs;
import com.jshx.fstzs.entity.FstzsXm;
import com.jshx.fstzs.service.FstzsService;
import com.jshx.fstzs.service.FstzsXmService;
import com.jshx.yzscw.yzscwjzpz.dao.YzscwjzpzDao;
import com.jshx.zzhkppj.dao.ZzhkppjDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("fstzsXmService")
public class FstzsXmServiceImpl extends BaseServiceImpl implements FstzsXmService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("fstzsXmDao")
	private FstzsXmDao fstzsXmDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return fstzsXmDao.findByPage(page, paraMap);
	}

	@Override
	public FstzsXm getBySlbh(String slbh) {
		Map<String,Object> param = new HashMap<>();
		param.put("slbh",slbh);
		List list = fstzsXmDao.findByPage(param);
		if(list != null && list.size() > 0) {
			return (FstzsXm)list.get(0);
		}
		return null;
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public FstzsXm getById(String id)
	{
		return fstzsXmDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param fstzsXm 信息
	 */
	@Transactional
	public void save(FstzsXm fstzsXm)
	{
		fstzsXmDao.save(fstzsXm);
	}

	/**
	 * 修改信息
	 * @param fstzsXm 信息
	 */
	@Transactional
	public void update(FstzsXm fstzsXm)
	{
		fstzsXmDao.update(fstzsXm);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
//		List objects=fstzsXmDao.findByPage(paraMap);
		//TODO 删除

//		fstzsXmDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					fstzsXmDao.deleteWithFlag(id);
			}
		}
	}
}
