package com.jshx.fstzs.service.impl;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fstzs.dao.FstzsDao;
import com.jshx.fstzs.entity.Fstzs;
import com.jshx.fstzs.service.FstzsService;
import com.jshx.rfxm.dao.RfxmDao;
import com.jshx.rfxm.entity.Rfxm;
import com.jshx.rfxm.service.RfxmService;
import com.jshx.yzscw.yzscwjzpz.dao.YzscwjzpzDao;
import com.jshx.yzscw.yzscwjzpz.entity.Yzscwjzpz;
import com.jshx.zzhkppj.dao.ZzhkppjDao;
import com.jshx.zzhkppj.entity.Zzhkppj;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("fstzsService")
public class FstzsServiceImpl extends BaseServiceImpl implements FstzsService
{
	/**
	 * Dao类
	 */
	@Autowired()
	@Qualifier("fstzsDao")
	private FstzsDao fstzsDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return fstzsDao.findByPage(page, paraMap);
	}

	@Override
	public List findList(Map<String, Object> paraMap) {
		return fstzsDao.findByPage(paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Fstzs getById(String id)
	{
		return fstzsDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param fstzs 信息
	 */
	@Transactional
	public void save(Fstzs fstzs)
	{
		fstzsDao.save(fstzs);
	}

	/**
	 * 修改信息
	 * @param fstzs 信息
	 */
	@Transactional
	public void update(Fstzs fstzs)
	{
		fstzsDao.update(fstzs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		delete(list);
	}

	@Override
	public void delete(List<String> ids) {
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", ids);
		List objects=fstzsDao.findByPage(paraMap);
		fstzsDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
					fstzsDao.deleteWithFlag(id);
			}
		}
	}
}
