package com.jshx.fstzs.entity;

import com.jshx.core.base.entity.BaseModel;
import com.jshx.xmxxb.entity.Xmxxb;

import javax.persistence.*;


/**
 * 实体类模板（目前仅适配MS-SQLServer数据库）
 * @author jinx@caoz.
 * 非税通知书-清单
 * 1个项目可以对应多个清单文件
 *
 */
@SuppressWarnings("serial")
@Entity
@Table(name="FSTZS")
public class Fstzs extends BaseModel {

    private FstzsXm fstzsXm;

    /**
     * 激活的流水号
     */
    private String lsh;

    /**
     * 开票的流水号
     */
    private String kpLsh;

    /**
     * 非税通知书状态
     * 0：默认，不显示在列表
     * 1:已激活，正常
     * 2：已作废
     * 3：已缴费：从财政同步状态
     * 4：激活没成功，生成电子缴费码失败
     */
    private Integer status;


    /**
     * 编制日期
     */
    private String bzrq;

    /**
     * 财政返回的缴款吗
     */
    private String jkm;

    /**
     * 缴款缴款人
     */
    private String jkr;

    /**
     * 票据代码
     */
    private String pjdm;

    /**
     * 缴款书号
     */
    private String jksh;

    /**
     * 应缴金额
     */
    private String yjje;

    /**
     * 应缴面积
     */
    private String yjmj;

    /**
     * 删除标记
     */
    private Integer delFlag;

    /**
     * 受理编号
     */
    private String slbh;

    /**
     * 工程项目名称
     */
    private String gcxmmc;

    /**
     * 建设单位名成
     */
    private String jsdwmc;

    /**
     * 电子票号
     */
    private String dzph;
    /**
     * 票据的url
     */
    private String pjUrl;

    /**
     * 是否开票
     * 0 没开
     */
    private Integer isKp;

    /**
     * 是否缴款
     * 0，未交款
     */
    private Integer isJk;
    /**
     * 缴款时间
     */
    private String jkTime;
    /**
     * 开票时间
     */
    private String kpTime;

    /**
     * 缴款渠道
     */
    private String jkqd;

    /**
     * 操作激活的时间
     */
    private String jhTime;

    /**
     * 一个项目可以对应对个缴款人
     * 这个是总缴款人数量
     */
    private Integer length;

    /**
     * 是否审批通过
     */
    private Integer isSptg;

    /**
     * 生成缴款书的经办人
     */
    private String jksJbr;

    /**
     * 开票的经办人
     */
    private String kpJbr;


    /**
     * 对应项目信息
     */
    @ManyToOne(targetEntity = FstzsXm.class, fetch = FetchType.LAZY)
    @JoinColumn(name = "XMZJ", insertable = false, updatable = false)
    public FstzsXm getFstzsXm() {
        return fstzsXm;
    }

    public void setFstzsXm(FstzsXm fstzsXm) {
        this.fstzsXm = fstzsXm;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getBzrq() {
        return bzrq;
    }

    public void setBzrq(String bzrq) {
        this.bzrq = bzrq;
    }

    public String getJkm() {
        return jkm;
    }

    public void setJkm(String jkm) {
        this.jkm = jkm;
    }

    public String getJkr() {
        return jkr;
    }

    public void setJkr(String jkr) {
        this.jkr = jkr;
    }

    public String getPjdm() {
        return pjdm;
    }

    public void setPjdm(String pjdm) {
        this.pjdm = pjdm;
    }

    public String getJksh() {
        return jksh;
    }

    public void setJksh(String jksh) {
        this.jksh = jksh;
    }

    public String getYjje() {
        return yjje;
    }

    public void setYjje(String yjje) {
        this.yjje = yjje;
    }

    public Integer getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    public String getSlbh() {
        return slbh;
    }

    public void setSlbh(String slbh) {
        this.slbh = slbh;
    }

    public String getGcxmmc() {
        return gcxmmc;
    }

    public void setGcxmmc(String gcxmmc) {
        this.gcxmmc = gcxmmc;
    }

    public String getJsdwmc() {
        return jsdwmc;
    }

    public void setJsdwmc(String jsdwmc) {
        this.jsdwmc = jsdwmc;
    }

    public String getDzph() {
        return dzph;
    }

    public void setDzph(String dzph) {
        this.dzph = dzph;
    }

    public Integer getIsKp() {
        return isKp;
    }

    public void setIsKp(Integer isKp) {
        this.isKp = isKp;
    }

    public Integer getIsJk() {
        return isJk;
    }

    public void setIsJk(Integer isJk) {
        this.isJk = isJk;
    }

    public String getJkTime() {
        return jkTime;
    }

    public void setJkTime(String jkTime) {
        this.jkTime = jkTime;
    }

    public String getKpTime() {
        return kpTime;
    }

    public void setKpTime(String kpTime) {
        this.kpTime = kpTime;
    }

    public String getJkqd() {
        return jkqd;
    }

    public void setJkqd(String jkqd) {
        this.jkqd = jkqd;
    }

    public String getYjmj() {
        return yjmj;
    }

    public void setYjmj(String yjmj) {
        this.yjmj = yjmj;
    }

    public Integer getLength() {
        return length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getIsSptg() {
        return isSptg;
    }

    public void setIsSptg(Integer isSptg) {
        this.isSptg = isSptg;
    }

    public String getJhTime() {
        return jhTime;
    }

    public void setJhTime(String jhTime) {
        this.jhTime = jhTime;
    }

    public String getLsh() {
        return lsh;
    }

    public void setLsh(String lsh) {
        this.lsh = lsh;
    }

    public String getJksJbr() {
        return jksJbr;
    }

    public void setJksJbr(String jksJbr) {
        this.jksJbr = jksJbr;
    }

    public String getKpJbr() {
        return kpJbr;
    }

    public void setKpJbr(String kpJbr) {
        this.kpJbr = kpJbr;
    }

    public String getKpLsh() {
        return kpLsh;
    }

    public void setKpLsh(String kpLsh) {
        this.kpLsh = kpLsh;
    }

    public String getPjUrl() {
        return pjUrl;
    }

    public void setPjUrl(String pjUrl) {
        this.pjUrl = pjUrl;
    }
}
