package com.jshx.fstzs.dao.impl;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fstzs.dao.FstzsDao;
import com.jshx.fstzs.entity.Fstzs;
import com.jshx.rfxm.dao.RfxmDao;
import com.jshx.rfxm.entity.Rfxm;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component("fstzsDao")
public class FstzsDaoImpl extends BaseDaoImpl implements FstzsDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findFstzsByMap", paraMap, page);
	}

	public List findByPage(Map<String, Object> paraMap)
	{
		return this.findListByHqlId("findFstzsByMap",paraMap);
	}


	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Fstzs getById(String id)
	{
		return (Fstzs)this.getObjectById(Fstzs.class, id);
	}

	/**
	 * 保存信息
	 * @param fstzs 信息
	 */
	public void save(Fstzs fstzs)
	{
		fstzs.setId(null);
		this.saveOrUpdateObject(fstzs);
	}

	/**
	 * 修改信息
	 * @param fstzs 信息
	 */
	public void update(Fstzs fstzs)
	{
		this.saveOrUpdateObject(fstzs);
	}
	/**
	 * 修改信息
	 * @param fstzs 信息
	 */
	@Override
	public void updateNotSave(Fstzs fstzs)
	{
		this.update(fstzs);
	}

	/**
	 * 物理删除信息
	 * @param id 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Fstzs.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param id 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Fstzs fstzs = (Fstzs)this.getObjectById(Fstzs.class, id);
		fstzs.setDelFlag(1);
		this.saveObject(fstzs);
	}
}
