package com.jshx.fsjktb.dao.impl;

import java.util.List;
import java.sql.Blob;
import java.util.Map;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.springframework.stereotype.Component;

import com.jshx.core.base.dao.impl.BaseDaoImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fsjktb.entity.Fsjktb;
import com.jshx.fsjktb.dao.FsjktbDao;

@Component("fsjktbDao")
public class FsjktbDaoImpl extends BaseDaoImpl implements FsjktbDao
{
	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return this.findPageByHqlId("findFsjktbByMap", paraMap, page);
	}
	
	/**
	 * 查询所有记录
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public List findFsjktb(Map<String, Object> paraMap){
		return this.findListByHqlId("findFsjktbByMap", paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Fsjktb getById(String id)
	{
		return (Fsjktb)this.getObjectById(Fsjktb.class, id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	public void save(Fsjktb fsjktb)
	{
		fsjktb.setId(null);
		this.saveOrUpdateObject(fsjktb);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	public void update(Fsjktb fsjktb)
	{
		this.saveOrUpdateObject(fsjktb);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID
	 */
	public void delete(String id)
	{
		this.removeObjectById(Fsjktb.class, id);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID
	 */
	public void deleteWithFlag(String id)
	{
		Fsjktb fsjktb = (Fsjktb)this.getObjectById(Fsjktb.class, id);
		fsjktb.setDelFlag(1);
		this.saveObject(fsjktb);
	}
}
