package com.jshx.constantset.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.common.utils.Constant;
import com.jshx.constantset.dao.ConstantSetDao;
import com.jshx.constantset.entity.ConstantSet;
import com.jshx.constantset.service.ConstantSetService;

@Service("constantSetService")
public class ConstantSetServiceImpl extends BaseServiceImpl implements ConstantSetService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("constantSetDao")
	private ConstantSetDao constantSetDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return constantSetDao.findByPage(page, paraMap);
	}
	
	@Transactional
	public List findConstantSet(Map<String, Object> paraMap)
	{
		return constantSetDao.findConstantSet(paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public ConstantSet getById(String id)
	{
		return constantSetDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(ConstantSet constantSet)
	{
		constantSetDao.save(constantSet);
		Constant.CONSTANT_MAP.put(constantSet.getConstantName(), constantSet.getConstantValue());
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(ConstantSet constantSet)
	{
		constantSetDao.update(constantSet);
		Constant.CONSTANT_MAP.put(constantSet.getConstantName(), constantSet.getConstantValue());
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=constantSetDao.findConstantSet(paraMap);
		
		constantSetDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    constantSetDao.deleteWithFlag(id);
			}
		}
	}
}
