package com.jshx.cktzs.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.cktzs.dao.CktzsDao;
import com.jshx.cktzs.entity.Cktzs;
import com.jshx.cktzs.service.CktzsService;

@Service("cktzsService")
public class CktzsServiceImpl extends BaseServiceImpl implements CktzsService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("cktzsDao")
	private CktzsDao cktzsDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return cktzsDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public Cktzs getById(String id)
	{
		return cktzsDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(Cktzs cktzs)
	{
		cktzsDao.save(cktzs);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(Cktzs cktzs)
	{
		cktzsDao.update(cktzs);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=cktzsDao.findCktzs(paraMap);
		
		cktzsDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    cktzsDao.deleteWithFlag(id);
			}
		}
	}

	@Override
	public List<Cktzs> findByall(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return cktzsDao.findCktzs(paraMap);
	}
	@Override
	public List<Cktzs> findByall1(Map<String, Object> paraMap) {
		// TODO Auto-generated method stub
		return cktzsDao.findCktzs1(paraMap);
	}
}
