package com.jshx.account.accountBank.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.jshx.core.base.service.impl.BaseServiceImpl;
import com.jshx.core.base.vo.Pagination;
import com.jshx.fawen.entity.FawenAttach;
import com.jshx.account.accountBank.dao.AccountBankAttachDao;
import com.jshx.account.accountBank.entity.AccountBankAttach;
import com.jshx.account.accountBank.service.AccountBankAttachService;

@Service("accountBankAttachService")
public class AccountBankAttachServiceImpl extends BaseServiceImpl implements AccountBankAttachService
{
	/**
	 * Dao类
	 */
	@Autowired() 
	@Qualifier("accountBankAttachDao")
	private AccountBankAttachDao accountBankAttachDao;

	/**
	 * 分页查询
	 * @param page 分页信息
	 * @param paraMap 查询条件信息
	 * @return 分页信息
	 */
	public Pagination findByPage(Pagination page, Map<String, Object> paraMap)
	{
		return accountBankAttachDao.findByPage(page, paraMap);
	}

	/**
	 * 根据主键ID查询信息
	 * @param id 主键ID
	 * @return 主键ID对应的信息
	 */
	public AccountBankAttach getById(String id)
	{
		return accountBankAttachDao.getById(id);
	}

	/**
	 * 保存信息
	 * @param model 信息
	 */
	@Transactional
	public void save(AccountBankAttach accountBankAttach)
	{
		accountBankAttachDao.save(accountBankAttach);
	}

	/**
	 * 修改信息
	 * @param model 信息
	 */
	@Transactional
	public void update(AccountBankAttach accountBankAttach)
	{
		accountBankAttachDao.update(accountBankAttach);
	}

	/**
	 * 物理删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void delete(String[] ids)
	{
		List list=Arrays.asList(ids);
		
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("ids", list);
		List objects=accountBankAttachDao.findAccountBankAttach(paraMap);
		
		accountBankAttachDao.removeAll(objects);
	}

	/**
	 * 逻辑删除信息
	 * @param ids 主键ID列表
	 */
	@Transactional
	public void deleteWithFlag(String ids)
	{
	    String[] idArray = ids.split("\\|");
		if(null != idArray)
		{
			for(String id : idArray)
			{
			    if(id!=null && !id.trim().equals(""))
				    accountBankAttachDao.deleteWithFlag(id);
			}
		}
	}
	
	/**
	 * 根据模板ID取相应的附件
	 * @param paramsMap
	 * @return
	 * 
	 */
	@Override
	public List<AccountBankAttach> queryAttachListByTempleId(Map<String, String> paramsMap) {
	
		return accountBankAttachDao.queryAttachListByTempleId(paramsMap);
	}
}
