/*     */ package cn.com.jshx.smgp.connect;
/*     */ 
/*     */ import cn.com.jshx.smgp.bean.Deliver;
/*     */ import cn.com.jshx.smgp.bean.LongDeliver;
/*     */ import cn.com.jshx.smgp.bean.Result;
/*     */ import cn.com.jshx.smgp.bean.Submit;
/*     */ import cn.com.jshx.smgp.bean.SubmitBatch;
/*     */ import cn.com.jshx.smgp.message.ActiveTestMessage;
/*     */ import cn.com.jshx.smgp.message.ActiveTestRespMessage;
/*     */ import cn.com.jshx.smgp.message.DeliverMessage;
/*     */ import cn.com.jshx.smgp.message.DeliverRespMessage;
/*     */ import cn.com.jshx.smgp.message.ExitMessage;
/*     */ import cn.com.jshx.smgp.message.LoginMessage;
/*     */ import cn.com.jshx.smgp.message.LoginRespMessage;
/*     */ import cn.com.jshx.smgp.message.Package;
/*     */ import cn.com.jshx.smgp.message.SubmitMessage;
/*     */ import cn.com.jshx.smgp.message.SubmitRespMessage;
/*     */ import cn.com.jshx.smgp.pdu.WapPushPdu;
/*     */ import cn.com.jshx.smgp.protocol.RequestId;
/*     */ import cn.com.jshx.smgp.protocol.Tlv;
/*     */ import cn.com.jshx.smgp.protocol.TlvId;
/*     */ import cn.com.jshx.util.Hex;
/*     */ import cn.com.jshx.util.TypeConvert;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.FileWriter;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintStream;
/*     */ import java.net.Socket;
/*     */ import java.net.SocketTimeoutException;
/*     */ import java.net.UnknownHostException;
/*     */ import java.security.NoSuchAlgorithmException;
/*     */ import java.text.SimpleDateFormat;
/*     */ import java.util.Calendar;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class PConnect extends Thread
/*     */ {
/*     */   private String Host;
/*     */   private int Port;
/*     */   private Socket GwSocket;
/*     */   private DataInputStream in;
/*     */   private DataOutputStream out;
/*  52 */   private boolean HasConnect = false;
/*     */   private int LoginMode;
/*     */   private String ClientID;
/*     */   private String ClientPasswd;
/*     */   private String SPID;
/*  63 */   private int DisplayMode = 1;
/*  64 */   private int FirstLogin = 0;
/*     */ 
/*  66 */   private int HasLogin = 0;
/*  67 */   private int Logout = 0;
/*     */   private FileWriter LogFile;
/*  77 */   private Package CurPack = new Package();
/*  78 */   private Vector<Package> undoPack = new Vector();
/*  79 */   private Vector deliverbuffer = new Vector();
/*  80 */   private int SequenceId = 0;
/*  81 */   private int SockTimeOut = 60000;
/*     */ 
/*  94 */   private HashMap<String, LongDeliver> longsmsbuffer = new HashMap();
/*  95 */   private int LongSmsOverTime = 60;
/*     */ 
/*     */   public int getSockTimeOut()
/*     */   {
/*  84 */     return this.SockTimeOut;
/*     */   }
/*     */ 
/*     */   public void setSockTimeOut(int sockTimeOut) {
/*  88 */     this.SockTimeOut = sockTimeOut;
/*     */   }
/*     */ 
/*     */   public PConnect(String host, int port, int loginmode, String clientid, String clientpasswd, String spid, int displaymode)
/*     */   {
/*  99 */     this.Host = host;
/* 100 */     this.Port = port;
/* 101 */     this.LoginMode = loginmode;
/* 102 */     this.ClientID = clientid;
/* 103 */     this.ClientPasswd = clientpasswd;
/* 104 */     this.SPID = spid;
/* 105 */     this.DisplayMode = displaymode;
/* 106 */     this.SequenceId = GetStartSeq();
/* 107 */     this.HasConnect = Connect();
/*     */   }
/*     */ 
/*     */   public PConnect(String host, int port, int loginmode, String clientid, String clientpasswd, String spid)
/*     */   {
/* 113 */     this.Host = host;
/* 114 */     this.Port = port;
/* 115 */     this.LoginMode = loginmode;
/* 116 */     this.ClientID = clientid;
/* 117 */     this.ClientPasswd = clientpasswd;
/* 118 */     this.SPID = spid;
/* 119 */     this.SequenceId = GetStartSeq();
/* 120 */     this.HasConnect = Connect();
/*     */   }
/*     */ 
/*     */   public void setDisplayMode(int displaymode)
/*     */   {
/* 125 */     this.DisplayMode = displaymode;
/*     */   }
/*     */ 
/*     */   public void SetLogFile(String LogFile) throws IOException {
/* 129 */     this.LogFile = new FileWriter(LogFile);
/*     */   }
/*     */ 
/*     */   private boolean Connect() {
/*     */     try {
/* 134 */       this.GwSocket = new Socket(this.Host, this.Port);
/*     */ 
/* 138 */       this.GwSocket.setSoTimeout(this.SockTimeOut);
/*     */ 
/* 141 */       this.in = new DataInputStream(this.GwSocket.getInputStream());
/* 142 */       this.out = new DataOutputStream(this.GwSocket.getOutputStream());
/* 143 */       this.FirstLogin += 1;
/*     */     }
/*     */     catch (UnknownHostException e) {
/* 146 */       e.printStackTrace();
/*     */     } catch (IOException e) {
/* 148 */       if (this.FirstLogin > 0) {
/*     */         try {
/* 150 */           Thread.sleep(5000L);
/* 151 */           if (this.DisplayMode >= 2)
/* 152 */             System.out.println("Connect Fail!Reconneted");
/*     */         }
/*     */         catch (InterruptedException e1) {
/* 155 */           e1.printStackTrace();
/*     */         }
/* 157 */         return Connect();
/*     */       }
/*     */ 
/* 160 */       return false;
/*     */     }
/*     */ 
/* 164 */     return true;
/*     */   }
/*     */ 
/*     */   private void ReConnect(int ms) {
/* 168 */     if (this.Logout == 0)
/*     */       try {
/* 170 */         Thread.sleep(ms);
/* 171 */         System.out.println("Try Reconnect!");
/* 172 */         Connect();
/* 173 */         System.out.println("Try Login!");
/*     */ 
/* 176 */         LoginMessage lm = new LoginMessage(this.ClientID, 
/* 177 */           this.ClientPasswd, this.LoginMode);
/* 178 */         SendBuf(lm.getBuf());
/*     */       }
/*     */       catch (InterruptedException e)
/*     */       {
/* 184 */         e.printStackTrace();
/*     */       } catch (IllegalArgumentException e) {
/* 186 */         e.printStackTrace();
/*     */       } catch (NoSuchAlgorithmException e) {
/* 188 */         e.printStackTrace();
/*     */       } catch (IOException e) {
/* 190 */         e.printStackTrace();
/*     */       }
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     while (true)
/*     */     {
/*     */       try {
/* 199 */         int PackLen = this.in.readInt();
/* 200 */         byte[] Message = new byte[PackLen - 4];
/*     */ 
/* 202 */         this.in.read(Message);
/*     */ 
/* 205 */         if (this.LogFile != null) {
/* 206 */           this.LogFile.write("[" + GetTime() + "]" + "Recv:" + 
/* 207 */             Hex.rhex(TypeConvert.int2byte(PackLen)) + 
/* 208 */             Hex.rhex(Message) + "\n");
/* 209 */           this.LogFile.flush();
/*     */         }
/*     */ 
/* 214 */         this.CurPack = new Package(Message);
/* 215 */         if (this.DisplayMode >= 2)
/* 216 */           DisplayPackage(PackLen, Message, 0);
/* 217 */         switch (this.CurPack.ReqestId) {
/*     */         case 4:
/* 219 */           SendBuf(new ActiveTestRespMessage().getBuf());
/*     */ 
/* 221 */           if (this.DisplayMode >= 3) {
/* 222 */             DisplayPackage(new ActiveTestRespMessage().getBuf(), 
/* 223 */               1);
/*     */           }
/* 225 */           break;
/*     */         case 3:
/* 227 */           DeliverMessage dm = new DeliverMessage(this.CurPack.Message);
/* 228 */           DeliverRespMessage drm = new DeliverRespMessage(
/* 229 */             dm.MsgID_BCD, dm.getSequence_Id(), 0);
/* 230 */           SendBuf(drm.getBuf());
/*     */ 
/* 232 */           if (this.DisplayMode >= 2) {
/* 233 */             DisplayPackage(drm.getBuf(), 1);
/*     */           }
/*     */ 
/* 237 */           if (dm.TP_udhi == 1)
/*     */           {
/* 239 */             AddLongSms(dm);
/*     */           }
/*     */           else
/*     */           {
/* 244 */             this.deliverbuffer.add(dm);
/*     */           }
/*     */ 
/* 247 */           break;
/*     */         case -2147483647:
/* 249 */           break;
/*     */         case -2147483646:
/* 251 */           break;
/*     */         case -2147483642:
/* 253 */           break;
/*     */         }
/*     */ 
/* 259 */         if ((this.CurPack.ReqestId != RequestId.Deliver) && 
/* 260 */           (this.CurPack.ReqestId != RequestId.Login_Resp) && 
/* 261 */           (this.CurPack.ReqestId != RequestId.Submit_Resp) && 
/* 262 */           (this.CurPack.ReqestId != RequestId.Exit_Resp) && 
/* 263 */           (!CheckLongSmsOverTime(this.LongSmsOverTime))) continue;
/* 264 */         if ((this.CurPack.ReqestId == RequestId.Submit_Resp) || 
/* 265 */           (this.CurPack.ReqestId == RequestId.Login_Resp) || 
/* 266 */           (this.CurPack.ReqestId == RequestId.Exit_Resp))
/* 267 */           this.undoPack.add(this.CurPack);
/* 268 */         synchronized (this) {
/* 269 */           notifyAll();
/*     */         }
/*     */       }
/*     */       catch (SocketTimeoutException e)
/*     */       {
/* 274 */         SendActive(); continue;
/*     */       }
/*     */       catch (IOException e) {
/* 277 */         if ((this.DisplayMode >= 1) && (this.Logout == 0))
/* 278 */           System.out.println("Lost Connect,ReConnect");
/*     */       }
/* 280 */       if (this.Logout == 0)
/* 281 */         ReConnect(1000);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setLSmsOverTime(int second)
/*     */   {
/* 290 */     this.LongSmsOverTime = second;
/*     */   }
/*     */ 
/*     */   private void SendActive() {
/* 294 */     ActiveTestMessage activeTestMessage = new ActiveTestMessage();
/*     */     try {
/* 296 */       SendBuf(activeTestMessage.getBuf());
/*     */     } catch (IOException e) {
/* 298 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void AddLongSms(DeliverMessage dm)
/*     */   {
/* 304 */     if (this.longsmsbuffer.get(dm.SrcTermID) != null) {
/* 305 */       int curstat = ((LongDeliver)this.longsmsbuffer.get(dm.SrcTermID)).AddDeliver(dm);
/*     */ 
/* 310 */       if (curstat == 0)
/* 311 */         return;
/* 312 */       if (curstat == 1) {
/* 313 */         this.deliverbuffer.add(((LongDeliver)this.longsmsbuffer.get(dm.SrcTermID))
/* 314 */           .MergeDeliver());
/* 315 */         this.longsmsbuffer.remove(dm.SrcTermID);
/* 316 */       } else if (curstat == -1) {
/* 317 */         DeliverMessage[] tmpdeliver = ((LongDeliver)this.longsmsbuffer.get(
/* 318 */           dm.SrcTermID)).popDeliver();
/* 319 */         for (int i = 0; i < tmpdeliver.length; i++) {
/* 320 */           this.deliverbuffer.add(tmpdeliver[i]);
/*     */         }
/* 322 */         this.longsmsbuffer.put(dm.SrcTermID, new LongDeliver(dm));
/*     */       }
/*     */     } else {
/* 325 */       this.longsmsbuffer.put(dm.SrcTermID, new LongDeliver(dm));
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized Deliver OnDeliver()
/*     */   {
/* 331 */     while (this.deliverbuffer.size() == 0) {
/*     */       try {
/* 333 */         synchronized (this)
/*     */         {
/* 335 */           wait();
/*     */         }
/*     */       }
/*     */       catch (RuntimeException e) {
/* 339 */         e.printStackTrace();
/*     */       } catch (InterruptedException e) {
/* 341 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 345 */     Deliver dm = new Deliver((DeliverMessage)this.deliverbuffer.get(0));
/* 346 */     this.deliverbuffer.remove(0);
/*     */ 
/* 348 */     return dm;
/*     */   }
/*     */ 
/*     */   private boolean CheckLongSmsOverTime(int second) {
/* 352 */     Iterator spit = this.longsmsbuffer.keySet().iterator();
/*     */ 
/* 354 */     while (spit.hasNext())
/*     */     {
/* 356 */       String key = "";
/*     */       DeliverMessage[] tmpDeliverMsg;
/* 357 */       if ((tmpDeliverMsg = ((LongDeliver)this.longsmsbuffer.get(
/* 358 */         key = (String)spit.next())).CheckIfOverTime(second)) != null) {
/* 359 */         for (int i = 0; i < tmpDeliverMsg.length; i++) {
/* 360 */           this.deliverbuffer.add(tmpDeliverMsg[i]);
/*     */         }
/*     */ 
/* 363 */         this.longsmsbuffer.remove(key);
/* 364 */         return true;
/*     */       }
/*     */     }
/*     */ 
/* 368 */     return false;
/*     */   }
/*     */ 
/*     */   public synchronized void LogOut() {
/* 372 */     ExitMessage em = new ExitMessage();
/* 373 */     this.Logout = 1;
/*     */     try {
/* 375 */       SendBuf(em.getBuf());
/*     */ 
/* 377 */       long sendTime = getTimeStamp().longValue();
/* 378 */       Package tmppack = new Package();
/* 379 */       while ((getTimeStamp().longValue() - sendTime < 60000L) && 
/* 380 */         ((tmppack = checkPackage(0, RequestId.Exit_Resp)) != null)) {
/*     */         try {
/* 382 */           synchronized (this) {
/* 383 */             wait(60000L);
/*     */           }
/*     */         }
/*     */         catch (RuntimeException e) {
/* 387 */           e.printStackTrace();
/*     */         } catch (InterruptedException e) {
/* 389 */           e.printStackTrace();
/*     */         }
/*     */       }
/*     */ 
/* 393 */       this.GwSocket.close();
/* 394 */       if (this.LogFile != null) {
/* 395 */         this.LogFile.close();
/*     */       }
/* 397 */       stop();
/*     */     } catch (IOException e) {
/* 399 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized Deliver getDeliver()
/*     */   {
/* 405 */     if (this.deliverbuffer.size() == 0) {
/* 406 */       return null;
/*     */     }
/* 408 */     Deliver dm = new Deliver(
/* 409 */       (DeliverMessage)this.deliverbuffer
/* 409 */       .get(0));
/* 410 */     this.deliverbuffer.remove(0);
/*     */ 
/* 412 */     return dm;
/*     */   }
/*     */ 
/*     */   public synchronized Result Login()
/*     */   {
/* 417 */     if (!this.HasConnect) {
/* 418 */       return new Result(-2, "Can not creat socket!");
/*     */     }
/* 420 */     Result result = new Result();
/*     */     try {
/* 422 */       LoginMessage lm = new LoginMessage(this.ClientID, 
/* 423 */         this.ClientPasswd, this.LoginMode);
/* 424 */       SendBuf(lm.getBuf());
/*     */ 
/* 427 */       while ((this.CurPack == null) || 
/* 428 */         (this.CurPack.ReqestId != RequestId.Login_Resp)) {
/*     */         try {
/* 430 */           synchronized (this) {
/* 431 */             wait();
/*     */           }
/*     */         }
/*     */         catch (RuntimeException e) {
/* 435 */           e.printStackTrace();
/*     */         }
/*     */       }
/*     */ 
/* 439 */       LoginRespMessage lrm = new LoginRespMessage(this.CurPack.Message);
/* 440 */       result.ErrorCode = lrm.getStatus();
/* 441 */       result.ErrorDescription = 
/* 442 */         ("SerVersion:" + lrm.getServerVersion() + 
/* 442 */         " ShareKey:" + Hex.rhex(lrm.getAuthenticatorServer()));
/*     */ 
/* 444 */       if (lrm.getStatus() == 0)
/* 445 */         this.HasLogin = 1;
/*     */     }
/*     */     catch (IllegalArgumentException e) {
/* 448 */       e.printStackTrace();
/*     */     } catch (NoSuchAlgorithmException e) {
/* 450 */       e.printStackTrace();
/*     */     } catch (IOException e) {
/* 452 */       e.printStackTrace();
/*     */     } catch (InterruptedException e) {
/* 454 */       e.printStackTrace();
/*     */     }
/* 456 */     return result;
/*     */   }
/*     */ 
/*     */   public synchronized Result[] SendLong(Submit submit)
/*     */   {
/* 461 */     Vector splitContent = SplitContent(submit.getMsgContent());
/* 462 */     Result[] result = new Result[splitContent.size()];
/*     */ 
/* 464 */     for (int i = 0; i < splitContent.size(); i++) {
/* 465 */       Submit tmpSubmit = submit;
/* 466 */       tmpSubmit.setMsgContent(addContentHeader((byte[])splitContent.get(i), 
/* 467 */         splitContent.size(), i + 1));
/*     */ 
/* 470 */       tmpSubmit.setTP_udhi(1);
/* 471 */       tmpSubmit.AddTlv(TlvId.PkNumber, String.valueOf(i + 1));
/* 472 */       tmpSubmit
/* 473 */         .AddTlv(TlvId.PkTotal, String.valueOf(splitContent.size()));
/* 474 */       result[i] = Send(tmpSubmit);
/*     */     }
/*     */ 
/* 478 */     return result;
/*     */   }
/*     */ 
/*     */   public synchronized Result SendWapPush(String desc, String url, String srcTermId, String destTermid, String productID)
/*     */   {
/* 484 */     Submit[] submitarray = WapPushPdu.getWapPushSubmit(desc, url, 
/* 485 */       srcTermId, destTermid, destTermid, productID);
/* 486 */     Result result = null;
/* 487 */     Result resulttmp = null;
/* 488 */     for (int i = 0; i < submitarray.length; i++) {
/* 489 */       resulttmp = Send(submitarray[i]);
/*     */ 
/* 491 */       if ((result == null) || (resulttmp.ErrorCode != 0)) {
/* 492 */         result = resulttmp;
/*     */       }
/*     */     }
/* 495 */     return result;
/*     */   }
/*     */ 
/*     */   public synchronized Result SendWapPush(String desc, String url, Submit submit)
/*     */   {
/* 501 */     Submit[] submitarray = WapPushPdu.getWapPushSubmit(desc, url, submit);
/* 502 */     Result result = null;
/* 503 */     Result resulttmp = null;
/* 504 */     for (int i = 0; i < submitarray.length; i++) {
/* 505 */       resulttmp = Send(submitarray[i]);
/*     */ 
/* 507 */       if ((result == null) || (resulttmp.ErrorCode != 0)) {
/* 508 */         result = resulttmp;
/*     */       }
/*     */     }
/* 511 */     return result;
/*     */   }
/*     */ 
/*     */   private static byte[] addContentHeader(byte[] content, int total, int num)
/*     */   {
/* 603 */     byte[] newcontent = new byte[content.length + 6];
/* 604 */     newcontent[0] = 5;
/* 605 */     newcontent[1] = 0;
/* 606 */     newcontent[2] = 3;
/* 607 */     newcontent[4] = ((byte)total);
/* 608 */     newcontent[5] = ((byte)num);
/* 609 */     System.arraycopy(content, 0, newcontent, 6, content.length);
/*     */ 
/* 611 */     return newcontent;
/*     */   }
/*     */ 
/*     */   private static Vector<byte[]> SplitContent(byte[] content) {
/* 615 */     ByteArrayInputStream buf = new ByteArrayInputStream(content);
/* 616 */     Vector tmpv = new Vector();
/*     */ 
/* 618 */     int msgCount = content.length / 134 + 1;
/* 619 */     int LeftLen = content.length;
/* 620 */     for (int i = 0; i < msgCount; i++) {
/* 621 */       byte[] tmp = new byte[''];
/* 622 */       if (LeftLen < 134)
/* 623 */         tmp = new byte[LeftLen];
/*     */       try {
/* 625 */         buf.read(tmp);
/* 626 */         tmpv.add(tmp);
/*     */       } catch (IOException e) {
/* 628 */         e.printStackTrace();
/*     */       }
/* 630 */       LeftLen -= tmp.length;
/*     */     }
/* 632 */     return tmpv;
/*     */   }
/*     */ 
/*     */   public synchronized Result Send(Submit submit)
/*     */   {
/* 642 */     if (submit.getMsgContent().length > 200) {
/* 643 */       return new Result(4, "Message too Long");
/*     */     }
/* 645 */     Vector tlv = new Vector();
/* 646 */     if ((this.SPID != null) && (!this.SPID.equals(""))) {
/* 647 */       tlv.add(new Tlv(TlvId.MsgSrc, this.SPID));
/*     */     }
/* 649 */     if ((submit.getProductID() != null) && (!submit.getProductID().equals(""))) {
/* 650 */       tlv.add(new Tlv(TlvId.Mserviceid, submit.getProductID()));
/*     */     }
/*     */ 
/* 653 */     if (submit.getTP_udhi() == 1) {
/* 654 */       tlv.add(new Tlv(TlvId.TP_udhi, String.valueOf(1)));
/*     */     }
/*     */ 
/* 657 */     if ((submit.getLinkID() != null) && (!submit.getLinkID().equals(""))) {
/* 658 */       tlv.add(new Tlv(TlvId.LinkID, submit.getLinkID()));
/*     */     }
/*     */ 
/* 661 */     if (submit.getOtherTlvArray() != null) {
/* 662 */       for (int i = 0; i < submit.getOtherTlvArray().length; i++) {
/* 663 */         tlv.add(submit.getOtherTlvArray()[i]);
/*     */       }
/*     */     }
/* 666 */     Tlv[] tlvarray = new Tlv[tlv.size()];
/*     */ 
/* 668 */     for (int i = 0; i < tlv.size(); i++)
/*     */     {
/* 670 */       tlvarray[i] = ((Tlv)tlv.get(i));
/*     */     }
/*     */ 
/* 673 */     String[] desttermidarray = new String[1];
/* 674 */     desttermidarray[0] = submit.getDestTermid();
/* 675 */     if (this.SequenceId++ == 8388607) {
/* 676 */       this.SequenceId = 0;
/*     */     }
/*     */ 
/* 679 */     int tmpseq = this.SequenceId;
/* 680 */     SubmitMessage sm = new SubmitMessage(submit.getMsgType(), submit
/* 681 */       .getNeedReport(), submit.getPriority(), submit.getServiceID(), 
/* 682 */       submit.getFeetype(), submit.getFeeCode(), submit.getFixedFee(), 
/* 683 */       submit.getMsgFormat(), submit.getValidTime(), submit
/* 684 */       .getAtTime(), submit.getSrcTermid(), submit
/* 685 */       .getChargeTermid(), desttermidarray, submit
/* 686 */       .getMsgLength(), submit.getMsgContent(), submit
/* 687 */       .getReserve(), tlvarray, tmpseq);
/*     */     try
/*     */     {
/* 690 */       SendBuf(sm.getBuf());
/*     */ 
/* 692 */       if (this.DisplayMode >= 2)
/* 693 */         DisplayPackage(sm.getBuf(), 1);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 697 */       return new Result(-1, "Socket Error!");
/*     */     }
/*     */ 
/* 701 */     long sendTime = getTimeStamp().longValue();
/*     */ 
/* 708 */     Package tmppack = new Package();
/* 709 */     while ((getTimeStamp().longValue() - sendTime < 60000L) && 
/* 710 */       ((tmppack = checkPackage(tmpseq, RequestId.Submit_Resp)) == null)) {
/*     */       try
/*     */       {
/* 713 */         synchronized (this) {
/* 714 */           wait(60000L);
/*     */         }
/*     */       }
/*     */       catch (RuntimeException e) {
/* 718 */         e.printStackTrace();
/*     */       } catch (InterruptedException e) {
/* 720 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 724 */     if (tmppack != null) {
/* 725 */       SubmitRespMessage srm = new SubmitRespMessage(tmppack.Message);
/* 726 */       return new Result(srm.getStatus(), srm.getMsgID());
/*     */     }
/* 728 */     System.out.println("SubmitResp��ʱ��Seq:" + tmpseq);
/* 729 */     return new Result(-1, "00000000000000000000");
/*     */   }
/*     */ 
/*     */   private static Long getTimeStamp()
/*     */   {
/* 742 */     return Long.valueOf(new Date().getTime());
/*     */   }
/*     */ 
/*     */   public synchronized Result SendBatch(SubmitBatch submit)
/*     */   {
/* 747 */     Vector tlv = new Vector();
/* 748 */     if ((this.SPID != null) && (!this.SPID.equals(""))) {
/* 749 */       tlv.add(new Tlv(TlvId.MsgSrc, this.SPID));
/*     */     }
/* 751 */     if ((submit.getProductID() != null) && (!submit.getProductID().equals(""))) {
/* 752 */       tlv.add(new Tlv(TlvId.Mserviceid, submit.getProductID()));
/*     */     }
/*     */ 
/* 755 */     if ((submit.getLinkID() != null) && (!submit.getLinkID().equals(""))) {
/* 756 */       tlv.add(new Tlv(TlvId.LinkID, submit.getLinkID()));
/*     */     }
/*     */ 
/* 759 */     if (submit.getOtherTlvArray() != null) {
/* 760 */       for (int i = 0; i < submit.getOtherTlvArray().length; i++) {
/* 761 */         tlv.add(submit.getOtherTlvArray()[i]);
/*     */       }
/*     */     }
/* 764 */     Tlv[] tlvarray = new Tlv[tlv.size()];
/*     */ 
/* 766 */     for (int i = 0; i < tlv.size(); i++)
/*     */     {
/* 768 */       tlvarray[i] = ((Tlv)tlv.get(i));
/*     */     }
/*     */ 
/* 773 */     if (this.SequenceId++ == 8388607) {
/* 774 */       this.SequenceId = 0;
/*     */     }
/* 776 */     SubmitMessage sm = new SubmitMessage(submit.getMsgType(), submit
/* 777 */       .getNeedReport(), submit.getPriority(), submit.getServiceID(), 
/* 778 */       submit.getFeetype(), submit.getFeeCode(), submit.getFixedFee(), 
/* 779 */       submit.getMsgFormat(), submit.getValidTime(), submit
/* 780 */       .getAtTime(), submit.getSrcTermid(), submit
/* 781 */       .getChargeTermid(), submit.getDestTermid(), submit
/* 782 */       .getMsgLength(), submit.getMsgContent(), submit
/* 783 */       .getReserve(), tlvarray, this.SequenceId);
/*     */     try
/*     */     {
/* 786 */       SendBuf(sm.getBuf());
/*     */ 
/* 788 */       if (this.DisplayMode >= 2)
/* 789 */         DisplayPackage(sm.getBuf(), 1);
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 793 */       return new Result(-1, "Socket Error!");
/*     */     }
/*     */ 
/* 797 */     while ((this.CurPack == null) || 
/* 798 */       (this.CurPack.ReqestId != RequestId.Submit_Resp)) {
/*     */       try {
/* 800 */         synchronized (this) {
/* 801 */           wait();
/*     */         }
/*     */       }
/*     */       catch (RuntimeException e) {
/* 805 */         e.printStackTrace();
/*     */       } catch (InterruptedException e) {
/* 807 */         e.printStackTrace();
/*     */       }
/*     */     }
/*     */ 
/* 811 */     Result result = new Result();
/* 812 */     SubmitRespMessage srm = new SubmitRespMessage(this.CurPack.Message);
/*     */ 
/* 816 */     return new Result(srm.getStatus(), srm.getMsgID());
/*     */   }
/*     */ 
/*     */   private void DisplayPackage(int len, byte[] message, int sendOrReceive)
/*     */   {
/* 822 */     if (sendOrReceive == 0)
/* 823 */       System.out.println("-------------Receive Package-------------");
/*     */     else {
/* 825 */       System.out.println("--------------Send  Package--------------");
/*     */     }
/* 827 */     System.out.println("Length:" + len);
/* 828 */     System.out.println("Pack:" + Hex.rhex(message));
/*     */   }
/*     */ 
/*     */   private void DisplayPackage(byte[] message, int sendOrReceive) {
/* 832 */     int len = TypeConvert.byte2int(message, 0);
/* 833 */     byte[] messagetmp = new byte[message.length - 4];
/*     */ 
/* 835 */     System.arraycopy(message, 4, messagetmp, 0, messagetmp.length);
/*     */ 
/* 838 */     DisplayPackage(len, messagetmp, sendOrReceive);
/*     */   }
/*     */ 
/*     */   private synchronized void SendBuf(byte[] buf) throws IOException
/*     */   {
/* 843 */     this.out.write(buf);
/* 844 */     if (this.LogFile != null) {
/* 845 */       this.LogFile.write("[" + GetTime() + "]" + "Send:" + Hex.rhex(buf) + 
/* 846 */         "\n");
/* 847 */       this.LogFile.flush();
/*     */     }
/*     */   }
/*     */ 
/*     */   private synchronized Package checkPackage(int seq, int reqid)
/*     */   {
/* 853 */     for (int i = 0; i < this.undoPack.size(); i++) {
/* 854 */       Package pk = (Package)this.undoPack.get(i);
/*     */ 
/* 856 */       if ((pk.SequenceId == seq) && (pk.ReqestId == reqid)) {
/* 857 */         this.undoPack.remove(i);
/* 858 */         return pk;
/*     */       }
/* 860 */       if (new Date().getTime() - pk.timestamp > 60000L)
/*     */       {
/* 862 */         this.undoPack.remove(i);
/* 863 */         i--;
/*     */       }
/*     */     }
/*     */ 
/* 867 */     return null;
/*     */   }
/*     */ 
/*     */   private static String GetTime() {
/* 871 */     String TimeStamp = "";
/* 872 */     Calendar now = Calendar.getInstance();
/*     */ 
/* 874 */     SimpleDateFormat bartDateFormat = new SimpleDateFormat(
/* 875 */       "yyyy-MM-dd HH:mm:ss");
/* 876 */     return bartDateFormat.format(now.getTime());
/*     */   }
/*     */ 
/*     */   private static int GetStartSeq()
/*     */   {
/* 888 */     SimpleDateFormat bartDateFormat = new SimpleDateFormat("HHmmss");
/* 889 */     Calendar now = Calendar.getInstance();
/*     */ 
/* 891 */     return Integer.parseInt(bartDateFormat.format(now.getTime()));
/*     */   }
/*     */ }

/* Location:           C:\Users\Administrator\Desktop\message-1.0.1.jar
 * Qualified Name:     cn.com.jshx.smgp.connect.PConnect
 * JD-Core Version:    0.6.2
 */