/**
 * Copyright 2011 hongxin 
 * Change Revision
 * ---------------------------------------------------------------
 * Date               Author            Remarks
 * 2011-1-25        Chenjian          create
 * Feb 10, 2011        Chenjian          添加登录日志
 * ---------------------------------------------------------------
 */
package com.jshx.module.admin.web.action;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import com.fr.web.core.A.O;
import com.google.gwt.user.client.rpc.core.java.util.Arrays;
import com.jshx.core.utils.*;
import com.jshx.http.HttpclientUtil;
import com.jshx.http.NetServiceException;
import com.jshx.jkfsjlb.entity.Jkfsjlb;
import com.jshx.jkfsjlb.service.JkfsjlbService;
import com.jshx.mobile.utils.DESUtil;
import com.jshx.paymentItemHis.entity.PaymentItemHis;
import com.jshx.paymentItemHis.service.PaymentItemHisService;
import com.jshx.tbshxk.entity.Tbshxk;
import com.jshx.tbshxk.service.TbshxkService;
import com.jshx.wwjdclinfo.entity.Wwjdclinfo;
import com.jshx.wwjdclinfo.service.WwjdclinfoService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.fop.cli.Main;
import org.apache.http.params.CoreProtocolPNames;
import org.apache.log4j.MDC;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.struts2.ServletActionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import com.jshx.core.base.action.BaseAction;
import com.jshx.core.base.vo.Pagination;
import com.jshx.core.security.RSAKeyGenerater;
import com.jshx.dxjl.entity.Dxjl;
import com.jshx.dxjl.service.DxjlService;
import com.jshx.fawen.service.FawenReceiveinfoService;
import com.jshx.module.admin.entity.Code;
import com.jshx.module.admin.entity.Department;
import com.jshx.module.admin.entity.LogoffLog;
import com.jshx.module.admin.entity.LogonLog;
import com.jshx.module.admin.entity.Module;
import com.jshx.module.admin.entity.OnlineUser;
import com.jshx.module.admin.entity.Permission;
import com.jshx.module.admin.entity.QuicklyStart;
import com.jshx.module.admin.entity.User;
import com.jshx.module.admin.entity.UserRight;
import com.jshx.module.admin.service.CodeService;
import com.jshx.module.admin.service.DeptService;
import com.jshx.module.admin.service.LogService;
import com.jshx.module.admin.service.LogoffLogService;
import com.jshx.module.admin.service.ModuleService;
import com.jshx.module.admin.service.OnlineUserService;
import com.jshx.module.admin.service.QuicklyStartService;
import com.jshx.module.admin.service.SecurityService;
import com.jshx.module.admin.service.UserLinkedDeptService;
import com.jshx.module.admin.service.UserService;
import com.jshx.returnItem.entity.ReturnItem;
import com.jshx.returnItem.service.ReturnItemService;
import com.jshx.schedule.entity.Schedule1;
import com.jshx.schedule.service.Schedule1Service;
import com.jshx.xmxxb.entity.Xmxxb;
import com.jshx.xmxxb.service.XmxxbService;
import com.jshx.xxjl.service.XxjlService;
import com.jshx.zsdw.entity.Zsdw;
import com.jshx.zsdw.service.ZsdwService;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Encoder;

/**
 * @author Chenjian
 * @version 创建时间：2011-1-25 上午11:11:57 公共Action
 */
@Component
public class CommonAction extends BaseAction
{

	@Autowired
	private FawenReceiveinfoService fawenReceiveService;
	@Autowired
	private XxjlService xxjlService;
	
	@Autowired()
	@Qualifier("securityServiceImpl")
	private SecurityService securityService;

	@Autowired()
	@Qualifier("quicklyStartService")
	private QuicklyStartService quicklyStartService;

	@Autowired()
	@Qualifier("moduleService")
	private ModuleService moduleService;

	@Autowired()
	@Qualifier("deptService")
	private DeptService deptService;

	@Autowired()
	@Qualifier("userService")
	private UserService userService;

	@Autowired()
	@Qualifier("logService")
	private LogService logService;

	@Autowired()
	@Qualifier("codeService")
	private CodeService codeService;

	@Autowired()
	@Qualifier("onlineUserService")
	private OnlineUserService onlineUserService;

	@Autowired()
	@Qualifier("userLinkedDeptService")
	private UserLinkedDeptService userLinkedDeptService;

	@Autowired()
	@Qualifier("logoffLogService")
	private LogoffLogService logoffLogService;

	@Autowired()
	@Qualifier("zsdwService")
	private ZsdwService zsdwService;

	/**
	 * 业务类
	 */
	private  static JkfsjlbService jkfsjlbService;

    /**
     * 业务类
     */
    private  static XmxxbService xmxxbService;

    /**
     * 业务类
     */
    private  static PaymentItemHisService paymentItemHisService;

	/**
	 * 业务类
	 */
	private  static WwjdclinfoService wwjdclinfoService;

    /**
     * 业务类
     */
    private  static TbshxkService tbshxkService;
	
	private List<Module> moduleList;
	private List<Module> moduleList1;
	private List  shouwenList;
	private List  xxfhList;
	private List<User> userList;

	private Module module;

	private String codeId;

	private Boolean isChecked;

	private Boolean showCheck;
	JSONArray jsonRoot = new JSONArray();
	private Code code;

	private String func;

	private String message = "";

	private String css;

	private String extendParams;

	private String test;

	private String uuid;

	private Long timestamp;

	private Integer safety;

	private static final long serialVersionUID = 6026790061476395281L;

	// 用户登录用户名与密码
	private String loginId;
	private String password;
	private User user;
	private Department dept;
	private String credential;

	/** ajax模式登录消息 */
	private Map<String, Object> map;

	/** 登录方式：0表示用手机号登录；1表示用用户ID登录 */
	private Integer loginType = 1;

	private String callback;

	private List<QuicklyStart> quikStarList;

	private List<Map<String, Object>> items;
	private List<Map<String, Object>> allItems;

	private List<QuicklyStart> startList;

	private String validateFlag;

	public String getUserNameIds()
	{
		return userNameIds;
	}

	public void setUserNameIds(String userNameIds)
	{
		this.userNameIds = userNameIds;
	}

	private String userNameIds;

	public void caLogin()
	{
		try
		{
			Map<String, Object> map = new HashMap<String, Object>();
			String id = this.getRequestParameter("deviceid");
			map.put("deviceId", id);
			User user = userService.findUsrByDeviceId(map);
			if (user != null)
			{
				this.getResponse().getWriter().println(
						"{\"name\":\"" + user.getLoginId() + "\",\"password\":\"" + user.getPassword() + "\"}");
			}
		} catch (IOException e)
		{
			e.printStackTrace();
		}
	}

	public String certlogin()
	{
		// try {
		// IAccount cc = new IAccount(this.getRequest(),this.getResponse());
		// cc.SetManager("61.177.144.130","61.177.144.130","test","753042863409190729368247","/");
		// if(cc.CheckCertLogin()){
		// UserBean bean = cc.getUserBean();
		// Struts2Util.getSession().setAttribute("name", bean.getUserID());
		// System.out.println("{\"name\":\""+ bean.getUserID()+"\"}");
		//
		// }
		//
		//
		//
		// } catch (Exception e) {
		// e.printStackTrace();
		// }

		return SUCCESS;
	}

	/**
	 * CA用户登录，参数：loginType（默认loginId为用户名
	 * 返回json字符串：{"loginMessage":"","loginCode":""}
	 * @return 
	 * @return String
	 * @throws java.io.IOException
	 */
	public String caAuthLogin()
	{
		try
		{

			Subject currentUser = SecurityUtils.getSubject();
			UsernamePasswordToken token = null;

			token = new UsernamePasswordToken(loginId, password);
			token.setRememberMe(false);
			try
			{
				currentUser.login(token);
			} catch (AuthenticationException e)
			{
				String error = userService.doErrorPassword(loginId, true);
				if (null != error)
					this.getSession().setAttribute(Constants.LOGIN_MESSAGE, error);
				else
					this.getSession().setAttribute(Constants.LOGIN_MESSAGE, e.getLocalizedMessage());
				this.getSession().setAttribute(Constants.LOGIN_FAIL, "true");

				return INPUT;
			}
			if (currentUser.isAuthenticated())
			{
				user = getLoginUser();
				List<?> rightList = user.getUserRoles();
				Map<String, List<String>> permissions = user.getPermissions();
				if (permissions == null)
					permissions = new HashMap<String, List<String>>();

				// 角色增加2个字段用于配置 超级管理员和部门管理员
				if (rightList != null && rightList.size() > 0)
				{
					String[] roleIds = new String[rightList.size()];
					for (int i = 0; i < rightList.size(); i++)
					{
						UserRight right = (UserRight) rightList.get(i);
						roleIds[i] = right.getRole().getId();
						if (null != (right.getRole().getIsSupAdmin()) && 1 == (right.getRole().getIsSupAdmin()))
						{
							user.setIsSuperAdmin(true);
						}
						List<String> pm = permissions.get(right.getRole().getRoleName());
						if (pm == null)
							pm = new ArrayList<String>();
						List<Permission> list = securityService.findPermission(null, right.getRole().getId(), null,
								null);
						if (list != null && list.size() > 0)
						{
							for (Permission permission : list)
							{
								pm.add(permission.getPermissionExpression());
							}
						}

						permissions.put(right.getRole().getRoleName(), pm);

					}

					user.setRoleIds(roleIds);

				}

				List<String> pm = new ArrayList<String>();
				List<Permission> list = securityService.findPermission(user.getId(), null, null, null);
				if (list != null && list.size() > 0)
				{
					for (Permission permission : list)
					{
						pm.add(permission.getPermissionExpression());
					}
				}
				permissions.put("NO_ROLE", pm);
				user.setPermissions(permissions);

				saveExtendVarToSession();
				// 查看用户在登录前是否有需要查看的页面，如果有，转到该页面
				String requestUrl = (String) this.getSessionAttribute(Constants.USER_REQUEST_URL);
				if (requestUrl != null && !requestUrl.trim().equals("") && requestUrl.indexOf("logout.action") == -1)
				{
					try
					{
						this.getResponse().sendRedirect(requestUrl);
						return null;
					} catch (Exception e)
					{
						e.printStackTrace();
					}
				}
			}
			else
			{
				this.getSession().setAttribute(Constants.LOGIN_MESSAGE, Constants.LOGIN_ERROR);
				this.getSession().setAttribute(Constants.LOGIN_FAIL, "true");
				return INPUT;
			}
		} catch (Exception e)
		{
			e.printStackTrace();
			this.getSession().setAttribute(Constants.LOGIN_MESSAGE, e.getMessage());
			this.getSession().setAttribute(Constants.LOGIN_FAIL, "true");
			return INPUT;
		}
		this.getSession().setAttribute("calogin", "true");
		check();
		return SUCCESS;
	}

	/**
	 * 手机端用户登录，参数：loginType（默认loginId为用户名，当值为0时loginId为手机号码）、loginId、password<br>
	 * 返回json字符串：{"loginMessage":"","loginCode":""}
	 * @return String
	 * @throws java.io.IOException
	 */
	@SuppressWarnings("unchecked")
	public void mobileLogin()
	{
		Map<String, String> result = new HashMap<String, String>();

		try
		{
			if (loginType == 0)
			{
				user = userService.checkPasswordByMobile(loginId, password);
			}
			else
				user = userService.checkPassword(loginId, CodeUtil.encode(password, CodeUtil.MD5));

			if (null != user)
			{

				if (user.getDelFlag() == 1 || ((Department) user.getDept()).getDelFlag() == 1)
				{
					result.put("loginCode", "0");
					result.put("loginMessage", "用户或用户的所在部门被禁用！");
				}
				else
				{
					List<String> deptIds = setUserDeptIds(user.getId(), ((Department) user.getDept()).getId());
					user.setDeptIds(deptIds);

					List rightList = user.getUserRoles();
					if (rightList != null && rightList.size() > 0)
					{
						String[] roleIds = new String[rightList.size()];

						for (int i = 0; i < rightList.size(); i++)
						{
							UserRight right = (UserRight) rightList.get(i);
							roleIds[i] = right.getRole().getId();
							if (right.getRole().getIsSupAdmin() == 1)
							{
								user.setIsSuperAdmin(true);
							}
						}
						user.setRoleIds(roleIds);
					}
					user.setLogTime(new Date());
					Map<String, User> userMap = (Map<String, User>) Struts2Util.getServletContext()
							.getAttribute(Constants.CURR_USERS);
					if (userMap == null)
						userMap = new HashMap<String, User>();
					userMap.put(user.getId(), user);
					Struts2Util.getServletContext().setAttribute(Constants.CURR_USERS, userMap);
					this.getSession().setAttribute(Constants.CURR_USER, user);
					this.getSession().setAttribute(Constants.LOGIN_USER_ID, user.getId());
					user.setLinkedDepts(userLinkedDeptService.getLinkedDeptByUser(user.getId()));

					// 在线用户
					setOnlineInfo(user, "手机");
					MDC.put("userId", user.getId());
					result.put("loginCode", "1");
					result.put("loginMessage", "登录成功");
				}
			}
			else
			{
				result.put("loginCode", "0");
				result.put("loginMessage", Constants.LOGIN_ERROR);
			}
		} catch (Exception e)
		{
			result.put("loginCode", "0");
			result.put("loginMessage", e.getMessage());
		}

		try
		{
			JSONObject json = JSONObject.fromObject(result);
			this.getResponse().getWriter().println(callback + "(" + json.toString() + ")");
		} catch (Exception e)
		{
			e.printStackTrace();
		}
	}

	public void checkSession()
	{
		map = new HashMap<String, Object>();
		try
		{
			Subject currentUser = SecurityUtils.getSubject();
			if (currentUser == null || !currentUser.isAuthenticated())
			{
				map.put("result", false);
			}
			else
			{
				map.put("result", true);
			}
		} catch (Exception e)
		{
			map.put("result", false);
			map.put("error", e.getLocalizedMessage());
		}
		try
		{
			JSONObject json = JSONObject.fromObject(map);
			this.getResponse().getWriter().println(json);
		} catch (Exception e)
		{
			logger.error(e.getLocalizedMessage(), e);
		}
	}

	/**
	 * Ajax登录，参数：loginId、password<br>
	 * 返回json字符串：{"info":""}
	 * 
	 * @throws java.io.IOException
	 */
	public void ajaxLogin()
	{
		map = new HashMap<String, Object>();
		try
		{

			Subject currentUser = SecurityUtils.getSubject();
			UsernamePasswordToken token = new UsernamePasswordToken(loginId, CodeUtil.encode(password, CodeUtil.MD5));
			token.setRememberMe(false);
			try
			{
				currentUser.login(token);
			} catch (AuthenticationException e)
			{
				this.getSession().setAttribute(Constants.LOGIN_MESSAGE, e.getLocalizedMessage());
				this.getSession().setAttribute(Constants.LOGIN_FAIL, "true");
				map.put("result", false);
				map.put("error", e.getLocalizedMessage());
			}
			if (currentUser.isAuthenticated())
			{
				user = getLoginUser();
				List<?> rightList = user.getUserRoles();
				Map<String, List<String>> permissions = user.getPermissions();
				if (permissions == null)
					permissions = new HashMap<String, List<String>>();

				// 角色增加2个字段用于配置 超级管理员和部门管理员
				if (rightList != null && rightList.size() > 0)
				{
					String[] roleIds = new String[rightList.size()];
					for (int i = 0; i < rightList.size(); i++)
					{
						UserRight right = (UserRight) rightList.get(i);
						roleIds[i] = right.getRole().getId();
						if (null != (right.getRole().getIsSupAdmin()) && 1 == (right.getRole().getIsSupAdmin()))
						{
							user.setIsSuperAdmin(true);
						}
						List<String> pm = permissions.get(right.getRole().getRoleName());
						if (pm == null)
							pm = new ArrayList<String>();
						List<Permission> list = securityService.findPermission(null, right.getRole().getId(), null,
								null);
						if (list != null && list.size() > 0)
						{
							for (Permission permission : list)
							{
								pm.add(permission.getPermissionExpression());
							}
						}

						permissions.put(right.getRole().getRoleName(), pm);

					}

					user.setRoleIds(roleIds);

				}

				List<String> pm = new ArrayList<String>();
				List<Permission> list = securityService.findPermission(user.getId(), null, null, null);
				if (list != null && list.size() > 0)
				{
					for (Permission permission : list)
					{
						pm.add(permission.getPermissionExpression());
					}
				}
				permissions.put("NO_ROLE", pm);
				user.setPermissions(permissions);

				saveExtendVarToSession();
				map.put("result", true);
				// 查看用户在登录前是否有需要查看的页面，如果有，转到该页面
				String requestUrl = (String) this.getSessionAttribute(Constants.USER_REQUEST_URL);
				if (requestUrl != null && !requestUrl.trim().equals("") && requestUrl.indexOf("logout.action") == -1)
				{
					map.put("requestUrl", requestUrl);
				}
			}
			else
			{
				this.getSession().setAttribute(Constants.LOGIN_MESSAGE, Constants.LOGIN_ERROR);
				this.getSession().setAttribute(Constants.LOGIN_FAIL, "true");
				map.put("result", false);
				map.put("error", Constants.LOGIN_ERROR);
			}
		} catch (Exception e)
		{
			map.put("result", false);
			map.put("error", e.getLocalizedMessage());
		}
		try
		{
			JSONObject json = JSONObject.fromObject(map);
			this.getResponse().getWriter().println(json);
		} catch (Exception e)
		{
			logger.error(e.getLocalizedMessage(), e);
		}
	}

	private String getBrowser(String userAgent)
	{
		if (userAgent.contains("MSIE") == true)
			return "IE";
		else if (userAgent.contains("Firefox") == true)
			return "Firefox";
		else if (userAgent.contains("Chrome") == true)
			return "Chrome";
		else if (userAgent.contains("Safari") == true)
			return "Safari";
		else if (userAgent.contains("Opera") == true)
			return "Opera";
		else
			return "其他";
	}

	private String getOS(String userAgent)
	{
		if (userAgent.contains("Windows") == true)
			return "Windows";
		else if (userAgent.contains("Linux") == true)
			return "Linux";
		else if (userAgent.contains("Mac") == true)
			return "Mac";
		else
			return "其他";
	}

	/**
	 * 添加/修改用户信息
	 * 
	 * @param user
	 * @return
	 */
	@SuppressWarnings("unchecked")
	protected String saveUser(User user)
	{

		if (user.getDelFlag() == 1 || ((Department) user.getDept()).getDelFlag() == 1)
		{
			this.getSession().setAttribute(Constants.LOGIN_MESSAGE, "用户或用户的所在部门被禁用！");
			return INPUT;
		}
		// 数据访问权限
		List<String> deptIds = setUserDeptIds(user.getId(), ((Department) user.getDept()).getId());
		user.setDeptIds(deptIds);
		List<?> rightList = user.getUserRoles();

		if (rightList != null && rightList.size() > 0)
		{
			String[] roleIds = new String[rightList.size()];
			for (int i = 0; i < rightList.size(); i++)
			{
				UserRight right = (UserRight) rightList.get(i);
				roleIds[i] = right.getRole().getId();
				if (right.getRole().getIsSupAdmin() == 1)
				{
					user.setIsSuperAdmin(true);
				}
			}
			user.setRoleIds(roleIds);
		}

		checkQuickStart(user);

		user.setLogTime(new Date());
		List<String> childDeptIds = deptService.findChildDeptIds(user.getDeptCode());
		dept = deptService.findDeptByDeptCode(user.getDeptCode());
		dept.setChildDeptIds(childDeptIds);
		user.setDept(dept);

		Map<String, User> userMap = (Map<String, User>) Struts2Util.getServletContext()
				.getAttribute(Constants.CURR_USERS);
		if (userMap == null)
			userMap = new HashMap<String, User>();
		userMap.put(user.getId(), user);
		Struts2Util.getServletContext().setAttribute(Constants.CURR_USERS, userMap);
		this.getSession().setAttribute(Constants.CURR_USER, user);
		this.getSession().setAttribute(Constants.LOGIN_USER_ID, user.getId());

		LogonLog log = new LogonLog();
		log.setFromIp(super.getRequest().getRemoteAddr());
		String userAgent = super.getRequest().getHeader("user-agent");
		log.setBrowser(this.getBrowser(userAgent));
		log.setOs(this.getOS(userAgent));
		log.setUserAgent(userAgent);
		log.setVisitedDate(new Date());
		log.setVisitor(user);
		log.setLoginType("电脑");
		logService.saveLogonLog(log);

		// 查看用户在登录前是否有需要查看的页面，如果有，转到该页面
		String requestUrl = (String) this.getSessionAttribute(Constants.USER_REQUEST_URL);
		if (requestUrl != null && !requestUrl.trim().equals("") && requestUrl.indexOf("logout.action") == -1)
		{

			try
			{
				this.getResponse().sendRedirect(requestUrl);
				return null;
			} catch (Exception e)
			{
				e.printStackTrace();
			}
		}
		return SUCCESS;
	}

	public void encryptCredential() throws Exception
	{
		RSAKeyGenerater keyGenerator = new RSAKeyGenerater();
		this.setSessionAttribute("keyGenerator", keyGenerator);
		this.getResponse().getWriter().print(keyGenerator.generateBase64PublicKey(timestamp));
	}

	/**
	 * 验证用户登录，根据系统配置需要进行验证码校验
	 * needCaptcha : 0, 登录页始终不显示验证码校验，后台不做验证
	 * needCaptcha : 1, 登录页始终显示验证码校验，后台做验证
	 * needCaptcha : 2, 登录页开始不显示验证码校验，当用户输入用户名密码错误超过3次以后显示验证码校验，后台开始做验证
	 * 
	 * @return String
	 * @throws java.io.IOException
	 */
	public String userLogin() throws IOException
	{

		try
		{
			/**
			 * 根据系统配置需要进行验证码校验
			 * needCaptcha : 0, 登录页始终不显示验证码校验，后台不做验证
			 * needCaptcha : 1, 登录页始终显示验证码校验，后台做验证
			 * needCaptcha : 2, 登录页开始不显示验证码校验，当用户输入用户名密码错误超过3次以后显示验证码校验，后台开始做验证
			 * 
			 * @author YuWeitao 2013-11-04
			 * 
			 */
			if ("1".equals(SysPropertiesUtil.getProperty("needCaptcha")))
			{
				if (!checkValidateNumber())
				{
					this.getSession().setAttribute(Constants.LOGIN_MESSAGE, Constants.CAPTCHA_ERROR);
					return INPUT;
				}
			}
			else if ("2".equals(SysPropertiesUtil.getProperty("needCaptcha")))
			{
				if ("true".equalsIgnoreCase(this.validateFlag) && !checkValidateNumber())
				{
					this.getSession().setAttribute(Constants.LOGIN_MESSAGE, Constants.CAPTCHA_ERROR);
					return INPUT;
				}
			}

			Subject currentUser = SecurityUtils.getSubject();
			UsernamePasswordToken token = null;
			/**
			if(safety!=null){
				String character = (String)getSessionAttribute("encrypt");
				//TODO 解密密码
				credential = PwEncryptUtil.decrypt(credential, character);
			}
			*/
			// TODO 使用RSA解密
			RSAKeyGenerater keyGenerator = (RSAKeyGenerater) this.getSessionAttribute("keyGenerator");
			credential = new String(keyGenerator.decryptBase64(credential));
			this.getSession().removeAttribute("keyGenerator");
			;
			token = new UsernamePasswordToken(loginId, CodeUtil.encode(credential, CodeUtil.MD5));
			token.setRememberMe(false);
			try
			{
				currentUser.login(token);
			} catch (AuthenticationException e)
			{
				String error = userService.doErrorPassword(loginId, true);
				if (null != error)
					this.getSession().setAttribute(Constants.LOGIN_MESSAGE, error);
				else
					this.getSession().setAttribute(Constants.LOGIN_MESSAGE, e.getLocalizedMessage());
				this.getSession().setAttribute(Constants.LOGIN_FAIL, "true");

				return INPUT;
			}
			if (currentUser.isAuthenticated())
			{
				user = getLoginUser();
				List<?> rightList = user.getUserRoles();
				Map<String, List<String>> permissions = user.getPermissions();
				if (permissions == null)
					permissions = new HashMap<String, List<String>>();

				// 角色增加2个字段用于配置 超级管理员和部门管理员
				if (rightList != null && rightList.size() > 0)
				{
					String[] roleIds = new String[rightList.size()];
					for (int i = 0; i < rightList.size(); i++)
					{
						UserRight right = (UserRight) rightList.get(i);
						roleIds[i] = right.getRole().getId();
						if (null != (right.getRole().getIsSupAdmin()) && 1 == (right.getRole().getIsSupAdmin()))
						{
							user.setIsSuperAdmin(true);
						}
						List<String> pm = permissions.get(right.getRole().getRoleName());
						if (pm == null)
							pm = new ArrayList<String>();
						List<Permission> list = securityService.findPermission(null, right.getRole().getId(), null,
								null);
						if (list != null && list.size() > 0)
						{
							for (Permission permission : list)
							{
								pm.add(permission.getPermissionExpression());
							}
						}

						permissions.put(right.getRole().getRoleName(), pm);

					}

					user.setRoleIds(roleIds);

				}

				List<String> pm = new ArrayList<String>();
				List<Permission> list = securityService.findPermission(user.getId(), null, null, null);
				if (list != null && list.size() > 0)
				{
					for (Permission permission : list)
					{
						pm.add(permission.getPermissionExpression());
					}
				}
				permissions.put("NO_ROLE", pm);
				user.setPermissions(permissions);

				saveExtendVarToSession();
				// 查看用户在登录前是否有需要查看的页面，如果有，转到该页面
				String requestUrl = (String) this.getSessionAttribute(Constants.USER_REQUEST_URL);
				if (requestUrl != null && !requestUrl.trim().equals("") && requestUrl.indexOf("logout.action") == -1)
				{
					try
					{
						this.getResponse().sendRedirect(requestUrl);
						return null;
					} catch (Exception e)
					{
						e.printStackTrace();
					}
				}
			}
			else
			{
				this.getSession().setAttribute(Constants.LOGIN_MESSAGE, Constants.LOGIN_ERROR);
				this.getSession().setAttribute(Constants.LOGIN_FAIL, "true");
				return INPUT;
			}
		} catch (Exception e)
		{
			e.printStackTrace();
			this.getSession().setAttribute(Constants.LOGIN_MESSAGE, e.getMessage());
			this.getSession().setAttribute(Constants.LOGIN_FAIL, "true");
			return INPUT;
		}
		check();
		this.getSession().setAttribute("calogin", "false");
		return SUCCESS;
	}

	// TODO bob
	private void check()
	{
		User user = getUser();
		String str = zsdwService.getDwdm(getLoginUserDepartmentId());
		String userid = "";
		if ("sf".equals(str))
		{
			String id = user.getLoginId();
			if (id != null && id != "")
			{
				switch (id.trim())
				{
				case "102001":
					userid = "201";
					break;
				case "102002":
					userid = "107";
					break;
				case "102003":
					userid = "206";
					break;
				case "102004":
					userid = "010";
					break;
				case "102005":
					userid = "017";
					break;
				case "102006":
					userid = "108";
					break;
				case "102007":
					userid = "013";
					break;
				case "102008":
					userid = "014";
					break;
				case "102009":
					userid = "105";
					break;
				case "102010":
					userid = "205";
					break;
				case "102011":
					userid = "004";
					break;
				case "102012":
					userid = "005";
					break;
				case "102013":
					userid = "012";
					break;
				case "102014":
					userid = "018";
					break;
				case "102015":
					userid = "202";
					break;
				case "102016":
					userid = "204";
					break;
				case "102017":
					userid = "011";
					break;
				case "102018":
					userid = "019";
					break;
				case "102019":
					userid = "102019";
					break;
				case "102020":
					userid = "102020";
					break;
				case "102021":
					userid = "102021";
					break;
				case "102022":
					userid = "102022";
					break;
				case "102023":
					userid = "102023";
					break;
				case "102024":
					userid = "102024";
					break;
				case "102025":
					userid = "102025";
					break;
				case "102026":
					userid = "102026";
					break;
				case "102027":
					userid = "102027";
					break;
				case "102028":
					userid = "102028";
					break;
				default:
				        userid=id;
					this.getSession().setAttribute("check", "false");
					return;
				}
			}
			String url = SysPropertiesUtil.getProperty("archivesURL");
			byte[] ids;
			try
			{
				ids = userid.getBytes("UTF-8");
				userid = new BASE64Encoder().encode(ids);
				String password = new BASE64Encoder().encode("njzsb".getBytes("UTF-8"));
				url = url + "?loginCode=" + userid + "&password=" + password;
				this.getSession().setAttribute("url", url);
//				this.getSession().setAttribute("url", SysPropertiesUtil.getProperty("archivesURL"));
				this.getSession().setAttribute("check", "true");
			} catch (UnsupportedEncodingException e)
			{
				e.printStackTrace();
			}

		}

	}

	/**
	 * 登陆页除用户名、密码、验证码以外的任何input输入框(type=text)的变量值都放入session,input标签的ID对应放入Session的KEY
	 * 
	 * @author YuWeitao 2013-03-08
	 */
	private void saveExtendVarToSession()
	{
		Enumeration<String> enu = getRequest().getAttributeNames();
		while (enu.hasMoreElements())
		{
			String param = enu.nextElement();
			String[] values = getRequest().getParameterValues(param);
			if (values != null)
			{
				if (values.length > 1)
				{
					setSessionAttribute(param, values);
				}
				else
				{
					setSessionAttribute(param, values[0]);
				}
			}
		}
	}

	/**
	 * 设置用户的数据权限所能访问的部门
	 * @return String[] 所能访问的部门ID数组
	 * @throws
	 */
	private List<String> setUserDeptIds(String userId, String departmentId)
	{
		List<String> deptIds = new ArrayList<String>();
		deptIds.add(departmentId);
		// List<Department> deptList =
		// securityService.findDataAccessAuth(userId);
		// if (deptList != null && deptList.size() > 0) {
		// for (int i = 0; i < deptList.size(); i++) {
		// deptIds.add(deptList.get(i).getId());
		// }
		// }
		return deptIds;
	}

	/**
	 * 网站退出登录，记录登出日志
	 * 
	 * @Title: logout
	 * @Description:
	 * @return String
	 */
	public String logout()
	{
		User user = this.getLoginUser();
		saveLog(user, "电脑");
		HttpSession session = getSession();
		session.invalidate();
		return SUCCESS;
	}

	/**
	 * ajax退出登录
	 * 
	 * @Title: logout
	 * @Description:
	 * @return String
	 */
	public void ajaxLogout()
	{
		HttpSession session = getSession();
		session.invalidate();
	}

	/**
	 * 记录登出日志
	 * 
	 * @param type
	 */
	private void saveLog(User user, String type)
	{
		LogoffLog log = new LogoffLog();
		log.setFromIp(Struts2Util.getRequest().getRemoteAddr());
		String userAgent = Struts2Util.getRequest().getHeader("user-agent");
		log.setBrowser(getBrowser(userAgent));
		log.setOperationsystem(getOS(userAgent));
		log.setUserAgent(userAgent);
		log.setLogoffDate(new Date());
		log.setUser(user);
		log.setLogoffType(type);
		logoffLogService.save(log);
	}

	/**
	 * 查找在线用户
	 * 
	 * @Title: queryOnlineUsers
	 * @Description:
	 * @return String
	 */
	@SuppressWarnings("unchecked")
	public String queryOnlineUsers()
	{
		Map<String, User> userMap = (Map<String, User>) Struts2Util.getServletContext()
				.getAttribute(Constants.CURR_USERS);
		userList = new ArrayList<User>();
		if (userMap != null)
		{
			Iterator<String> keyIt = userMap.keySet().iterator();
			while (keyIt.hasNext())
			{
				String key = keyIt.next();
				User user = userMap.get(key);
				if (loginId == null || loginId.equals(""))
					userList.add(user);
				else
				{
					if (user.getLoginId().indexOf(loginId) != -1 || user.getDisplayName().indexOf(loginId) != -1)
						userList.add(user);
				}
			}
		}
		return SUCCESS;
	}

	/**
	 * 检查用户quickstart模块列表和角色权限模块列表是否不在一个集合内
	 * 
	 */
	private void checkQuickStart(User user)
	{
		// 得到用户的所有角色对应的模块列表
		// userService.

		List<String> moduleCodeList = securityService.findMyModuleCode(user.getId());

		// 得到用户的quickstart模块列表

		List<QuicklyStart> startList = quicklyStartService.findQuicklyStart(user.getId());

		List<String> deleteIdsList = new ArrayList<String>();

		// 循环quickstart列表，如果有不存在于所有角色模块类别中的，则删除
		for (QuicklyStart quicklyStart : startList)
		{
			if (!moduleCodeList.contains(quicklyStart.getModule().getModuleCode()))
			{
				deleteIdsList.add(quicklyStart.getId());
			}

		}
		if (deleteIdsList.size() > 0)
		{
			quicklyStartService.deleteQSbyIDs(deleteIdsList);
		}

	}

	private static SecureRandom random = new SecureRandom();

	private Color getRandColor(int fc, int bc)
	{
		return getRandColor(fc, bc, fc);
	}

	private Color getRandColor(int fc, int bc, int interval)
	{
		if (fc > 255)
		{
			fc = 255;
		}
		if (bc > 255)
		{
			bc = 255;
		}
		int r = fc + random.nextInt(bc - interval);
		int g = fc + random.nextInt(bc - interval);
		int b = fc + random.nextInt(bc - interval);
		return new Color(r, g, b);
	}

	/**
	 * 生成验证码
	 * 
	 * @throws Exception
	 */
	public void exec() throws Exception
	{
		HttpServletResponse response = Struts2Util.getResponse();
		// int codeLength = 4;
		// int mixTimes = 50;
		// Color bgColor = getRandColor(200, 250);
		// Color bfColor = new Color(0, 0, 0);
		// boolean ifRandomColor = true;
		// boolean ifMixColor = false;
		//
		// response.setHeader("Pragma", "No-cache");
		// response.setHeader("Cache-Control", "no-cache");
		// response.setDateHeader("Expires", 0);
		//
		// int width = 13 * codeLength + 6, height = 24;
		// BufferedImage image = new BufferedImage(width, height,
		// BufferedImage.TYPE_INT_RGB);
		//
		// Graphics g = image.getGraphics();
		//
		// g.setColor(bgColor);
		// g.fillRect(0, 0, width, height);
		//
		// g.setFont(new Font("Times New Roman", Font.BOLD, 17));
		//
		// g.setColor(new Color(33, 66, 99));
		// g.drawRect(0, 0, width - 1, height - 1);
		//
		// g.setColor(getRandColor(160, 200));
		// for (int i = 0; i < mixTimes * codeLength / 10; i++) {
		// if (ifMixColor) {
		// g.setColor(getRandColor(160, 200));
		// }
		// int x = random.nextInt(width);
		// int y = random.nextInt(height);
		// int xl = random.nextInt(12);
		// int yl = random.nextInt(12);
		// g.drawLine(x, y, x + xl, y + yl);
		// }
		//
		// String sRand = "";
		// for (int i = 0; i < codeLength; i++) {
		// String rand = String.valueOf(random.nextInt(10));
		// sRand += rand;
		//
		// if (ifRandomColor)
		// g.setColor(getRandColor(20, 110, 0));
		// else
		// g.setColor(bfColor);
		//
		// g.drawString(rand, 13 * i + 6, 16);
		// }
		ValidateCode vCode = new ValidateCode(120, 40, 4, 100);

		Struts2Util.getRequest().getSession().setAttribute("rand", vCode.getCode());

		// g.dispose();

		ImageIO.write(vCode.getBuffImg(), "PNG", response.getOutputStream());

	}

	/**
	 * 校验验证码是否正确
	 */
	public boolean checkValidateNumber() throws IOException
	{
		HttpServletRequest request = Struts2Util.getRequest();
		String code = (String) request.getSession().getAttribute("rand");
		request.getSession().removeAttribute("rand");
		String validateCode = request.getParameter("validateCode");
		if (validateCode == null || !validateCode.toUpperCase().equals(code))
		{
			return false;
		}
		else
		{
			return true;
		}
	}

	/**
	 * 获得可以访问的模块
	 * 
	 * @Description:
	 * @return String
	 */
	public String findMyModule()
	{
		User user = (User) this.getSessionAttribute(Constants.CURR_USER);
		moduleList = securityService.findMyModule(user);
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("user", user);
		quikStarList = securityService.findQuicklyStart(paraMap);
		return SUCCESS;
	}

	/**
	 * 初始化用户信息，模块信息，快捷菜单，并返回首页
	 * 
	 * @Description:
	 * @return String
	 */
	public String index()
	{
		items = getChildrenModule("M");
		allItems = getAllChildrenModule("M");
		User user = this.getLoginUser();
		startList = quicklyStartService.findQuicklyStart(user.getId());
		return SUCCESS;
	}

	private List<Map<String, Object>> getChildrenModule(String modulecode)
	{
		User user = this.getLoginUser();
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("userId", user.getId());
		paraMap.put("moduleCode", modulecode.trim() + "%");
		paraMap.put("length", modulecode.length() + 2);
		if (user.getIsSuperAdmin() != null && user.getIsSuperAdmin())
		{
			moduleList = moduleService.findModuleForAdmin(paraMap);
		}
		else
		{
			moduleList = moduleService.findModuleForLeft(paraMap);
		}
		List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
		for (Module m : moduleList)
		{
			Map<String, Object> item = new HashMap<String, Object>();
			item.put("id", m.getModuleCode());
			item.put("text", m.getModuleName());
			if (moduleService.findChildModulesByModuleCode(m.getModuleCode()).size() > 0)
			{
				item.put("children", getChildrenModule(m.getModuleCode()));
			}
			else
			{
				item.put("attributes", m.getModuleAddr());
			}
			if (m.getSmallIconAddr() != null && m.getSmallIconAddr().length() > 0)
				item.put("iconCls",
						"icon-" + m.getSmallIconAddr().trim().substring(0, m.getSmallIconAddr().trim().length() - 4));
			if (m.getTarget() == null || m.getTarget().equals("框架"))
				item.put("data", "frm");
			else
				item.put("data", "_blank");

			item.put("isAutoExpand", m.getIsAutoExpand()); // 2013.3.6 李淮如 修改

			items.add(item);
		}
		return items;
	}
	
	private List<Map<String, Object>> getAllChildrenModule(String modulecode)
	{
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("userId", "402880e92db726b5012db729f65f0001");
		paraMap.put("moduleCode", modulecode.trim() + "%");
		paraMap.put("length", modulecode.length() + 2);
		moduleList1 = moduleService.findModuleForAdmin(paraMap);
		List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
		for (Module m : moduleList1)
		{
			Map<String, Object> item = new HashMap<String, Object>();
			item.put("id", m.getModuleCode());
			item.put("text", m.getModuleName());
			if (moduleService.findChildModulesByModuleCode(m.getModuleCode()).size() > 0)
			{
				item.put("children", getAllChildrenModule(m.getModuleCode()));
			}
			else
			{
				item.put("attributes", m.getModuleAddr());
			}
			if (m.getSmallIconAddr() != null && m.getSmallIconAddr().length() > 0)
				item.put("iconCls",
						"icon-" + m.getSmallIconAddr().trim().substring(0, m.getSmallIconAddr().trim().length() - 4));
			if (m.getTarget() == null || m.getTarget().equals("框架"))
				item.put("data", "frm");
			else
				item.put("data", "_blank");

			item.put("isAutoExpand", m.getIsAutoExpand()); // 2013.3.6 李淮如 修改

			items.add(item);
		}
		return items;
	}

	/**
	 * 一维代码树形菜单
	 * 
	 * @Title: codeTree
	 * @Description:
	 * @return String
	 */
	public String codeTree()
	{
		if (isChecked == null)
			isChecked = false;
		if (showCheck == null)
			showCheck = false;

		code = codeService.findCodeById(codeId);
		return SUCCESS;
	}

	/**
	 * 一维代码树形菜单
	 * 
	 * @return void
	 */
	public void findQuicklyStartTree()
	{
		User user = (User) this.getSessionAttribute(Constants.CURR_USER);
		Map<String, Object> paraMap = new HashMap<String, Object>();
		paraMap.put("user", user);
		List<QuicklyStart> startList = securityService.findQuicklyStart(paraMap);
		List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
		for (QuicklyStart q : startList)
		{
			Map<String, Object> item = new HashMap<String, Object>();
			item.put("id", q.getModule().getModuleCode());
			item.put("text", q.getModule().getModuleName());
			item.put("iconCls", "icon-module");
			item.put("attributes", q.getModule().getModuleAddr());
			if (q.getModule().getTarget() == null || q.getModule().getTarget().equals("框架"))
				item.put("data", "frm");
			else
				item.put("data", "_blank");
			items.add(item);
		}
		writerJSONArray(items);
	}

	private void setOnlineInfo(User user, String loginType)
	{
		OnlineUser onlineUser = new OnlineUser();
		if (onlineUserService.isUserLogon(user.getId()))
		{
			/**
			 * 在配置允许同一用户多处登录的情况下，在线用户列表数据库中更新用户信息，不添加重复用户数据
			 * 
			 * @author YuWeitao 2013-03-22
			 */
			onlineUser = onlineUserService.getOnlineUserByUserId(user.getId());
		}
		onlineUser.setUser(user);
		onlineUser.setSessionId(Struts2Util.getSession().getId());
		onlineUser.setLoginType(loginType);
		onlineUser.setLoginTime(new Date());
		onlineUserService.save(onlineUser);
	}

	public String selectUsers()
	{
		userNameIds = getRequest().getParameter("commonUserIds"); // 传递参数
		return "success";
	}

	/**
	 * 获取部门用户
	 * 
	 * @return
	 * @throws IOException
	 */
	public String getDepartUser() throws IOException
	{
		String commonUserIds = getRequest().getParameter("commonUserIds"); // 传递参数
		Map paramsMap = new HashMap();
		// 获取组织机构树
		JSONObject obj = new JSONObject();
		obj.put("id", "-1");
		obj.put("pId", "-2");
		obj.put("name", "组织机构");
		obj.put("open", true);
		if (null != commonUserIds && !"".equals(commonUserIds.trim()))
		{
			if (commonUserIds.indexOf("-1") != -1)
			{
				obj.put("checked", true);
			}
			else
			{
				obj.put("checked", false);
			}
		}
		else
		{
			obj.put("checked", false);
		}
		obj.put("icon", getRequest().getContextPath() + "/webResources/images/ico_0006.png");
		jsonRoot.add(obj);

		List<Object> departmentList = deptService.getDepartmentAndUserTree(paramsMap);

		for (int i = 0; i < departmentList.size(); i++)
		{
			Object[] deptArr = (Object[]) departmentList.get(i);
			obj = new JSONObject();
			obj.put("id", null != deptArr[0] ? deptArr[0].toString() : "");
			obj.put("pId", null != deptArr[2] ? deptArr[2].toString() : "");
			obj.put("name", null != deptArr[1] ? deptArr[1].toString() : "");
			if (deptArr[4].toString().equals("1"))
			{
				obj.put("icon", getRequest().getContextPath() + "/webResources/images/ico_0006.png");
			}
			else
			{
				obj.put("flag", "1");
				obj.put("icon", getRequest().getContextPath() + "/webResources/images/ico_0148.png");
			}
			if (null != commonUserIds && !"".equals(commonUserIds.trim()))
			{
				if (null != deptArr[0] && null != deptArr[0].toString())
				{
					if (commonUserIds.indexOf(deptArr[0].toString()) != -1)
					{
						obj.put("checked", true);
					}
					else
					{
						obj.put("checked", false);
					}
				}
				else
				{
					obj.put("checked", false);
				}
			}
			else
			{
				obj.put("checked", false);
			}
			jsonRoot.add(obj);
		}

		getResponse().getWriter().println(jsonRoot.toString());

		return NONE;
	}
	
	// TODO 首页待办任务
	private Pagination pagination;
	
	public Pagination getPagination()
	{
		return pagination;
	}

	public void setPagination(Pagination pagination)
	{
		this.pagination = pagination;
	}

	@Autowired
    protected TaskService taskService;
	@Autowired
    protected RuntimeService runtimeService;
	@Autowired()
    private ReturnItemService returnItemService;

	 public String findToClaimTaskList() throws IOException {
	        try {
	            // 综合用户ID\角色\角色部门组合等
	            List<String> groups = new ArrayList<>();
	            User loginUser = this.getLoginUser();
	           boolean flag=false;
	            List<UserRight> roles = (List<UserRight>) loginUser.getUserRoles();
	            if (roles != null) {
	                for (UserRight role : roles) {
	                	if("A30".equals(role.getRole().getRoleCode()))
	                	{
	                		flag =true;
	                	}
	                    groups.add(role.getRole().getRoleName());
	                    groups.add(loginUser.getDeptCode() + "|" + role.getRole().getRoleName());
	                }
	            }
	            pagination = new Pagination(super.getRequest());
	            TaskQuery claimedTaskQuery = taskService.createTaskQuery().taskCandidateOrAssigned(getLoginUser().getLoginId());
	            if (!groups.isEmpty())
	            	claimedTaskQuery.taskCandidateGroupIn(groups);

	            claimedTaskQuery.active().orderByTaskId().desc();
	            List<Task> claimedTaskList = claimedTaskQuery.listPage(pagination.getFirstResult(), pagination.getPageSize());
	            claimedTaskList = claimedTaskQuery.listPage(pagination.getFirstResult(), pagination.getPageSize());
	            List<HashMap<String, Object>> mapList = new ArrayList<>();
	            for(int i = 0;i < claimedTaskList.size();i++){
	            	HashMap<String, Object> map = new HashMap<String, Object>();
	            	Task task = claimedTaskList.get(i);
	            	 String businesskey = runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult().getBusinessKey();
	            	Xmxxb xmxxb = xmxxbService.getById(businesskey);
	            	if(null!=xmxxb){
                    	 map.put("projectName", xmxxb.getXmmc());
                    }else{
                    	 map.put("projectName", "");
                    }
	            	 ReturnItem returnItem = returnItemService.getByXmbzjAndProcessInsId(businesskey, task.getProcessInstanceId());
	                     if(null != returnItem){
	                    	 if("0".equals(returnItem.getReturnStatus())||"1".equals(returnItem.getReturnStatus())){
	                    		 map.put("returnStatus", " ");
	                    	 }
	                     }else {
	                    	 map.put("returnStatus", "办理");
						}
                     if(task.getAssignee()==null){
	            		 map.put("returnStatus", "签收");
					}
                     
	                map.put("name", claimedTaskList.get(i).getName());
	                mapList.add(map);
	            }
	            setRequestAttribute("dbrw", mapList);
	            list();
	            //首页弹出框显示未读收件和未审批的项目信息审核
	            Map<String, String> paraMap = new HashMap<String, String>();
	            paraMap.put("userId",loginUser.getId());
	            paraMap.put("receivestatus", "1");
	            shouwenList = fawenReceiveService.findnotReadInfo(paraMap);
	            if(flag)
	            {
	            Zsdw zsdw = zsdwService.getzsdw(this.getLoginUserDepartmentId());
	            Map<String, Object> paraMap1 = new HashMap<String, Object>();
				paraMap1.put("zsdw", zsdw.getZsdw());
				paraMap1.put("state", "0");
				xxfhList = xxjlService.findxxjlList(paraMap1);
	            }
	        } catch (Exception e) {
	        	System.out.println("error");
	        }
			return SUCCESS;
	    }
	 
	 @Autowired
	 private Schedule1Service schedule1Service;
	 public void list() throws Exception{
			Map<String, Object> paraMap = new HashMap<String, Object>();
			Map<String, String> map = new HashMap<String,String>();
			Map<String, String> map1 = new HashMap<String,String>();
			Map<String, String> map2 = new HashMap<String,String>();
			List<Schedule1> list = schedule1Service.findAll(paraMap);
			
			List<Schedule1> list1=new ArrayList<Schedule1>();
			
			for(Schedule1 schedule1:list){
				if(schedule1.getUserIds()!=null&&!("".equals(schedule1.getUserIds()))){
					if(schedule1.getUserIds().indexOf(this.getLoginUserId())!=-1){
						list1.add(schedule1);
					}
				}	
			}
			
			for(int i= 0;i < list1.size();i++){
				map2.put(i+"", list1.get(i).getId());
				if(null!=list1.get(i).getRemark()&&list1.get(i).getRemark().length()>35){
					map.put(i+"", list1.get(i).getRemark().substring(0, 33));
				}else{
					map.put(i+"", list1.get(i).getRemark());
				}
				map1.put(i+"", list1.get(i).getStartdate());
			}
			setRequestAttribute("rcap", map);
			setRequestAttribute("rcap1", map1);
			setRequestAttribute("rcap2", map2);
		}

	 
	//短信接口
	    public static HttpMethod getMethod(String url,String param) {
	    	try {
				
	    		GetMethod get = new GetMethod(url+"?"+param);
	    		get.releaseConnection();
	    		return get;
			} catch (Exception e) {
				// TODO: handle exception
				return null;
			}
	    }
	    //短信
	    public  static void dxjk(String neirong,String ywbm,String dwdm){
             	    	
	    }

	    public static final String SMS_CODE_SUCCESS = "201";
	    public static final String SMS_CODE_ERROR = "201";
	    public static void sendNewMessage(String content, String phone, String deptId, String loginUserMobile) {
	 		String url = SysPropertiesUtil.getProperty("newMessageHost");
			Map<String, String> params = new HashMap<>();
			params.put("createName", loginUserMobile);
			params.put("receivePhone", phone);
			params.put("smsContent", content);
			Dxjl d = new Dxjl();
			DxjlService dxjlService = SpringContextHolder.getBean("dxjlService");
			try {
				HttpClientUtil httpClientUtil = new HttpClientUtil();
				String result = httpClientUtil.doJsonPost(url, JSONObject.fromObject(params));
//			String post = HttpclientUtil.post(url, params, "UTF-8");
				JSONObject jsonObject = JSONObject.fromObject(result);
				// 封装消息
				d.setDelFlag(0);
				//收信息的人
				d.setSxxr(phone);
				//发信息的人
				d.setFsr(loginUserMobile);
				//部门
				d.setBumen(deptId);
				d.setFsnr(content);
				// 记录发送状态
				d.setByzd(jsonObject.get("code").toString() + "_" + jsonObject.get("id"));
				dxjlService.save(d);
			}catch (Exception e) {
				e.printStackTrace();
			}
		}

	    public static void send(String content,String phone,String deptId,String loginUserMobile){
	    	  if("Y".equals(SysPropertiesUtil.getProperty("duanxinKg"))){
	    	
			  String url = "/byjcy/jsp/message/sendMessage.action";
		        //String host =     "127.0.0.1";
			  String host = SysPropertiesUtil.getProperty("duanxinUrl");
//			  String host="202.102.101.411";
			  int duankou =Integer.parseInt( SysPropertiesUtil.getProperty("duanxinDk"));
			  
			  Dxjl d=new Dxjl();
			  d.setDelFlag(0);
			  //收信息的人
			  d.setSxxr(phone);
			  //发信息的人
			  d.setFsr(loginUserMobile);
			  //部门
			  d.setBumen(deptId);
			  d.setFsnr(content);
		        String param;
		        DxjlService dxjlService = SpringContextHolder.getBean("dxjlService");
				try {
					param = "content="+URLEncoder.encode(content, "utf-8")+"&phone="+phone+"&sendMobile="+URLEncoder.encode(loginUserMobile, "utf-8")
					+"&deptNo="+deptId;
			        HttpClient httpClient = new HttpClient();
			        httpClient.getHostConfiguration().setHost(host, duankou, "http");       
			        httpClient.getParams().setParameter(CoreProtocolPNames.HTTP_CONTENT_CHARSET, "UTF-8");  
			        HttpMethod method = getMethod(url, param);
			        int result=999;
			        if(null!=method){
			        	result=httpClient.executeMethod(method);
			        }
			         
			        //发送内容
			        //返回结果
			        d.setByzd(String.valueOf(result));
				} catch (UnsupportedEncodingException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					d.setByzd(e.getMessage());
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					d.setByzd(e.getMessage());
				} 
				finally {
					dxjlService.save(d);
					
				}
	    	  }
	    	
	    }


	/**
	 *@param jkfsjlb 是否是接口重发，是则传入重发对应表中的实体类对象，否则传null
	 * @param map 传入的参数para
	 */
	public static   String send2ww(Map<String,String> map, Jkfsjlb jkfsjlb)
	{
		HttpClientUtil httpClientUtil = new HttpClientUtil();
		String result = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
		String host = SysPropertiesUtil.getProperty("waiwangip");
		Integer port = Integer.parseInt(SysPropertiesUtil.getProperty("waiwangduankou"));
		String action =SysPropertiesUtil.getProperty("wwCommonAction");
		String url = "http://"+host+":"+port + action;
//		String url = "http://192.168.1.248:8080/zsbwwsb1/util/getInfo.action";
//		String url = "http://202.102.101.93:8080/zsbwwsb/util/getInfo.action";
//		String url = "http://localhost:8081/util/getInfo.action";
		map.put("key",String.valueOf((new Date().getTime()*6+1)/7));
		String method1 = map.get("method");
		if(StringUtil.isEmpty(host) || port == null || StringUtil.isEmpty(method1))
		{
			return result;
		}
		try
		{
			if(jkfsjlb == null)
			{
				//不是重发 需要先新增数据
				jkfsjlb = jkfsjlbService.beforejkfs(url,map,"POST");
			}
			result = httpClientUtil.doPost(url,map,"UTF-8");
			jkfsjlbService.updateZhuantai(result,jkfsjlb);
			System.out.println("请求的接口地址是 ："+url+" 返回结果是："+result);
		}catch (Exception e)
		{
			e.printStackTrace();
		}
		return result;
	}

    /**
     *@param tbshxk 是否是接口重发，是则传入重发对应表中的实体类对象，否则传null
     * @param
     */
    public static   String send2wwSGXK(Xmxxb xmxxb,Tbshxk tbshxk,String dwdm,Map<String,String> map111)
    {

    	String result1 ="";
		String isneed = "yes";
    	int i = tbshxk == null ? 0 : 1;
		if(map111 != null)
		{
			isneed = map111.get("isneed");
		}
    	if(xmxxb!=null) {
			tbshxk = getTbshxkByXxylb("", xmxxb,dwdm,isneed);
		}
		if(tbshxk == null)
		{
			return "false";
		}
		Map<String,String> map = new HashMap<>();
        HttpClientUtil httpClientUtil = new HttpClientUtil();
        String result = "false";
        String host = SysPropertiesUtil.getProperty("waiwangip");
        Integer port = Integer.parseInt(SysPropertiesUtil.getProperty("waiwangduankou"));
        String action =SysPropertiesUtil.getProperty("wwCommonAction");

        String url = "http://"+host+":"+port + action;
//        String url = "http://localhost:28080/util/getInfo.action";

//        String url = "http://192.168.1.248:8080/zsbwwsb1/util/getInfo.action";
//		String url = "http://localhost:8081/util/getInfo.action";NJSGXKPlat
		if(map111 != null)
		{
			map.putAll(map111);
		}
		else
		{
			map.put("key",String.valueOf((System.currentTimeMillis()*6+1)/7));
			map.put("method","sgxt");
		}
         map.put("ghxkzh1",tbshxk.getGhxkzh());
         map.put("ghxmbh1",tbshxk.getGhxmbh());
         map.put("fgwbh1",tbshxk.getFgwbh());
         map.put("czjb1",tbshxk.getCzjb());
         map.put("qx1",tbshxk.getQuxianenglish());
         map.put("xxylb1",tbshxk.getXxylb());
         map.put("slbh1",tbshxk.getSlbh());
         map.put("jsdw1",tbshxk.getJsdw());
         map.put("xmmc1",tbshxk.getGcxmmc());
         map.put("xmdd1",tbshxk.getXmdd());
         map.put("zjzmj1",tbshxk.getZjzmj());
         map.put("lxr1",tbshxk.getLxr());
         map.put("phone1",tbshxk.getPhone());
         map.put("jddh1",tbshxk.getJddh());
         map.put("jfzt1",tbshxk.getJfzt());
         map.put("jfpzwj1",tbshxk.getJfpzwj());
         map.put("pzbh1",tbshxk.getPzbh());
         map.put("ecn1",tbshxk.getEcn());
         map.put("date1",tbshxk.getJfrq());
         map.put("jfpzwjm1",tbshxk.getJfpzwjm());
		//发送参数
		String sendParam = JSONArray.fromObject(map).toString();
		tbshxk.setFscs(sendParam.substring(1,sendParam.length()-1));

//		map.put("fscs1",tbshxk.getFscs());
        try
        {
            if(i == 0)
            {
				Map<String ,Object> map1 = new HashMap<>();
				map1.put("xxylb",tbshxk.getXxylb());
				Pagination pagination  = tbshxkService.findByPage(new Pagination(1,0),map1);
				List<Tbshxk> p = pagination.getListOfObject();
				if("yes".equals(isneed))
				{
					if(CollectionUtils.isEmpty(p) )
					{
						//不是重发 需要先新增数据
						tbshxk = tbshxkService.beforejkfs(url,tbshxk);
					}
					else
					{
						Tbshxk	tbshxkdatabase = p.get(0);
						tbshxkdatabase.setJfzt(tbshxk.getJfzt());
						tbshxkdatabase.setPzbh(tbshxk.getPzbh());
						tbshxkdatabase.setJfpzwjm(tbshxk.getJfpzwjm());
						tbshxkdatabase.setJfpzwj(tbshxk.getJfpzwj());
						tbshxkdatabase.setJfrq(tbshxk.getJfrq());
						tbshxkdatabase.setEcn(tbshxk.getEcn());
						tbshxk = tbshxkdatabase;
					}
				}
            }
			result1 = httpClientUtil.doPost(url,map,"UTF-8");
			System.out.println(map);
			if(StringUtil.isNotEmpty(result1) && result1.contains("\"ResultStatus\":")) {
				String re1 = com.jshx.module.admin.web.action.CommonAction.getValueFromJsonstr(result1, "ResultStatus");
				if("1".equals(re1))
				{
					result="true";
					if(xmxxb == null)
					{
						Xmxxb xmxxb1 = xmxxbService.getByXxylb(tbshxk.getXxylb());
						xmxxb1.setIstbsgxt("yes");
						xmxxbService.update(xmxxb1);
					}
					else
					{
						xmxxb.setIstbsgxt("yes");
						if(StringUtil.isEmpty(xmxxb.getId()))
						{
							xmxxbService.save(xmxxb);
						}
						else
						{
							xmxxbService.update(xmxxb);
						}
					}
				}
				else
				{
					result ="false";
				}
			}
			else
			{
				result ="false";
			}
			if("yes".equals(isneed))
			{
				tbshxkService.updateZhuantai(result1,tbshxk);
			}
            System.out.println("请求的接口地址是 ："+url+" 返回结果是："+result1);
        }catch (Exception e)
        {
            e.printStackTrace();
        }
        return result;
    }

    public static Tbshxk getTbshxkByXxylb(String xxylb1, Xmxxb xmxxb1,String dwdm,String isneed)
    {
        if(StringUtil.isEmpty(xxylb1) && xmxxb1 == null)
        {
            return null;
        }
        Tbshxk tbshxk = new Tbshxk();
        String xxylb = StringUtil.isEmpty(xxylb1)?xmxxb1.getXxylb():xxylb1;
        Xmxxb xmxxb = xmxxb1 == null? xmxxbService.getByXxylb(xxylb) :xmxxb1;
        if(xmxxb == null )
        {
            return null;
        }
        else if("yes".equals(isneed) && !("001".equals(xmxxb.getMjyj()) || "005".equals(xmxxb.getMjyj())))
		{
			return null;
		}
		else
        {
            tbshxk.setDelFlag(0);
            tbshxk.setZjzmj(xmxxb.getZjsmj());
            tbshxk.setXxylb(xmxxb.getXxylb());
            tbshxk.setGhxkzh(xmxxb.getXkzh());
            tbshxk.setGhxmbh(xmxxb.getXmbh());
            tbshxk.setGcxmmc(xmxxb.getXmmc());
            tbshxk.setFgwbh(xmxxb.getLxpw());
            String[] result = isSbj(dwdm);
            if(result == null){ return null;}
            tbshxk.setCzjb(result[0]);
            tbshxk.setQuxian(result[1]);
            tbshxk.setQuxianenglish(result[2]);
            tbshxk.setSlbh(xmxxb.getSlbh());
            tbshxk.setJsdw(xmxxb.getJsdw());
            tbshxk.setXmdd(xmxxb.getJsdd());
            tbshxk.setLxr(xmxxb.getLianxiren());
            tbshxk.setPhone(xmxxb.getPhone());
            Map isjf = isJf(xmxxb);
            tbshxk.setJfzt(isjf.get("isjf").toString());
            PaymentItemHis paymentItemHis = (PaymentItemHis)isjf.get("payment");
            if(paymentItemHis != null)
			{
				tbshxk.setPzbh(paymentItemHis.getZslxdbh());
				tbshxk.setEcn(paymentItemHis.getECN());

				DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
				tbshxk.setJfrq(dateFormat.format(paymentItemHis.getCreateTime()));
			}
			Map<String ,Object> parajc = new HashMap<>();
			parajc.put("xxylb",xxylb);
			Pagination pagination = wwjdclinfoService.findByPage(new Pagination(1,0),parajc);
		   List<Wwjdclinfo> list =	pagination.getListOfObject();
		   String scwjm = "";
		   if(CollectionUtils.isNotEmpty(list))
		   {
		   	for(Wwjdclinfo wwjdclinfo : list)
			{
				if("缴费凭证".equals(wwjdclinfo.getFjqm()))
				{
					scwjm = wwjdclinfo.getScwjm();
				}
			}
		   }
			String path = SysPropertiesUtil.jdlj(ServletActionContext.getRequest())
					+ File.separator+ "wwupload"+ File.separator+"bjcl" +File.separator+xxylb+File.separator;
		    path = StringUtil.isEmpty(scwjm)?"":path+scwjm;
			path = path.replaceAll("\\\\", "/").trim();
			tbshxk.setJfpzwjm(scwjm);
			String mmm = encodeBase64File(path);
			mmm = StringUtil.isEmpty(mmm)?null:mmm.replace("\r\n","");
			tbshxk.setJfpzwj(mmm);
			//TODO jddh
			tbshxk.setJddh("");
			return tbshxk;
        }
    }
	/**
	 * 将文件转成base64 字符串
	 * @param path 文件路径
	 * @return  *
	 * @throws Exception
	 */

	public static String encodeBase64File(String path)
	{
		if(StringUtil.isEmpty(path))
		{
			return null;
		}
		try {
			File file = new File(path);
			FileInputStream inputFile = new FileInputStream(file);
			byte[] buffer = new byte[(int) file.length()];
			inputFile.read(buffer);
			inputFile.close();
			return new BASE64Encoder().encode(buffer);
		}catch (Exception e)
		{
			e.printStackTrace();
			return "";
		}
	}


    public static String[] isSbj (String dwdm)
    {
    	String[] strings = new String[3];
        if(StringUtil.isEmpty(dwdm))
        {
            return null;
        }
        else
        {
			if("jn".equals(dwdm))
			{
				strings[0] = "1";
				strings[1] = "江宁区";
			}
			else if("ls".equals(dwdm))
			{
				strings[0] = "1";
				strings[1] = "溧水区";
			}
			else if("gc".equals(dwdm))
			{
				strings[0] = "1";
				strings[1] = "高淳区";
			}
			else if("lh".equals(dwdm))
			{
				strings[0] = "1";
				strings[1] = "六合区";
			}
			else if("pz".equals(dwdm))
			{
				strings[0] = "1";
				strings[1] = "浦口区";
			}
			else if("jb".equals(dwdm))
			{
				strings[0] = "1";
				strings[1] = "江北新区";
			}
			else if("jk".equals(dwdm))
			{
				strings[0] = "1";
				strings[1] = "经开区";
			}
			else if("gx".equals(dwdm))
			{
				strings[0] = "1";
				strings[1] = "高新区";
			}
			else
			{
				strings[0] = "0";
				strings[1] = "";
			}
			strings[2] = dwdm;

        }
        return strings;
    }
    //TODO
    public static Map<String,Object> isJf (Xmxxb xmxxb)
    {
    	Map<String ,Object> map1 = new HashMap<>();
        if(xmxxb == null)
        {
            return null;
        }
        else
        {
           String xkzh =  xmxxb.getXkzh();
           Map<String ,Object> map = new HashMap<>();
           map.put("xkzh",xkzh);
           List<Xmxxb> list = xmxxbService.findXmxxb(map);
          
           
			PaymentItemHis  paymentItemHis1 =  paymentItemHisService.getByXmbId(xmxxb.getId());
           if(CollectionUtils.isEmpty(list))
           {
               map1.put("isjf","1");
               map1.put("payment",paymentItemHis1);
           }
           else
           {
           	   String i = "0" ;
               for(Xmxxb xmxxb1:list)
               {
            	   //排除项目是否是撤销或者作废
            	if(!"1".equals(xmxxb1.getIsxmcx())&&(xmxxb1.getIstj()==null)){
            		   
                 PaymentItemHis  paymentItemHis =  paymentItemHisService.getByXmbId(xmxxb1.getId());
                 if(paymentItemHis == null)
				 {
				 	i="1";
				 }
                 
            	 }
                 
               }

			   map1.put("isjf",i );
			   if (paymentItemHis1 == null)
			   {
				   map1.put("isjf","1");
			   }
               map1.put("payment",paymentItemHis1);
           }
        }
        return map1;
    }
    /**
	 *
	 * @param map 传入的参数para
	 */
	public static   String ceshi(Map<String,String> map,String dizhi,String dk)
	{
		HttpClientUtil httpClientUtil = new HttpClientUtil();
		String result = "{ \"message\": \"查询失败\",\"code\": \"1000\"}";
		String host = dizhi;
		Integer port = Integer.parseInt(dk);
//		String action = "/zsbwwsb/util/getInfo.action";
//		String action = "/util/getInfo.action";
		String action = "/mobile/getInfo.action";
		String url = "http://"+host+":"+port + action;
//       String url = "http://localhost:8081/mobile/getInfo.action";
		map.put("key",String.valueOf((new Date().getTime()*6+1)/7));
		String method1 = map.get("method");
		if(StringUtil.isEmpty(host) || port == null || StringUtil.isEmpty(method1))
		{
			return result;
		}
		try
		{
			result = httpClientUtil.doPost(url,map,"UTF-8");
			System.out.println("请求的接口地址是 ："+url+" 返回结果是："+result);
		}catch (Exception e)
		{
			e.printStackTrace();
		}
		return result;
	}
	public static String getValueFromJsonstr(String jsonstr,String key)
	{
		String result ="";
		if(StringUtils.isEmpty(jsonstr) || StringUtils.isEmpty(key))
		{
			return result;
		}
		int index = jsonstr.indexOf("\""+key+"\":");
		if(index > -1)
		{
			if('[' == jsonstr.charAt(index+key.length()+4))
			{
				int index5 = jsonstr.indexOf(']',index+key.length()+4);
				if(index5>0 )
				{
					result = jsonstr.substring(index+key.length()+4,index5+1);
					return result;
				}
			}
			int index2 = jsonstr.indexOf(',',index+key.length()+1);
			int index3 = jsonstr.indexOf('}',index+key.length()+1);
			int index4 = jsonstr.indexOf('\"',index+key.length()+2);
			if(index2<0 && index3>0)
			{
				result = jsonstr.substring(index4+1,index3-1);
			}
			else if(index2 > 0)
			{
				result = jsonstr.substring(index4+1,index2-1);
			}
		}
		return result;
	}
	/**
	 * @return the moduleList
	 */
	public List<Module> getModuleList()
	{
		return moduleList;
	}

	/**
	 * @param moduleList
	 *            the moduleList to set
	 */
	public void setModuleList(List<Module> moduleList)
	{
		this.moduleList = moduleList;
	}

	/**
	 * @return the module
	 */
	public Module getModule()
	{
		return module;
	}

	/**
	 * @param module
	 *            the module to set
	 */
	public void setModule(Module module)
	{
		this.module = module;
	}

	public String getLoginId()
	{
		return loginId;
	}

	public void setLoginId(String loginId)
	{
		this.loginId = loginId;
	}

	public String getPassword()
	{
		return password;
	}

	public void setPassword(String password)
	{
		this.password = password;
	}

	/**
	 * @return the userList
	 */
	public List<User> getUserList()
	{
		return userList;
	}

	/**
	 * @param userList
	 *            the userList to set
	 */
	public void setUserList(List<User> userList)
	{
		this.userList = userList;
	}

	public User getUser()
	{
		return user;
	}

	public void setUser(User user)
	{
		this.user = user;
	}

	public Department getDept()
	{
		return dept;
	}

	public void setDept(Department dept)
	{
		this.dept = dept;
	}

	/**
	 * @return the codeId
	 */
	public String getCodeId()
	{
		return codeId;
	}

	/**
	 * @param codeId
	 *            the codeId to set
	 */
	public void setCodeId(String codeId)
	{
		this.codeId = codeId;
	}

	/**
	 * @return the isChecked
	 */
	public Boolean getIsChecked()
	{
		return isChecked;
	}

	/**
	 * @param isChecked
	 *            the isChecked to set
	 */
	public void setIsChecked(Boolean isChecked)
	{
		this.isChecked = isChecked;
	}

	/**
	 * @return the showCheck
	 */
	public Boolean getShowCheck()
	{
		return showCheck;
	}

	/**
	 * @param showCheck
	 *            the showCheck to set
	 */
	public void setShowCheck(Boolean showCheck)
	{
		this.showCheck = showCheck;
	}

	/**
	 * @return the code
	 */
	public Code getCode()
	{
		return code;
	}

	/**
	 * @param code
	 *            the code to set
	 */
	public void setCode(Code code)
	{
		this.code = code;
	}

	/**
	 * @return the func
	 */
	public String getFunc()
	{
		return func;
	}

	/**
	 * @param func
	 *            the func to set
	 */
	public void setFunc(String func)
	{
		this.func = func;
	}

	/**
	 * @return the loginType
	 */
	public Integer getLoginType()
	{
		return loginType;
	}

	/**
	 * @param loginType
	 *            the loginType to set
	 */
	public void setLoginType(Integer loginType)
	{
		this.loginType = loginType;
	}

	public String getMessage()
	{
		return message;
	}

	public void setMessage(String message)
	{
		this.message = message;
	}

	public String getCss()
	{
		return css;
	}

	public void setCss(String css)
	{
		this.css = css;
	}

	public String getCallback()
	{
		return callback;
	}

	public void setCallback(String callback)
	{
		this.callback = callback;
	}

	public Map<String, Object> getMap()
	{
		return map;
	}

	public void setMap(Map<String, Object> map)
	{
		this.map = map;
	}

	public String getExtendParams()
	{
		return extendParams;
	}

	public void setExtendParams(String extendParams)
	{
		this.extendParams = extendParams;
	}

	public String getTest()
	{
		return test;
	}

	public void setTest(String test)
	{
		this.test = test;
	}

	public List<Map<String, Object>> getItems()
	{
		return items;
	}

	public void setItems(List<Map<String, Object>> items)
	{
		this.items = items;
	}

	public List<QuicklyStart> getStartList()
	{
		return startList;
	}

	public void setStartList(List<QuicklyStart> startList)
	{
		this.startList = startList;
	}

	public String getValidateFlag()
	{
		return validateFlag;
	}

	public void setValidateFlag(String validateFlag)
	{
		this.validateFlag = validateFlag;
	}

	public List<QuicklyStart> getQuikStarList()
	{
		return quikStarList;
	}

	public void setQuikStarList(List<QuicklyStart> quikStarList)
	{
		this.quikStarList = quikStarList;
	}

	public String getCredential()
	{
		return credential;
	}

	public void setCredential(String credential)
	{
		this.credential = credential;
	}

	public String getUuid()
	{
		return uuid;
	}

	public void setUuid(String uuid)
	{
		this.uuid = uuid;
	}

	public Long getTimestamp()
	{
		return timestamp;
	}

	public void setTimestamp(Long timestamp)
	{
		this.timestamp = timestamp;
	}

	public Integer getSafety()
	{
		return safety;
	}

	public void setSafety(Integer safety)
	{
		this.safety = safety;
	}

	public List<Map<String, Object>> getAllItems()
	{
		return allItems;
	}

	public void setAllItems(List<Map<String, Object>> allItems)
	{
		this.allItems = allItems;
	}

	public List<Module> getModuleList1()
	{
		return moduleList1;
	}

	public void setModuleList1(List<Module> moduleList1)
	{
		this.moduleList1 = moduleList1;
	}

	public List getShouwenList() {
		return shouwenList;
	}

	public void setShouwenList(List shouwenList) {
		this.shouwenList = shouwenList;
	}

	public List getXxfhList() {
		return xxfhList;
	}

	public void setXxfhList(List xxfhList) {
		this.xxfhList = xxfhList;
	}

	public JkfsjlbService getJkfsjlbService() {
		return jkfsjlbService;
	}

	@Autowired
	public void setJkfsjlbService(JkfsjlbService jkfsjlbService) {
		CommonAction.jkfsjlbService = jkfsjlbService;
	}

    public TbshxkService getTbshxkService() {
        return tbshxkService;
    }

    @Autowired
    public void setTbshxkService(TbshxkService tbshxkService) {
        CommonAction.tbshxkService = tbshxkService;
    }

    public  XmxxbService getXmxxbService() {
        return xmxxbService;
    }

	@Autowired
    public  void setXmxxbService(XmxxbService xmxxbService) {
        CommonAction.xmxxbService = xmxxbService;
    }

    public  PaymentItemHisService getPaymentItemHisService() {
        return paymentItemHisService;
    }
	@Autowired
    public  void setPaymentItemHisService(PaymentItemHisService paymentItemHisService) {
        CommonAction.paymentItemHisService = paymentItemHisService;
    }
	public  WwjdclinfoService getWwjdclinfoService() {
		return wwjdclinfoService;
	}
	@Autowired
	public  void setWwjdclinfoService(WwjdclinfoService wwjdclinfoService) {
		CommonAction.wwjdclinfoService = wwjdclinfoService;
	}

}
