package com.jshx.activiti.listener;

import com.jshx.activiti.service.ActivitiSmsService;
import com.jshx.core.exception.BasalException;
import com.jshx.core.utils.SpringContextHolder;
import org.activiti.engine.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * 发送短信给当前任务的办理人
 *
 *
 * Created by chenjian on 16/6/15.
 */
public class SmsListener extends NoficationListener {

    private static final Logger logger = LoggerFactory.getLogger(SmsListener.class);

    private ActivitiSmsService activitiSmsService;

    @Override
    public void notify(DelegateTask delegateTask) {
        initService();
        if(activitiSmsService==null)
            activitiSmsService = SpringContextHolder.getBean("activitiSmsService");
        try{
            activitiSmsService.sendNewTaskNotification(delegateTask);
        }catch(BasalException e){
            logger.error("发送短信失败", e);
        }
    }
}
