<%@page language="java" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/common/header.jsp"%>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>非税借口同步信息管理</title>
    <%@include file="/common/jsLib.jsp"%>
	<script>
        
        function view(id){
        	var dt=new Date();
            createSimpleWindow("win_fstzs","查看非税通知书","${ctx}/jsp/fstzs/winViewFstzs.action?id=" + id,900,700);
        	
        }

		function edit(id){
			var dt=new Date();
			createSimpleWindow("win_fstzs","修改非税通知书","${ctx}/jsp/fstzs/winAddFstzs.action?flag=edit&id=" + id,900,700);

		}

		function dayin(id){
			var dt=new Date();
			createSimpleWindow("win_fstzs","打印非税通知书","${ctx}/jsp/fstzs/winPrintFstzs.action?id=" + id,900,700);

		}

		function jihuo(id){
			$.messager.confirm("提示", "确认要激活该项目？", function(result) {
				if(result) {
					$.ajax({
						url : "${ctx}/jsp/fstzs/jihuoXm.action",
						type: 'post',
						dataType: 'json',
						data:{
							id : id
						},
						async : false,
						error: function (data) {
							$.messager.alert('错误', data.message);
						},
						success: function (data) {
							if (data.result) {
								$.messager.alert("提示",data.message)
								reloadDate()
							} else {
								$.messager.alert('错误', '验证失败,'+data.message);
								return;
							}
						}
					});
				}
			});
		}

		function shanchu(id) {
			$.messager.confirm("提示", "确认要删除该项目？", function(result) {
				if(result) {
					$.ajax({
						url : "${ctx}/jsp/fstzs/shanchu.action",
						type: 'post',
						dataType: 'json',
						data:{
							id : id
						},
						async : false
					});
					$.messager.alert("提示","操作成功")
					reloadDate()
				}
			});
		}

		function reloadDate(){
			$('#pagination').datagrid('clearSelections');
			search_fstzsXm();
		}

		function search_fstzsXm(){
			var queryParams = {
				"fstzsXm.slbh": $("#slbh").val(),
				"fstzsXm.jsdwmc": $("#jsdwmc").val(),
				"fstzsXm.gcxmmc": $("#gcxmmc").val(),
				"fstzsXm.yjje": $("#yjje").val()
			};
			$('#pagination').datagrid('options').queryParams = queryParams;
			$('#pagination').datagrid('clearSelections');
			$("#pagination").datagrid('load');
		}

		$(function(){
			$('#pagination').datagrid($.extend(window.dg_cm_pp_2,{
				title:'已生成非税通知书列表',
				url:'${ctx}/jsp/fstzs/fstzsXmList.action',
				queryParams:{
					"fstzsXm.slbh": $("#slbh").val(),
					"fstzsXm.dwmc": $("#jsdwmc").val(),
					"fstzsXm.gcxmmc": $("#gcxmmc").val(),
					"fstzsXm.yjje": $("#yjje").val(),
				},

				columns:[[
					{field:'op',title:'操作',width:170,align:'center',formatter:function(value,rec){
						var result = "";
						if(rec.status == 3 || rec.status == 4) {//复核不通过、退回时
							result += "<a class='btn_01_mini' onclick=edit('"+rec.id+"') >修改<b></b></a>";
						} else {
							result += "<a class='btn_01_mini' onclick=view('"+rec.id+"') >查看<b></b></a>";
						}
						if(rec.status == 2) {//复核通过
							result += "<a class='btn_01_mini' onclick=jihuo('"+rec.id+"') >激活<b></b></a>";
							result += "<a class='btn_01_mini' onclick=dayin('"+rec.id+"') >打印<b></b></a>";
						} else if(rec.status == 6) {
							result += "<a class='btn_01_mini' onclick=jihuo('"+rec.id+"') >重新激活<b></b></a>";
							result += "<a class='btn_01_mini' onclick=dayin('"+rec.id+"') >打印<b></b></a>";
						} else {
							result += "<a class='btn_01_mini'  style='opacity: 0.5' >激活<b></b></a>";
						}

						return result;
					}},
					{field:'slbh',title:'受理编号',width:150},
					{field:'jsdwmc',title:'建设单位名称',width:300},
					{field:'gcxmmc',title:'工程项目名称',width:300},
					{field:'yjje',title:'配套费应缴金额',width:100,formatter: function (value, row, index){
							if (row != null && ""!=value) {
								return (parseFloat(value).toFixed(2) + '').replace(/\d{1,3}(?=(\d{3})+(\.\d*)?$)/g, '$&,');
							}
						}},
					{field:'zyjje',title:'项目总应缴金额',width:150,formatter: function (value, row, index){
							return (parseFloat(row.paymentItemPending.zyjje).toFixed(2) + '').replace(/\d{1,3}(?=(\d{3})+(\.\d*)?$)/g, '$&,');
						}},
					{field:'jzmj',title:'总建筑面积',width:100,formatter: function (value, row, index){
							return row.paymentItemPending.csmj;
						}},
					{field:'status',title:'是否复核',width:80,formatter: function (value, row, index){
							if (value == 1) return "待复核";
							if (value == 2 || value == 6) return "复核通过";
							if (value == 3) return "复核不通过";
							if (value == 4) return "作废退回";
							return "待生成";

						}},
					{field: 'jhjd',title: '激活进度',width: 80,formatter:function (value,row,index) {
							if(row.status == 6) {
								return row.jhjd
							}
							return '';
						}}
				]]
			}));
		});
        
    </script>
</head>
<body>
    <div class="page_content">
	
	    <div class="box_01 submitdata">
			<div class="cell boxBmargin12">
				<table width="100%">
					<tr>
						<th width="15%">受理编号</th>
						<td width="35%"><input name="fstzsXm.slbh" id="slbh" value="" type="text"></td>
						<th width="15%">应缴金领</th>
						<td width="35%"><input name="fstzsXm.yjje" id="yjje" value="" type="text"></td>
					</tr>
					<tr>
						<th width="15%">工程项目名称</th>
						<td width="35%"><input name="fstzsXm.gcxmmc" id="gcxmmc" value="" type="text"></td>
						<th width="15%">建设单位名称</th>
						<td width="35%"><input name="fstzsXm.jsdwmc" id="jsdwmc" value="" type="text"></td>
					</tr>
					<tr>
						<td colspan="4" align="center">
							<a href="###" class="btn_01" onclick="search_fstzsXm()" >查询<b></b></a>&nbsp;
							<!-- 						<a href="###" class="btn_01" onclick="search_sdjd(1)" >已复核项目<b></b></a>&nbsp; -->
							<a href="###" class="btn_01" onclick="clear_form(document.myform);" >清空<b></b></a>&nbsp;
						</td>
					</tr>
				</table>
			</div>
		
			<div id="pagination" ></div>
		</div>
	</div>
</body>
</html>
