<%@page language="java" pageEncoding="UTF-8" isELIgnored="false"%>
<%@include file="/common/header.jsp"%>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <style>
        .to_path{
            color: blue;
            text-decoration: revert !important;
        }
    </style>
    <title>非税借口同步信息管理</title>
    <%@include file="/common/jsLib.jsp"%>
    <script>


        function search_fstzs(){
            var queryParams = {
                "fstzs.slbh": $("#slbh").val(),
                "fstzs.jsdwmc": $("#jsdwmc").val(),
                "fstzs.gcxmmc": $("#gcxmmc").val(),
                "fstzs.yjje": $("#yjje").val(),
                "fstzs.jkm": $("#jkm").val(),
                "fstzs.status": $("#status").val(),
                "fstzs.isKp": $("#isKp").val(),
                "kssj":$("#kssj").val(),
                "jssj":$("#jssj").val()
            };
            $('#pagination').datagrid('options').queryParams = queryParams;
            $('#pagination').datagrid('clearSelections');
            $("#pagination").datagrid('load');
        }

        $(function(){
            $('#pagination').datagrid($.extend(window.dg_cm_pp,{
                title:'已缴款非税通知书列表',
                url:'${ctx}/jsp/fstzs/fstzsList.action?status=3',
                queryParams:{
                    "fstzs.slbh": $("#slbh").val(),
                    "fstzs.jsdwmc": $("#jsdwmc").val(),
                    "fstzs.gcxmmc": $("#gcxmmc").val(),
                    "fstzs.yjje": $("#yjje").val(),
                    "fstzs.jkm": $("#jkm").val(),
                    "fstzs.status": $("#status").val(),
                    "kssj":$("#kssj").val(),
                    "jssj":$("#jssj").val()
                },
                frozenColumns:[[
                    {field:'id',checkbox:true}
                ]],
                columns:[[
                    {field:'op',title:'操作',width:80,align:'center',formatter:function(value,rec){
                            var result = "";
                            if(rec.isKp == 0) {
                                result += "<a class='btn_01_mini' onclick=kaipiao('"+rec.id+"') >开票<b></b></a>";
                            }
                            return result;
                        }},
                    {field:'jkm',title:'缴款码',width:100},
                    {field:'bzrq',title:'编制日期',width:100},
                    {field:'slbh',title:'受理编号',width:100},
                    {field:'jsdwmc',title:'建设单位名称',width:100},
                    {field:'gcxmmc',title:'工程项目名称',width:100},
                    {field:'jkr',title:'缴款人',width:100},
                    {field:'yjje',title:'金额',width:100},
                    {field:'pjdm',title:'票据代码',width:100},
                    {field:'dzph',title:'票据号码',width:100,formatter: function (value, row, index){
                            return "<a class='to_path' target='_black' href='" + row.pjUrl + "'>" + value + "<b></b></a>"
                        }},
                    {field:'isKp',title:'开票状态',width:100,formatter: function (value, row, index){
                            if (value == 0) return "未开票";
                            return "已开票";
                        }},
                    {field:'isJk',title:'缴款状态',width:100,formatter: function (value, row, index){
                            if (value == 0) return "未缴款";
                            return "已缴款";
                        }},
                    {field:'jkTime',title:'缴款日期',width:100},
                    {field:'jkqd',title:'缴款渠道',width:100}
                ]],
                toolbar:[{
                    id:'btnkaipiao',
                    text:'批量开票',
                    iconCls:'icon-ok',
                    handler:function(){
                        addNew();
                    }
                }
                ]
            }));
        });

        function kaipiao(id){
            $.messager.confirm("提示", "确认开票？", function(result) {
                if(result) {
                    $.ajax({
                        url : "${ctx}/jsp/fstzs/kaipiao.action",
                        type: 'post',
                        dataType: 'json',
                        data:{
                            id : id
                        },
                        async : false,
                        error: function (data) {
                            $.messager.alert('错误', data.message);
                        },
                        success: function (data) {
                            if (data.result) {
                                $.messager.alert("提示",data.message)
                                reloadDate()
                            } else {
                                $.messager.alert('错误', data.message);
                            }
                        }
                    });

                }
            });
        }


    </script>
</head>
<body>
<div class="page_content">

    <div class="box_01 submitdata">
        <div class="inner12px">
            <div class="cell boxBmargin12">
                <table width="100%">
                    <tr>
                        <th width="15%">受理编号</th>
                        <td width="12%"><input name="fstzs.slbh" id="slbh" value="" type="text"></td>
                        <th width="15%">缴款码</th>
                        <td width="12%"><input name="fstzs.jkm" id="jkm" value="" type="text"></td>
                        <th width="15%">应缴金额</th>
                        <td width="12%"><input name="fstzs.yjje" id="yjje" value="" type="text"></td>

                    </tr>
                    <tr>
                        <th width="15%">工程项目名称</th>
                        <td width="12%"><input name="fstzs.gcxmmc" id="gcxmmc" value="" type="text"></td>
                        <th width="12%">建设单位名称</th>
                        <td width="12%"><input name="fstzs.jsdwmc" id="jsdwmc" value="" type="text"></td>

                        <th width="15%">非税通知书状态</th>
                        <td width="12%"><select name="rfxm.status" id="status" >
                            <option value="">请选择</option>
                            <option value="1">正常</option>
                            <option value="3">已缴款</option>
                            <option value="2">已作废</option>

                        </select></td>

                    </tr>
                    <tr>
                        <th width="15%">通知书开具时间</th>
                        <td width="12%" style="border-right: none;position: relative">	<input  name="kssj" id="kssj" style="width: 90%" type="text" class="Wdate" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="*1-30">
                            <span style="position:  absolute;right: -8px">-</span>
                        </td>
                        <td width="12%" style="border-left: none">
                            <input name="jssj" id="jssj" style="width:90%" type="text" class="Wdate" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'})" datatype="*1-30">
                        </td>
                        <td></td>
                        <th width="12%">开票状态</th>
                        <td width="12%">
                            <select name="rfxm.isKp" id="isKp" >
                                <option value="">请选择</option>
                                <option value="0">未开票</option>
                                <option value="1">已开票</option>
                            </select>
                        </td>
                    </tr>

                    <tr >
                        <td colspan="8" align="center">
                            <a href="###" class="btn_01" onclick="search_fstzs()" >查询<b></b></a>&nbsp;
                            <a href="###" class="btn_01" onclick="clear_form(document.myform);" >清空<b></b></a>&nbsp;
                        </td>

                    </tr>
                </table>
            </div>

            <div id="pagination" >
            </div>
        </div>
    </div>
</div>
</body>
</html>
